/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.piutypesupervisor;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeHandler;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.su.SuMgr;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.support.thread.BlockingQueue;
import se.ericsson.cello.swmanagement.swmaccess.SwAllocationProperties;
import se.ericsson.cello.swmanagement.swmaccess.SwAllocationPropertyChangeEvent;
import se.ericsson.cello.upgradepackage.install.event.LMsForPiuTypeInstallStateInformationEvent;
import se.ericsson.cello.upgradepackage.install.event.LoadModuleStateInformationEvent;
import se.ericsson.cello.upgradepackage.lmsupervisor.LoadModuleSupervisionInformationEvent;
import se.ericsson.cello.upgradepackage.piutypesupervisor.PiuTypeMosSupervisionInformationEvent;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.hwsensitive.HW_SensitiveAdapter;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class PiuTypeInstallStateSupervisor
implements Runnable,
PropertyChangeListener {
    private BlockingQueue myQueue = new BlockingQueue();
    private LinkedList myQueuedSwAllocationConfigurationChangeEvents = new LinkedList();
    private boolean myIsActive = true;

    public PiuTypeInstallStateSupervisor(SuMgr suMgr) {
        String string = "PiuTypeInstallStateSupervisor(SuMgr aSuMgr)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string);
        }
    }

    public void initiateThread() {
        new Thread((Runnable)this, "PiuTypeInstallStateSupervisor").start();
    }

    public void activate() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "activate()");
        }
        if (!this.myIsActive) {
            this.addAsListener();
            this.myIsActive = true;
        } else {
            Trace.info(this.getClass(), "activate()", "Trying to active when already active (ignoring)");
        }
    }

    public void deactivate() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deactivate()");
        }
        if (this.myIsActive) {
            this.removeAsListener();
            this.myIsActive = false;
        } else {
            Trace.info(this.getClass(), "activate()", "Trying to deactive when already inactive (ignoring)");
        }
    }

    public void addAsListener() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addAsListener()()");
        }
        ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingSystemUpgradePropertyName.LoadModuleState, this);
        ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingSystemUpgradePropertyName.LMsForPiuTypeInstallState, this);
        PropertyChangeHandler.instance().addPropertyChangeListener("SwAllocationConfigurationChange", (PropertyChangeListener)this);
    }

    private void removeAsListener() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeAsListener()");
        }
        ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.LoadModuleState, this);
        ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.LMsForPiuTypeInstallState, this);
        PropertyChangeHandler.instance().removePropertyChangeListener("SwAllocationConfigurationChange", (PropertyChangeListener)this);
    }

    public boolean isIdle() {
        String string = "isIdle()";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string);
        }
        return this.myQueue.isEmpty();
    }

    public void run() {
        String string = "run()";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string);
        }
        EventObject eventObject = null;
        try {
            while (true) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "run ( )", "Waiting for an event object to be received");
                }
                eventObject = (EventObject)this.myQueue.dequeue();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, string, "EventObject received - " + eventObject);
                }
                if (eventObject instanceof LoadModuleStateInformationEvent) {
                    this.updatePiuTypeLoadModuleInstallState((LoadModuleStateInformationEvent)eventObject);
                    continue;
                }
                if (eventObject instanceof LoadModuleSupervisionInformationEvent) {
                    this.updatePiuTypeLoadModuleInstallState((LoadModuleSupervisionInformationEvent)eventObject);
                    continue;
                }
                if (eventObject instanceof LMsForPiuTypeInstallStateInformationEvent) {
                    this.updatePiuTypeLoadModuleInstallState((LMsForPiuTypeInstallStateInformationEvent)eventObject);
                    continue;
                }
                if (eventObject instanceof SwAllocationPropertyChangeEvent) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "run ( )", "myQueuedSwAllocationConfigurationChangeEvents size: " + this.myQueuedSwAllocationConfigurationChangeEvents.size());
                    }
                    Collection collection = (Collection)this.myQueuedSwAllocationConfigurationChangeEvents.clone();
                    this.updatePiuTypeLoadModuleInstallState(collection);
                    this.removeAllObjectsInQueuedSwAllocations();
                    continue;
                }
                Trace.info(this.getClass(), string, "Unknown type of object received (ignored),\n\tReceived event object: " + eventObject);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught (ignored). Note that this might result in that the state in PiuTypeMo not is updated as expected.\n\ttheEventObject: " + eventObject, throwable);
            return;
        }
    }

    public void updatePiuTypeLoadModuleInstallState(Collection collection) {
        String string = "updatePiuTypeLoadModuleInstallState(Collection aSwAllocationPropertyChangeEvents)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aSwAllocationPropertyChangeEvents: " + collection);
        }
        try {
            Object object;
            Iterator iterator = collection.iterator();
            HashSet hashSet = new HashSet();
            Collection collection2 = null;
            SwAllocationPropertyChangeEvent swAllocationPropertyChangeEvent = null;
            while (iterator.hasNext()) {
                Collection collection3;
                swAllocationPropertyChangeEvent = (SwAllocationPropertyChangeEvent)iterator.next();
                object = swAllocationPropertyChangeEvent.getOldSwAllocationProperties();
                SwAllocationProperties swAllocationProperties = swAllocationPropertyChangeEvent.getNewSwAllocationProperties();
                if (object.isConnected() && swAllocationProperties.isConnected()) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, string, "The SwAllocation was connected before and is connected after (SU_TEST)");
                    }
                    collection3 = new HashSet();
                    collection3.addAll(swAllocationPropertyChangeEvent.getAddedRepertoires());
                    collection3.addAll(swAllocationPropertyChangeEvent.getDeletedRepertoires());
                    collection2 = ServiceFinder.getRepertoireMO_HandlerInterface().getPiuTypeMos(collection3);
                    hashSet.addAll(collection2);
                    continue;
                }
                if (!object.isConnected() && swAllocationProperties.isConnected()) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, string, "The SwAllocation was not connected before but is connected after (SU_TEST)");
                    }
                    collection3 = swAllocationProperties.getRepertoires();
                    collection2 = ServiceFinder.getRepertoireMO_HandlerInterface().getPiuTypeMos(collection3);
                    hashSet.addAll(collection2);
                    continue;
                }
                if (object.isConnected() && !swAllocationProperties.isConnected()) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, string, "The SwAllocation was connected but is not connected after (SU_TEST)");
                    }
                    collection3 = object.getRepertoires();
                    collection2 = ServiceFinder.getRepertoireMO_HandlerInterface().getPiuTypeMos(collection3);
                    hashSet.addAll(collection2);
                    continue;
                }
                if (object.isConnected() || swAllocationProperties.isConnected() || !Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, string, "The SwAllocation was not connected before or after the configuration change i.e. do not need to do anything");
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, string, "thePiuTypeMos: " + hashSet);
            }
            if (!hashSet.isEmpty()) {
                object = new HW_SensitiveAdapter();
                ((HW_SensitiveAdapter)object).updateStateInAllPiuTypes(hashSet, false);
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, string, "No PiuType was found in possible repertoire changes (no need to request for piu type state updates) (SU_TEST)");
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught (ignored). Note that this might result in that the state in PiuTypeMo not is updated as expected.\n\taSwAllocationPropertyChangeEvents: " + collection, throwable);
        }
    }

    public void updatePiuTypeLoadModuleInstallState(LMsForPiuTypeInstallStateInformationEvent lMsForPiuTypeInstallStateInformationEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updatePiuTypeLoadModuleInstallState(LMsForPiuTypeInstallStateInformationEvent aLMsForPiuTypeInstallStateInformationEvent)", "theLMsForPiuTypeInstallStateInformationEvent: " + lMsForPiuTypeInstallStateInformationEvent);
        }
        try {
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "updatePiuTypeLoadModuleInstallState(LMsForPiuTypeInstallStateInformationEvent aLMsForPiuTypeInstallStateInformationEvent)", "Updating state in PiuType Mo: " + lMsForPiuTypeInstallStateInformationEvent.piuTypeMo);
            }
            HW_SensitiveAdapter hW_SensitiveAdapter = new HW_SensitiveAdapter();
            hW_SensitiveAdapter.updateStateInPiuType(lMsForPiuTypeInstallStateInformationEvent.piuTypeMo);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "updatePiuTypeLoadModuleInstallState(LMsForPiuTypeInstallStateInformationEvent aLMsForPiuTypeInstallStateInformationEvent)", "State updated");
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updatePiuTypeLoadModuleInstallState(LMsForPiuTypeInstallStateInformationEvent aLMsForPiuTypeInstallStateInformationEvent)", "Throwable caught (ignored). Note that this might result in that the state in PiuTypeMo not is updated as expected.\n\ttheLMsForPiuTypeInstallStateInformationEvent: " + lMsForPiuTypeInstallStateInformationEvent, throwable);
        }
    }

    public void updatePiuTypeLoadModuleInstallState(LoadModuleStateInformationEvent loadModuleStateInformationEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updatePiuTypeLoadModuleInstallState(LoadModuleStateInformationEvent aLoadModuleStateInformationEvent)", "aLoadModuleStateInformationEvent: " + loadModuleStateInformationEvent);
        }
        try {
            HW_SensitiveAdapter hW_SensitiveAdapter = new HW_SensitiveAdapter();
            hW_SensitiveAdapter.updateStateInAllPiuTypes();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "updatePiuTypeLoadModuleInstallState(LoadModuleStateInformationEvent aLoadModuleStateInformationEvent)", "The states have been updated");
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updatePiuTypeLoadModuleInstallState(LoadModuleStateInformationEvent aLoadModuleStateInformationEvent)", "Throwable caught (ignored). Note that this might result in that the state in the PiuTypeMo's not are updated as expected.\n\taLoadModuleStateInformationEvent: " + loadModuleStateInformationEvent, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePiuTypeLoadModuleInstallState(LoadModuleSupervisionInformationEvent loadModuleSupervisionInformationEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updatePiuTypeLoadModuleInstallState(LoadModuleSupervisionInformationEvent aLoadModuleSupervisionInformationEvent)", "aLoadModuleSupervisionInformationEvent: " + loadModuleSupervisionInformationEvent);
        }
        boolean bl = false;
        try {
            block6: {
                try {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "updatePiuTypeLoadModuleInstallState(LoadModuleSupervisionInformationEvent aLoadModuleSupervisionInformationEvent)", "Updating state in all PiuType Mo's");
                    }
                    HW_SensitiveAdapter hW_SensitiveAdapter = new HW_SensitiveAdapter();
                    hW_SensitiveAdapter.updateStateInAllPiuTypes();
                    bl = true;
                    if (!Trace.valid(this.getClass(), 22)) break block6;
                    Trace.debug(this.getClass(), 22, "updatePiuTypeLoadModuleInstallState(LoadModuleSupervisionInformationEvent aLoadModuleSupervisionInformationEvent)", "States updated in Piu Type Mo's");
                }
                catch (Throwable throwable) {
                    Trace.error(this.getClass(), "updatePiuTypeLoadModuleInstallState(LoadModuleSupervisionInformationEvent aLoadModuleSupervisionInformationEvent)", "Throwable caught (ignored). Note that this might result in that the state in the PiuTypeMo's not are updated as expected.\n\taLoadModuleSupervisionInformationEvent: " + loadModuleSupervisionInformationEvent, throwable);
                    Object var5_6 = null;
                    PiuTypeMosSupervisionInformationEvent piuTypeMosSupervisionInformationEvent = new PiuTypeMosSupervisionInformationEvent(this, bl);
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.PiuTypeStateSupervision, piuTypeMosSupervisionInformationEvent);
                }
            }
            Object var5_5 = null;
            PiuTypeMosSupervisionInformationEvent piuTypeMosSupervisionInformationEvent = new PiuTypeMosSupervisionInformationEvent(this, bl);
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.PiuTypeStateSupervision, piuTypeMosSupervisionInformationEvent);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            PiuTypeMosSupervisionInformationEvent piuTypeMosSupervisionInformationEvent = new PiuTypeMosSupervisionInformationEvent(this, bl);
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.PiuTypeStateSupervision, piuTypeMosSupervisionInformationEvent);
            throw throwable;
        }
    }

    public void updatePiuTypeLoadModuleInstallState(boolean bl) {
        String string = "updatePiuTypeLoadModuleInstallState(boolean anIsStartUpOfOaM_InProgress)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "anIsStartUpOfOaM_InProgress: " + bl);
        }
        try {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, string, "Updating state in all PiuType Mo's");
            }
            HW_SensitiveAdapter hW_SensitiveAdapter = new HW_SensitiveAdapter();
            hW_SensitiveAdapter.updateStateInAllPiuTypes(bl);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, string, "The states have been updated");
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught (ignored). Note that this might result in that the state in the PiuTypeMo's not are updated as expected.", throwable);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = "propertyChange(PropertyChangeEvent aPropertyChangeEvent)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aPropertyChangeEvent (new value): " + propertyChangeEvent.getNewValue() + "\n\tmyIsActive: " + this.myIsActive);
        }
        if (!this.myIsActive) {
            return;
        }
        if (propertyChangeEvent.getNewValue() instanceof LoadModuleStateInformationEvent) {
            this.myQueue.enqueue(propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getNewValue() instanceof LoadModuleSupervisionInformationEvent) {
            this.myQueue.enqueue(propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getNewValue() instanceof LMsForPiuTypeInstallStateInformationEvent) {
            this.myQueue.enqueue(propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getNewValue() instanceof SwAllocationPropertyChangeEvent) {
            this.addObjectToQueuedSwAllocations(propertyChangeEvent.getNewValue());
            this.myQueue.enqueue(propertyChangeEvent.getNewValue());
        } else {
            Trace.info(this.getClass(), string, "Unknown type of object received in a PropertyChangeEvent (ignored),\n\tReceived object: " + propertyChangeEvent.getNewValue());
        }
    }

    private synchronized void removeAllObjectsInQueuedSwAllocations() {
        this.myQueuedSwAllocationConfigurationChangeEvents.clear();
    }

    private synchronized void addObjectToQueuedSwAllocations(Object object) {
        this.myQueuedSwAllocationConfigurationChangeEvents.add(object);
    }
}

