/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade.step.rebootnodeupgrade;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.SAXException;
import se.ericsson.cello.managedelement.suaccess.ManagedElementMoSU_Access;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.su.classloader.DynamicClassLoaderCentral;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageUtil;
import se.ericsson.cello.su.util.javaheap.JavaHeapHelper;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.main.UpgradePackageMoImpl;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.UpgradePackageUpgrader;
import se.ericsson.cello.upgradepackage.upgrade.event.ActivatedTypeOfUP_InformationEvent;
import se.ericsson.cello.upgradepackage.upgrade.step.ExecutableOp;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootjvmupgrade.JvmUpdateHandler;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootnodeupgrade.PmTriggerController;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootnodeupgrade.TriggerData;
import se.ericsson.cello.upgradepackage.upgrade.step.trigger.TriggerOp;
import se.ericsson.cello.upgradepackage.util.datacontainer.NewStepLabelInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.NodeRestartNormalReqInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.NodeUpgradeRequestInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.WaitingForResumeUpgrade;
import se.ericsson.cello.upgradepackage.util.enumer.ActivatedTypeOfUP;
import se.ericsson.cello.upgradepackage.util.enumer.InstalledTypeOfUP;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;

public final class RebootNodeUpgradeOp
implements ExecutableOp {
    private String myBaseClassPath;
    private Integer myJavaHeapSize;
    private boolean myUseRepertoiresValue = false;
    private Vector myAddLmList = null;
    private Vector myRemoveLmList = null;
    private String myProductNumber = null;
    private String myProductRevision = null;
    private boolean myTolerateErrors = false;
    private UpgradePackageMoImpl myUpgradePackageMO = null;
    private InstalledTypeOfUP myInstalledTypeOfUP = null;
    private Vector myTriggerList = new Vector();
    private String myPreviousStepLabel = null;
    private String myStepLabel = null;
    private UpgradePackageUpgrader myUpgradePackageUpgrader = null;
    private boolean myIsForcedMoppletUsage = false;
    public static final String New = "new";

    public RebootNodeUpgradeOp(String string, UpgradePackageUpgrader upgradePackageUpgrader) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "RebootNodeUpgradeOp(String aStepLabel, UpgradePackageUpgrader anUpgradePackageUpgrader)", "aStepLabel: " + string + "\n\tanUpgradePackageUpgrader: " + upgradePackageUpgrader);
        }
        this.myStepLabel = string;
        this.myUpgradePackageUpgrader = upgradePackageUpgrader;
    }

    public RebootNodeUpgradeOp(UpgradePackageMoImpl upgradePackageMoImpl, String string, UpgradePackageUpgrader upgradePackageUpgrader) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "RebootNodeUpgradeOp(UpgradePackageMoImpl anUpgradePackageMoImpl, String aStepLabel, UpgradePackageUpgrader anUpgradePackageUpgrader)", "anUpgradePackageMoImpl: " + upgradePackageMoImpl + "\n\taStepLabel: " + string + "\n\tanUpgradePackageUpgrader: " + upgradePackageUpgrader);
        }
        this.myUpgradePackageMO = upgradePackageMoImpl;
        this.myStepLabel = string;
        this.myUpgradePackageUpgrader = upgradePackageUpgrader;
    }

    public RebootNodeUpgradeOp(Vector vector, String string, Integer n, String string2, Vector vector2, Vector vector3, String string3, String string4, boolean bl, UpgradePackageMoImpl upgradePackageMoImpl, InstalledTypeOfUP installedTypeOfUP, String string5, String string6, UpgradePackageUpgrader upgradePackageUpgrader, boolean bl2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "RebootNodeUpgradeOp(Vector aTriggerList, String aBaseClassPath, Integer aJavaHeapSize, String aUseRepertoiresValue, Vector anAddLmList, Vector aRemoveLmList, String aProductNumber, String aProductRevision, boolean aTolerateErrors, UpgradePackageMoImpl anUpgradePackageMoImpl, InstalledTypeOfUP anInstalledTypeOfUP, String aPreviousStepLabel, String aStepLabel, UpgradePackageUpgrader anUpgradePackageUpgrader, boolean anIsForcedMoppletUsage)", "aTriggerList: " + vector + "\n\taBaseClassPath: " + string + "\n\taJavaHeapSize: " + n + "\n\taUseRepertoiresValue: " + string2 + "\n\tanAddLmList: " + vector2 + "\n\taRemoveLmList: " + vector3 + "\n\taProductNumber: " + string3 + "\n\taProductRevision: " + string4 + "\n\taTolerateErrors: " + bl + "\n\tanUpgradePackageMoImpl: " + upgradePackageMoImpl + "\n\tanInstalledTypeOfUP: " + installedTypeOfUP + "\n\taPreviousStepLabel: " + string5 + "\n\taStepLabel: " + string6 + "\n\tanUpgradePackageUpgrader: " + upgradePackageUpgrader + "\n\tanIsForcedMoppletUsage: " + bl2);
        }
        this.myTriggerList = vector;
        this.myBaseClassPath = string;
        this.myJavaHeapSize = n;
        if (string2 != null) {
            this.myUseRepertoiresValue = true;
        }
        this.myAddLmList = vector2;
        this.myRemoveLmList = vector3;
        this.myProductNumber = string3;
        this.myProductRevision = string4;
        this.myTolerateErrors = bl;
        this.myUpgradePackageMO = upgradePackageMoImpl;
        this.myInstalledTypeOfUP = installedTypeOfUP;
        this.myPreviousStepLabel = string5;
        this.myStepLabel = string6;
        this.myUpgradePackageUpgrader = upgradePackageUpgrader;
        this.myIsForcedMoppletUsage = bl2;
    }

    public synchronized void executeOp(ActionListener actionListener) throws SAXException {
        try {
            if (UpgradeDB_StorageUtil.isUpgradeWithStop()) {
                Trace.log1(this.getClass(), "executeOp(ActionListener anObserver)", "Stop before execute operation 'RebootNodeUpgrade', stepLabel: " + this.myStepLabel);
                this.stopBeforeRebootNodeUpgrade();
            } else if (UpgradeDB_StorageUtil.isNameOfCreatedSU_CV_Existing()) {
                Trace.log1(this.getClass(), "executeOp(ActionListener anObserver)", "Execute operation 'RebootNodeUpgrade' after resumeSwUpgrade, stepLabel: " + this.myStepLabel);
                this.rebootNodeUpgradeAfterResumeSwUpgrade();
            } else {
                Trace.log1(this.getClass(), "executeOp( ActionListener anObserver )", "Execute operation 'RebootNodeUpgrade', stepLabel: " + this.myStepLabel);
                this.rebootNodeUpgrade();
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "executeOp( ActionListener anObserver )", "Throwable caught. Reson: " + throwable.getMessage(), throwable);
            throw new SAXException(throwable.toString());
        }
    }

    public synchronized void executeOpAtPiuRestartRejected(String string, String string2, boolean bl) throws SAXException {
        Trace.log1(this.getClass(), "executeOpAtPiuRestartRejected()", "Execute operation 'RebootNodeUpgrade' at PIU restart rejected.");
        try {
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NewStepLabelInformation((Object)this, this.myStepLabel));
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NodeUpgradeRequestInformation(this));
            JvmUpdateHandler jvmUpdateHandler = new JvmUpdateHandler();
            jvmUpdateHandler.generateAndSetJvmToStateClassPathAndHeapSize(this.myUpgradePackageMO.getCurrentSequenceLabel(null), this.myStepLabel, this.myUpgradePackageMO);
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            configurationVersionMO_HandlerInterface.createUpgradeTemporaryCV_AndSetStartable(string, string2, bl);
            configurationVersionMO_HandlerInterface.updateRollbackDataForUpgradeTemporaryCV(1);
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "executeOpAtPiuRestartRejected()", "Exception caught. Reson: " + exception.getMessage(), exception);
            throw new SAXException(exception.toString());
        }
        try {
            this.doPerformNodeRestart();
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "executeOpAtPiuRestartRejected()", "Exception caught when requesting for a node restart. Reson: " + moAccessException.getMessage(), moAccessException);
            throw new SAXException(moAccessException.toString());
        }
    }

    private void doPerformNodeRestart() throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "doPerformNodeRestart()");
        }
        Coordinator coordinator = null;
        Control control = null;
        try {
            control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
            coordinator = control.getCoordinator();
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "doPerformNodeRestart ( )", "Failed to create a tansaction handle to request for node restart.\n\tException message: " + exception.getMessage(), exception);
        }
        Trace.log1(this.getClass(), "doPerformNodeRestart( )", "Requesting the Node to be restarted within 5000 milliseconds.");
        try {
            Trace.flushToTraceFile();
        }
        catch (Exception exception) {
            Trace.warning(this.getClass(), "doPerformNodeRestart( )", "Exception caught when flushing trace logs (ignored).");
        }
        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NodeRestartNormalReqInformation(this));
        TimeHandler.sleep(500L);
        ManagedElementMoSU_Access managedElementMoSU_Access = (ManagedElementMoSU_Access)ServiceLocatorFacade.getRepository().getService(ManagedElementMoSU_Access.class);
        managedElementMoSU_Access.systemInitiatedRestartFromSU(0, 20, "", coordinator);
        try {
            control.getTerminator().commit();
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "doPerformNodeRestart ( )", "Failed to commit the transaction created to request for node restart.\n\tException message: " + exception.getMessage(), exception);
        }
    }

    private void stopBeforeRebootNodeUpgrade() throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "stopBeforeRebootNodeUpgrade( )");
        }
        try {
            Object object;
            Object object2;
            UpgradeDB_StorageUtil.removeUpgradeWithStop();
            JvmMO_HandlerInterface jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface();
            LoadModuleMoSU_Access[] loadModuleMoSU_AccessArray = jvmMO_HandlerInterface.getAdmClassPath();
            Collection collection = DynamicClassLoaderCentral.getInstance().getDynClasspath(this.myUpgradePackageMO);
            long l = jvmMO_HandlerInterface.getJavaHeapSizeInBytes();
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            UpgradePackageMoExtended upgradePackageMoExtended = configurationVersionMO_HandlerInterface.getCurrentUpgradePackage(null);
            String string = UpgradeDB_StorageUtil.getNewActiveUP_ProductNumber();
            String string2 = UpgradeDB_StorageUtil.getNewActiveUP_ProductRevision();
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NewStepLabelInformation(this, this.myStepLabel, true));
            UpgradeDB_StorageUtil.changeExecutedFromStateTo_ToState();
            UpgradeDB_StorageUtil.logUpgradeDB(" --- change value of ExecutedFromStateTo_ToState --- ");
            UpgradeDB_StorageUtil.removeAllLoadedCertInfo();
            if (this.myJavaHeapSize == null && (New.equalsIgnoreCase(this.myBaseClassPath) || this.myUseRepertoiresValue) && (object2 = ((JavaHeapHelper)(object = new JavaHeapHelper())).selectJavaHeap(this.myUpgradePackageMO.getUpgradeControlFilePath(null), this.myUpgradePackageMO.getDocumentNumber(null), this.myUpgradePackageMO.getDocumentRevision(null))) != null) {
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "stopBeforeRebootNodeUpgrade( )", "The Java heap defined in Repertoires is used: " + object2);
                }
                this.myJavaHeapSize = object2;
            }
            object = new JvmUpdateHandler();
            ((JvmUpdateHandler)object).updateJvmDynamicClassPathAndJavaHeap(this.myBaseClassPath, this.myAddLmList, this.myRemoveLmList, this.myJavaHeapSize, this.myUpgradePackageMO, this.myIsForcedMoppletUsage, true);
            object2 = this.createSU_CV(configurationVersionMO_HandlerInterface);
            UpgradeDB_StorageUtil.saveNameOfCreatedSU_CV((String)object2);
            if (string != null && string2 != null) {
                UpgradeDB_StorageUtil.saveNewActiveUP_ProductNumber(string);
                UpgradeDB_StorageUtil.saveNewActiveUP_ProductRevision(string2);
            }
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NewStepLabelInformation(this, this.myPreviousStepLabel, true));
            this.restoreJvmClasspathAndJavaHeapSize(loadModuleMoSU_AccessArray, l, collection, jvmMO_HandlerInterface);
            configurationVersionMO_HandlerInterface.setCurrentUpgradePackage(upgradePackageMoExtended, null);
            this.myUpgradePackageUpgrader.requestNormalExecutionMode();
            this.executeTriggerResumePM();
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new WaitingForResumeUpgrade(this));
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "stopBeforeRebootNodeUpgrade( )", "Execution of stop before RebootNodeUgprade failed due to Throwable caugth.\n\tRequest for rollback to rollback CV.", throwable);
            throw new SAXException("Execution of stop before RebootNodeUpgrade failed due to Throwable caugth.Throwable: " + throwable);
        }
    }

    private void rebootNodeUpgradeAfterResumeSwUpgrade() throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "rebootNodeUpgradeAfterResumeSwUpgrade( )");
        }
        try {
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NewStepLabelInformation((Object)this, this.myStepLabel));
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NodeUpgradeRequestInformation(this));
            this.executeRequestedTriggers();
            this.executeTriggerSuspendPM();
            String string = UpgradeDB_StorageUtil.getNameOfCreatedSU_CV();
            UpgradeDB_StorageUtil.removeNameOfCreatedSU_CV();
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            this.setStartableCV(string, configurationVersionMO_HandlerInterface);
            this.doPerformNodeRestart();
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "rebootNodeUpgradeAfterResumeSwUpgrade( )", "Execution of RebootNodeUgrade after resumeSwUpgrade failed due to Throwable caugth.\n\tRequest for rollback to rollback CV.", throwable);
            throw new SAXException("Execution of RebootNodeUgrade after resumeSwUpgrade failed due to Throwable caugth.Throwable: " + throwable);
        }
    }

    private void rebootNodeUpgrade() throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "rebootNodeUpgrade( )");
        }
        try {
            Object object;
            Object object2;
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NewStepLabelInformation((Object)this, this.myStepLabel));
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NodeUpgradeRequestInformation(this));
            UpgradeDB_StorageUtil.changeExecutedFromStateTo_ToState();
            UpgradeDB_StorageUtil.logUpgradeDB(" --- change value of ExecutedFromStateTo_ToState --- ");
            UpgradeDB_StorageUtil.removeAllLoadedCertInfo();
            if (this.myJavaHeapSize == null && (New.equalsIgnoreCase(this.myBaseClassPath) || this.myUseRepertoiresValue) && (object2 = ((JavaHeapHelper)(object = new JavaHeapHelper())).selectJavaHeap(this.myUpgradePackageMO.getUpgradeControlFilePath(null), this.myUpgradePackageMO.getDocumentNumber(null), this.myUpgradePackageMO.getDocumentRevision(null))) != null) {
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "rebootNodeUpgrade( )", "The Java heap defined in Repertoires is used: " + object2);
                }
                this.myJavaHeapSize = object2;
            }
            object = new JvmUpdateHandler();
            ((JvmUpdateHandler)object).updateJvmDynamicClassPathAndJavaHeap(this.myBaseClassPath, this.myAddLmList, this.myRemoveLmList, this.myJavaHeapSize, this.myUpgradePackageMO, this.myIsForcedMoppletUsage, true);
            object2 = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            String string = this.createSU_CV((ConfigurationVersionMO_HandlerInterface)object2);
            this.executeRequestedTriggers();
            this.setStartableCV(string, (ConfigurationVersionMO_HandlerInterface)object2);
            this.doPerformNodeRestart();
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "rebootNodeUpgrade( )", "Execution of RebootNodeUgrade failed due to Throwable caugth.\n\tRequest for rollback to rollback CV.", throwable);
            throw new SAXException("Execution of RebootNodeUgrade failed due to Throwable caugth.Throwable: " + throwable);
        }
    }

    private String createSU_CV(ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface) throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createSU_CV(ConfigurationVersionMO_HandlerInterface aConfigurationVersionMO_HandlerInterface)", "aConfigurationVersionMO_HandlerInterface: " + configurationVersionMO_HandlerInterface);
        }
        String string = null;
        try {
            configurationVersionMO_HandlerInterface.deleteOneOldUpgradeTemporaryCV();
            ActivatedTypeOfUP activatedTypeOfUP = ActivatedTypeOfUP.getInstance(this.myInstalledTypeOfUP.getValue());
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ActivatedTypeOfUP, new ActivatedTypeOfUP_InformationEvent(this, activatedTypeOfUP));
            configurationVersionMO_HandlerInterface.setCurrentUpgradePackage(this.myUpgradePackageMO, null);
            UpgradeDB_StorageUtil.removeNewActiveUP();
            string = configurationVersionMO_HandlerInterface.createUpgradeTemporaryCV(this.myProductNumber, this.myProductRevision, this.myTolerateErrors);
            return string;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createSU_CV(ConfigurationVersionMO_HandlerInterface aConfigurationVersionMO_HandlerInterface)", "Throwable caught when trying to create an SU CV.", throwable);
            throw new SAXException("Throwable caught when trying to create a System Upgrade CV.Throwable: " + throwable);
        }
    }

    private void restoreJvmClasspathAndJavaHeapSize(LoadModuleMoSU_Access[] loadModuleMoSU_AccessArray, long l, Collection collection, JvmMO_HandlerInterface jvmMO_HandlerInterface) throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "restoreJvmClasspathAndJavaHeapSize(LoadModuleMoSU_Access[] anOriginalAdmClassPath, long anOriginalJavaHeapSize, Collection anOriginalDYnamicClassPath, JvmMO_HandlerInterface aJvmMO_Handler)", "anOriginalAdmClassPath: " + SuLib.toString((ManagedObject[])loadModuleMoSU_AccessArray) + "\n\tanOriginalJavaHeapSize: " + l + "\n\tanOriginalDynamicClassPath: " + collection + "\n\taJvmMO_HandlerInterface: " + jvmMO_HandlerInterface);
        }
        try {
            jvmMO_HandlerInterface.setClassPath((ManagedObject[])loadModuleMoSU_AccessArray);
            if (l != -1L && l != -2L) {
                l /= 1024L;
            }
            jvmMO_HandlerInterface.setJavaHeapSize(new Integer((int)l));
            DynamicClassLoaderCentral.getInstance().setDynClassPath(this.myUpgradePackageMO, collection);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "restoreJvmClasspathAndJavaHeapSize(LoadModuleMoSU_Access[] anOriginalAdmClassPath, long anOriginalJavaHeapSize, Collection anOriginalDYnamicClassPath, JvmMO_HandlerInterface aJvmMO_HandlerInterface)", "Throwable caught, \n\tanOriginalAdmClassPath: " + SuLib.toString((ManagedObject[])loadModuleMoSU_AccessArray) + "\n\tanOriginalJavaHeapSize: " + l + "\n\taJvmMO_HandlerInterface: " + jvmMO_HandlerInterface, throwable);
            throw new SAXException("Throwable caught when trying to restore JVM classpath and java heapsize.Throwable: " + throwable);
        }
    }

    private void executeRequestedTriggers() throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "executeRequestedTriggers( )");
        }
        Iterator iterator = this.myTriggerList.iterator();
        TriggerData triggerData = null;
        TriggerOp triggerOp = null;
        boolean bl = false;
        UpgradeDB_StorageUtil.logUpgradeDB("Trigger List ..." + this.myTriggerList.size());
        try {
            while (iterator.hasNext()) {
                triggerData = (TriggerData)iterator.next();
                triggerOp = new TriggerOp(triggerData.getSubSpec(), triggerData.getSupervisionTimeIntValue(), this.myUpgradePackageMO);
                bl = triggerOp.doTriggerCentral();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "executeRequestedTriggers( )", "subSpec: " + triggerData.getSubSpec() + "\n\tsupervisionTimeIntValue: " + triggerData.getSupervisionTimeIntValue() + "\n\ttriggerResult : " + bl);
                }
                if (bl) continue;
                Trace.error(this.getClass(), "executeRequestedTriggers( )", "Execution of trigger failed (at execution of an Operation 'executeOp').\n\tsubSpec: " + triggerData.getSubSpec() + "\n\tsupervisionTimeIntValue: " + triggerData.getSupervisionTimeIntValue());
                throw new SAXException("Execution of trigger " + triggerData.getSubSpec() + " failed (at execution of a RebootNodeUpgrade step).");
            }
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "executeRequestedTriggers( )", "Throwable caught.", throwable);
            throw new SAXException("Throwable caught when trying to execute trigger " + triggerData.getSubSpec() + " (at execution of a RebootNodeUpgrade step)." + "Throwable: " + throwable);
        }
    }

    private void executeTriggerSuspendPM() throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "executeTriggerSuspendPM( )");
        }
        try {
            if (UpgradeDB_StorageUtil.isResumePM_AtStop()) {
                UpgradeDB_StorageUtil.removeResumePM_AtStop();
                PmTriggerController pmTriggerController = new PmTriggerController();
                pmTriggerController.suspendPm(this.myUpgradePackageMO);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "executeTriggerSuspendPM( )", "Throwable caught when checking if trigger SuspendPM shall be executed.", throwable);
            throw new SAXException("Throwable caught when checking if trigger SuspendPM shall be executed.Throwable: " + throwable);
        }
    }

    private void executeTriggerResumePM() throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "executeTriggerResumePM( )");
        }
        try {
            if (UpgradeDB_StorageUtil.isSuspendPM()) {
                PmTriggerController pmTriggerController = new PmTriggerController();
                pmTriggerController.resumePm(this.myUpgradePackageMO);
                UpgradeDB_StorageUtil.saveResumePM_AtStop(true);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "executeTriggerResumePM( )", "Throwable caught when checking if trigger ResumePM shall be executed.", throwable);
            throw new SAXException("Throwable caught when checking if trigger ResumePM shall be executed.Throwable: " + throwable);
        }
    }

    private void setStartableCV(String string, ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface) throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setStartableCV(String aCV_Name, ConfigurationVersionMO_HandlerInterface aConfigurationVersionMO_HandlerInterface)", "aCV_Name: " + string + "\n\taConfigurationVersionMO_HandlerInterface: " + configurationVersionMO_HandlerInterface);
        }
        try {
            configurationVersionMO_HandlerInterface.setRollbackDataForUpgradeTemporaryCV();
            configurationVersionMO_HandlerInterface.setStartableCV(string);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setStartableCV(String aCV_Name, ConfigurationVersionMO_HandlerInterface aConfigurationVersionMO_HandlerInterface)", "Throwable caught when trying to set the created System Upgrade CV as startable CV.", throwable);
            throw new SAXException("Throwable caught when trying to set the created System Upgrade CV as startable CV.Throwable: " + throwable);
        }
    }
}

