/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade;

import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.SAXException;
import se.ericsson.cello.mao.RestartReasonEnum;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.su.extsuif.upgradepackage.main.exception.UpgradePackageException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageUtil;
import se.ericsson.cello.su.util.javaheap.JavaHeapHelper;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.upgradepackage.control.UpgradeCoordinator;
import se.ericsson.cello.upgradepackage.main.UpgradePackageMoImpl;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.UpgradePackageUpgrader;
import se.ericsson.cello.upgradepackage.upgrade.event.ActivatedTypeOfUP_InformationEvent;
import se.ericsson.cello.upgradepackage.upgrade.step.ExecutableOp;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootjvmupgrade.JvmUpdateHandler;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootnodeupgrade.PmTriggerController;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootnodeupgrade.TriggerData;
import se.ericsson.cello.upgradepackage.upgrade.step.trigger.TriggerOp;
import se.ericsson.cello.upgradepackage.util.datacontainer.NewStepLabelInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.NodeRestartFailureReqInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.PIU_UpgradeRequestInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.UpgradeExecutionFailedInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.WaitingForResumeUpgrade;
import se.ericsson.cello.upgradepackage.util.enumer.ActivatedTypeOfUP;
import se.ericsson.cello.upgradepackage.util.enumer.InstalledTypeOfUP;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public final class RebootPiuUpgradeOp
implements ExecutableOp {
    private int myNumberOfIterations = 0;
    private String myBaseClassPath = null;
    private Integer myJavaHeapSize = null;
    private boolean myUseRepertoiresValue = false;
    private Vector myAddLmList = null;
    private Vector myRemoveLmList = null;
    private UpgradePackageMoImpl myUpgradePackageMO = null;
    private Vector myTriggers = null;
    private InstalledTypeOfUP myInstalledTypeOfUP = null;
    private String myStepLabel = null;
    private UpgradePackageUpgrader myUpgradePackageUpgrader = null;
    private boolean myIsOpForStopBeforeRebootPiuUpgrade = false;
    private boolean myIsForcedMoppletUsage = false;
    private boolean myIsAllJvmPiusRemovedFromPiuLists = false;

    public RebootPiuUpgradeOp(UpgradePackageMoImpl upgradePackageMoImpl, InstalledTypeOfUP installedTypeOfUP, String string, UpgradePackageUpgrader upgradePackageUpgrader) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "RebootPiuUpgradeOp(UpgradePackageUpgrader anUpgradePackageUpgrader, String aStepLabel)", "anUpgradePackageMO: " + upgradePackageMoImpl + "\n\tanInstalledTypeOfUP: " + installedTypeOfUP + "\n\taStepLabel: " + string + "\n\tanUpgradePackageUpgrader: " + upgradePackageUpgrader);
        }
        this.myUpgradePackageMO = upgradePackageMoImpl;
        this.myInstalledTypeOfUP = installedTypeOfUP;
        this.myStepLabel = string;
        this.myUpgradePackageUpgrader = upgradePackageUpgrader;
        this.myIsOpForStopBeforeRebootPiuUpgrade = true;
    }

    public RebootPiuUpgradeOp(int n, String string, Integer n2, String string2, Vector vector, Vector vector2, UpgradePackageMoImpl upgradePackageMoImpl, Vector vector3, InstalledTypeOfUP installedTypeOfUP, String string3, boolean bl, boolean bl2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "RebootPiuUpgradeOp(int aNumberOfIterations, String aBaseClassPath, Integer aJavaHeapSize, String aUseRepertoiresValue, Vector anAddLmList, Vector aRemoveLmList, UpgradePackageMoImpl anUpgradePackageMO, Vector aTriggers, InstalledTypeOfUP anInstalledTypeOfUP, String aStepLabel, boolean anIsForcedMoppletUsage, boolean anIsAllJvmPiusRemovedFromPiuLists)", "aNumberOfIterations: " + n + "\n\taBaseClassPath: " + string + "\n\taJavaHeapSize: " + n2 + "\n\taUseRepertoiresValue: " + string2 + "\n\tanAddLmList: " + vector + "\n\taRemoveLmList: " + vector2 + "\n\tanUpgradePackageMO: " + upgradePackageMoImpl + "\n\taTriggers: " + vector3 + "\n\tanInstalledTypeOfUP: " + installedTypeOfUP + "\n\taStepLabel: " + string3 + "\n\tanIsForcedMoppletUsage: " + bl + "\n\tanIsAllJvmPiusRemovedFromPiuLists: " + bl2);
        }
        this.myNumberOfIterations = n;
        this.myBaseClassPath = string;
        this.myJavaHeapSize = n2;
        if (string2 != null) {
            this.myUseRepertoiresValue = true;
        }
        this.myAddLmList = vector;
        this.myRemoveLmList = vector2;
        this.myUpgradePackageMO = upgradePackageMoImpl;
        this.myTriggers = vector3;
        this.myInstalledTypeOfUP = installedTypeOfUP;
        this.myStepLabel = string3;
        this.myIsForcedMoppletUsage = bl;
        this.myIsAllJvmPiusRemovedFromPiuLists = bl2;
    }

    public synchronized void executeOp(ActionListener actionListener) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "executeOp(ActionListener anObserver)", "anObserver: " + actionListener);
        }
        try {
            if (this.myIsOpForStopBeforeRebootPiuUpgrade) {
                Trace.log1(this.getClass(), "executeOp(ActionListener anObserver)", "Stop before execute operation 'RebootPiuUpgrade', stepLabel: " + this.myStepLabel);
                this.stopBeforeRebootPiuUpgrade();
            } else if (UpgradeDB_StorageUtil.isNameOfCreatedSU_CV_Existing()) {
                Trace.log1(this.getClass(), "executeOp(ActionListener anObserver)", "Execute operation 'RebootPiuUpgrade' after resumeSwUpgrade, stepLabel: " + this.myStepLabel);
                this.rebootPiuUpgradeAfterResumeSwUpgrade();
            } else {
                Trace.log1(this.getClass(), "executeOp( ActionListener anObserver )", "Execute operation 'RebootPiuUpgrade', stepLabel: " + this.myStepLabel);
                this.rebootPiuUpgrade();
            }
        }
        catch (SAXException sAXException) {
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NodeRestartFailureReqInformation(this));
            UpgradeExecutionFailedInformation upgradeExecutionFailedInformation = new UpgradeExecutionFailedInformation((Object)this, "Execution of operation RebootPiuUpgrade failed,\n\treason: " + sAXException.getMessage());
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, upgradeExecutionFailedInformation);
            UpgradeCoordinator.instance().doPerformNodeRestart(new RestartReasonEnum(21, this.getClass()));
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "executeOp(ActionListener anObserver)", "Execution of operation RebootPiuUpgrade failed due to Throwable caugth.\n\tRequest for rollback to rollback CV.", throwable);
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NodeRestartFailureReqInformation(this));
            UpgradeExecutionFailedInformation upgradeExecutionFailedInformation = new UpgradeExecutionFailedInformation((Object)this, "Execution of operation RebootPiuUpgrade failed,\n\treason: Throwable caugth,\n\tThrowable: " + throwable);
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, upgradeExecutionFailedInformation);
            UpgradeCoordinator.instance().doPerformNodeRestart(new RestartReasonEnum(21, this.getClass()));
        }
    }

    public String toString() {
        return "\n\n\tClass: " + this.getClass().getName() + "\n\tmyNumberOfIterations: " + this.myNumberOfIterations + "\n\tmyBaseClassPath: " + this.myBaseClassPath + "\n\tmyJavaHeapSize: " + this.myJavaHeapSize + "\n\tmyUseRepertoiresValue: " + this.myUseRepertoiresValue + "\n\tmyAddLmList: " + this.myAddLmList + "\n\tmyRemoveLmList: " + this.myRemoveLmList + "\n\tmyUpgradePackageMO: " + this.myUpgradePackageMO + "\n\tmyTriggers: " + this.myTriggers + "\n\tmyInstalledTypeOfUP: " + this.myInstalledTypeOfUP + "\n\tmyStepLabel: " + this.myStepLabel + "\n\tmyUpgradePackageUpgrader: " + this.myUpgradePackageUpgrader + "\n\tmyIsOpForStopBeforeRebootPiuUpgrade: " + this.myIsOpForStopBeforeRebootPiuUpgrade;
    }

    private void stopBeforeRebootPiuUpgrade() throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "stopBeforeRebootPiuUpgrade( )");
        }
        try {
            UpgradeDB_StorageUtil.removeUpgradeWithStop();
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            UpgradePackageMoExtended upgradePackageMoExtended = configurationVersionMO_HandlerInterface.getCurrentUpgradePackage(null);
            String string = UpgradeDB_StorageUtil.getNewActiveUP_ProductNumber();
            String string2 = UpgradeDB_StorageUtil.getNewActiveUP_ProductRevision();
            String string3 = this.createSU_CV(configurationVersionMO_HandlerInterface);
            UpgradeDB_StorageUtil.saveNameOfCreatedSU_CV(string3);
            if (string != null && string2 != null) {
                UpgradeDB_StorageUtil.saveNewActiveUP_ProductNumber(string);
                UpgradeDB_StorageUtil.saveNewActiveUP_ProductRevision(string2);
            }
            configurationVersionMO_HandlerInterface.setCurrentUpgradePackage(upgradePackageMoExtended, null);
            this.myUpgradePackageUpgrader.requestNormalExecutionMode();
            this.executeTriggerResumePM();
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new WaitingForResumeUpgrade(this));
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "stopBeforeRebootPiuUpgrade( )", "Execution of stop before RebootPiuUpgrade failed due to Throwable caugth.\n\tRequest for rollback to rollback CV.", throwable);
            throw new SAXException("Execution of stop before RebootPiuUpgrade failed due to Throwable caugth.Throwable: " + throwable);
        }
    }

    private void rebootPiuUpgradeAfterResumeSwUpgrade() throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "rebootPiuUpgradeAfterResumeSwUpgrade( )");
        }
        try {
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NewStepLabelInformation((Object)this, this.myStepLabel));
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new PIU_UpgradeRequestInformation(this));
            ServiceFinder.getConfigurationVersionMO_HandlerInterface().setCurrentUpgradePackage(this.myUpgradePackageMO, null);
            if (!UpgradeDB_StorageUtil.isExecutedFromStateExisting() || UpgradeDB_StorageUtil.isExecutedFromState()) {
                UpgradeDB_StorageUtil.changeExecutedFromStateTo_ToState();
                UpgradeDB_StorageUtil.logUpgradeDB("------- REBOOT PIU UPGRADE ------");
            }
            this.updateJvmDynamicClassPathAndJavaHeap();
            this.executeRequestedTriggers();
            this.executeTriggerSuspendPM();
            String string = UpgradeDB_StorageUtil.getNameOfCreatedSU_CV();
            UpgradeDB_StorageUtil.removeNameOfCreatedSU_CV();
            this.setStartableCV(string, null);
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "rebootPiuUpgradeAfterResumeSwUpgrade( )", "Execution of RebootPiuUgrade after resumeSwUpgrade failed due to Throwable caugth.\n\tRequest for rollback to rollback CV.", throwable);
            throw new SAXException("Execution of RebootPiuUgrade after resumeSwUpgrade failed due to Throwable caugth.Throwable: " + throwable);
        }
    }

    private void rebootPiuUpgrade() throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "rebootPiuUpgrade( )");
        }
        try {
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NewStepLabelInformation((Object)this, this.myStepLabel));
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new PIU_UpgradeRequestInformation(this));
            if (!UpgradeDB_StorageUtil.isExecutedFromStateExisting() || UpgradeDB_StorageUtil.isExecutedFromState()) {
                UpgradeDB_StorageUtil.changeExecutedFromStateTo_ToState();
                UpgradeDB_StorageUtil.logUpgradeDB("------- REBOOT PIU UPGRADE ------");
            }
            this.updateJvmDynamicClassPathAndJavaHeap();
            String string = this.createSU_CV(null);
            this.executeRequestedTriggers();
            this.setStartableCV(string, null);
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "rebootPiuUpgrade( )", "Execution of RebootPiuUgrade failed due to Throwable caugth.\n\tRequest for rollback to rollback CV.", throwable);
            throw new SAXException("Execution of RebootPiuUgrade failed due to Throwable caugth.Throwable: " + throwable);
        }
    }

    private String createSU_CV(ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface) throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createSU_CV(ConfigurationVersionMO_HandlerInterface aConfigurationVersionMO_HandlerInterface)", "aConfigurationVersionMO_HandlerInterface: " + configurationVersionMO_HandlerInterface);
        }
        String string = null;
        try {
            if (!this.myUpgradePackageMO.getIsSU_CV_ForPiuUpgradeCreated()) {
                ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface2 = configurationVersionMO_HandlerInterface;
                if (configurationVersionMO_HandlerInterface2 == null) {
                    configurationVersionMO_HandlerInterface2 = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
                }
                configurationVersionMO_HandlerInterface2.deleteOneOldUpgradeTemporaryCV();
                ActivatedTypeOfUP activatedTypeOfUP = ActivatedTypeOfUP.getInstance(this.myInstalledTypeOfUP.getValue());
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ActivatedTypeOfUP, new ActivatedTypeOfUP_InformationEvent(this, activatedTypeOfUP));
                configurationVersionMO_HandlerInterface2.setCurrentUpgradePackage(this.myUpgradePackageMO, null);
                UpgradeDB_StorageUtil.removeNewActiveUP();
                this.myUpgradePackageMO.setIsSU_CV_ForPiuUpgradeCreated(true);
                UpgradeDB_StorageUtil.changeExecutedFromStateTo_ToState();
                UpgradeDB_StorageUtil.logUpgradeDB(" --- change value of ExecutedFromStateTo_ToState --- ");
                UpgradeDB_StorageUtil.removeAllLoadedCertInfo();
                string = configurationVersionMO_HandlerInterface2.createUpgradeTemporaryCV(this.myUpgradePackageMO.getDocumentNumber(null), this.myUpgradePackageMO.getDocumentRevision(null), false);
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "createSU_CV( )", "Do not need to create a System Upgrade CV since it already has been performed.");
            }
            return string;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createSU_CV( )", "Throwable caught when trying to create an SU CV to enable passive Core MP to start up on correct program version.", throwable);
            throw new SAXException("Throwable caught when trying to create a System Upgrade CV.Throwable: " + throwable);
        }
    }

    private void executeRequestedTriggers() throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "executeRequestedTriggers( )");
        }
        Iterator iterator = this.myTriggers.iterator();
        TriggerData triggerData = null;
        TriggerOp triggerOp = null;
        boolean bl = false;
        try {
            while (iterator.hasNext()) {
                triggerData = (TriggerData)iterator.next();
                triggerOp = new TriggerOp(triggerData.getSubSpec(), triggerData.getSupervisionTimeIntValue(), this.myUpgradePackageMO);
                bl = triggerOp.doTriggerCentral();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "executeRequestedTriggers( )", "subSpec: " + triggerData.getSubSpec() + "\n\tsupervisionTimeIntValue: " + triggerData.getSupervisionTimeIntValue() + "\n\ttriggerResult : " + bl);
                }
                if (bl) continue;
                Trace.error(this.getClass(), "executeRequestedTriggers( )", "Execution of trigger failed (at execution of an Operation 'executeOp').\n\tsubSpec: " + triggerData.getSubSpec() + "\n\tsupervisionTimeIntValue: " + triggerData.getSupervisionTimeIntValue());
                throw new SAXException("Execution of trigger " + triggerData.getSubSpec() + " failed (at execution of a RebootPiuUpgrade step).");
            }
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "executeRequestedTriggers( )", "Throwable caught.", throwable);
            throw new SAXException("Throwable caught when trying to execute trigger " + triggerData.getSubSpec() + " (at execution of a RebootPiuUpgrade step)." + "Throwable: " + throwable);
        }
    }

    private void executeTriggerSuspendPM() throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "executeTriggerSuspendPM( )");
        }
        try {
            if (UpgradeDB_StorageUtil.isResumePM_AtStop()) {
                UpgradeDB_StorageUtil.removeResumePM_AtStop();
                PmTriggerController pmTriggerController = new PmTriggerController();
                pmTriggerController.suspendPm(this.myUpgradePackageMO);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "executeTriggerSuspendPM( )", "Throwable caught when checking if trigger SuspendPM shall be executed.", throwable);
            throw new SAXException("Throwable caught when checking if trigger SuspendPM shall be executed.Throwable: " + throwable);
        }
    }

    private void executeTriggerResumePM() throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "executeTriggerResumePM( )");
        }
        try {
            if (UpgradeDB_StorageUtil.isSuspendPM()) {
                PmTriggerController pmTriggerController = new PmTriggerController();
                pmTriggerController.resumePm(this.myUpgradePackageMO);
                UpgradeDB_StorageUtil.saveResumePM_AtStop(true);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "executeTriggerResumePM( )", "Throwable caught when checking if trigger ResumePM shall be executed.", throwable);
            throw new SAXException("Throwable caught when checking if trigger ResumePM shall be executed.Throwable: " + throwable);
        }
    }

    private void setStartableCV(String string, ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface) throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setStartableCV(String aCV_Name)", "aCV_Name: " + string + "\n\taConfigurationVersionMO_HandlerInterface: " + configurationVersionMO_HandlerInterface);
        }
        try {
            if (string != null) {
                ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface2;
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "setStartableCV(String aCV_Name, ConfigurationVersionMO_HandlerInterface aConfigurationVersionMO_HandlerInterface)", "Set the created System Upgrade CV as startable CV.");
                }
                if ((configurationVersionMO_HandlerInterface2 = configurationVersionMO_HandlerInterface) == null) {
                    configurationVersionMO_HandlerInterface2 = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
                }
                configurationVersionMO_HandlerInterface2.setRollbackDataForUpgradeTemporaryCV(0);
                configurationVersionMO_HandlerInterface2.setStartableCV(string);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setStartableCV(String aCV_Name, ConfigurationVersionMO_HandlerInterface aConfigurationVersionMO_HandlerInterface)", "Throwable caught when trying to set the created System Upgrade CV as startable CV.", throwable);
            throw new SAXException("Throwable caught when trying to set the created System Upgrade CV as startable CV.Throwable: " + throwable);
        }
    }

    private void updateJvmDynamicClassPathAndJavaHeap() throws SAXException, UpgradePackageException, MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateJvmDynamicClassPathAndJavaHeap( )");
        }
        JvmUpdateHandler jvmUpdateHandler = new JvmUpdateHandler();
        if (!this.myIsAllJvmPiusRemovedFromPiuLists) {
            JavaHeapHelper javaHeapHelper;
            Integer n;
            if (this.myJavaHeapSize == null && ("new".equalsIgnoreCase(this.myBaseClassPath) || this.myUseRepertoiresValue) && (n = (javaHeapHelper = new JavaHeapHelper()).selectJavaHeap(this.myUpgradePackageMO.getUpgradeControlFilePath(null), this.myUpgradePackageMO.getDocumentNumber(null), this.myUpgradePackageMO.getDocumentRevision(null))) != null) {
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "updateJvmDynamicClassPathAndJavaHeap( )", "The Java heap defined in Repertoires is used: " + n);
                }
                this.myJavaHeapSize = n;
            }
            jvmUpdateHandler.updateJvmDynamicClassPathAndJavaHeap(this.myBaseClassPath, this.myAddLmList, this.myRemoveLmList, this.myJavaHeapSize, this.myUpgradePackageMO, this.myIsForcedMoppletUsage, true);
        } else {
            jvmUpdateHandler.loadUnloadAUEsInDynamicClassPath(this.myBaseClassPath, this.myAddLmList, this.myRemoveLmList, this.myUpgradePackageMO, this.myIsForcedMoppletUsage);
        }
    }
}

