/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.eventhandler;

import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.NotifyingUpgradePackagePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.Timer;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.TimerEvent;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.TimerListener;
import se.ericsson.cello.upgradepackage.main.event.UpgradePackageProperty;
import se.ericsson.cello.upgradepackage.main.event.progresstotal.ProgressTotalEvent;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.PreUpgradeSU_Information;
import se.ericsson.cello.upgradepackage.util.datacontainer.ProgressCount;
import se.ericsson.cello.upgradepackage.util.datacontainer.ProgressHeaderInformationInterface;
import se.ericsson.cello.upgradepackage.util.datacontainer.SoftJvmUpgradeInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.TriggerInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerificationFinishedInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerificationRequestedInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyUP_Started;
import se.ericsson.cello.upgradepackage.util.event.EventInformationInterface;
import se.ericsson.cello.upgradepackage.util.eventhandler.EventClientInterface;

public class VerifyEventHandler
implements PropertyChangeListener,
TimerListener {
    private EventClientInterface myUpgradePackage = null;
    private EventClientInterface myVerifyUpgradeHandler = null;
    private int myMaxTimeBetweenVerifyEvents = 0;
    private int myTotalSteps = 0;
    private int myCurrentStepCounter = 0;
    private UpgradePackageProperty myLastSentVerifyProgressInformation = null;
    private Timer myTimer = null;

    public VerifyEventHandler(EventClientInterface eventClientInterface, EventClientInterface eventClientInterface2, int n, int n2, int n3) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "VerifyEventHandler(EventClientInterface anUpgradePackage, EventClientInterface aVerifyUpgradeHandler, boolean anIsEventsToBeSent, int aMaxTimeBetweenEvents, int aTotalSteps, int aCurrentStepCounter)", "anUpgradePackage: " + eventClientInterface + "\n\taVerifyUpgradeHandler: " + eventClientInterface2 + "\n\taMaxTimeBetweenEvents: " + n + "\n\taTotalSteps: " + n2 + "\n\taCurrentStepCounter: " + n3);
        }
        this.myUpgradePackage = eventClientInterface;
        this.myVerifyUpgradeHandler = eventClientInterface2;
        this.myMaxTimeBetweenVerifyEvents = n * 60 * 1000;
        this.myTotalSteps = n2;
        this.myCurrentStepCounter = n3;
        this.addAsListener();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "aPropertyChangeEvent: " + propertyChangeEvent);
        }
        try {
            if (propertyChangeEvent.getNewValue() instanceof ProgressCount) {
                this.handleVerifyProgressPropertyChange((ProgressCount)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof ProgressTotalEvent) {
                this.handleVerifyProgressPropertyChange((ProgressTotalEvent)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof VerificationFinishedInformation) {
                this.handleVerifyProgressPropertyChange((VerificationFinishedInformation)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof VerificationRequestedInformation) {
                this.handleVerifyProgressPropertyChange((VerificationRequestedInformation)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof PreUpgradeSU_Information) {
                this.handleVerifyProgressPropertyChange((ProgressHeaderInformationInterface)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof SoftJvmUpgradeInformation) {
                this.handleVerifyProgressPropertyChange((ProgressHeaderInformationInterface)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof TriggerInformation) {
                this.handleVerifyProgressPropertyChange((ProgressHeaderInformationInterface)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof VerifyUP_Started) {
                this.handleVerifyProgressPropertyChange((ProgressHeaderInformationInterface)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof ProgressHeaderInformationInterface) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Received property type is ignored,\n\taPropertyChangeEvent: " + propertyChangeEvent + "\n\tNewValue: " + propertyChangeEvent.getNewValue());
                }
            } else {
                Trace.info(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Unexpected property type received (ignored),\n\taPropertyChangeEvent: " + propertyChangeEvent + "\n\tNewValue: " + propertyChangeEvent.getNewValue());
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Throwable caught.\n\tThrowable data: " + throwable.toString(), throwable);
        }
    }

    public void stop() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "stop( )");
        }
        this.removeAsListener();
        this.myUpgradePackage = null;
        this.myMaxTimeBetweenVerifyEvents = 0;
        this.myTotalSteps = 0;
        this.myCurrentStepCounter = 0;
        this.myLastSentVerifyProgressInformation = null;
        this.stopTimer();
        this.myTimer = null;
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "stop( )", "The VerifyEventHandler has been deactivated.");
        }
    }

    public void timerAction(TimerEvent timerEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "timerAction(TimerEvent aTimerEvent)", "aTimerEvent: " + timerEvent);
        }
        try {
            if (this.myLastSentVerifyProgressInformation != null) {
                this.invokeHandleVerifyProgressPropertyChange(this.myLastSentVerifyProgressInformation);
            } else {
                Trace.info(this.getClass(), "timerAction(TimerEvent aTimerEvent)", "Time out between events and latest sent event is null. Should never happen (ignored).\n\taTimerEvent: " + timerEvent);
            }
        }
        catch (Throwable throwable) {
            Trace.info(this.getClass(), "timerAction(TimerEvent aTimerEvent)", "Throwable caught when receiving a time out indication at event handling (IGNORED).\n\tThrowable data: " + throwable.toString());
        }
    }

    private void addAsListener() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addAsListener( )");
        }
        this.myUpgradePackage.addPropertyChangeListener(NotifyingUpgradePackagePropertyName.ProgressCount, this);
        this.myUpgradePackage.addPropertyChangeListener(NotifyingUpgradePackagePropertyName.ProgressInformation, this);
        this.myUpgradePackage.addPropertyChangeListener(NotifyingUpgradePackagePropertyName.ProgressTotal, this);
        this.myVerifyUpgradeHandler.addPropertyChangeListener(NotifyingUpgradePackagePropertyName.VerificationRequested, this);
        this.myVerifyUpgradeHandler.addPropertyChangeListener(NotifyingUpgradePackagePropertyName.VerifyUP_Started, this);
    }

    private String getExecutingTaskNumber() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getExecutingTaskNumber( )");
        }
        if (this.myTotalSteps != 0) {
            return "Executing task number " + this.myCurrentStepCounter + " of " + this.myTotalSteps;
        }
        return "Executing task number " + this.myCurrentStepCounter + " of x";
    }

    private void handleVerifyProgressPropertyChange(ProgressCount progressCount) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleVerifyProgressPropertyChange(ProgressCount aProgressCount)", "aProgressCount: " + progressCount);
        }
        this.myCurrentStepCounter = progressCount.getValue();
    }

    private void handleVerifyProgressPropertyChange(ProgressTotalEvent progressTotalEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleVerifyProgressPropertyChange(ProgressTotalEvent aProgressTotalEvent)", "aProgressTotalEvent: " + progressTotalEvent);
        }
        this.myTotalSteps = progressTotalEvent.totalSteps;
    }

    private void handleVerifyProgressPropertyChange(VerificationFinishedInformation verificationFinishedInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleVerifyProgressPropertyChange(VerificationFinishedInformation aVerificationFinishedInformation)", "aVerificationFinishedInformation: " + verificationFinishedInformation);
        }
        this.sendEvent(verificationFinishedInformation.getEventId(), "");
        this.myLastSentVerifyProgressInformation = verificationFinishedInformation;
    }

    private void handleVerifyProgressPropertyChange(VerificationRequestedInformation verificationRequestedInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleVerifyProgressPropertyChange(VerificationRequestedInformation aVerificationRequestedInformation)", "aVerificationRequestedInformation: " + verificationRequestedInformation);
        }
        this.sendEvent(verificationRequestedInformation.getEventId(), "");
        this.myLastSentVerifyProgressInformation = verificationRequestedInformation;
    }

    private void handleVerifyProgressPropertyChange(ProgressHeaderInformationInterface progressHeaderInformationInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleVerifyProgressPropertyChange(ProgressHeaderInformationInterface aProgressHeaderInformationInterface)", "aProgressHeaderInformationInterface: " + progressHeaderInformationInterface);
        }
        this.sendEvent(((EventInformationInterface)((Object)progressHeaderInformationInterface)).getEventId(), this.getExecutingTaskNumber());
        this.myLastSentVerifyProgressInformation = progressHeaderInformationInterface;
    }

    private void invokeHandleVerifyProgressPropertyChange(UpgradePackageProperty upgradePackageProperty) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "invokeHandleVerifyProgressPropertyChange(UpgradePackageProperty anUpgradePackageProperty)", "anUpgradePackageProperty: " + upgradePackageProperty);
        }
        if (upgradePackageProperty instanceof VerificationRequestedInformation) {
            this.handleVerifyProgressPropertyChange((VerificationRequestedInformation)upgradePackageProperty);
        } else if (upgradePackageProperty instanceof VerificationFinishedInformation) {
            this.handleVerifyProgressPropertyChange((VerificationFinishedInformation)upgradePackageProperty);
        } else {
            this.handleVerifyProgressPropertyChange((ProgressHeaderInformationInterface)upgradePackageProperty);
        }
    }

    private void removeAsListener() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeAsListener( )");
        }
        this.myUpgradePackage.removePropertyChangeListener(NotifyingUpgradePackagePropertyName.ProgressCount, this);
        this.myUpgradePackage.removePropertyChangeListener(NotifyingUpgradePackagePropertyName.ProgressInformation, this);
        this.myUpgradePackage.removePropertyChangeListener(NotifyingUpgradePackagePropertyName.ProgressTotal, this);
        this.myVerifyUpgradeHandler.removePropertyChangeListener(NotifyingUpgradePackagePropertyName.VerificationRequested, this);
        this.myVerifyUpgradeHandler.removePropertyChangeListener(NotifyingUpgradePackagePropertyName.VerifyUP_Started, this);
    }

    private void sendEvent(int n, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendEvent(int anEventId, String anAdditionalText)", "anEventId: " + n + "\n\tanAdditionalText: " + string);
        }
        AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{};
        try {
            AlarmManager.getReporter().reportEvent(n, (ManagedObject)this.myUpgradePackage, null, string, additionalInfoArray);
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "sendEvent(int anEventId, String anAdditionalText)", "Event has been sent, id=" + n + ", additional text=" + string);
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendEvent(int anEventId, String anAdditionalText)", "Event has been sent.\n\tanEventId: " + n + "\n\tanAdditionalText: " + string);
            }
        }
        catch (Throwable throwable) {
            Trace.info(this.getClass(), "sendEvent(int anEventId, String anAdditionalText)", "Failed to send an event due to Throwable was caught (IGNORED).\n\t\tFullDistinguishedName: " + ((ManagedObject)this.myUpgradePackage).getFullDistinguishedName() + "\n\tType eventId: " + ((ManagedObject)this.myUpgradePackage).getType() + " " + n + "\n\tanAdditionalText: " + string + "\n\tThrowable data: " + throwable.toString());
        }
        this.startTimer();
    }

    private void startTimer() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "startTimer( )");
        }
        this.stopTimer();
        this.myTimer = new Timer(this.myMaxTimeBetweenVerifyEvents);
        this.myTimer.addListener(this);
        this.myTimer.startTimer();
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "startTimer( )", "Time supervision between events has been started (or re-started).");
        }
    }

    private void stopTimer() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "stopTimer( )");
        }
        if (this.myTimer != null) {
            this.myTimer.removeListener(this);
            this.myTimer.stopTimer();
        }
    }
}

