/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.mohandler.managedelement;

import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.managedelement.suaccess.ManagedElementMoSU_Access;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.su.uci.verify.diskhealthcheck.FileSystemHealthCheckControllerInterface;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.util.datacontainer.ProductDataContainer;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.mohandler.factory.MO_HandlerFactoryInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.managedelement.ManagedElementMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.managedelement.ManagedElementMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public class ManagedElementMO_Handler
implements ManagedElementMO_HandlerInterface {
    public ManagedElementMO_Handler(MO_HandlerFactoryInterface mO_HandlerFactoryInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "ManagedElementMO_Handler(MO_HandlerFactoryInterface aMO_HandlerFactoryInterface)");
        }
    }

    public PlugInUnitMoSU_Access[] getFtcMos() throws ManagedElementMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getFtcMos()");
        }
        try {
            ManagedElementMoSU_Access managedElementMoSU_Access = this.getManagedElementMo();
            ManagedObject[] managedObjectArray = managedElementMoSU_Access.getFtcsMos(null);
            PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray = new PlugInUnitMoSU_Access[managedObjectArray.length];
            for (int i = 0; i < managedObjectArray.length; ++i) {
                plugInUnitMoSU_AccessArray[i] = (PlugInUnitMoSU_Access)managedObjectArray[i];
            }
            return plugInUnitMoSU_AccessArray;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getFtcMos()", "Throwable caught.Throwable: " + throwable.toString(), throwable);
            throw new ManagedElementMO_HandlerException("Throwable caught: " + throwable.toString());
        }
    }

    public boolean isSU_VersionSupported(String string) throws ManagedElementMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isSU_VersionSupported(SU_AccessVersion aSU_AccessVersion)", "aSU_AccessVersion: " + string);
        }
        try {
            boolean bl = false;
            if (SU_AccessVersionHandler.getInstance().isSupported(string, (Object)this.getManagedElementMo())) {
                bl = true;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isSU_VersionSupported(SU_AccessVersion aSU_AccessVersion)", "RETURNS - theIsSupported: " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isSU_VersionSupported(SU_AccessVersion aSU_AccessVersion)", "aSU_AccessVersion: " + string + "\n\tThrowable caught", throwable);
            throw new ManagedElementMO_HandlerException(throwable.toString());
        }
    }

    public void requestForDiskHealthCheck(FileSystemHealthCheckControllerInterface fileSystemHealthCheckControllerInterface) throws ManagedElementMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "requestForDiskHealthCheck(FileSystemHealthCheckControllerInterface aFileSystemHealthCheckControllerInterface)", "aFileSystemHealthCheckControllerInterface: " + fileSystemHealthCheckControllerInterface);
        }
        try {
            ManagedElementMoSU_Access managedElementMoSU_Access = this.getManagedElementMo();
            if (SU_AccessVersionHandler.getInstance().isSupported("SU_2", (Object)managedElementMoSU_Access)) {
                managedElementMoSU_Access.requestForDiskHealthCheck();
            } else {
                fileSystemHealthCheckControllerInterface.diskCheckOfFileSystemNotSupported();
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "requestForDiskHealthCheck(DiskHealthCheckController aDiskHealthCheckController)", "Throwable caught when trying to request for a disk healt check.aFileSystemHealthCheckControllerInterface: " + fileSystemHealthCheckControllerInterface + "Throwable: " + throwable, throwable);
            throw new ManagedElementMO_HandlerException(throwable.toString());
        }
    }

    public void setProductData(ProductDataContainer productDataContainer) throws ManagedElementMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setProductData(ProductDataContainer aProductDataContainer)", "aProductDataContainer: " + productDataContainer);
        }
        Control control = null;
        try {
            if (productDataContainer != null) {
                control = Transaction.create();
                Coordinator coordinator = Transaction.getCoordinator(control);
                ManagedElementMoSU_Access managedElementMoSU_Access = (ManagedElementMoSU_Access)ServiceLocatorFacade.getRepository().getService(ManagedElementMoSU_Access.class);
                managedElementMoSU_Access.setProductNumberFromSU(productDataContainer.getNumber(), coordinator);
                managedElementMoSU_Access.setProductRevisionFromSU(productDataContainer.getRevision(), coordinator);
                managedElementMoSU_Access.setProductNameFromSU(productDataContainer.getName(), coordinator);
                Transaction.commit(control);
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "setProductData(ProductDataContainer aProductDataContainer)", "The MO Managed Element was not updated due to XML element ManagedElement was not specified in the Upgrade Package Control File.");
            }
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "setProductData(ProductDataContainer aProductDataContainer)", "MoAccessException caught when trying to set product data in MO ManagedElement.aProductDataContainer: " + productDataContainer + "MoAccessException: " + moAccessException.toString(), moAccessException);
            Transaction.rollback(control);
            throw new ManagedElementMO_HandlerException("MoAccessException caught when trying to set product data in MO ManagedElement.aProductDataContainer: " + productDataContainer + "MoAccessException: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "setProductData(ProductDataContainer aProductDataContainer)", "Exception caught when trying to set product data in MO ManagedElement.aProductDataContainer: " + productDataContainer + "MoAccessException: " + exception.toString(), exception);
            Transaction.rollback(control);
            throw new ManagedElementMO_HandlerException("Exception caught when trying to set product data in MO ManagedElement.aProductDataContainer: " + productDataContainer + "Exception: " + exception.toString());
        }
    }

    private ManagedElementMoSU_Access getManagedElementMo() {
        return (ManagedElementMoSU_Access)ServiceLocatorFacade.getRepository().getService(ManagedElementMoSU_Access.class);
    }
}

