/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.mohandler.rpu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.equipment.suaccess.ProgramMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SlotMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SubrackMoSU_Access;
import se.ericsson.cello.managedelement.meaccess.MO_HandlerException;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.IdGenerator;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RPU_ModificationInformation;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RPU_PropertyInformation;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.RPU_AttributesInformation;
import se.ericsson.cello.swmanagement.suaccess.ReliableProgramUniterMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.SoftRpuDataHelper;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.factory.MO_HandlerFactoryInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.RepertoireMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.rpu.RPU_MO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.rpu.RPU_MO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public class RPU_MO_Handler
implements RPU_MO_HandlerInterface {
    private static final String SU_Created = "SU_Created";

    public RPU_MO_Handler(MO_HandlerFactoryInterface mO_HandlerFactoryInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "RPU_MO_Handler (MO_HandlerFactoryInterface aMO_HandlerFactoryInterface)");
        }
    }

    public ReliableProgramUniterMoSU_Access createRPU_MO(ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access, RPU_PropertyInformation rPU_PropertyInformation, Coordinator coordinator) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createRPU_MO ( ReliableProgramUniterMoSU_Access anOldRPU_MO, RPU_PropertyInformation aNewRPU_Information, Coordinator aCoordinator)", "\n\tanOldRPU_MO: " + reliableProgramUniterMoSU_Access + "\n\taNewRPU_Information: " + rPU_PropertyInformation + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            if (rPU_PropertyInformation.isReverseRelations && reliableProgramUniterMoSU_Access.getAdmPassiveSlot(null) == null) {
                Trace.warning(this.getClass(), "createRPU_MO ( ReliableProgramUniterMoSU_Access anOldRPU_MO, RPU_PropertyInformation aNewRPU_Information)", "Couldn't copy an old RPU to a new RPU since the admPassiveSlot was not assigned any Slot (i.e. reverse relation case).\n\tThe copy function for this RPU is ignored.\n\tanOldRPU_MO: " + reliableProgramUniterMoSU_Access);
                return null;
            }
            boolean bl = false;
            int n = reliableProgramUniterMoSU_Access.getNormalisation(null);
            if (rPU_PropertyInformation.rpuNormalisationMode != null) {
                bl = true;
                n = rPU_PropertyInformation.rpuNormalisationMode.getValue();
            }
            int n2 = reliableProgramUniterMoSU_Access.getReplication(null);
            if (rPU_PropertyInformation.rpuReplicationMode != null) {
                bl = true;
                n2 = rPU_PropertyInformation.rpuReplicationMode.getValue();
            }
            int n3 = reliableProgramUniterMoSU_Access.getSwitchOver(null);
            if (rPU_PropertyInformation.rpuSwitchOverMode != null) {
                bl = true;
                n3 = rPU_PropertyInformation.rpuSwitchOverMode.getValue();
            }
            ManagedObject managedObject = null;
            ManagedObject managedObject2 = null;
            if (rPU_PropertyInformation.isReverseRelations) {
                managedObject = reliableProgramUniterMoSU_Access.getAdmPassiveSlot(null);
                managedObject2 = reliableProgramUniterMoSU_Access.getAdmActiveSlot(null);
            } else {
                managedObject = reliableProgramUniterMoSU_Access.getAdmActiveSlot(null);
                managedObject2 = reliableProgramUniterMoSU_Access.getAdmPassiveSlot(null);
            }
            if (rPU_PropertyInformation.isOneLegged) {
                managedObject2 = null;
            }
            boolean bl2 = false;
            if (SU_AccessVersionHandler.getInstance().isSupported("SU_2", reliableProgramUniterMoSU_Access.getSupportedVersions())) {
                bl2 = reliableProgramUniterMoSU_Access.getIsForDeviceProgram(null);
            }
            if (rPU_PropertyInformation.isForDeviceProgram != null) {
                bl = true;
                bl2 = rPU_PropertyInformation.isForDeviceProgram;
            }
            String string = reliableProgramUniterMoSU_Access.getUserLabel(null);
            String string2 = rPU_PropertyInformation.rpLabel;
            if (bl && Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "createRPU_MO ( ReliableProgramUniterMoSU_Access anOldRPU_MO, RPU_PropertyInformation aNewRPU_Information)", "Copy and modification of an old RPU is to take place.");
            }
            return this.createRPU_MO(string2, managedObject, managedObject2, n, n2, n3, string, bl2, coordinator);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createRPU_MO ( ReliableProgramUniterMoSU_Access anOldRPU_MO, RPU_PropertyInformation aNewRPU_Information, Coordinator aCoordinator)", "anOldRPU_MO: " + reliableProgramUniterMoSU_Access + "\n\taNewRPU_Information: " + rPU_PropertyInformation + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught.", throwable);
            throw new RPU_MO_HandlerException("Class: " + this.getClass().getName() + "\n\tMethod: createRPU_MO ( ReliableProgramUniterMoSU_Access anOldRPU_MO, RPU_PropertyInformation aNewRPU_Information, Coordinator aCoordinator)" + "\n\tanOldRPU_MO: " + reliableProgramUniterMoSU_Access + "\n\taNewRPU_Information: " + rPU_PropertyInformation + "\n\ttheCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    public ReliableProgramUniterMoSU_Access createRPU_MO(ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access, ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access2, RPU_PropertyInformation rPU_PropertyInformation, Coordinator coordinator) throws RPU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createRPU_MO ( ReliableProgramUniterMoSU_Access anActiveRPU_MO, ReliableProgramUniterMoSU_Access aPassiveRPU_MO, RPU_PropertyInformation aNewRPU_Information, Coordinator aCoordinator)", "anActiveRPU_MO: " + reliableProgramUniterMoSU_Access + "\n\taPassiveRPU_MO: " + reliableProgramUniterMoSU_Access2 + "\n\taNewRPU_Information: " + rPU_PropertyInformation + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            boolean bl = false;
            int n = reliableProgramUniterMoSU_Access.getNormalisation(null);
            if (rPU_PropertyInformation.rpuNormalisationMode != null) {
                bl = true;
                n = rPU_PropertyInformation.rpuNormalisationMode.getValue();
            }
            int n2 = reliableProgramUniterMoSU_Access.getReplication(null);
            if (rPU_PropertyInformation.rpuReplicationMode != null) {
                bl = true;
                n2 = rPU_PropertyInformation.rpuReplicationMode.getValue();
            }
            int n3 = reliableProgramUniterMoSU_Access.getSwitchOver(null);
            if (rPU_PropertyInformation.rpuSwitchOverMode != null) {
                bl = true;
                n3 = rPU_PropertyInformation.rpuSwitchOverMode.getValue();
            }
            ManagedObject managedObject = null;
            ManagedObject managedObject2 = null;
            managedObject = reliableProgramUniterMoSU_Access.getAdmActiveSlot(null);
            managedObject2 = rPU_PropertyInformation.isOneLegged ? null : reliableProgramUniterMoSU_Access2.getAdmPassiveSlot(null);
            boolean bl2 = false;
            if (SU_AccessVersionHandler.getInstance().isSupported("SU_2", reliableProgramUniterMoSU_Access.getSupportedVersions())) {
                bl2 = reliableProgramUniterMoSU_Access.getIsForDeviceProgram(null);
            }
            if (rPU_PropertyInformation.isForDeviceProgram != null) {
                bl = true;
                bl2 = rPU_PropertyInformation.isForDeviceProgram;
            }
            String string = reliableProgramUniterMoSU_Access.getUserLabel(null);
            String string2 = rPU_PropertyInformation.rpLabel;
            if (bl && Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "createRPU_MO ( ReliableProgramUniterMoSU_Access anActiveRPU_MO, ReliableProgramUniterMoSU_Access aPassiveRPU_MO, RPU_PropertyInformation aNewRPU_Information)", "Copy and modification of a new RPU is to take place (2 RPUs to 1 RPU case).");
            }
            return this.createRPU_MO(string2, managedObject, managedObject2, n, n2, n3, string, bl2, coordinator);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createRPU_MO ( ReliableProgramUniterMoSU_Access anActiveRPU_MO, ReliableProgramUniterMoSU_Access aPassiveRPU_MO, RPU_PropertyInformation aNewRPU_Information, Coordinator aCoordinator)", "anActiveRPU_MO: " + reliableProgramUniterMoSU_Access + "\n\taPassiveRPU_MO: " + reliableProgramUniterMoSU_Access2 + "\n\taNewRPU_Information: " + rPU_PropertyInformation + "\n\taCoordinator: " + SuLib.toString(coordinator) + "Throwable caught.", throwable);
            throw new RPU_MO_HandlerException("Class: " + this.getClass().getName() + "\n\tMethod: createRPU_MO ( ReliableProgramUniterMoSU_Access anActiveRPU_MO, ReliableProgramUniterMoSU_Access aPassiveRPU_MO, RPU_PropertyInformation aNewRPU_Information, Coordinator aCoordinator)" + "\n\tanActiveRPU_MO: " + reliableProgramUniterMoSU_Access + "\n\taPassiveRPU_MO: " + reliableProgramUniterMoSU_Access2 + "\n\taNewRPU_Information: " + rPU_PropertyInformation + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    public boolean isRPU_Used(ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access) throws RPU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isRPU_Used ( ReliableProgramUniterMoSU_Access aRPU_MO )", "aRPU_MO: " + reliableProgramUniterMoSU_Access);
        }
        boolean bl = true;
        String string = null;
        try {
            RPU_AttributesInformation rPU_AttributesInformation = reliableProgramUniterMoSU_Access.getRPU_AttributesInformation(null);
            string = reliableProgramUniterMoSU_Access.getReliableProgramLabel(null);
            if (rPU_AttributesInformation.admActiveInstanceId == 0L && rPU_AttributesInformation.admPassiveInstanceId == 0L && rPU_AttributesInformation.newAdmActiveInstanceId == 0L && rPU_AttributesInformation.newAdmPassiveInstanceId == 0L) {
                ManagedObject[] managedObjectArray = reliableProgramUniterMoSU_Access.getReservedBy(null);
                if (managedObjectArray == null || managedObjectArray.length == 0) {
                    bl = false;
                } else if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "deleteNotUsedRPUs()", "The indicated RPU MO is not used but reserved by other MAO's (delete of it is therefor not possible).\n\tRPU MAO: " + reliableProgramUniterMoSU_Access + "\n\tReserved by following MOs: " + SuLib.toString(managedObjectArray) + "\n\ttheRPU_AttributesInformation: " + rPU_AttributesInformation);
                }
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "isRPU_Used(ReliableProgramUniterMoSU_Access aRPU_MO)", "Failed to determine wether or not the RPU is un-used or not i.e. no delete of this RPU will be requested even if it really is un-used.\n\taRPU_MO: " + reliableProgramUniterMoSU_Access + "\n\trpLabel: " + string + "\n\tReason for the failure: " + throwable);
            return bl;
        }
    }

    public void deleteNotUsedRPUs() throws RPU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteNotUsedRPUs()");
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("ReliableProgramUniter");
            ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = null;
            while (moIterator != null && moIterator.hasMoreElements()) {
                reliableProgramUniterMoSU_Access = (ReliableProgramUniterMoSU_Access)moIterator.nextMo();
                try {
                    if (!this.isRPU_Used(reliableProgramUniterMoSU_Access)) {
                        if (this.isRPU_CandidateForFutureUse(reliableProgramUniterMoSU_Access)) continue;
                        this.deleteRPU(reliableProgramUniterMoSU_Access);
                        continue;
                    }
                    if (!Trace.valid(this.getClass(), 22)) continue;
                    Trace.debug(this.getClass(), 22, "deleteNotUsedRPUs()", "The RPU is in use and will not be deleted.\n\taRPU_MO: " + reliableProgramUniterMoSU_Access + "\n\trpLabel: " + reliableProgramUniterMoSU_Access.getReliableProgramLabel(null));
                }
                catch (Throwable throwable) {
                    Trace.warning(this.getClass(), "deleteNotUsedRPUs()", "Unexpected failure detected (the RPU is ignored).\n\taRPU_MO: " + reliableProgramUniterMoSU_Access + "\n\tReason for the unexpected failure: " + throwable);
                }
            }
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "deleteNotUsedRPUs()", "Throwable caught (ignored due to the deletion of not used RPU's are not critical for the upgrade logic).\n\tReason for the failure:" + throwable);
        }
    }

    public boolean isRPU_CandidateForFutureUse(ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access) throws RPU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isRPU_CandidateForFutureUse (ReliableProgramUniterMoSU_Access aRPU_MO)", "aRPU_MO: " + reliableProgramUniterMoSU_Access);
        }
        try {
            SlotMoSU_Access slotMoSU_Access = (SlotMoSU_Access)reliableProgramUniterMoSU_Access.getAdmActiveSlot(null);
            Collection collection = this.getLoadModuleMosReferencedBySlot(slotMoSU_Access);
            slotMoSU_Access = (SlotMoSU_Access)reliableProgramUniterMoSU_Access.getAdmPassiveSlot(null);
            Collection collection2 = this.getLoadModuleMosReferencedBySlot(slotMoSU_Access);
            collection.addAll(collection2);
            LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
            Collection collection3 = loadModuleMO_HandlerInterface.getRP_LabelsForLM_MOs(collection);
            if (collection3.contains(reliableProgramUniterMoSU_Access.getReliableProgramLabel(null))) {
                if (Trace.valid(this.getClass(), 21)) {
                    Trace.debug(this.getClass(), 21, "isRPU_CandidateForFutureUse (ReliableProgramUniterMoSU_Access aRPU_MO)", "RETURNS - true");
                }
                return true;
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "isRPU_CandidateForFutureUse (ReliableProgramUniterMoSU_Access aRPU_MO)", "RETURNS - false");
            }
            return false;
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "isRPU_CandidateForFutureUse (ReliableProgramUniterMoSU_Access aRPU_MO)", "Failed to find out if the RPU MO may be used in future (assuming it will be used).\n\taRPU_MO: " + reliableProgramUniterMoSU_Access + "\n\tReason for the failure: " + throwable);
            return true;
        }
    }

    public Collection getLoadModuleMosReferencedBySlot(SlotMoSU_Access slotMoSU_Access) throws RPU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModuleMosReferencedBySlot ( SlotMoSU_Access aSlotMo)", "aSlotMo: " + slotMoSU_Access);
        }
        HashSet hashSet = new HashSet();
        try {
            if (slotMoSU_Access == null) {
                if (Trace.valid(this.getClass(), 21)) {
                    Trace.debug(this.getClass(), 21, "getLoadModuleMosReferencedBySlot ( SlotMoSU_Access aSlotMo)", "Input slot reference is 'null': " + null + "\n\tRETURNS - theReferencedLM_MOs: " + hashSet);
                }
                return hashSet;
            }
            SlotMoSU_Access slotMoSU_Access2 = slotMoSU_Access;
            ManagedObject[] managedObjectArray = slotMoSU_Access2.getSwAllocations(null);
            if (managedObjectArray == null || managedObjectArray.length == 0) {
                if (Trace.valid(this.getClass(), 21)) {
                    Trace.debug(this.getClass(), 21, "getLoadModuleMosReferencedBySlot ( SlotMoSU_Access aSlotMo)", "No SWAs assigned to the Slot: " + slotMoSU_Access2 + "\n\tRETURNS - theReferencedLM_MOs: " + hashSet);
                }
                return hashSet;
            }
            RepertoireMO_HandlerInterface repertoireMO_HandlerInterface = ServiceFinder.getRepertoireMO_HandlerInterface();
            Collection collection = null;
            ManagedObject[] managedObjectArray2 = null;
            for (int i = 0; i < managedObjectArray.length; ++i) {
                managedObjectArray2 = ((SwAllocationMoSU_Access)managedObjectArray[i]).getRepertoireList(null);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getLoadModuleMosReferencedBySlot ( SlotMoSU_Access aSlotMo)", "The repertoires assigned to SWA: " + managedObjectArray[i] + "\n\t - theRepertoires: " + SuLib.toString(managedObjectArray2));
                }
                collection = repertoireMO_HandlerInterface.getLoadModuleMosReferencedByRepertoires(managedObjectArray2);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getLoadModuleMosReferencedBySlot ( SlotMoSU_Access aSlotMo)", "The loadModules connected to SWA: " + managedObjectArray[i] + "\n\t - theReferencedLMsFromTheSwa: " + collection);
                }
                hashSet.addAll(collection);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getLoadModuleMosReferencedBySlot ( SlotMoSU_Access aSlotMo)", "\n\tRETURNS - theReferencedLM_MOs: " + hashSet);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLoadModuleMosReferencedBySlot ( SlotMoSU_Access aSlotMo)", "aSlotMo: " + slotMoSU_Access + "\n\tThrowable caught.", throwable);
            throw new RPU_MO_HandlerException("Class: " + this.getClass().getName() + "Method: getLoadModuleMosReferencedBySlot ( SlotMoSU_Access aSlotMo)" + "aSlotMo: " + slotMoSU_Access + "\n\tThrowable caught: " + throwable);
        }
    }

    public void deleteRPU(ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access) throws RPU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteRPU(ReliableProgramUniterMoSU_Access aRPU_MO)", "aRPU_MO: " + reliableProgramUniterMoSU_Access);
        }
        Control control = null;
        Coordinator coordinator = null;
        String string = null;
        try {
            string = reliableProgramUniterMoSU_Access.getReliableProgramLabel(null);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "deleteNotUsedRPUs()", "The RPU MO is to be deleted due to it is not used.\n\trpLabel: " + reliableProgramUniterMoSU_Access.getReliableProgramLabel(null));
            }
            control = Transaction.create();
            coordinator = Transaction.getCoordinator(control);
            reliableProgramUniterMoSU_Access.delete(coordinator);
            Transaction.commit(control);
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "deleteRPU(ReliableProgramUniterMoSU_Access aRPU_MO)", "Failed to delete the  RPU for any reason.\n\taRPU_MO: " + reliableProgramUniterMoSU_Access + "\n\trpLabel: " + string + "\n\tReason for the delete failure: " + throwable);
            Transaction.rollback(control);
        }
    }

    public int getNormalisation(ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access, Coordinator coordinator) throws RPU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNormalisation(ReliableProgramUniterMoSU_Access aReliableProgramUniterMo, Coordinator aCoordinator)", "aReliableProgramUniterMo: " + reliableProgramUniterMoSU_Access + "\n\taCoordinator: " + Transaction.toString(coordinator));
        }
        return this.getNormalisation(reliableProgramUniterMoSU_Access, coordinator, 2);
    }

    public int getOperationalMode(ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access, Coordinator coordinator) throws RPU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getOperationalMode(ReliableProgramUniterMoSU_Access aReliableProgramUniterMo, Coordinator aCoordinator)", "aReliableProgramUniterMo: " + reliableProgramUniterMoSU_Access + "\n\taCoordinator: " + Transaction.toString(coordinator));
        }
        return this.getOperationalMode(reliableProgramUniterMoSU_Access, coordinator, 2);
    }

    public Map getExistingRPUs() throws RPU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getExistingRPUs ()");
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("ReliableProgramUniter");
            ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = null;
            HashMap<String, LinkedList<ReliableProgramUniterMoSU_Access>> hashMap = new HashMap<String, LinkedList<ReliableProgramUniterMoSU_Access>>();
            String string = null;
            LinkedList<ReliableProgramUniterMoSU_Access> linkedList = null;
            while (moIterator != null && moIterator.hasMoreElements()) {
                reliableProgramUniterMoSU_Access = (ReliableProgramUniterMoSU_Access)moIterator.nextMo();
                string = reliableProgramUniterMoSU_Access.getReliableProgramLabel(null);
                linkedList = (LinkedList<ReliableProgramUniterMoSU_Access>)hashMap.get(string);
                if (linkedList != null) {
                    linkedList.add(reliableProgramUniterMoSU_Access);
                    continue;
                }
                linkedList = new LinkedList<ReliableProgramUniterMoSU_Access>();
                linkedList.add(reliableProgramUniterMoSU_Access);
                hashMap.put(string, linkedList);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getExistingRPUs ()", "RETURNS - theRPU_MOs: " + hashMap);
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getExistingRPUs ()", "Throwable caught.", throwable);
            throw new RPU_MO_HandlerException("Class: " + this.getClass().getName() + "\n\tMethod: getExistingRPUs ()" + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    public Map getExistingRPUs(Collection collection) throws RPU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getExistingRPUs (Collection aWithRP_Labels)", "aWithRP_Labels: " + collection);
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("ReliableProgramUniter");
            ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = null;
            HashMap<String, LinkedList<ReliableProgramUniterMoSU_Access>> hashMap = new HashMap<String, LinkedList<ReliableProgramUniterMoSU_Access>>();
            String string = null;
            LinkedList<ReliableProgramUniterMoSU_Access> linkedList = null;
            while (moIterator != null && moIterator.hasMoreElements()) {
                reliableProgramUniterMoSU_Access = (ReliableProgramUniterMoSU_Access)moIterator.nextMo();
                string = reliableProgramUniterMoSU_Access.getReliableProgramLabel(null);
                if (collection.contains(string)) {
                    linkedList = (LinkedList<ReliableProgramUniterMoSU_Access>)hashMap.get(string);
                    if (linkedList != null) {
                        linkedList.add(reliableProgramUniterMoSU_Access);
                        continue;
                    }
                    linkedList = new LinkedList<ReliableProgramUniterMoSU_Access>();
                    linkedList.add(reliableProgramUniterMoSU_Access);
                    hashMap.put(string, linkedList);
                    continue;
                }
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "getExistingRPUs ()", "RPU MO omitted: " + reliableProgramUniterMoSU_Access + "\n\tRP label: " + string);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getExistingRPUs ()", "RETURNS - theRPU_MOs: " + hashMap);
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getExistingRPUs ()", "Throwable caught.", throwable);
            throw new RPU_MO_HandlerException("Class: " + this.getClass().getName() + "\n\tMethod: getExistingRPUs ()" + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    public Map getExistingRPUsAdmPassiveSlots() throws RPU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getExistingRPUsAdmPassiveSlots ()");
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("ReliableProgramUniter");
            ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = null;
            SlotMoSU_Access slotMoSU_Access = null;
            HashMap<String, SlotMoSU_Access> hashMap = new HashMap<String, SlotMoSU_Access>();
            while (moIterator != null && moIterator.hasMoreElements()) {
                reliableProgramUniterMoSU_Access = (ReliableProgramUniterMoSU_Access)moIterator.nextMo();
                slotMoSU_Access = (SlotMoSU_Access)reliableProgramUniterMoSU_Access.getAdmPassiveSlot(null);
                hashMap.put(reliableProgramUniterMoSU_Access.getLocalDistinguishedName(), slotMoSU_Access);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getExistingRPUs ()", "RETURNS - theRPU_MOsAdmPassiveSlots: " + hashMap);
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getExistingRPUs ()", "Throwable caught.", throwable);
            throw new RPU_MO_HandlerException("Class: " + this.getClass().getName() + "\n\tMethod: getExistingRPUsAdmPassiveSlots ()" + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    public Collection getRPUsWithGivenRP_label(Collection linkedList, String string, Coordinator coordinator) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRPUsWithGivenRP_label ( Collection aRPU_MOs, String aRP_Label, Coordinator aCoordinator )", "aRPU_MOs: " + linkedList + "\n\taRP_Label: " + string + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            if (linkedList == null) {
                linkedList = new LinkedList();
            }
            ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = null;
            Iterator iterator = linkedList.iterator();
            LinkedList<ReliableProgramUniterMoSU_Access> linkedList2 = new LinkedList<ReliableProgramUniterMoSU_Access>();
            while (iterator.hasNext()) {
                reliableProgramUniterMoSU_Access = (ReliableProgramUniterMoSU_Access)iterator.next();
                if (!string.equals(reliableProgramUniterMoSU_Access.getReliableProgramLabel(null))) continue;
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getRPUsWithGivenRP_label ( String aRP_Label, Coordinator aCoordinator )", "Adds the RPU to the linked list.\n\tRPU MO :" + reliableProgramUniterMoSU_Access);
                }
                linkedList2.add(reliableProgramUniterMoSU_Access);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getRPUsWithGivenRP_label ( Collection aRPU_MOs, String aRP_Label, Coordinator aCoordinator )", "RETURNS - theRPU_MOs: " + linkedList2);
            }
            return linkedList2;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getRPUsWithGivenRP_label ( String aRP_Label, Coordinator aCoordinator )", "Throwable caught.", throwable);
            throw new RPU_MO_HandlerException("Class: " + this.getClass().getName() + "\n\tMethod: getRPUsWithGivenRP_label ( String aRP_Label, Coordinator aCoordinator )" + "\n\taRP_Label: " + string + "\n\ttheCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    public void switchRPU(ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access, Coordinator coordinator) throws RPU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "switchRPU(ReliableProgramUniterMoSU_Access aReliableProgramUniterMo, Coordinator aCoordinator)", "aReliableProgramUniterMo: " + reliableProgramUniterMoSU_Access + "\n\taCoordinator: " + Transaction.toString(coordinator));
        }
        this.switchRPU(reliableProgramUniterMoSU_Access, coordinator, 2);
    }

    private ReliableProgramUniterMoSU_Access createRPU_MO(String string, ManagedObject managedObject, ManagedObject managedObject2, int n, int n2, int n3, String string2, boolean bl, Coordinator coordinator) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createRPU_MO ( String aRP_Label, ManagedObject anActiveSlot, ManagedObject aPassiveSlot, int aRPU_NormalisationMode, int aRPU_ReplicationMode, int aRPU_SwitchOverMode, String anOldUserLabel, boolean anIsForDeviceProgram, Coordinator aCoordinator )", "aRP_Label: " + string + "\n\tanActiveSlot: " + managedObject + "\n\taPassiveSlot: " + managedObject2 + "\n\taRPU_NormalisationMode: " + n + "\n\taRPU_ReplicationMode: " + n2 + "\n\taRPU_SwitchOverMode: " + n3 + "\n\tanOldUserLabel: " + string2 + "\n\tanIsForDeviceProgram: " + bl + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            AttrListImpl attrListImpl = new AttrListImpl(7);
            attrListImpl.addElement("reliableProgramLabel", (Object)string);
            Integer n4 = TimeHandler.createActionId();
            if (string2 != null && string2.equals("")) {
                string2 = "NotDefined";
            }
            if (this.isSU_Created(string2)) {
                string2 = this.extractOriginUserLabel(string2);
            }
            string2 = string + "_" + string2 + "_" + SU_Created + "_" + n4.toString();
            attrListImpl.addElement("userLabel", (Object)string2);
            attrListImpl.addElement("switchOver", (Object)new Integer(n3));
            attrListImpl.addElement("normalisation", (Object)new Integer(n));
            attrListImpl.addElement("replication", (Object)new Integer(n2));
            attrListImpl.addElement("admActiveSlot", (Object)managedObject);
            if (managedObject2 != null) {
                attrListImpl.addElement("admPassiveSlot", (Object)managedObject2);
            }
            if (SU_AccessVersionHandler.getInstance().isSupported("SU_2", (Object)MoFactoryMgr.instance().lookup("ReliableProgramUniter"))) {
                attrListImpl.addElement("isForDeviceProgram", (Object)bl);
            }
            SingletonMoFactory singletonMoFactory = (SingletonMoFactory)MoFactoryMgr.instance().lookup("SwManagement");
            ManagedObject managedObject3 = singletonMoFactory.getMo();
            String string3 = null;
            SubrackMoSU_Access subrackMoSU_Access = ((SlotMoSU_Access)managedObject).getSubrackMo(null);
            String string4 = new Integer(subrackMoSU_Access.getSwitchModuleNumber(null)).toString();
            String string5 = new Integer(((SlotMoSU_Access)managedObject).getSlotNumber(null)).toString();
            string3 = string + "--" + string4 + "--" + string5;
            string3 = this.getAvailableRDN_ValueForRPU(string3, managedObject3.getLocalDistinguishedName());
            MoFactory moFactory = MoFactoryMgr.instance().lookup("ReliableProgramUniter");
            return (ReliableProgramUniterMoSU_Access)moFactory.createMo(managedObject3, (AttrList)attrListImpl, string3, null, coordinator);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createRPU_MO ( String aRP_Label, ManagedObject anActiveSlot, ManagedObject aPassiveSlot, int aRPU_NormalisationMode, int aRPU_ReplicationMode, int aRPU_SwitchOverMode, String anOldUserLabel, Coordinator aCoordinator )", "aRP_Label: " + string + "\n\tanActiveSlot: " + managedObject + "\n\taPassiveSlot: " + managedObject2 + "\n\taRPU_NormalisationMode: " + n + "\n\taRPU_ReplicationMode: " + n2 + "\n\taRPU_SwitchOverMode: " + n3 + "\n\tanOldUserLabel: " + string2 + "\n\tanIsForDeviceProgram: " + bl + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught.", throwable);
            throw new RPU_MO_HandlerException("Class: " + this.getClass().getName() + "\n\tMethod: createRPU_MO ( String aRP_Label, ManagedObject anActiveSlot, ManagedObject aPassiveSlot, int aRPU_NormalisationMode, int aRPU_ReplicationMode, int aRPU_SwitchOverMode, String anOldUserLabel, Coordinator aCoordinator )" + "\n\taRP_Label: " + string + "\n\tanActiveSlot: " + managedObject + "\n\taPassiveSlot: " + managedObject2 + "\n\taRPU_NormalisationMode: " + n + "\n\taRPU_ReplicationMode: " + n2 + "\n\taRPU_SwitchOverMode: " + n3 + "\n\tanOldUserLabel: " + string2 + "\n\tanIsForDeviceProgram: " + bl + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    private String getAvailableRDN_ValueForRPU(String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAvailableRDN_ValueForRPU(String aRPU_RDN_Value, String aParentMoLDN)", "aRPU_RDN_Value: " + string + "\n\taParentMoLDN: " + string2);
        }
        try {
            String string3 = string;
            ManagedObject managedObject = null;
            String string4 = string2 + "," + "ReliableProgramUniter" + "=" + string3;
            managedObject = MoRepository.instance().lookup(string4);
            if (managedObject != null) {
                int n = 2;
                do {
                    string3 = string + "--" + n;
                    string4 = string2 + "," + "ReliableProgramUniter" + "=" + string3;
                    managedObject = MoRepository.instance().lookup(string4);
                    ++n;
                } while (managedObject != null);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getAvailableRDN_ValueForRPU(String aRPU_RDN_Value, String aParentMoLDN)", "RETURNS : " + string3);
            }
            return string3;
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "getAvailableRDN_ValueForRPU(String aRPU_RDN_Value, String aParentMoLDN)", "Throwable caught.aRPU_RDN_Value: " + string + "Throwable data: " + throwable);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getAvailableRDN_ValueForRPU(String aRPU_RDN_Value, String aParentMoLDN)", "RETURNS: " + string);
            }
            return IdGenerator.getNext();
        }
    }

    private int getNormalisation(ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access, Coordinator coordinator, int n) throws RPU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNormalisation(ReliableProgramUniterMoSU_Access aReliableProgramUniterMo, Coordinator aCoordinator, int aNumberOfAttempts)", "aReliableProgramUniterMo: " + reliableProgramUniterMoSU_Access + "\n\taNumberOfAttempts: " + n + "\n\taCoordinator: " + Transaction.toString(coordinator));
        }
        try {
            --n;
            return reliableProgramUniterMoSU_Access.getNormalisation(coordinator);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            if (n > 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getNormalisation(ReliableProgramUniterMoSU_Access aReliableProgramUniterMo, Coordinator aCoordinator, int aNumberOfAttempts)", "FroNotAccessibleException caught when trying to retreive the normalisation for the RPU.\n\tTrying one more time due to the FRO might have been switch after request signal has been sent but before a reply was returned.\n\taReliableProgramUniterMo: " + reliableProgramUniterMoSU_Access + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfAttempts: " + n + "\n\tException data: " + froNotAccessibleException.toString());
                }
                return this.getNormalisation(reliableProgramUniterMoSU_Access, coordinator, n);
            }
            Trace.error(this.getClass(), "getNormalisation(ReliableProgramUniterMoSU_Access aReliableProgramUniterMo, Coordinator aCoordinator, int aNumberOfAttempts)", "FroNotAccessibleException caught when trying to retreive the normalisation for the RPU.\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString(), froNotAccessibleException);
            throw new RPU_MO_HandlerException("Exception caught when trying to retreive the normalisation for the RPU.\n\taReliableProgramUniterMo: " + reliableProgramUniterMoSU_Access + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getNormalisation(ReliableProgramUniterMoSU_Access aReliableProgramUniterMo, Coordinator aCoordinator, int aNumberOfAttempts)", "Exception caught when trying to retreive the normalisation for the RPU.\n\taReliableProgramUniterMo: " + reliableProgramUniterMoSU_Access + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + exception.toString(), exception);
            throw new RPU_MO_HandlerException("Exception caught when trying to retreive the normalisation for the RPU.\n\taReliableProgramUniterMo: " + reliableProgramUniterMoSU_Access + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + exception.toString());
        }
    }

    private int getOperationalMode(ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access, Coordinator coordinator, int n) throws RPU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getOperationalMode(ReliableProgramUniterMoSU_Access aReliableProgramUniterMo, Coordinator aCoordinator, int aNumberOfAttempts)", "aReliableProgramUniterMo: " + reliableProgramUniterMoSU_Access + "\n\taNumberOfAttempts: " + n + "\n\taCoordinator: " + Transaction.toString(coordinator));
        }
        try {
            --n;
            return reliableProgramUniterMoSU_Access.getOperationalMode(coordinator);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            if (n > 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getNormalisation(ReliableProgramUniterMoSU_Access aReliableProgramUniterMo, Coordinator aCoordinator, int aNumberOfAttempts)", "FroNotAccessibleException caught when trying to retreive the operational mode for the RPU.\n\tTrying one more time due to the FRO might have been switch after request signal has been sent but before a reply was returned.\n\taReliableProgramUniterMo: " + reliableProgramUniterMoSU_Access + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfAttempts: " + n + "\n\tException data: " + froNotAccessibleException.toString());
                }
                return this.getOperationalMode(reliableProgramUniterMoSU_Access, coordinator, n);
            }
            Trace.error(this.getClass(), "getNormalisation(ReliableProgramUniterMoSU_Access aReliableProgramUniterMo, Coordinator aCoordinator, int aNumberOfAttempts)", "FroNotAccessibleException caught when trying to retreive the operational mode for the RPU.\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString(), froNotAccessibleException);
            throw new RPU_MO_HandlerException("Exception caught when trying to retreive the operational mode for the RPU.\n\taReliableProgramUniterMo: " + reliableProgramUniterMoSU_Access + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getNormalisation(ReliableProgramUniterMoSU_Access aReliableProgramUniterMo, Coordinator aCoordinator, int aNumberOfAttempts)", "Exception caught when trying to retreive the operational mode for the RPU.\n\taReliableProgramUniterMo: " + reliableProgramUniterMoSU_Access + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + exception.toString(), exception);
            throw new RPU_MO_HandlerException("Exception caught when trying to retreive the operational mode for the RPU.\n\taReliableProgramUniterMo: " + reliableProgramUniterMoSU_Access + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + exception.toString());
        }
    }

    private void switchRPU(ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access, Coordinator coordinator, int n) throws RPU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "switchRPU(ReliableProgramUniterMoSU_Access aReliableProgramUniterMo, Coordinator aCoordinator, int aNumberOfAttempts)", "aReliableProgramUniterMo: " + reliableProgramUniterMoSU_Access + "\n\taNumberOfAttempts: " + n + "\n\taCoordinator: " + Transaction.toString(coordinator));
        }
        try {
            --n;
            Trace.flushToTraceFile();
            reliableProgramUniterMoSU_Access.actionSwitch(coordinator);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            if (n > 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getNormalisation(ReliableProgramUniterMoSU_Access aReliableProgramUniterMo, Coordinator aCoordinator)", "FroNotAccessibleException caught when trying to switch the RPU.\n\tTrying one more time due to the FRO might have been switch after request signal has been sent but before a reply was returned.\n\taReliableProgramUniterMo: " + reliableProgramUniterMoSU_Access + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfAttempts: " + n + "\n\tException data: " + froNotAccessibleException.toString());
                }
                this.switchRPU(reliableProgramUniterMoSU_Access, coordinator, n);
            }
            Trace.error(this.getClass(), "getNormalisation(ReliableProgramUniterMoSU_Access aReliableProgramUniterMo, Coordinator aCoordinator)", "FroNotAccessibleException caught when trying to switch the RPU.\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString(), froNotAccessibleException);
            throw new RPU_MO_HandlerException("Exception caught when trying to switch the RPU.\n\taReliableProgramUniterMo: " + reliableProgramUniterMoSU_Access + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getNormalisation(ReliableProgramUniterMoSU_Access aReliableProgramUniterMo, Coordinator aCoordinator)", "Exception caught when trying to retreive the switch the RPU.\n\taReliableProgramUniterMo: " + reliableProgramUniterMoSU_Access + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + exception.toString(), exception);
            throw new RPU_MO_HandlerException("Exception caught when trying to retreive switch the RPU.\n\taReliableProgramUniterMo: " + reliableProgramUniterMoSU_Access + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + exception.toString());
        }
    }

    public SoftRpuDataHelper checkNewAdmActiveAndPassive(Vector vector, ProgramMoSU_Access programMoSU_Access, Coordinator coordinator) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checkNewAdmActiveAndPassive(Vector aReliableProgramLabelList, ProgramMoSU_Access programMo,Coordinator aCoordinator)", "aReliableProgramLabelList: " + vector + "\n\tprogramMo: " + programMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            SoftRpuDataHelper softRpuDataHelper = new SoftRpuDataHelper(-1L, -1L, -1L);
            MoIterator moIterator = MoRepository.instance().lookupType("ReliableProgramUniter");
            if (moIterator == null) {
                return softRpuDataHelper;
            }
            while (moIterator.hasMoreElements()) {
                ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = (ReliableProgramUniterMoSU_Access)moIterator.nextMo();
                for (int i = 0; i < vector.size(); ++i) {
                    String string = (String)vector.elementAt(i);
                    if (!reliableProgramUniterMoSU_Access.getReliableProgramLabel(coordinator).equals(string)) continue;
                    RPU_AttributesInformation rPU_AttributesInformation = reliableProgramUniterMoSU_Access.getRPU_AttributesInformation(coordinator);
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "checkNewAdmActiveAndPassive(Vector aReliableProgramLabelList, ProgramMoSU_Access programMo, Coordinator aCoordinator)", "theRPU_AttributesInformation: " + rPU_AttributesInformation);
                    }
                    long l = programMoSU_Access.getProgramFroId(coordinator);
                    if (rPU_AttributesInformation.newAdmActiveInstanceId < 0L && rPU_AttributesInformation.newAdmPassiveInstanceId < 0L) continue;
                    if (l == rPU_AttributesInformation.newAdmActiveInstanceId) {
                        softRpuDataHelper.pgmFroId = rPU_AttributesInformation.admActiveInstanceId;
                        softRpuDataHelper.newAdmActiveInsId = rPU_AttributesInformation.newAdmActiveInstanceId;
                        softRpuDataHelper.newAdmPassiveInsId = rPU_AttributesInformation.newAdmPassiveInstanceId;
                        softRpuDataHelper.rpuMoImpl = reliableProgramUniterMoSU_Access;
                        continue;
                    }
                    if (l == rPU_AttributesInformation.newAdmPassiveInstanceId) {
                        softRpuDataHelper.pgmFroId = rPU_AttributesInformation.admPassiveInstanceId;
                        softRpuDataHelper.newAdmActiveInsId = rPU_AttributesInformation.newAdmActiveInstanceId;
                        softRpuDataHelper.newAdmPassiveInsId = rPU_AttributesInformation.newAdmPassiveInstanceId;
                        softRpuDataHelper.rpuMoImpl = reliableProgramUniterMoSU_Access;
                        continue;
                    }
                    if (l != rPU_AttributesInformation.admActiveInstanceId) continue;
                    softRpuDataHelper.oldAdmNewactPass = true;
                    softRpuDataHelper.pgmFroId = rPU_AttributesInformation.admActiveInstanceId;
                    softRpuDataHelper.newAdmActiveInsId = rPU_AttributesInformation.newAdmActiveInstanceId;
                    softRpuDataHelper.newAdmPassiveInsId = rPU_AttributesInformation.newAdmPassiveInstanceId;
                    softRpuDataHelper.rpuMoImpl = reliableProgramUniterMoSU_Access;
                }
            }
            return softRpuDataHelper;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "checkNewAdmActiveAndPassive(Vector aReliableProgramLabelList, ProgramMoSU_Access programMo, Coordinator aCoordinator)", "aReliableProgramLabelList: " + vector + "\n\tprogramMo: " + programMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught.", throwable);
            throw new RPU_MO_HandlerException("Class name: " + this.getClass().getName() + "\n\tcheckNewAdmActiveAndPassive(Vector aReliableProgramLabelList, ProgramMoSU_Access programMo, Coordinator aCoordinator)" + "\n\taReliableProgramLabelList: " + vector + "\n\tprogramMo: " + programMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught: " + throwable);
        }
    }

    public boolean checkStatusOfRpuAttributes(ProgramMoSU_Access programMoSU_Access) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checkStatusOfRpuAttributes(ProgramMoSU_Access programMo)", "programMo: " + programMoSU_Access);
        }
        try {
            boolean bl = false;
            MoIterator moIterator = MoRepository.instance().lookupType("ReliableProgramUniter");
            if (moIterator == null) {
                return true;
            }
            int n = programMoSU_Access.getProgramFroId(null);
            while (moIterator.hasMoreElements()) {
                ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = (ReliableProgramUniterMoSU_Access)moIterator.nextMo();
                RPU_AttributesInformation rPU_AttributesInformation = reliableProgramUniterMoSU_Access.getRPU_AttributesInformation(null);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "checkStatusOfRpuAttributes(ProgramMoSU_Access programMo)", "theRPU_AttributesInformation: " + rPU_AttributesInformation);
                }
                if ((long)n == rPU_AttributesInformation.newAdmActiveInstanceId) {
                    bl = true;
                    break;
                }
                if ((long)n == rPU_AttributesInformation.newAdmPassiveInstanceId) {
                    bl = true;
                    break;
                }
                if ((long)n == rPU_AttributesInformation.admActiveInstanceId) {
                    bl = true;
                    break;
                }
                if ((long)n != rPU_AttributesInformation.admPassiveInstanceId) continue;
                bl = true;
                break;
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "checkStatusOfRpuAttributes(ProgramMoSU_Access programMo)", "\n\tprogramMo: " + programMoSU_Access + "\n\tThrowable caught.", throwable);
            throw new RPU_MO_HandlerException("Class name: " + this.getClass().getName() + "\n\tcheckStatusOfRpuAttributes(ProgramMoSU_Access programMo)" + "\n\tprogramMo: " + programMoSU_Access + "\n\tThrowable caught: " + throwable);
        }
    }

    public void reliableProgramCreated(ProgramMoSU_Access programMoSU_Access, Coordinator coordinator) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "reliableProgramCreated (ProgramMoSU_Access programMo, Coordinator aCoordinator)", "programMo: " + programMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("ReliableProgramUniter");
            if (moIterator == null) {
                return;
            }
            LoadModuleMoSU_Access loadModuleMoSU_Access = (LoadModuleMoSU_Access)programMoSU_Access.getLoadModule(coordinator);
            int n = programMoSU_Access.getLoaderType(coordinator);
            boolean bl = false;
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "reliableProgramCreated(ProgramMoSU_Access programMo, Coordinator aCoordinator)", "lmMo: " + loadModuleMoSU_Access);
            }
            while (moIterator.hasMoreElements()) {
                RPU_AttributesInformation rPU_AttributesInformation;
                ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = (ReliableProgramUniterMoSU_Access)moIterator.nextMo();
                if (!reliableProgramUniterMoSU_Access.getReliableProgramLabel(coordinator).equals(loadModuleMoSU_Access.getReliableProgramLabel(coordinator))) continue;
                bl = true;
                PlugInUnitMoSU_Access plugInUnitMoSU_Access = (PlugInUnitMoSU_Access)programMoSU_Access.getParent();
                SlotMoSU_Access slotMoSU_Access = (SlotMoSU_Access)plugInUnitMoSU_Access.getParent();
                PiuTypeMoSU_Access piuTypeMoSU_Access = (PiuTypeMoSU_Access)plugInUnitMoSU_Access.getPiuType(coordinator);
                boolean bl2 = false;
                if (SU_AccessVersionHandler.getInstance().isSupported("SU_2", reliableProgramUniterMoSU_Access.getSupportedVersions())) {
                    bl2 = reliableProgramUniterMoSU_Access.getIsForDeviceProgram(coordinator);
                }
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "reliableProgramCreated(ProgramMoSU_Access programMo, Coordinator aCoordinator)", "The program's LM MO: " + loadModuleMoSU_Access + "The program's LM MO's reliableProgramLabel: " + loadModuleMoSU_Access.getReliableProgramLabel(coordinator) + "\n\tThe program's Slot MO: " + slotMoSU_Access + "\n\tPiuType for program's PIU: " + piuTypeMoSU_Access + "\n\tpiuType Role for program's PIU: " + piuTypeMoSU_Access.getRole(coordinator) + "\n\trpuMo reliableProgramLabel: " + reliableProgramUniterMoSU_Access.getReliableProgramLabel(coordinator) + "\n\trpuMo AdmActiveSlot: " + reliableProgramUniterMoSU_Access.getAdmActiveSlot(coordinator) + "\n\trpuMo AdmPassiveSlot: " + reliableProgramUniterMoSU_Access.getAdmPassiveSlot(coordinator) + "\n\ttheRPU_IsForDeviceProgram: " + bl2);
                }
                if (bl2 && n == 6) {
                    if (piuTypeMoSU_Access.getRole(coordinator) == 1 && slotMoSU_Access == reliableProgramUniterMoSU_Access.getAdmActiveSlot(coordinator) && reliableProgramUniterMoSU_Access.getAdmPassiveSlot(coordinator) == null) {
                        rPU_AttributesInformation = reliableProgramUniterMoSU_Access.getRPU_AttributesInformation(null);
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "reliableProgramCreated(ProgramMoSU_Access programMo, Coordinator aCoordinator)", "theRPU_AttributesInformation: " + rPU_AttributesInformation);
                        }
                        if (rPU_AttributesInformation.admActiveInstanceId == 0L) {
                            reliableProgramUniterMoSU_Access.setAdmActivePgmId((long)programMoSU_Access.getProgramFroId(coordinator), coordinator);
                            continue;
                        }
                        if (rPU_AttributesInformation.newAdmActiveInstanceId == 0L) {
                            reliableProgramUniterMoSU_Access.setNewAdmActivePgmId((long)programMoSU_Access.getProgramFroId(coordinator), coordinator);
                            continue;
                        }
                        Trace.warning(this.getClass(), "reliableProgramCreated(ProgramMoSU_Access programMo, Coordinator aCoordinator).", " admActive and newAdmActive relations to program objects already set for RPU " + reliableProgramUniterMoSU_Access.getRpuId(coordinator));
                        continue;
                    }
                    Trace.warning(this.getClass(), "reliableProgramCreated(ProgramMoSU_Access programMo, Coordinator aCoordinator).", " Slot may not match or not an MP or admPassiveSlot is not empty for the device processor RPU" + reliableProgramUniterMoSU_Access.getRpuId(coordinator));
                    continue;
                }
                if (bl2 || n == 6) continue;
                if (piuTypeMoSU_Access.getRole(coordinator) == 1 && slotMoSU_Access == reliableProgramUniterMoSU_Access.getAdmActiveSlot(coordinator)) {
                    rPU_AttributesInformation = reliableProgramUniterMoSU_Access.getRPU_AttributesInformation(null);
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "reliableProgramCreated(ProgramMoSU_Access programMo, Coordinator aCoordinator)", "theRPU_AttributesInformation: " + rPU_AttributesInformation);
                    }
                    if (rPU_AttributesInformation.admActiveInstanceId == 0L) {
                        reliableProgramUniterMoSU_Access.setAdmActivePgmId((long)programMoSU_Access.getProgramFroId(coordinator), coordinator);
                        continue;
                    }
                    if (rPU_AttributesInformation.newAdmActiveInstanceId == 0L) {
                        reliableProgramUniterMoSU_Access.setNewAdmActivePgmId((long)programMoSU_Access.getProgramFroId(coordinator), coordinator);
                        continue;
                    }
                    Trace.warning(this.getClass(), "reliableProgramCreated(ProgramMoSU_Access programMo, Coordinator aCoordinator).", " admActive and newAdmActive relations to program objects already set for RPU " + reliableProgramUniterMoSU_Access.getRpuId(coordinator));
                    continue;
                }
                if (piuTypeMoSU_Access.getRole(coordinator) != 1 || slotMoSU_Access != reliableProgramUniterMoSU_Access.getAdmPassiveSlot(coordinator)) continue;
                rPU_AttributesInformation = reliableProgramUniterMoSU_Access.getRPU_AttributesInformation(null);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "reliableProgramCreated(ProgramMoSU_Access programMo, Coordinator aCoordinator)", "theRPU_AttributesInformation: " + rPU_AttributesInformation);
                }
                if (rPU_AttributesInformation.admPassiveInstanceId == 0L) {
                    reliableProgramUniterMoSU_Access.setAdmPassivePgmId((long)programMoSU_Access.getProgramFroId(coordinator), coordinator);
                    continue;
                }
                if (rPU_AttributesInformation.newAdmPassiveInstanceId == 0L) {
                    reliableProgramUniterMoSU_Access.setNewAdmPassivePgmId((long)programMoSU_Access.getProgramFroId(coordinator), coordinator);
                    continue;
                }
                Trace.warning(this.getClass(), "reliableProgramCreated(ProgramMoSU_Access programMo, Coordinator aCoordinator).", " admPassive and newAdmPassive relations to program objects already set for RPU " + reliableProgramUniterMoSU_Access.getRpuId(coordinator));
            }
            if (!bl) {
                Trace.info(this.getClass(), "reliableProgramCreated(ProgramMoSU_Access programMo, Coordinator aCoordinator).", " ReliableProgramUniter::reliableProgramCreated can't find matching label RPU for " + programMoSU_Access.getLocalDistinguishedName());
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "reliableProgramCreated(ProgramMoSU_Access programMo, Coordinator aCoordinator)", "\n\tprogramMo: " + programMoSU_Access + "\n\tThrowable caught.", throwable);
            throw new RPU_MO_HandlerException("Class name: " + this.getClass().getName() + "\n\treliableProgramCreated(ProgramMoSU_Access programMo, Coordinator aCoordinator)" + "\n\tprogramMo: " + programMoSU_Access + "\n\tThrowable caught: " + throwable);
        }
    }

    public void reliableProgramDeleted(ProgramMoSU_Access programMoSU_Access, Coordinator coordinator) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "reliableProgramDeleted(ProgramMoSU_Access programMo, Coordinator context)", "programMo: " + programMoSU_Access + "\n\tcontext: " + SuLib.toString(coordinator));
        }
        try {
            boolean bl = false;
            ArrayList<ReliableProgramUniterMoSU_Access> arrayList = new ArrayList<ReliableProgramUniterMoSU_Access>();
            SlotMoSU_Access slotMoSU_Access = (SlotMoSU_Access)programMoSU_Access.getParent().getParent();
            MoIterator moIterator = MoRepository.instance().lookupType("ReliableProgramUniter");
            if (moIterator == null) {
                return;
            }
            ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = null;
            while (moIterator.hasMoreElements()) {
                reliableProgramUniterMoSU_Access = (ReliableProgramUniterMoSU_Access)moIterator.nextMo();
                if (slotMoSU_Access != reliableProgramUniterMoSU_Access.getAdmActiveSlot(coordinator) && slotMoSU_Access != reliableProgramUniterMoSU_Access.getAdmPassiveSlot(coordinator)) continue;
                arrayList.add(reliableProgramUniterMoSU_Access);
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "reliableProgramDeleted(ProgramMoSU_Access programMo, Coordinator context)", "RPU MO's found: " + arrayList + "\n\tThe program's Slot MO: " + slotMoSU_Access);
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n;
                reliableProgramUniterMoSU_Access = (ReliableProgramUniterMoSU_Access)iterator.next();
                RPU_AttributesInformation rPU_AttributesInformation = reliableProgramUniterMoSU_Access.getRPU_AttributesInformation(null);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "reliableProgramDeleted(ProgramMoSU_Access programMo, Coordinator aCoordinator)", "theRPU_AttributesInformation: " + rPU_AttributesInformation);
                }
                if (rPU_AttributesInformation.admActiveInstanceId == (long)(n = programMoSU_Access.getProgramFroId(coordinator))) {
                    reliableProgramUniterMoSU_Access.setAdmActivePgmId(rPU_AttributesInformation.newAdmActiveInstanceId, coordinator);
                    reliableProgramUniterMoSU_Access.setNewAdmActivePgmId(0L, coordinator);
                    bl = true;
                }
                if (rPU_AttributesInformation.newAdmActiveInstanceId == (long)n) {
                    reliableProgramUniterMoSU_Access.setNewAdmActivePgmId(0L, coordinator);
                    bl = true;
                }
                if (rPU_AttributesInformation.admPassiveInstanceId == (long)n) {
                    reliableProgramUniterMoSU_Access.setAdmPassivePgmId(rPU_AttributesInformation.newAdmPassiveInstanceId, coordinator);
                    reliableProgramUniterMoSU_Access.setNewAdmPassivePgmId(0L, coordinator);
                    bl = true;
                }
                if (rPU_AttributesInformation.newAdmPassiveInstanceId != (long)n) continue;
                reliableProgramUniterMoSU_Access.setNewAdmPassivePgmId(0L, coordinator);
                bl = true;
            }
            if (!bl && Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "reliableProgramDeleted(ProgramMoSU_Access programMo, Coordinator context).", "A Program MO 'tagged' as reliable is deleted when no RPU resource relation is foundi.e. none of the attributes admActive, admPassive,  newAdmActive or newAdmPassive has any relation to a RPU.\n\tProgram tagged as RPU: " + programMoSU_Access);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "reliableProgramDeleted(ProgramMoSU_Access programMo, Coordinator aCoordinator)", "\n\tprogramMo: " + programMoSU_Access + "\n\tThrowable caught.", throwable);
            throw new RPU_MO_HandlerException("Class name: " + this.getClass().getName() + "\n\treliableProgramDeleted(ProgramMoSU_Access programMo, Coordinator aCoordinator)" + "\n\tprogramMo: " + programMoSU_Access + "\n\tThrowable caught: " + throwable);
        }
    }

    public void updatePropertiesInRPU_MOs(Map map, Collection collection, Collection collection2, RPU_ModificationInformation rPU_ModificationInformation) throws RPU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updatePropertiesInRPU_MOs ( Map anOriginRPUsAdmPassiveSlots, Collection aRPU_MOsToBeModified, Collection aRPU2_MOs, RPU_ModificationInformation aRPU_ModificationInformation )", "anOriginRPUsAdmPassiveSlots: " + map + "\n\taRPU_MOsToBeModified: " + collection + "\n\taRPU2_MOs: " + collection2 + "\n\taRPU_ModificationInformation: " + rPU_ModificationInformation);
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            if (collection.isEmpty()) {
                return;
            }
            RPU_PropertyInformation rPU_PropertyInformation = rPU_ModificationInformation.rpuInformation;
            boolean bl = false;
            if (rPU_PropertyInformation.oldRP_Label2 != null) {
                if (collection2.size() == 1) {
                    bl = true;
                } else if (collection2.size() == 0) {
                    Trace.warning(this.getClass(), "updatePropertiesInRPU_MOs ( Map anOriginRPUsAdmPassiveSlots, Collection aRPU_MOsToBeModified, Collection aRPU2_MOs, RPU_ModificationInformation aRPU_ModificationInformation )", "Not possible set the passive slot for the RPUs since no RPU MO was found that matches the\n\tgiven OldRPU2 to be used when setting the passive adm slot.\n\tAny other requested modifications of the RPU will be executed.\n\tRequested theRPU_PropertyInformation: " + rPU_PropertyInformation + "\n\tSelected RPU MOs to be modified: " + collection);
                } else {
                    Trace.warning(this.getClass(), "updatePropertiesInRPU_MOs ( Map anOriginRPUsAdmPassiveSlots, Collection aRPU_MOsToBeModified, Collection aRPU2_MOs, RPU_ModificationInformation aRPU_ModificationInformation )", "Not possible set the passive slot for the RPUs since more than one RPU MO was found that matches the\n\tgiven OldRPU2 to be used when setting the passive adm slot.\n\tAny other requested modifications of the RPU will be executed.\n\tRequested theRPU_PropertyInformation: " + rPU_PropertyInformation + "\n\tSelected RPU MOs to be modified: " + collection);
                }
            }
            control = Transaction.create();
            coordinator = Transaction.getCoordinator(control);
            Iterator iterator = collection.iterator();
            ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = null;
            ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access2 = null;
            SlotMoSU_Access slotMoSU_Access = null;
            while (iterator.hasNext()) {
                reliableProgramUniterMoSU_Access = (ReliableProgramUniterMoSU_Access)iterator.next();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "updatePropertiesInRPU_MOs (Map anOriginRPUsAdmPassiveSlots, Collection aRPU_MOsToBeModified, Collection aRPU2_MOs, RPU_ModificationInformation aRPU_ModificationInformation )", "Updates RPU properties for RPU MO: " + reliableProgramUniterMoSU_Access + "\n\ttheRPU_PropertyInformation: " + rPU_PropertyInformation);
                }
                if (rPU_PropertyInformation.rpuNormalisationMode != null) {
                    reliableProgramUniterMoSU_Access.setNormalisation(rPU_PropertyInformation.rpuNormalisationMode.getValue(), coordinator);
                }
                if (rPU_PropertyInformation.rpuReplicationMode != null) {
                    reliableProgramUniterMoSU_Access.setReplication(rPU_PropertyInformation.rpuReplicationMode.getValue(), coordinator);
                }
                if (rPU_PropertyInformation.rpuSwitchOverMode != null) {
                    reliableProgramUniterMoSU_Access.setSwitchOver(rPU_PropertyInformation.rpuSwitchOverMode.getValue(), coordinator);
                }
                if (rPU_PropertyInformation.newRP_Label != null) {
                    reliableProgramUniterMoSU_Access.setReliableProgramLabelForSU(rPU_PropertyInformation.newRP_Label, coordinator);
                }
                if (rPU_PropertyInformation.isOneLegged) {
                    reliableProgramUniterMoSU_Access.setAdmPassiveSlot(null, coordinator);
                }
                if (bl) {
                    reliableProgramUniterMoSU_Access2 = (ReliableProgramUniterMoSU_Access)collection2.iterator().next();
                    slotMoSU_Access = (SlotMoSU_Access)map.get(reliableProgramUniterMoSU_Access2.getLocalDistinguishedName());
                    reliableProgramUniterMoSU_Access.setAdmPassiveSlot((ManagedObject)slotMoSU_Access, coordinator);
                }
                if (!SU_AccessVersionHandler.getInstance().isSupported("SU_2", reliableProgramUniterMoSU_Access.getSupportedVersions()) || rPU_PropertyInformation.isForDeviceProgram == null) continue;
                reliableProgramUniterMoSU_Access.setIsForDeviceProgramForSU(rPU_PropertyInformation.isForDeviceProgram.booleanValue(), coordinator);
            }
            Transaction.commit(control);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updatePropertiesInRPU_MOs ( Map anOriginRPUsAdmPassiveSlots, Collection aRPU_MOsToBeModified, Collection aRPU2_MOs, RPU_ModificationInformation aRPU_ModificationInformation )", "aRPU_MOsToBeModified: " + collection + "\n\taRPU2_MOs: " + collection2 + "\n\taRPU_ModificationInformation: " + rPU_ModificationInformation + "\n\tThrowable caught.", throwable);
            Transaction.rollback(control);
            throw new RPU_MO_HandlerException("Class: " + this.getClass().getName() + "\n\tMethod: updatePropertiesInRPU_MOs ( Map anOriginRPUsAdmPassiveSlots, Collection aRPU_MOsToBeModified, Collection aRPU2_MOs, RPU_ModificationInformation aRPU_ModificationInformation )" + "\n\taRPU_MOsToBeModified: " + collection + "\n\taRPU2_MOs: " + collection2 + "\n\taRPU_ModificationInformation: " + rPU_ModificationInformation + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    private boolean isSU_Created(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isSU_Created ( String theUserLabel )", "theUserLabel: " + string);
        }
        boolean bl = false;
        if (string == null) {
            return bl;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        if (stringTokenizer.countTokens() >= 4 && string.indexOf(SU_Created) != -1) {
            bl = true;
        }
        return bl;
    }

    private String extractOriginUserLabel(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "extractOriginUserLabel ( String anUserLabel )", "anUserLabel: " + string);
        }
        int n = this.getNoOfSuCreated(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        int n2 = 0;
        String string2 = null;
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (n2 == n) {
                string3 = string2;
                break;
            }
            ++n2;
        }
        if (string3.length() == 0) {
            Trace.warning(this.getClass(), "extractOriginUserLabel ( String anUserLabel )", "Couldn't extract the origin user label (assumes an empty string)");
        }
        return string3;
    }

    private int getNoOfSuCreated(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNoOfSuCreated ( String anUserLabel )", "anUserLabel: " + string);
        }
        if (string == null) {
            return 0;
        }
        int n = 0;
        while (string.indexOf(SU_Created) != -1) {
            string = string.substring(string.indexOf(SU_Created) + SU_Created.length());
            ++n;
        }
        return n;
    }
}

