/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.verify;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.equipment.MultipleSwAllocationsAllowed;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumbersAndRevisions;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoiresProxyInterface;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.mohandler.slot.SlotMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.swallocation.SwAllocationMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.upgradeable.UpgradeablePIU_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.verify.PiuTypeConfigOverlappInformation;
import se.ericsson.cello.upgradepackage.verify.PiuTypeLoadListInformation;
import se.ericsson.cello.upgradepackage.verify.UcfDataContainer;
import se.ericsson.cello.upgradepackage.verify.VerifyUpgradeException;
import se.ericsson.cello.upgradepackage.verify.event.VerifyRequestEvent;

public class MultipleSwaVerifier {
    public UcfDataContainer initiateValidation(Collection collection, HashSet hashSet, RepertoiresProxyInterface repertoiresProxyInterface) throws VerifyUpgradeException, MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "initiateValidation(Collection anRepertoireReplacementData, HashSet anRepertoireNamesInUCF, RepertoiresProxyInterface aRepertoireProxy)", "anRepertoireReplacementData: " + collection + "\n\tanRepertoireNamesInUCF: " + hashSet + "\n\taRepertoireProxy: " + repertoiresProxyInterface);
        }
        UcfDataContainer ucfDataContainer = new UcfDataContainer();
        SwAllocationMO_HandlerInterface swAllocationMO_HandlerInterface = ServiceFinder.getSwAllocationMO_HandlerInterface();
        Iterator iterator = this.getUpgradeableUnitsWithMultipleSWA();
        while (iterator.hasNext()) {
            MultipleSwAllocationsAllowed multipleSwAllocationsAllowed = (MultipleSwAllocationsAllowed)iterator.next();
            ManagedObject[] managedObjectArray = multipleSwAllocationsAllowed.getSwAllocations(null);
            for (int i = 0; i < managedObjectArray.length; ++i) {
                Collection collection2 = swAllocationMO_HandlerInterface.getRepertoiresToBeConnected((SwAllocationMoSU_Access)managedObjectArray[i], collection, hashSet);
                Iterator iterator2 = collection2.iterator();
                while (iterator2.hasNext()) {
                    String string = (String)iterator2.next();
                    ProductNumbersAndRevisions productNumbersAndRevisions = repertoiresProxyInterface.getProductNumbersAndRevisionsOfPiuTypeRefs(string);
                    ucfDataContainer.add(multipleSwAllocationsAllowed, (SwAllocationMoSU_Access)managedObjectArray[i], string, productNumbersAndRevisions);
                    if (!Trace.valid(this.getClass(), 20)) continue;
                    Trace.debug(this.getClass(), 20, "initiateValidation(..)", "Adding UpgradeableUnit: " + multipleSwAllocationsAllowed.getLocalDistinguishedName() + ", SwAllocation: " + (SwAllocationMoSU_Access)managedObjectArray[i] + ", RepertoireName: " + string + ", ProductNumbersAndRevisions: " + productNumbersAndRevisions.toString());
                }
            }
        }
        return ucfDataContainer;
    }

    public Collection getInconsistentPiuTypeLoadLists(VerifyRequestEvent verifyRequestEvent, UcfDataContainer ucfDataContainer) throws VerifyUpgradeException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getInconsistentPiuTypeLoadLists(VerifyRequestEvent aVerifyRequestEvent, UcfDataContainer anUCF_DataContainer)", "aVerifyRequestEvent: " + verifyRequestEvent + "\n\tanUCF_DataContainer: " + ucfDataContainer);
        }
        HashSet<PiuTypeLoadListInformation> hashSet = new HashSet<PiuTypeLoadListInformation>();
        Iterator iterator = ucfDataContainer.getUpgradableUnitIterator();
        while (iterator.hasNext()) {
            MultipleSwAllocationsAllowed multipleSwAllocationsAllowed = (MultipleSwAllocationsAllowed)iterator.next();
            PiuTypeLoadListInformation piuTypeLoadListInformation = new PiuTypeLoadListInformation(multipleSwAllocationsAllowed);
            Iterator iterator2 = ucfDataContainer.getSwAllocationIterator(multipleSwAllocationsAllowed);
            while (iterator2.hasNext()) {
                HashSet<String> hashSet2 = new HashSet<String>();
                SwAllocationMoSU_Access swAllocationMoSU_Access = (SwAllocationMoSU_Access)iterator2.next();
                Iterator iterator3 = ucfDataContainer.getProductNumbersAndRevisionIterator(multipleSwAllocationsAllowed, swAllocationMoSU_Access);
                while (iterator3.hasNext()) {
                    ProductNumbersAndRevisions productNumbersAndRevisions = (ProductNumbersAndRevisions)iterator3.next();
                    Iterator iterator4 = ucfDataContainer.getProductNumbersAndRevisionIterator(multipleSwAllocationsAllowed, swAllocationMoSU_Access);
                    while (iterator4.hasNext()) {
                        ProductNumbersAndRevisions productNumbersAndRevisions2 = (ProductNumbersAndRevisions)iterator4.next();
                        if (productNumbersAndRevisions.getNotIncludedElements(productNumbersAndRevisions2).isEmpty() && productNumbersAndRevisions2.getNotIncludedElements(productNumbersAndRevisions).isEmpty()) continue;
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "getInconsistentPiuTypeLoadLists(VerifyRequestEvent aVerifyRequestEvent, UcfDataContainer anUCF_DataContainer)", "theAnotherProductNumbersAndRevisions: " + productNumbersAndRevisions2 + "theProductNumbersAndRevisions: " + productNumbersAndRevisions + "theUnSupportedPiu(1): " + productNumbersAndRevisions.getNotIncludedElements(productNumbersAndRevisions2) + "theUnSupportedPiu(2): " + productNumbersAndRevisions2.getNotIncludedElements(productNumbersAndRevisions));
                        }
                        hashSet2.add(ucfDataContainer.getRepertoireName(multipleSwAllocationsAllowed, swAllocationMoSU_Access, productNumbersAndRevisions));
                        if (!productNumbersAndRevisions.isEmpty()) continue;
                        hashSet2.add(ucfDataContainer.getRepertoireName(multipleSwAllocationsAllowed, swAllocationMoSU_Access, productNumbersAndRevisions2));
                    }
                }
                if (hashSet2.isEmpty()) continue;
                piuTypeLoadListInformation.addSwa(swAllocationMoSU_Access, hashSet2);
                if (!Trace.valid(this.getClass(), 20)) continue;
                Trace.debug(this.getClass(), 20, "getInconsistentPiuTypeLoadLists(VerifyRequestEvent aVerifyRequestEvent, UcfDataContainer anUCF_DataContainer)", "Configuration fault, the following Repertoires: " + hashSet2.toString() + " in SwAllocation: " + swAllocationMoSU_Access + ", UpgradeableUnit: " + multipleSwAllocationsAllowed + " do not support the same set of PiuType's");
            }
            if (piuTypeLoadListInformation.isEmpty()) continue;
            hashSet.add(piuTypeLoadListInformation);
        }
        return hashSet;
    }

    public Collection getOverlappingPiuTypeDefinitions(VerifyRequestEvent verifyRequestEvent, UcfDataContainer ucfDataContainer) throws VerifyUpgradeException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "VerifyRequestEvent aVerifyRequestEvent, UcfDataContainer anUCF_DataContainer)", "aVerifyRequestEvent: " + verifyRequestEvent + "\n\tanUCF_DataContainer: " + ucfDataContainer);
        }
        HashSet<PiuTypeConfigOverlappInformation> hashSet = new HashSet<PiuTypeConfigOverlappInformation>();
        PiuTypeConfigOverlappInformation piuTypeConfigOverlappInformation = null;
        Iterator iterator = ucfDataContainer.getUpgradableUnitIterator();
        while (iterator.hasNext()) {
            MultipleSwAllocationsAllowed multipleSwAllocationsAllowed = (MultipleSwAllocationsAllowed)iterator.next();
            piuTypeConfigOverlappInformation = new PiuTypeConfigOverlappInformation(multipleSwAllocationsAllowed);
            Iterator iterator2 = ucfDataContainer.getSwAllocationIterator(multipleSwAllocationsAllowed);
            while (iterator2.hasNext()) {
                SwAllocationMoSU_Access swAllocationMoSU_Access = (SwAllocationMoSU_Access)iterator2.next();
                Iterator iterator3 = ucfDataContainer.getSwAllocationIterator(multipleSwAllocationsAllowed);
                while (iterator3.hasNext()) {
                    SwAllocationMoSU_Access swAllocationMoSU_Access2 = (SwAllocationMoSU_Access)iterator3.next();
                    if (swAllocationMoSU_Access == swAllocationMoSU_Access2) continue;
                    Iterator iterator4 = ucfDataContainer.getProductNumbersAndRevisionIterator(multipleSwAllocationsAllowed, swAllocationMoSU_Access);
                    while (iterator4.hasNext()) {
                        ProductNumbersAndRevisions productNumbersAndRevisions = (ProductNumbersAndRevisions)iterator4.next();
                        Iterator iterator5 = ucfDataContainer.getProductNumbersAndRevisionIterator(multipleSwAllocationsAllowed, swAllocationMoSU_Access2);
                        while (iterator5.hasNext()) {
                            ProductNumbersAndRevisions productNumbersAndRevisions2 = (ProductNumbersAndRevisions)iterator5.next();
                            ProductNumbersAndRevisions productNumbersAndRevisions3 = productNumbersAndRevisions.getIncludedElements(productNumbersAndRevisions2);
                            if (productNumbersAndRevisions3.isEmpty()) continue;
                            piuTypeConfigOverlappInformation.add(swAllocationMoSU_Access, ucfDataContainer.getRepertoireName(multipleSwAllocationsAllowed, swAllocationMoSU_Access, productNumbersAndRevisions), swAllocationMoSU_Access2, ucfDataContainer.getRepertoireName(multipleSwAllocationsAllowed, swAllocationMoSU_Access2, productNumbersAndRevisions2), productNumbersAndRevisions3);
                            if (!Trace.valid(this.getClass(), 20)) continue;
                            Trace.debug(this.getClass(), 20, "getOverlappingPiuTypeDefinitions(...)", "Configuration fault, UpgradeableUnit: " + multipleSwAllocationsAllowed + ", SwAllocation: " + swAllocationMoSU_Access + ", Repertoire: " + ucfDataContainer.getRepertoireName(multipleSwAllocationsAllowed, swAllocationMoSU_Access, productNumbersAndRevisions) + " and SwAllocation: " + swAllocationMoSU_Access2 + ", Repertoire: " + ucfDataContainer.getRepertoireName(multipleSwAllocationsAllowed, swAllocationMoSU_Access2, productNumbersAndRevisions2) + " contains the same PiuType definition. " + "The common PiuType definitions are: " + productNumbersAndRevisions3.toString());
                        }
                    }
                }
            }
            if (piuTypeConfigOverlappInformation.isEmpty()) continue;
            hashSet.add(piuTypeConfigOverlappInformation);
        }
        return hashSet;
    }

    private Iterator getUpgradeableUnitsWithMultipleSWA() throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUpgradeableUnitsWithMultipleSWA()");
        }
        UpgradeablePIU_HandlerInterface upgradeablePIU_HandlerInterface = ServiceFinder.getUpgradeablePIU_HandlerInterface();
        Collection collection = upgradeablePIU_HandlerInterface.getAllConfiguredUpgradeablePIUs();
        HashSet<MultipleSwAllocationsAllowed> hashSet = new HashSet<MultipleSwAllocationsAllowed>();
        GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = null;
        MultipleSwAllocationsAllowed multipleSwAllocationsAllowed = null;
        Iterator iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)iterator.next();
                if (genericUpgradeablePlugInUnit instanceof MultipleSwAllocationsAllowed) {
                    multipleSwAllocationsAllowed = (MultipleSwAllocationsAllowed)genericUpgradeablePlugInUnit;
                    if (!this.configuredWithMultipleSWA(multipleSwAllocationsAllowed)) continue;
                    hashSet.add(multipleSwAllocationsAllowed);
                    if (!Trace.valid(this.getClass(), 20)) continue;
                    Trace.debug(this.getClass(), 20, "getUpgradeableUnitsWithMultipleSWA()", "Adding MultipleSwAllocationsAllowed: " + multipleSwAllocationsAllowed.getLocalDistinguishedName());
                    continue;
                }
                if (!Trace.valid(this.getClass(), 20)) continue;
                Trace.debug(this.getClass(), 20, "getUpgradeableUnitsWithMultipleSWA()", "The PIU: " + genericUpgradeablePlugInUnit.getLocalDistinguishedName() + ", is not of type MultipleSwAllocationsAllowed");
            }
            SlotMO_HandlerInterface slotMO_HandlerInterface = ServiceFinder.getSlotMO_HandlerInterface();
            hashSet.addAll(slotMO_HandlerInterface.getAllEmptySlotsWithMultipleSwAllocations());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Trace.warning(this.getClass(), "getUpgradeableUnitsWithMultipleSWA()", "Throwable caught.\n\tCouldn't get the required information due to the GenericUpgradeablePlugInUnit was not compatible \n\tThrowable data: " + noClassDefFoundError);
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUpgradeableUnitsWithMultipleSWA()", "Total size: " + hashSet.size());
        }
        return hashSet.iterator();
    }

    private boolean configuredWithMultipleSWA(MultipleSwAllocationsAllowed multipleSwAllocationsAllowed) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "configuredWithMultipleSWA(MultipleSwAllocationsAllowed anUpgradeableUnit)", "anUpgradeableUnit: " + multipleSwAllocationsAllowed);
        }
        return multipleSwAllocationsAllowed.getSwAllocations(null).length > 1;
    }
}

