/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.verify;

import se.ericsson.cello.upgradepackage.util.mohandler.subrack.SubrackMoData;
import se.ericsson.cello.upgradepackage.util.mohandler.subrackprodtype.SubrackProdTypeData;

public class SubrackNotSupportedInformation {
    private SubrackMoData mySubrackMoData = null;
    private SubrackProdTypeData mySubrackProdTypeData = null;
    private boolean myIsRequiredMoAccessVersionSupported = true;
    private boolean myIsSubrackInfoPresentInUCF = true;

    public SubrackNotSupportedInformation(SubrackMoData subrackMoData, SubrackProdTypeData subrackProdTypeData) {
        this.mySubrackMoData = subrackMoData;
        this.mySubrackProdTypeData = subrackProdTypeData;
    }

    public SubrackNotSupportedInformation(boolean bl, boolean bl2) {
        this.myIsRequiredMoAccessVersionSupported = bl;
        this.myIsSubrackInfoPresentInUCF = bl2;
    }

    public String getInformation() {
        if (this.myIsRequiredMoAccessVersionSupported && !this.myIsSubrackInfoPresentInUCF) {
            return "Mandatory information about supported Subracks is not present in Upgrade Control File.";
        }
        if (!this.myIsRequiredMoAccessVersionSupported && this.myIsSubrackInfoPresentInUCF) {
            return "The implemented version of interface SubrackMoSystemUpgradeAccess is not compatible with the used Upgrade Control File,\n\t(information about supported Subracks was not expected in the Upgrade Control File).";
        }
        if (this.mySubrackMoData != null) {
            String string = "A Subrack in the node is not supported by the Upgrade Package (defined in UCF): \n\tSubrack (LDN): " + this.mySubrackMoData.ldnValue + "\n\tOperational product number: " + this.mySubrackMoData.operationalProductNumber + "\n\tOperational product revision: " + this.mySubrackMoData.operationalProductRevision;
            if (this.mySubrackProdTypeData != null) {
                return string + "\n\tConnected to SubrackProdType (LDN): " + this.mySubrackProdTypeData.subrackProdTypeMO.getLocalDistinguishedName() + "\n\tProduct number: " + this.mySubrackProdTypeData.productNumberAndRevision.productNumber + "\n\tProduct revision: " + this.mySubrackProdTypeData.productNumberAndRevision.revision;
            }
            return string;
        }
        return "No information available, internal error.";
    }

    public String toString() {
        return "\n\tmySubrackMoData: " + this.mySubrackMoData + "\n\tmySubrackProdTypeData: " + this.mySubrackProdTypeData + "\n\tmyIsRequiredMoAccessVersionSupported: " + this.myIsRequiredMoAccessVersionSupported + "\n\tmyIsSubrackInfoPresentInUCF: " + this.myIsSubrackInfoPresentInUCF;
    }
}

