/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.connection.ftp;

import com.ibm.oti.connection.ConnectionUtil;
import com.ibm.oti.connection.CreateConnection;
import com.ibm.oti.connection.DataConnection;
import com.ibm.oti.util.Msg;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

public class Connection
extends DataConnection
implements CreateConnection {
    private String host;
    private String file;
    private String user = "anonymous";
    private String password = "";
    private int access;
    private InputStream ctrlInput;
    private InputStream inputStream;
    private OutputStream ctrlOutput;
    private OutputStream outputStream;
    private boolean streamOpen = false;
    private static final int FTP_DATAOPEN = 125;
    private static final int FTP_OPENDATA = 150;
    private static final int FTP_OK = 200;
    private static final int FTP_USERREADY = 220;
    private static final int FTP_TRANSFEROK = 226;
    private static final int FTP_LOGGEDIN = 230;
    private static final int FTP_FILEOK = 250;
    private static final int FTP_PASWD = 331;
    private static final int FTP_NOTFOUND = 550;

    public void close() throws IOException {
        this.host = null;
        if (!this.streamOpen) {
            if (this.inputStream != null) {
                this.inputStream.close();
            } else {
                this.outputStream.close();
            }
        }
    }

    public InputStream openInputStream() throws IOException {
        if (this.host == null) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (this.access != 1) {
            throw new IOException(Msg.getString("K00a9"));
        }
        this.streamOpen = true;
        return this.inputStream;
    }

    public OutputStream openOutputStream() throws IOException {
        if (this.host == null) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (this.access != 2) {
            throw new IOException(Msg.getString("K00aa"));
        }
        this.streamOpen = true;
        return this.outputStream;
    }

    private void disconnect(StreamConnection c0, StreamConnectionNotifier c1) {
        try {
            if (c0 != null) {
                c0.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (this.ctrlInput != null) {
                this.ctrlInput.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (this.ctrlOutput != null) {
                this.ctrlOutput.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (c1 != null) {
                c1.close();
            }
        }
        catch (Exception exception) {}
    }

    public javax.microedition.io.Connection setParameters2(String spec, int access, boolean timeout) throws IOException {
        String[][] equates = ConnectionUtil.NO_PARAMETERS;
        int index = spec.indexOf(59);
        if (index != -1) {
            equates = ConnectionUtil.getParameters(spec.substring(index + 1));
            spec = spec.substring(0, index);
        }
        this.setParameters(spec, equates, access, timeout);
        return this;
    }

    private void setParameters(String spec, String[][] equates, int access, boolean timeout) throws IOException {
        char type = 'I';
        int i = 0;
        while (i < equates.length) {
            char ch;
            String key = equates[i][0].toLowerCase();
            if (key.equals("type") && equates[i][1] != null) {
                if (equates[i][1].length() > 1 || (ch = Character.toUpperCase(equates[i][1].charAt(0))) != 'A' && ch != 'I') {
                    throw new IllegalArgumentException(Msg.getString("K0089", equates[i][1]));
                }
            } else {
                throw new IllegalArgumentException(Msg.getString("K00a5", equates[i][0]));
            }
            type = ch;
            ++i;
        }
        this.access = access;
        if (access == 3) {
            throw new IllegalArgumentException(Msg.getString("K00b4"));
        }
        if (spec.startsWith("//")) {
            int index = spec.indexOf(47, 2);
            if (index == -1) {
                throw new IllegalArgumentException(Msg.getString("K00d6"));
            }
            String hostPart = spec.substring(2, index);
            this.file = spec.substring(index);
            index = hostPart.indexOf(64);
            if (index != -1) {
                String login = hostPart.substring(0, index);
                hostPart = hostPart.substring(index + 1);
                index = login.indexOf(58);
                if (index != -1) {
                    this.user = login.substring(0, index);
                    this.password = login.substring(index + 1);
                } else {
                    this.user = login;
                }
            }
            this.host = hostPart.indexOf(":") == -1 ? String.valueOf(hostPart) + ":21" : hostPart;
        } else {
            this.host = "localhost:21";
            this.file = spec;
        }
        StreamConnection dataSocket = null;
        com.ibm.oti.connection.serversocket.Connection acceptSocket = null;
        com.ibm.oti.connection.socket.Connection controlSocket = new com.ibm.oti.connection.socket.Connection();
        controlSocket.setParameters2("//" + this.host, 3, false);
        this.ctrlOutput = controlSocket.openOutputStream();
        this.ctrlInput = new BufferedInputStream(controlSocket.openInputStream());
        try {
            this.login();
            this.setType(type);
            if (access == 2) {
                this.cd();
            }
            acceptSocket = new com.ibm.oti.connection.serversocket.Connection();
            acceptSocket.setParameters2("//:0;so_timeout=3000", 1, true);
            this.port(acceptSocket.getLocalPort(), controlSocket.getLocalAddress());
            if (access == 1) {
                this.getFile();
            } else {
                this.sendFile();
            }
            dataSocket = acceptSocket.acceptAndOpen();
        }
        catch (RuntimeException e) {
            this.disconnect(controlSocket, acceptSocket);
            throw e;
        }
        catch (IOException e) {
            this.disconnect(controlSocket, acceptSocket);
            throw e;
        }
        this.disconnect(controlSocket, acceptSocket);
        if (access == 1) {
            final InputStream dataIn = dataSocket.openInputStream();
            dataSocket.close();
            this.inputStream = new InputStream(){

                public int available() throws IOException {
                    return dataIn.available();
                }

                public int read() throws IOException {
                    return dataIn.read();
                }

                public int read(byte[] buf, int offset, int length) throws IOException {
                    return dataIn.read(buf, offset, length);
                }

                public long skip(long amount) throws IOException {
                    return dataIn.skip(amount);
                }

                public void close() throws IOException {
                    dataIn.close();
                }
            };
        } else {
            final OutputStream dataOut = dataSocket.openOutputStream();
            dataSocket.close();
            this.outputStream = new OutputStream(){

                public void write(int value) throws IOException {
                    dataOut.write(value);
                }

                public void write(byte[] buf, int offset, int length) throws IOException {
                    dataOut.write(buf, offset, length);
                }

                public void close() throws IOException {
                    dataOut.close();
                }
            };
        }
    }

    private int getReply() throws IOException {
        String line = this.readLine();
        if (line.length() >= 4) {
            String replyCode = line.substring(0, 3);
            if (line.charAt(3) == '-') {
                while (this.readMultiLine(replyCode)) {
                }
            }
            try {
                return Integer.parseInt(replyCode);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new IOException(Msg.getString("K00dd", line));
    }

    private void login() throws IOException {
        int reply = this.getReply();
        if (reply != 220) {
            throw new IOException(Msg.getString("K0097", this.host));
        }
        this.write("USER " + this.user + "\r\n");
        reply = this.getReply();
        if (reply != 331 && reply != 230) {
            throw new IOException(Msg.getString("K0098", this.host));
        }
        if (reply == 331) {
            this.write("PASS " + this.password + "\r\n");
            reply = this.getReply();
            if (reply != 200 && reply != 220 && reply != 230) {
                throw new IOException(Msg.getString("K0098", this.host));
            }
        }
    }

    private String readLine() throws IOException {
        int c;
        StringBuffer sb = new StringBuffer();
        while ((c = this.ctrlInput.read()) != 10) {
            sb.append((char)c);
        }
        return sb.toString();
    }

    private boolean readMultiLine(String replyCode) throws IOException {
        String line = this.readLine();
        if (line.length() < 4) {
            return true;
        }
        return !line.substring(0, 3).equals(replyCode) || line.charAt(3) != ' ';
    }

    private void setType(char type) throws IOException {
        this.write("TYPE " + type + "\r\n");
        if (this.getReply() != 200) {
            throw new IOException(Msg.getString("K009b"));
        }
    }

    private void cd() throws IOException {
        int idx = this.file.lastIndexOf(47);
        if (idx > 0) {
            String dir = this.file.substring(0, idx);
            this.write("CWD " + dir + "\r\n");
            int reply = this.getReply();
            if (reply != 250 && dir.length() > 0 && dir.charAt(0) == '/') {
                this.write("CWD " + dir.substring(1) + "\r\n");
                reply = this.getReply();
            }
            if (reply != 250) {
                throw new IOException(Msg.getString("K0094"));
            }
        }
    }

    private void sendFile() throws IOException {
        this.write("STOR " + this.file.substring(this.file.lastIndexOf(47) + 1) + "\r\n");
        int reply = this.getReply();
        if (reply != 150 && reply != 200 && reply != 125) {
            throw new IOException(Msg.getString("K009a"));
        }
    }

    private void getFile() throws IOException {
        this.write("RETR " + this.file + "\r\n");
        int reply = this.getReply();
        if (reply == 550 && this.file.length() > 0 && this.file.charAt(0) == '/') {
            this.write("RETR " + this.file.substring(1) + "\r\n");
            reply = this.getReply();
        }
        if (reply != 150 && reply != 226) {
            throw new IOException(Msg.getString("K0096", reply));
        }
    }

    private void port(int dataPort, String ip) throws IOException {
        ip = ip.replace('.', ',');
        this.write("PORT " + ip + "," + (dataPort >> 8) + ',' + (dataPort & 0xFF) + "\r\n");
        if (this.getReply() != 200) {
            throw new IOException(Msg.getString("K0099"));
        }
    }

    private void write(String command) throws IOException {
        this.ctrlOutput.write(command.getBytes("ISO8859_1"));
    }
}

