/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.crypto;

import com.ibm.oti.crypto.AESProvider;
import com.ibm.oti.crypto.DESProvider;
import com.ibm.oti.crypto.Key;
import com.ibm.oti.crypto.NullProvider;
import com.ibm.oti.crypto.RC4Provider;
import com.ibm.oti.crypto.TripleDESProvider;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.spec.KeySpec;

public abstract class Provider {
    public static final int ALG_DES = 1;
    public static final int ALG_3DES = 2;
    public static final int ALG_RC2 = 3;
    public static final int ALG_RC4 = 4;
    public static final int ALG_AES = 5;
    public static final int ALG_NULL = 6;
    public static final int ALG_RSA = 7;
    protected int algorithm;
    protected int keyLength;
    protected int padType;
    protected boolean isDestroyed = false;
    boolean isInitialized;
    public static final int PAD_MIN = 1;
    public static final int PAD_MAX = 4;
    public static final int PAD_NONE = 1;
    public static final int PAD_PKCS5 = 2;
    public static final int PAD_SSL = 3;
    public static final int PAD_TLS = 4;

    public static Provider getProvider(int algorithm, int keyLength) throws IOException {
        try {
            Class clazz;
            if (algorithm == 6) {
                return new NullProvider();
            }
            switch (algorithm) {
                case 7: {
                    clazz = Class.forName("com.ibm.oti.crypto.JCEBasedRSAProvider");
                    break;
                }
                case 4: {
                    clazz = Class.forName("com.ibm.oti.crypto.JCEBasedStreamProvider");
                    break;
                }
                default: {
                    clazz = Class.forName("com.ibm.oti.crypto.JCEBasedProvider");
                }
            }
            Constructor constructor = clazz.getConstructor(new Class[]{Integer.TYPE, Integer.TYPE});
            Provider provider = (Provider)constructor.newInstance(new Object[]{new Integer(algorithm), new Integer(keyLength)});
            Provider.validateTestMode("JCE");
            return provider;
        }
        catch (Exception exception) {
            switch (algorithm) {
                case 1: {
                    Provider.validateTestMode("NOJCE");
                    return new DESProvider(keyLength);
                }
                case 2: {
                    Provider.validateTestMode("NOJCE");
                    return new TripleDESProvider(keyLength);
                }
                case 5: {
                    Provider.validateTestMode("NOJCE");
                    return new AESProvider(keyLength);
                }
                case 4: {
                    return new RC4Provider(keyLength);
                }
                case 6: {
                    return new NullProvider();
                }
            }
            throw new IOException();
        }
    }

    private static void validateTestMode(String type) throws IOException {
        String forceFail = (String)AccessController.doPrivileged(new PriviAction("jsseForceFail"));
        if (forceFail != null && forceFail.equalsIgnoreCase(type)) {
            throw new IOException(String.valueOf(type) + " Provider found when jsseForceFail= " + type);
        }
    }

    protected Provider(int algorithm, int keyLength) {
        this.algorithm = algorithm;
        this.keyLength = keyLength;
    }

    protected void setAlgorithm(int algorithm) {
        this.algorithm = algorithm;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public int getBlockLength() {
        switch (this.algorithm) {
            case 1: 
            case 2: 
            case 3: {
                return 8;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 16;
            }
        }
        return 0;
    }

    public final int getKeyLength() {
        switch (this.algorithm) {
            case 1: {
                return 8;
            }
            case 2: {
                return 24;
            }
            case 3: 
            case 4: 
            case 5: {
                return 16;
            }
            case 6: {
                return 0;
            }
        }
        return -1;
    }

    public final int getIVLength() {
        switch (this.algorithm) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return this.getBlockLength();
            }
        }
        return -1;
    }

    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    public Key createKey(byte[] keybytes) throws IOException {
        return new Key(this, keybytes);
    }

    public Key createKey(java.security.Key key) throws IOException {
        return new Key(this, key);
    }

    public void destroy() {
        if (!this.isDestroyed) {
            this.isDestroyed = true;
        }
    }

    abstract void destroyKey(Key var1);

    void cryptInit(Key key, int operation, int padType, byte[] iv) throws IOException {
        if (this.isInitialized) {
            return;
        }
        if (padType < 1 || padType > 4) {
            throw new IOException(Msg.getString("K01f7"));
        }
        this.padType = padType;
    }

    abstract byte[] cryptUpdate(Key var1, byte[] var2, int var3, int var4, boolean var5) throws IOException;

    public Key createKey(KeySpec keySpec) throws IOException {
        return new Key(this, keySpec);
    }
}

