/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import com.ibm.oti.security.provider.Util;
import com.ibm.oti.security.provider.X500Principal;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;

public class CertificateVerifierSecurity {
    public static void verifyCertificateChain(X509Certificate[] chain, Date date) throws CertificateException, IOException {
        KeyStore ks = CertificateVerifierSecurity.getSystemKeyStore();
        CertificateVerifierSecurity.verifyCertificateChain(ks, chain, date);
    }

    private static KeyStore getSystemKeyStore() throws IOException, CertificateException {
        KeyStore ks = null;
        String cacertsPath = CertificateVerifierSecurity.getCACertsPath();
        InputStream is = null;
        try {
            try {
                is = CertificateVerifierSecurity.getInputStreamForFile(cacertsPath);
                ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(is, null);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IOException("File not found: " + cacertsPath);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("Necessary cryptographic algorithm not available: " + e.getMessage());
            }
            catch (CertificateException e) {
                throw new IOException("Certificate problem: " + e.getMessage());
            }
            catch (KeyStoreException keyStoreException) {
                throw new CertificateException("Cannot get KeyStore implementation");
            }
        }
        catch (Throwable throwable) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {}
        return ks;
    }

    private static InputStream getInputStreamForFile(final String filePath) throws FileNotFoundException {
        if (filePath == null) {
            return null;
        }
        InputStream result = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return new BufferedInputStream(new FileInputStream(filePath));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
        });
        if (result == null) {
            throw new FileNotFoundException();
        }
        return result;
    }

    public static void verifyCertificateChain(KeyStore ks, X509Certificate[] chain, Date date) throws CertificateException {
        Certificate rootCert;
        int chainlen;
        PublicKey rootKey = null;
        X500Principal rootDN = CertificateVerifierSecurity.getSubject(chain[chain.length - 1]);
        if (rootDN.equals(CertificateVerifierSecurity.getIssuer(chain[chain.length - 1]))) {
            byte[] rootKeyBytes2;
            chainlen = chain.length - 1;
            rootCert = CertificateVerifierSecurity.getCertFromKeyStore(ks, chain[chain.length - 1]);
            if (rootCert == null) {
                throw new CertificateException("certificate chain root is not a trusted Certificate Authority");
            }
            rootKey = rootCert.getPublicKey();
            byte[] rootKeyBytes1 = rootKey.getEncoded();
            if (!Util.equals(rootKeyBytes1, rootKeyBytes2 = chain[chain.length - 1].getPublicKey().getEncoded())) {
                throw new CertificateException("root certificate public key does not match certificate public key on device for \"" + rootDN + "\"");
            }
        } else {
            chainlen = chain.length;
            rootDN = CertificateVerifierSecurity.getIssuer(chain[chain.length - 1]);
            rootCert = CertificateVerifierSecurity.getCertFromKeyStore(ks, rootDN);
            if (rootCert == null) {
                throw new CertificateException(Msg.getString("K0445", rootDN.getName()));
            }
            rootKey = rootCert.getPublicKey();
        }
        if (!(rootCert instanceof X509Certificate)) {
            throw new CertificateException("Root certificate not an X509 Certificate");
        }
        ((X509Certificate)rootCert).checkValidity(date);
        int i = 0;
        while (i < chainlen) {
            X500Principal issuerDN;
            PublicKey issuerKey;
            if (i < chainlen - 1) {
                issuerKey = chain[i + 1].getPublicKey();
                issuerDN = CertificateVerifierSecurity.getSubject(chain[i + 1]);
            } else {
                issuerKey = rootKey;
                issuerDN = rootDN;
            }
            if (!issuerDN.equals(CertificateVerifierSecurity.getIssuer(chain[i]))) {
                throw new CertificateException("issuer of certificate not in chain: " + issuerDN.toString());
            }
            CertificateVerifierSecurity.verifyCertificateSignature(issuerKey, chain[i]);
            chain[i].checkValidity(date);
            ++i;
        }
    }

    private static Certificate getCertFromKeyStore(KeyStore ks, Certificate cert) throws CertificateException {
        try {
            if (ks == null || cert == null) {
                return null;
            }
            String alias = ks.getCertificateAlias(cert);
            if (alias == null) {
                return null;
            }
            return ks.getCertificate(alias);
        }
        catch (KeyStoreException keyStoreException) {
            throw new CertificateException("Cannot find certificate in keystore");
        }
    }

    private static Certificate getCertFromKeyStore(KeyStore ks, X500Principal subject) {
        if (ks == null || subject == null) {
            return null;
        }
        try {
            Enumeration aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                String alias = (String)aliases.nextElement();
                X509Certificate cert = (X509Certificate)ks.getCertificate(alias);
                X500Principal certSubject = new X500Principal(cert.getSubjectDN().getName());
                if (!certSubject.equals(subject)) continue;
                return cert;
            }
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    private static String getCACertsPath() {
        String result = null;
        String ps = (String)AccessController.doPrivileged(new PriviAction("file.separator"));
        StringBuffer cacertsPath = new StringBuffer((String)AccessController.doPrivileged(new PriviAction("java.home")));
        cacertsPath.append(ps);
        cacertsPath.append("lib");
        cacertsPath.append(ps);
        cacertsPath.append("security");
        cacertsPath.append(ps);
        cacertsPath.append("cacerts");
        result = cacertsPath.toString();
        return result;
    }

    private static X500Principal getSubject(X509Certificate cert) {
        X500Principal subject = new X500Principal(cert.getSubjectDN().getName());
        return subject;
    }

    private static X500Principal getIssuer(X509Certificate cert) {
        X500Principal issuer = new X500Principal(cert.getIssuerDN().getName());
        return issuer;
    }

    private static void verifyCertificateSignature(PublicKey issuerKey, X509Certificate subject) throws CertificateException {
        try {
            subject.verify(issuerKey);
        }
        catch (InvalidKeyException e) {
            throw new CertificateException("error in signature for certificate \"" + subject.getSubjectDN().getName() + "\": " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertificateException("algorithm not supported for certificate \"" + subject.getSubjectDN().getName() + "\": " + e.getMessage());
        }
        catch (NoSuchProviderException e) {
            throw new CertificateException("algorithm not supported for certificate \"" + subject.getSubjectDN().getName() + "\": " + e.getMessage());
        }
        catch (SignatureException e) {
            throw new CertificateException("error in signature for certificate \"" + subject.getSubjectDN().getName() + "\": " + e.getMessage());
        }
    }
}

