/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import com.ibm.j9.bluez.crypto.CL3;
import com.ibm.j9.bluez.crypto.RSACipher;
import com.ibm.oti.security.provider.RSAPrivateCrtKey;
import com.ibm.oti.security.provider.RSAPublicKey;
import com.ibm.oti.util.Msg;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;

public class KeyPairGeneratorRSA
extends KeyPairGenerator {
    private int keySize = 512;
    private SecureRandom random = new SecureRandom();
    private BigInteger publicExponent = RSAKeyGenParameterSpec.F4;

    public KeyPairGeneratorRSA() {
        super("RSA");
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidParameterException {
        if (params == null) {
            throw new InvalidParameterException();
        }
        this.keySize = ((RSAKeyGenParameterSpec)params).getKeysize();
        this.publicExponent = ((RSAKeyGenParameterSpec)params).getPublicExponent();
        if (this.publicExponent == null) {
            this.publicExponent = RSAKeyGenParameterSpec.F4;
        }
        this.random = random;
        this.validate();
    }

    public void initialize(int keySize, SecureRandom random) throws InvalidParameterException {
        this.random = random;
        this.keySize = keySize;
        this.publicExponent = RSAKeyGenParameterSpec.F4;
        this.validate();
    }

    private void validate() throws InvalidParameterException {
        if (this.keySize % 8 != 0) {
            throw new InvalidParameterException(Msg.getString("K01ec"));
        }
        if (this.keySize < 512) {
            throw new InvalidParameterException(Msg.getString("K01ed"));
        }
    }

    public KeyPair generateKeyPair() {
        CL3 rsaKeyPair = RSACipher.rsaKeyGen(this.keySize, this.publicExponent.toByteArray(), this.random);
        byte[][] rsaKeyMaterial = RSACipher.exportRSAKeyMaterial(rsaKeyPair);
        BigInteger p = new BigInteger(rsaKeyMaterial[0]);
        BigInteger q = new BigInteger(rsaKeyMaterial[1]);
        BigInteger n = p.multiply(q);
        if (p.compareTo(q) < 0) {
            BigInteger temp = p;
            p = q;
            q = temp;
        }
        BigInteger pMinusOne = p.subtract(BigInteger.ONE);
        BigInteger qMinusOne = q.subtract(BigInteger.ONE);
        BigInteger m = pMinusOne.multiply(qMinusOne);
        BigInteger e = this.publicExponent;
        BigInteger d = e.modInverse(m);
        BigInteger dP = d.remainder(pMinusOne);
        BigInteger dQ = d.remainder(qMinusOne);
        BigInteger qInv = q.modInverse(p);
        RSAPrivateCrtKey privateKey = new RSAPrivateCrtKey(n, e, d, p, q, dP, dQ, qInv);
        RSAPublicKey publicKey = new RSAPublicKey(n, e);
        return new KeyPair(publicKey, privateKey);
    }
}

