/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.util;

import java.io.OutputStream;

public class SHAOutputStream
extends OutputStream
implements Cloneable {
    private int[] HConstants;
    private int[] WArray;
    private byte[] MArray;
    private long bytesProcessed;
    private int bytesToProcess;
    private byte[] oneByte = new byte[1];
    private static final int K0_19 = 1518500249;
    private static final int K20_39 = 1859775393;
    private static final int K40_59 = -1894007588;
    private static final int K60_79 = -899497514;
    private static final int H0 = 1732584193;
    private static final int H1 = -271733879;
    private static final int H2 = -1732584194;
    private static final int H3 = 271733878;
    private static final int H4 = -1009589776;
    private static final int HConstantsSize = 5;
    private static final int HashSizeInBytes = 20;
    private static final int BlockSizeInBytes = 64;
    private static final int WArraySize = 80;

    public SHAOutputStream() {
        this.initialize();
        this.reset();
    }

    public SHAOutputStream(byte[] state) {
        this();
        if (state.length < 20) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < 4) {
            this.HConstants[i] = 0;
            int j = 0;
            while (j < 4) {
                int n = i;
                this.HConstants[n] = this.HConstants[n] + ((state[4 * i + j] & 0xFF) << 8 * (3 - j));
                ++j;
            }
            ++i;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SHAOutputStream result = (SHAOutputStream)super.clone();
        result.HConstants = (int[])this.HConstants.clone();
        result.WArray = (int[])this.WArray.clone();
        result.MArray = (byte[])this.MArray.clone();
        result.oneByte = (byte[])this.oneByte.clone();
        return result;
    }

    private void copyToInternalBuffer(byte[] buffer, int off, int len) {
        int index = off;
        int i = this.bytesToProcess;
        while (i < this.bytesToProcess + len) {
            this.MArray[i] = buffer[index];
            ++index;
            ++i;
        }
        this.bytesToProcess += len;
    }

    public int[] getHash() {
        this.padBuffer();
        this.processBuffer();
        int[] result = (int[])this.HConstants.clone();
        this.reset();
        return result;
    }

    public byte[] getHashAsBytes() {
        byte[] hash = new byte[20];
        this.padBuffer();
        this.processBuffer();
        int i = 0;
        while (i < 5) {
            hash[i * 4] = (byte)(this.HConstants[i] >>> 24 & 0xFF);
            hash[i * 4 + 1] = (byte)(this.HConstants[i] >>> 16 & 0xFF);
            hash[i * 4 + 2] = (byte)(this.HConstants[i] >>> 8 & 0xFF);
            hash[i * 4 + 3] = (byte)(this.HConstants[i] & 0xFF);
            ++i;
        }
        this.reset();
        return hash;
    }

    public byte[] getHashAsBytes(boolean pad) {
        byte[] hash = new byte[20];
        if (pad) {
            this.padBuffer();
            this.processBuffer();
        }
        int i = 0;
        while (i < 5) {
            hash[i * 4] = (byte)(this.HConstants[i] >>> 24 & 0xFF);
            hash[i * 4 + 1] = (byte)(this.HConstants[i] >>> 16 & 0xFF);
            hash[i * 4 + 2] = (byte)(this.HConstants[i] >>> 8 & 0xFF);
            hash[i * 4 + 3] = (byte)(this.HConstants[i] & 0xFF);
            ++i;
        }
        this.reset();
        return hash;
    }

    private void initialize() {
        this.HConstants = new int[5];
        this.MArray = new byte[64];
        this.WArray = new int[80];
    }

    private void padBuffer() {
        this.MArray[this.bytesToProcess] = -128;
        int i = this.bytesToProcess + 1;
        while (i < 64) {
            this.MArray[i] = 0;
            ++i;
        }
        long lengthInBits = ((long)this.bytesToProcess + this.bytesProcessed) * 8L;
        if (this.bytesToProcess + 9 > 64) {
            this.processBuffer();
            i = 0;
            while (i < 64) {
                this.MArray[i] = 0;
                ++i;
            }
        }
        i = 1;
        while (i < 9) {
            this.MArray[64 - i] = (byte)(lengthInBits & 0xFFL);
            lengthInBits >>>= 8;
            ++i;
        }
    }

    private void processBuffer() {
        int temp;
        int t = 0;
        while (t <= 15) {
            this.WArray[t] = (this.MArray[4 * t] & 0xFF) << 24 | (this.MArray[4 * t + 1] & 0xFF) << 16 | (this.MArray[4 * t + 2] & 0xFF) << 8 | this.MArray[4 * t + 3] & 0xFF;
            ++t;
        }
        t = 16;
        while (t <= 79) {
            temp = this.WArray[t - 3] ^ this.WArray[t - 8] ^ this.WArray[t - 14] ^ this.WArray[t - 16];
            this.WArray[t] = temp = temp << 1 | temp >>> 31;
            ++t;
        }
        int A = this.HConstants[0];
        int B = this.HConstants[1];
        int C = this.HConstants[2];
        int D = this.HConstants[3];
        int E = this.HConstants[4];
        t = 0;
        while (t <= 19) {
            temp = A << 5 | A >>> 27;
            temp = temp + E + this.WArray[t] + 1518500249;
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = temp += B & C | ~B & D;
            ++t;
        }
        t = 20;
        while (t <= 39) {
            temp = A << 5 | A >>> 27;
            temp = temp + E + this.WArray[t] + 1859775393;
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = temp += B ^ C ^ D;
            ++t;
        }
        t = 40;
        while (t <= 59) {
            temp = A << 5 | A >>> 27;
            temp = temp + E + this.WArray[t] + -1894007588;
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = temp += B & C | B & D | C & D;
            ++t;
        }
        t = 60;
        while (t <= 79) {
            temp = A << 5 | A >>> 27;
            temp = temp + E + this.WArray[t] + -899497514;
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = temp += B ^ C ^ D;
            ++t;
        }
        this.HConstants[0] = this.HConstants[0] + A;
        this.HConstants[1] = this.HConstants[1] + B;
        this.HConstants[2] = this.HConstants[2] + C;
        this.HConstants[3] = this.HConstants[3] + D;
        this.HConstants[4] = this.HConstants[4] + E;
        this.bytesProcessed += 64L;
        this.bytesToProcess = 0;
    }

    public void reset() {
        this.HConstants[0] = 1732584193;
        this.HConstants[1] = -271733879;
        this.HConstants[2] = -1732584194;
        this.HConstants[3] = 271733878;
        this.HConstants[4] = -1009589776;
        this.bytesProcessed = 0L;
        this.bytesToProcess = 0;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ':' + SHAOutputStream.toStringBlock(this.getHashAsBytes());
    }

    private static String toStringBlock(byte[] block) {
        return SHAOutputStream.toStringBlock(block, 0, block.length);
    }

    private static String toStringBlock(byte[] block, int off, int len) {
        String hexdigits = "0123456789ABCDEF";
        StringBuffer buf = new StringBuffer();
        int i = off;
        while (i < off + len) {
            buf.append(hexdigits.charAt(block[i] >>> 4 & 0xF));
            buf.append(hexdigits.charAt(block[i] & 0xF));
            ++i;
        }
        return "[" + buf + "]";
    }

    public void write(byte[] buffer, int off, int len) {
        int spaceLeft = 64 - this.bytesToProcess;
        if (len < spaceLeft) {
            this.copyToInternalBuffer(buffer, off, len);
            return;
        }
        this.copyToInternalBuffer(buffer, off, spaceLeft);
        int bytesLeft = len - spaceLeft;
        this.processBuffer();
        int start = off + spaceLeft;
        while (bytesLeft >= 64) {
            this.copyToInternalBuffer(buffer, start, 64);
            bytesLeft -= 64;
            this.processBuffer();
            start += 64;
        }
        if (bytesLeft > 0) {
            this.copyToInternalBuffer(buffer, start, bytesLeft);
        }
    }

    public void write(int b) {
        this.oneByte[0] = (byte)b;
        this.write(this.oneByte, 0, 1);
    }
}

