/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileInputStream
extends InputStream {
    FileDescriptor fd;

    static {
        FileInputStream.oneTimeInitialization();
    }

    private static native void oneTimeInitialization();

    public FileInputStream(File file) throws FileNotFoundException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(file.getPath());
        }
        this.fd = new FileDescriptor();
        if (this.openImpl(file.properPath(true)) != 0) {
            throw new FileNotFoundException(file.getPath());
        }
    }

    public FileInputStream(FileDescriptor fd) {
        if (fd != null) {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkRead(fd);
            }
        } else {
            throw new NullPointerException();
        }
        this.fd = fd;
    }

    public FileInputStream(String fileName) throws FileNotFoundException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(fileName);
        }
        this.fd = new FileDescriptor();
        if (this.openImpl(new File(fileName).properPath(true)) != 0) {
            throw new FileNotFoundException(fileName);
        }
    }

    public native int available() throws IOException;

    public void close() throws IOException {
        this.closeImpl();
    }

    private native void closeImpl() throws IOException;

    protected void finalize() throws IOException {
        if (this.fd != null) {
            this.close();
        }
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    private native int openImpl(byte[] var1);

    public int read() throws IOException {
        if (this.fd != null) {
            return this.readByteImpl(this.getFD().descriptor);
        }
        throw new IOException();
    }

    private native int readByteImpl(long var1) throws IOException;

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int offset, int count) throws IOException {
        if (this.fd != null) {
            return this.readImpl(buffer, offset, count, this.getFD().descriptor);
        }
        throw new IOException();
    }

    private native int readImpl(byte[] var1, int var2, int var3, long var4) throws IOException;

    public native long skip(long var1) throws IOException;
}

