/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;

public class FileOutputStream
extends OutputStream {
    FileDescriptor fd;

    static {
        FileOutputStream.oneTimeInitialization();
    }

    private static native void oneTimeInitialization();

    public FileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    public FileOutputStream(File file, boolean append) throws FileNotFoundException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(file.getPath());
        }
        this.fd = new FileDescriptor();
        if (this.openImpl(file.properPath(true), append) != 0) {
            throw new FileNotFoundException(file.getPath());
        }
    }

    public FileOutputStream(FileDescriptor fd) {
        if (fd != null) {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkWrite(fd);
            }
        } else {
            throw new NullPointerException(Msg.getString("K006c"));
        }
        this.fd = fd;
    }

    public FileOutputStream(String filename) throws FileNotFoundException {
        this(filename, false);
    }

    public FileOutputStream(String filename, boolean append) throws FileNotFoundException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(filename);
        }
        this.fd = new FileDescriptor();
        File f = new File(filename);
        if (this.openImpl(f.properPath(true), append) != 0) {
            throw new FileNotFoundException(filename);
        }
    }

    public void close() throws IOException {
        this.closeImpl();
    }

    private native void closeImpl() throws IOException;

    protected void finalize() throws IOException {
        if (this.fd != null) {
            this.close();
        }
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    private native int openImpl(byte[] var1, boolean var2);

    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    public void write(byte[] buffer, int offset, int count) throws IOException {
        if (this.fd == null) {
            throw new IOException();
        }
        this.writeImpl(buffer, offset, count, this.getFD().descriptor);
    }

    private native void writeImpl(byte[] var1, int var2, int var3, long var4) throws IOException;

    public void write(int oneByte) throws IOException {
        if (this.fd == null) {
            throw new IOException();
        }
        this.writeByteImpl(oneByte, this.getFD().descriptor);
    }

    private native void writeByteImpl(int var1, long var2) throws IOException;
}

