/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.ibm.oti.util.PriviAction;
import java.net.NegCacheElement;
import java.security.AccessController;
import java.util.LinkedHashMap;
import java.util.Map;

class NegativeCache
extends LinkedHashMap {
    static NegativeCache negCache = null;
    static final int MAX_NEGATIVE_ENTRIES = 5;
    static final float LOADING = 0.75f;

    NegativeCache(int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor, accessOrder);
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        return this.size() > 5;
    }

    static void put(String hostName, String failedMessage) {
        NegativeCache.checkCacheExists();
        negCache.put(hostName, new NegCacheElement(failedMessage));
    }

    static String getFailedMessage(String hostName) {
        NegativeCache.checkCacheExists();
        NegCacheElement element = (NegCacheElement)negCache.get(hostName);
        if (element != null) {
            String ttlValue = (String)AccessController.doPrivileged(new PriviAction("networkaddress.cache.negative.ttl"));
            int ttl = 10;
            try {
                if (ttlValue != null) {
                    ttl = Integer.decode(ttlValue);
                }
            }
            catch (NumberFormatException numberFormatException) {}
            if (ttl == 0) {
                negCache.clear();
                element = null;
            } else if (ttl != -1 && element.timeAdded + (long)(ttl * 1000) < System.currentTimeMillis()) {
                negCache.remove(hostName);
                element = null;
            }
        }
        if (element != null) {
            return element.hostName();
        }
        return null;
    }

    static void checkCacheExists() {
        if (negCache == null) {
            negCache = new NegativeCache(6, 0.75f, true);
        }
    }
}

