/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.oti.util.Msg;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;

public final class AccessController {
    static {
        AccessController.initializeInternal();
    }

    private static native void initializeInternal();

    private AccessController() {
    }

    private static native Object[] getProtectionDomains(int var0);

    public static void checkPermission(Permission perm) throws AccessControlException {
        if (perm == null) {
            throw new NullPointerException();
        }
        if ((AccessControlContext.debugSetting() & 2) != 0) {
            new Exception("Stack trace").printStackTrace();
        }
        Object[] domains = AccessController.getProtectionDomains(1);
        AccessControlContext acc = (AccessControlContext)domains[0];
        ProtectionDomain[] pDomains = null;
        if (acc != null && acc.domainCombiner != null) {
            if ((AccessControlContext.debugSetting() & 1) != 0) {
                AccessControlContext.debugPrintAccess();
                System.err.println("AccessController invoking the Combiner");
            }
            pDomains = acc.domainCombiner.combine(AccessController.toArrayOfProtectionDomains(domains, null), acc.domainsArray);
        } else {
            pDomains = AccessController.toArrayOfProtectionDomains(domains, acc);
        }
        if ((AccessControlContext.debugSetting() & 4) != 0) {
            AccessControlContext.debugPrintAccess();
            if (pDomains.length == 0) {
                System.err.println("domain (context is null)");
            }
        }
        int i = 0;
        int length = pDomains.length;
        while (i < length) {
            if (!pDomains[i].implies(perm)) {
                if ((AccessControlContext.debugSetting() & 1) != 0) {
                    AccessControlContext.debugPrintAccess();
                    System.err.println("access denied " + perm);
                }
                if ((AccessControlContext.debugSetting() & 8) != 0) {
                    new Exception("Stack trace").printStackTrace();
                    System.err.println("domain that failed " + pDomains[i]);
                }
                throw new AccessControlException(Msg.getString("K002c", perm), perm);
            }
            ++i;
        }
        if ((AccessControlContext.debugSetting() & 1) != 0) {
            AccessControlContext.debugPrintAccess();
            System.err.println("access allowed " + perm);
        }
    }

    private static void keepalive(AccessControlContext context) {
    }

    public static AccessControlContext getContext() {
        Object[] domains = AccessController.getProtectionDomains(1);
        AccessControlContext acc = (AccessControlContext)domains[0];
        ProtectionDomain[] pDomains = null;
        if (acc != null && acc.domainCombiner != null) {
            pDomains = acc.domainCombiner.combine(AccessController.toArrayOfProtectionDomains(domains, null), acc.domainsArray);
            AccessControlContext result = new AccessControlContext(pDomains, false);
            result.domainCombiner = acc.domainCombiner;
            return result;
        }
        return new AccessControlContext(AccessController.toArrayOfProtectionDomains(domains, acc), false);
    }

    private static ProtectionDomain[] toArrayOfProtectionDomains(Object[] domains, AccessControlContext acc) {
        int len = 0;
        int size = domains.length - 1;
        int extra = acc == null ? 0 : acc.domainsArray.length;
        ProtectionDomain[] answer = new ProtectionDomain[size + extra];
        int i = 1;
        while (i <= size) {
            boolean found = false;
            answer[len] = (ProtectionDomain)domains[i];
            if (answer[len] == null) break;
            if (acc != null) {
                int j = 0;
                while (j < acc.domainsArray.length) {
                    if (answer[len] == acc.domainsArray[j]) {
                        found = true;
                        break;
                    }
                    ++j;
                }
            }
            if (!found) {
                ++len;
            }
            ++i;
        }
        if (len == 0 && acc != null) {
            return acc.domainsArray;
        }
        if (len < size) {
            ProtectionDomain[] copy = new ProtectionDomain[len + extra];
            System.arraycopy((Object)answer, 0, (Object)copy, 0, len);
            answer = copy;
        }
        if (acc != null) {
            System.arraycopy((Object)acc.domainsArray, 0, (Object)answer, len, acc.domainsArray.length);
        }
        return answer;
    }

    public static Object doPrivileged(PrivilegedAction action) {
        return action.run();
    }

    public static Object doPrivileged(PrivilegedAction action, AccessControlContext context) {
        Object result = action.run();
        AccessController.keepalive(context);
        return result;
    }

    public static Object doPrivileged(PrivilegedExceptionAction action) throws PrivilegedActionException {
        try {
            return action.run();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PrivilegedActionException(ex);
        }
    }

    public static Object doPrivileged(PrivilegedExceptionAction action, AccessControlContext context) throws PrivilegedActionException {
        try {
            Object result = action.run();
            AccessController.keepalive(context);
            return result;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PrivilegedActionException(ex);
        }
    }
}

