/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;

class BasicPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = 739301742472979399L;
    boolean all_allowed = false;
    Hashtable permissions = new Hashtable(8);

    public void add(Permission perm) {
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        String name = perm.getName();
        this.all_allowed = this.all_allowed || name.equals("*");
        this.permissions.put(name, perm);
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }

    public boolean implies(Permission perm) {
        if (this.all_allowed) {
            return true;
        }
        String name = perm.getName();
        if (this.permissions.get(name) != null) {
            return true;
        }
        int i = name.lastIndexOf(46);
        while (i >= 0) {
            if (i + 1 == name.length()) {
                return false;
            }
            if (this.permissions.get(String.valueOf(name = name.substring(0, i)) + ".*") != null) {
                return true;
            }
            i = name.lastIndexOf(46);
        }
        return false;
    }
}

