/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.oti.util.PriviAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;

public class KeyStore {
    private static final String KEY_PREFIX = "KeyStore.";
    private String type;
    private Provider provider;
    private KeyStoreSpi keyStoreSpi;
    private boolean loaded = false;

    protected KeyStore(KeyStoreSpi keyStoreSpi, Provider provider, String type) {
        this.setProvider(provider);
        this.setType(type);
        this.keyStoreSpi = keyStoreSpi;
    }

    public final Enumeration aliases() throws KeyStoreException {
        if (!this.loaded) {
            throw new KeyStoreException();
        }
        return this.keyStoreSpi.engineAliases();
    }

    public final boolean containsAlias(String alias) throws KeyStoreException {
        if (!this.loaded) {
            throw new KeyStoreException();
        }
        return this.keyStoreSpi.engineContainsAlias(alias);
    }

    private static KeyStore createKeyStore(Provider provider, Class keyStoreClass, String type) throws KeyStoreException {
        try {
            KeyStoreSpi providedKeyStore = (KeyStoreSpi)keyStoreClass.newInstance();
            return new KeyStore(providedKeyStore, provider, type);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {}
        throw new KeyStoreException(type);
    }

    public final void deleteEntry(String alias) throws KeyStoreException {
        if (!this.loaded) {
            throw new KeyStoreException();
        }
        this.keyStoreSpi.engineDeleteEntry(alias);
    }

    public final Certificate getCertificate(String alias) throws KeyStoreException {
        if (!this.loaded) {
            throw new KeyStoreException();
        }
        return this.keyStoreSpi.engineGetCertificate(alias);
    }

    public final String getCertificateAlias(Certificate cert) throws KeyStoreException {
        if (!this.loaded) {
            throw new KeyStoreException();
        }
        return this.keyStoreSpi.engineGetCertificateAlias(cert);
    }

    public final Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        if (!this.loaded) {
            throw new KeyStoreException();
        }
        return this.keyStoreSpi.engineGetCertificateChain(alias);
    }

    public final Date getCreationDate(String alias) throws KeyStoreException {
        if (!this.loaded) {
            throw new KeyStoreException();
        }
        return this.keyStoreSpi.engineGetCreationDate(alias);
    }

    public static KeyStore getInstance(String type) throws KeyStoreException {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return KeyStore.toKeyStoreImplementation(type);
    }

    public static KeyStore getInstance(String type, String providerName) throws KeyStoreException, NoSuchProviderException {
        if (providerName == null) {
            throw new IllegalArgumentException();
        }
        if (type == null) {
            throw new IllegalArgumentException();
        }
        Provider provider = Security.getProvider(providerName);
        if (provider == null) {
            throw new NoSuchProviderException(providerName);
        }
        return KeyStore.toKeyStoreImplementation(type, provider);
    }

    public static KeyStore getInstance(String type, Provider provider) throws KeyStoreException {
        if (type == null || provider == null) {
            throw new IllegalArgumentException();
        }
        return KeyStore.toKeyStoreImplementation(type, provider);
    }

    public final Key getKey(String alias, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (!this.loaded) {
            throw new KeyStoreException();
        }
        return this.keyStoreSpi.engineGetKey(alias, password);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getType() {
        return this.type;
    }

    public final boolean isCertificateEntry(String alias) throws KeyStoreException {
        if (!this.loaded) {
            throw new KeyStoreException();
        }
        return this.keyStoreSpi.engineIsCertificateEntry(alias);
    }

    public final boolean isKeyEntry(String alias) throws KeyStoreException {
        if (!this.loaded) {
            throw new KeyStoreException();
        }
        return this.keyStoreSpi.engineIsKeyEntry(alias);
    }

    public final void load(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStoreSpi.engineLoad(stream, password);
        this.loaded = true;
    }

    public final void setCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        if (!this.loaded) {
            throw new KeyStoreException();
        }
        this.keyStoreSpi.engineSetCertificateEntry(alias, cert);
    }

    public final void setKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        if (!this.loaded) {
            throw new KeyStoreException();
        }
        this.keyStoreSpi.engineSetKeyEntry(alias, key, chain);
    }

    public final void setKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (!this.loaded) {
            throw new KeyStoreException();
        }
        this.keyStoreSpi.engineSetKeyEntry(alias, key, password, chain);
    }

    void setProvider(Provider provider) {
        this.provider = provider;
    }

    void setType(String type) {
        this.type = type;
    }

    public final int size() throws KeyStoreException {
        if (!this.loaded) {
            throw new KeyStoreException();
        }
        return this.keyStoreSpi.engineSize();
    }

    public final void store(OutputStream stream, char[] password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (!this.loaded) {
            throw new KeyStoreException();
        }
        this.keyStoreSpi.engineStore(stream, password);
    }

    private static KeyStore toKeyStoreImplementation(String type) throws KeyStoreException {
        Provider[] providers = Security.getProviders();
        int i = 0;
        while (i < providers.length) {
            Provider provider = providers[i];
            try {
                return KeyStore.toKeyStoreImplementation(type, provider);
            }
            catch (KeyStoreException keyStoreException) {
                ++i;
            }
        }
        throw new KeyStoreException(type);
    }

    private static KeyStore toKeyStoreImplementation(String type, Provider provider) throws KeyStoreException {
        String keyStoreClassName;
        try {
            keyStoreClassName = provider.lookupProperty(KEY_PREFIX, type);
        }
        catch (ClassCastException classCastException) {
            throw new KeyStoreException(type);
        }
        if (keyStoreClassName == null) {
            throw new KeyStoreException(type);
        }
        try {
            Class keyStoreClass = Class.forName(keyStoreClassName, true, provider.getClass().getClassLoader());
            return KeyStore.createKeyStore(provider, keyStoreClass, type);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new KeyStoreException(type);
        }
    }

    public static final String getDefaultType() {
        String result = (String)AccessController.doPrivileged(PriviAction.getSecurityProperty("keystore.type"));
        if (result == null) {
            return "jks";
        }
        return result;
    }
}

