/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.ByteArrayInputStream;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.zip.CRC32;

public abstract class Certificate
implements Serializable {
    private static final long serialVersionUID = -6751606818319535583L;
    private String type;

    protected Certificate(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        Certificate c = null;
        try {
            c = (Certificate)o;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        try {
            return Arrays.equals(this.getEncoded(), c.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return false;
        }
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract PublicKey getPublicKey();

    public final String getType() {
        return this.type;
    }

    public int hashCode() {
        try {
            CRC32 hash = new CRC32();
            hash.update(this.getEncoded());
            return (int)hash.getValue();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return super.hashCode();
        }
    }

    public abstract String toString();

    public abstract void verify(PublicKey var1) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    protected Object writeReplace() throws ObjectStreamException {
        byte[] encoded = null;
        try {
            encoded = this.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new NotSerializableException(e.toString());
        }
        return new CertificateRep(this.type, encoded);
    }

    protected static class CertificateRep
    implements Serializable {
        static final long serialVersionUID = -8563758940495660020L;
        String type;
        byte[] data;

        protected CertificateRep(String type, byte[] encoded) {
            this.type = type;
            this.data = encoded;
        }

        protected Object readResolve() throws ObjectStreamException {
            try {
                CertificateFactory factory = CertificateFactory.getInstance(this.type);
                Certificate certificate = factory.generateCertificate(new ByteArrayInputStream(this.data));
                return certificate;
            }
            catch (CertificateException e) {
                throw new InvalidObjectException(e.toString());
            }
        }
    }
}

