/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509Extension;
import java.util.Arrays;
import java.util.Date;

public abstract class X509CRLEntry
implements X509Extension {
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof X509CRLEntry)) {
            return false;
        }
        X509CRLEntry param = (X509CRLEntry)o;
        try {
            return Arrays.equals(this.getEncoded(), param.getEncoded());
        }
        catch (CRLException cRLException) {
            return false;
        }
    }

    public abstract byte[] getEncoded() throws CRLException;

    public abstract BigInteger getSerialNumber();

    public abstract Date getRevocationDate();

    public abstract boolean hasExtensions();

    public int hashCode() {
        try {
            byte[] encoded = this.getEncoded();
            int hash = 1;
            int i = 0;
            while (i < encoded.length) {
                hash *= encoded[i] & 0xFF;
                ++i;
            }
            return hash;
        }
        catch (CRLException cRLException) {
            return 0;
        }
    }

    public abstract String toString();
}

