/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.ibm.oti.util.Msg;
import java.text.ParseException;
import java.text.PatternEntry;
import java.util.ArrayList;

final class MergeCollation {
    ArrayList patterns = new ArrayList();
    private transient PatternEntry saveEntry = null;
    private transient PatternEntry lastEntry = null;
    private transient StringBuffer excess = new StringBuffer();
    private transient byte[] statusArray = new byte[8192];
    private final byte BITARRAYMASK = 1;
    private final int BYTEPOWER = 3;
    private final int BYTEMASK = 7;

    public MergeCollation(String pattern) throws ParseException {
        int i = 0;
        while (i < this.statusArray.length) {
            this.statusArray[i] = 0;
            ++i;
        }
        this.setPattern(pattern);
    }

    public String getPattern() {
        return this.getPattern(true);
    }

    public String getPattern(boolean withWhiteSpace) {
        StringBuffer result = new StringBuffer();
        PatternEntry tmp = null;
        ArrayList extList = null;
        int i = 0;
        while (i < this.patterns.size()) {
            PatternEntry entry = (PatternEntry)this.patterns.get(i);
            if (entry.extension.length() != 0) {
                if (extList == null) {
                    extList = new ArrayList();
                }
                extList.add(entry);
            } else {
                if (extList != null) {
                    PatternEntry last = this.findLastWithNoExtension(i - 1);
                    int j = extList.size() - 1;
                    while (j >= 0) {
                        tmp = (PatternEntry)extList.get(j);
                        tmp.addToBuffer(result, false, withWhiteSpace, last);
                        --j;
                    }
                    extList = null;
                }
                entry.addToBuffer(result, false, withWhiteSpace, null);
            }
            ++i;
        }
        if (extList != null) {
            PatternEntry last = this.findLastWithNoExtension(i - 1);
            int j = extList.size() - 1;
            while (j >= 0) {
                tmp = (PatternEntry)extList.get(j);
                tmp.addToBuffer(result, false, withWhiteSpace, last);
                --j;
            }
            extList = null;
        }
        return result.toString();
    }

    private final PatternEntry findLastWithNoExtension(int i) {
        --i;
        while (i >= 0) {
            PatternEntry entry = (PatternEntry)this.patterns.get(i);
            if (entry.extension.length() == 0) {
                return entry;
            }
            --i;
        }
        return null;
    }

    public String emitPattern() {
        return this.emitPattern(true);
    }

    public String emitPattern(boolean withWhiteSpace) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.patterns.size()) {
            PatternEntry entry = (PatternEntry)this.patterns.get(i);
            if (entry != null) {
                entry.addToBuffer(result, true, withWhiteSpace, null);
            }
            ++i;
        }
        return result.toString();
    }

    public void setPattern(String pattern) throws ParseException {
        this.patterns.clear();
        this.addPattern(pattern);
    }

    public void addPattern(String pattern) throws ParseException {
        if (pattern == null) {
            return;
        }
        PatternEntry.Parser parser = new PatternEntry.Parser(pattern);
        PatternEntry entry = parser.next();
        while (entry != null) {
            this.fixEntry(entry);
            entry = parser.next();
        }
    }

    public int getCount() {
        return this.patterns.size();
    }

    public PatternEntry getItemAt(int index) {
        return (PatternEntry)this.patterns.get(index);
    }

    private final void fixEntry(PatternEntry newEntry) throws ParseException {
        if (this.lastEntry != null && newEntry.chars.equals(this.lastEntry.chars) && newEntry.extension.equals(this.lastEntry.extension)) {
            if (newEntry.strength != 3 && newEntry.strength != -2) {
                throw new ParseException(Msg.getString("K01ac", this.lastEntry, newEntry), -1);
            }
            return;
        }
        boolean changeLastEntry = true;
        if (newEntry.strength != -2) {
            int oldIndex = -1;
            if (newEntry.chars.length() == 1) {
                char c = newEntry.chars.charAt(0);
                int statusIndex = c >> 3;
                byte bitClump = this.statusArray[statusIndex];
                byte setBit = (byte)(1 << (c & 7));
                if (bitClump != 0 && (bitClump & setBit) != 0) {
                    oldIndex = this.patterns.lastIndexOf(newEntry);
                } else {
                    this.statusArray[statusIndex] = (byte)(bitClump | setBit);
                }
            } else {
                oldIndex = this.patterns.lastIndexOf(newEntry);
            }
            if (oldIndex != -1) {
                this.patterns.remove(oldIndex);
            }
            this.excess.setLength(0);
            int lastIndex = this.findLastEntry(this.lastEntry, this.excess);
            if (this.excess.length() != 0) {
                newEntry.extension = this.excess + newEntry.extension;
                if (lastIndex != this.patterns.size()) {
                    this.lastEntry = this.saveEntry;
                    changeLastEntry = false;
                }
            }
            if (lastIndex == this.patterns.size()) {
                this.patterns.add(newEntry);
                this.saveEntry = newEntry;
            } else {
                this.patterns.add(lastIndex, newEntry);
            }
        }
        if (changeLastEntry) {
            this.lastEntry = newEntry;
        }
    }

    private final int findLastEntry(PatternEntry entry, StringBuffer excessChars) throws ParseException {
        if (entry == null) {
            return 0;
        }
        if (entry.strength != -2) {
            int oldIndex = -1;
            if (entry.chars.length() == 1) {
                int index = entry.chars.charAt(0) >> 3;
                if ((this.statusArray[index] & 1 << (entry.chars.charAt(0) & 7)) != 0) {
                    oldIndex = this.patterns.lastIndexOf(entry);
                }
            } else {
                oldIndex = this.patterns.lastIndexOf(entry);
            }
            if (oldIndex == -1) {
                throw new ParseException(Msg.getString("K01aa", entry), oldIndex);
            }
            return oldIndex + 1;
        }
        int i = this.patterns.size() - 1;
        while (i >= 0) {
            PatternEntry e = (PatternEntry)this.patterns.get(i);
            if (e.chars.regionMatches(0, entry.chars, 0, e.chars.length())) {
                excessChars.append(entry.chars.substring(e.chars.length(), entry.chars.length()));
                break;
            }
            --i;
        }
        if (i == -1) {
            throw new ParseException(Msg.getString("K01ab", entry), i);
        }
        return i + 1;
    }
}

