/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.ibm.oti.text.CompactByteArray;
import com.ibm.oti.util.Msg;
import java.text.BreakIterator;
import java.text.CharSet;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

class RuleBasedBreakIterator
extends BreakIterator {
    protected static final byte IGNORE = -1;
    private static final short START_STATE = 1;
    private static final short STOP_STATE = 0;
    private String description;
    private CompactByteArray charCategoryTable = null;
    private short[] stateTable = null;
    private short[] backwardsStateTable = null;
    private boolean[] endStates = null;
    private boolean[] lookaheadStates = null;
    private int numCategories;
    private CharacterIterator text = null;

    public RuleBasedBreakIterator(String description) {
        this.description = description;
        Builder builder = this.makeBuilder();
        builder.buildBreakIterator();
    }

    protected Builder makeBuilder() {
        return new Builder();
    }

    public Object clone() {
        RuleBasedBreakIterator result = (RuleBasedBreakIterator)super.clone();
        if (this.text != null) {
            result.text = (CharacterIterator)this.text.clone();
        }
        return result;
    }

    public boolean equals(Object that) {
        try {
            RuleBasedBreakIterator other = (RuleBasedBreakIterator)that;
            if (!this.description.equals(other.description)) {
                return false;
            }
            if (this.text == null) {
                return other.text == null;
            }
            return this.text.equals(other.text);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String toString() {
        return this.description;
    }

    public int hashCode() {
        return this.description.hashCode();
    }

    public int first() {
        CharacterIterator t = this.getText();
        t.first();
        return t.getIndex();
    }

    public int last() {
        CharacterIterator t = this.getText();
        t.setIndex(t.getEndIndex());
        return t.getIndex();
    }

    public int next(int n) {
        int result = this.current();
        while (n > 0) {
            result = this.handleNext();
            --n;
        }
        while (n < 0) {
            result = this.previous();
            ++n;
        }
        return result;
    }

    public int next() {
        return this.handleNext();
    }

    public int previous() {
        int lastResult;
        CharacterIterator text = this.getText();
        if (this.current() == text.getBeginIndex()) {
            return -1;
        }
        int start = this.current();
        text.previous();
        int result = lastResult = this.handlePrevious();
        while (result != -1 && result < start) {
            lastResult = result;
            result = this.handleNext();
        }
        text.setIndex(lastResult);
        return lastResult;
    }

    protected static final void checkOffset(int offset, CharacterIterator text) {
        if (offset < text.getBeginIndex() || offset >= text.getEndIndex()) {
            throw new IllegalArgumentException(Msg.getString("K002e"));
        }
    }

    public int following(int offset) {
        CharacterIterator text = this.getText();
        RuleBasedBreakIterator.checkOffset(offset, text);
        text.setIndex(offset);
        if (offset == text.getBeginIndex()) {
            return this.handleNext();
        }
        int result = this.handlePrevious();
        while (result != -1 && result <= offset) {
            result = this.handleNext();
        }
        return result;
    }

    public int preceding(int offset) {
        CharacterIterator text = this.getText();
        RuleBasedBreakIterator.checkOffset(offset, text);
        text.setIndex(offset);
        return this.previous();
    }

    public boolean isBoundary(int offset) {
        CharacterIterator text = this.getText();
        RuleBasedBreakIterator.checkOffset(offset, text);
        if (offset == text.getBeginIndex()) {
            return true;
        }
        return this.following(offset - 1) == offset;
    }

    public int current() {
        return this.getText().getIndex();
    }

    public CharacterIterator getText() {
        if (this.text == null) {
            this.text = new StringCharacterIterator("");
        }
        return this.text;
    }

    public void setText(CharacterIterator newText) {
        boolean goodIterator;
        int end = newText.getEndIndex();
        try {
            newText.setIndex(end);
            goodIterator = newText.getIndex() == end;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            goodIterator = false;
        }
        this.text = goodIterator ? newText : new SafeCharIterator(newText);
        this.text.first();
    }

    /*
     * Unable to fully structure code
     */
    protected int handleNext() {
        text = this.getText();
        if (text.getIndex() == text.getEndIndex()) {
            return -1;
        }
        result = text.getIndex() + 1;
        lookaheadResult = 0;
        state = 1;
        lastC = c = text.current();
        lastCPos = 0;
        if (this.lookupCategory(c) != -1) ** GOTO lbl30
        while (this.lookupCategory(c) == -1) {
            c = text.next();
        }
        if (Character.getType(c) != 6 && Character.getType(c) != 7) ** GOTO lbl30
        return text.getIndex();
lbl-1000:
        // 1 sources

        {
            category = this.lookupCategory(c);
            if (category != -1) {
                state = this.lookupState(state, category);
            }
            if (this.lookaheadStates[state]) {
                if (this.endStates[state]) {
                    result = lookaheadResult;
                } else {
                    lookaheadResult = text.getIndex() + 1;
                }
            } else if (this.endStates[state]) {
                result = text.getIndex() + 1;
            }
            if (category != -1 && state != 0) {
                lastC = c;
                lastCPos = text.getIndex();
            }
            c = text.next();
lbl30:
            // 3 sources

            ** while (c != '\uffff' && state != 0)
        }
lbl31:
        // 1 sources

        if (c == '\uffff' && lookaheadResult == text.getEndIndex()) {
            result = lookaheadResult;
        } else if ("\n\r\f\u2028\u2029".indexOf(lastC) != -1) {
            result = lastCPos + 1;
        }
        text.setIndex(result);
        return result;
    }

    protected int handlePrevious() {
        CharacterIterator text = this.getText();
        int state = 1;
        int category = 0;
        int lastCategory = 0;
        char c = text.current();
        while (c != '\uffff' && state != 0) {
            lastCategory = category;
            category = this.lookupCategory(c);
            if (category != -1) {
                state = this.lookupBackwardState(state, category);
            }
            c = text.previous();
        }
        if (c != '\uffff') {
            if (lastCategory != -1) {
                text.setIndex(text.getIndex() + 2);
            } else {
                text.next();
            }
        }
        return text.getIndex();
    }

    protected int lookupCategory(char c) {
        return this.charCategoryTable.elementAt(c);
    }

    protected int lookupState(int state, int category) {
        return this.stateTable[state * this.numCategories + category];
    }

    protected int lookupBackwardState(int state, int category) {
        return this.backwardsStateTable[state * this.numCategories + category];
    }

    protected class Builder {
        protected Vector categories = null;
        protected Hashtable expressions = null;
        protected CharSet ignoreChars = null;
        protected Vector tempStateTable = null;
        protected Vector decisionPointList = null;
        protected Stack decisionPointStack = null;
        protected Vector loopingStates = null;
        protected Vector statesToBackfill = null;
        protected Vector mergeList = null;
        protected boolean clearLoopingStates = false;
        protected static final int END_STATE_FLAG = 32768;
        protected static final int DONT_LOOP_FLAG = 16384;
        protected static final int LOOKAHEAD_STATE_FLAG = 8192;
        protected static final int ALL_FLAGS = 57344;

        public void buildBreakIterator() {
            Vector tempRuleList = this.buildRuleList(RuleBasedBreakIterator.this.description);
            this.buildCharCategories(tempRuleList);
            this.buildStateTable(tempRuleList);
            this.buildBackwardsStateTable(tempRuleList);
        }

        private Vector buildRuleList(String description) {
            Vector tempRuleList = new Vector();
            Stack parenStack = new Stack();
            int p = 0;
            int ruleStart = 0;
            char c = '\u0000';
            int lastC = 0;
            int lastOpen = 0;
            boolean haveEquals = false;
            boolean havePipe = false;
            boolean sawVarName = false;
            if (description.length() != 0 && description.charAt(description.length() - 1) != ';') {
                description = String.valueOf(description) + ";";
            }
            while (p < description.length()) {
                c = description.charAt(p);
                switch (c) {
                    case '(': 
                    case '<': 
                    case '[': 
                    case '{': {
                        if (lastOpen == 60) {
                            this.error(Msg.getString("K00b8"), p, description);
                        }
                        if (lastOpen == 91 && c != '[') {
                            this.error(Msg.getString("K00b9"), p, description);
                        }
                        if (c == '<' && (haveEquals || havePipe)) {
                            this.error(Msg.getString("K00ba"), p, description);
                        }
                        lastOpen = c;
                        parenStack.push(new Character(c));
                        if (c != '<') break;
                        sawVarName = true;
                        break;
                    }
                    case ')': 
                    case '>': 
                    case ']': 
                    case '}': {
                        char expectedClose = '\u0000';
                        switch (lastOpen) {
                            case 123: {
                                expectedClose = '}';
                                break;
                            }
                            case 91: {
                                expectedClose = ']';
                                break;
                            }
                            case 40: {
                                expectedClose = ')';
                                break;
                            }
                            case 60: {
                                expectedClose = '>';
                            }
                        }
                        if (c != expectedClose) {
                            this.error(Msg.getString("K00bb"), p, description);
                        }
                        if (lastC == lastOpen) {
                            this.error(Msg.getString("K00bc"), p, description);
                        }
                        parenStack.pop();
                        if (!parenStack.empty()) {
                            lastOpen = ((Character)parenStack.peek()).charValue();
                            break;
                        }
                        lastOpen = 0;
                        break;
                    }
                    case '*': {
                        if ("=/{(|}*;\u0000".indexOf(lastC) == -1) break;
                        this.error(Msg.getString("K00bd"), p, description);
                        break;
                    }
                    case '?': {
                        if (lastC == 42) break;
                        this.error(Msg.getString("K00be"), p, description);
                        break;
                    }
                    case '=': {
                        if (haveEquals || havePipe) {
                            this.error(Msg.getString("K00bf"), p, description);
                        }
                        haveEquals = true;
                        break;
                    }
                    case '/': {
                        if (haveEquals || havePipe) {
                            this.error(Msg.getString("K00bf"), p, description);
                        }
                        if (sawVarName) {
                            this.error(Msg.getString("K00ba"), p, description);
                        }
                        havePipe = true;
                        break;
                    }
                    case '!': {
                        if (lastC == 59 || lastC == 0) break;
                        this.error(Msg.getString("K00c0"), p, description);
                        break;
                    }
                    case '\\': {
                        ++p;
                        break;
                    }
                    case '.': {
                        break;
                    }
                    case '-': 
                    case ':': 
                    case '^': {
                        if (lastOpen == 91 || lastOpen == 60) break;
                        this.error(Msg.getString("K00c1"), p, description);
                        break;
                    }
                    case ';': {
                        if (lastC == 59 || lastC == 0) {
                            this.error(Msg.getString("K00c2"), p, description);
                        }
                        if (!parenStack.empty()) {
                            this.error(Msg.getString("K00bb"), p, description);
                        }
                        if (!parenStack.empty()) break;
                        if (haveEquals) {
                            description = this.processSubstitution(description.substring(ruleStart, p), description, p + 1);
                        } else {
                            if (sawVarName) {
                                this.error(Msg.getString("K00ba"), p, description);
                            }
                            tempRuleList.addElement(description.substring(ruleStart, p));
                        }
                        ruleStart = p + 1;
                        sawVarName = false;
                        havePipe = false;
                        haveEquals = false;
                        break;
                    }
                    case '|': {
                        if (lastC == 124) {
                            this.error(Msg.getString("K00c4"), p, description);
                        }
                        if (!parenStack.empty() && lastOpen == 40) break;
                        this.error(Msg.getString("K00c5"), p, description);
                        break;
                    }
                    default: {
                        if (c < ' ' || c >= '\u007f' || Character.isLetter(c) || Character.isDigit(c)) break;
                        this.error("Illegal character", p, description);
                    }
                }
                lastC = c;
                ++p;
            }
            if (tempRuleList.size() == 0) {
                this.error(Msg.getString("K00c6"), p, description);
            }
            return tempRuleList;
        }

        protected String processSubstitution(String substitutionRule, String description, int startPos) {
            int equalPos = substitutionRule.indexOf(61);
            String replace = substitutionRule.substring(0, equalPos);
            String replaceWith = substitutionRule.substring(equalPos + 1);
            this.handleSpecialSubstitution(replace, replaceWith, startPos, description);
            if (replaceWith.length() == 0) {
                this.error(Msg.getString("K00c7"), startPos, description);
            }
            if (replace.length() == 0) {
                this.error(Msg.getString("K00c8"), startPos, description);
            }
            if (replace.length() == 2 && replace.charAt(0) != '\\') {
                this.error(Msg.getString("K00c9"), startPos, description);
            }
            if (replace.length() >= 3 && replace.charAt(0) != '<' && replace.charAt(equalPos - 1) != '>') {
                this.error(Msg.getString("K00c9"), startPos, description);
            }
            if (!(replaceWith.charAt(0) == '[' && replaceWith.charAt(replaceWith.length() - 1) == ']' || replaceWith.charAt(0) == '(' && replaceWith.charAt(replaceWith.length() - 1) == ')')) {
                this.error(Msg.getString("K00ca"), startPos, description);
            }
            StringBuffer result = new StringBuffer();
            result.append(description.substring(0, startPos));
            int lastPos = startPos;
            int pos = description.indexOf(replace, startPos);
            while (pos != -1) {
                result.append(description.substring(lastPos, pos));
                result.append(replaceWith);
                lastPos = pos + replace.length();
                pos = description.indexOf(replace, lastPos);
            }
            result.append(description.substring(lastPos));
            return result.toString();
        }

        protected void handleSpecialSubstitution(String replace, String replaceWith, int startPos, String description) {
            if (replace.equals("<ignore>")) {
                if (replaceWith.charAt(0) == '(') {
                    this.error(Msg.getString("K00cb"), startPos, description);
                }
                this.ignoreChars = CharSet.parseString(replaceWith);
            }
        }

        protected void buildCharCategories(Vector tempRuleList) {
            int bracketLevel = 0;
            int p = 0;
            int lineNum = 0;
            this.expressions = new Hashtable();
            while (lineNum < tempRuleList.size()) {
                String line = (String)tempRuleList.elementAt(lineNum);
                p = 0;
                while (p < line.length()) {
                    char c = line.charAt(p);
                    switch (c) {
                        case '!': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '.': 
                        case '/': 
                        case ';': 
                        case '?': 
                        case '{': 
                        case '|': 
                        case '}': {
                            break;
                        }
                        case '[': {
                            int q = p + 1;
                            ++bracketLevel;
                            while (q < line.length() && bracketLevel != 0) {
                                c = line.charAt(q);
                                switch (c) {
                                    case '\\': {
                                        ++q;
                                        break;
                                    }
                                    case '[': {
                                        ++bracketLevel;
                                        break;
                                    }
                                    case ']': {
                                        --bracketLevel;
                                    }
                                }
                                ++q;
                            }
                            if (this.expressions.get(line.substring(p, q)) == null) {
                                this.expressions.put(line.substring(p, q), CharSet.parseString(line.substring(p, q)));
                            }
                            p = q - 1;
                            break;
                        }
                        case '\\': {
                            c = line.charAt(++p);
                        }
                        default: {
                            this.expressions.put(line.substring(p, p + 1), CharSet.parseString(line.substring(p, p + 1)));
                        }
                    }
                    ++p;
                }
                ++lineNum;
            }
            CharSet.releaseExpressionCache();
            this.categories = new Vector();
            if (this.ignoreChars != null) {
                this.categories.addElement(this.ignoreChars);
            } else {
                this.categories.addElement(new CharSet());
            }
            this.ignoreChars = null;
            this.mungeExpressionList(this.expressions);
            Enumeration iter = this.expressions.elements();
            while (iter.hasMoreElements()) {
                CharSet e = (CharSet)iter.nextElement();
                int j = this.categories.size() - 1;
                while (!e.empty() && j > 0) {
                    CharSet that = (CharSet)this.categories.elementAt(j);
                    if (!that.intersection(e).empty()) {
                        CharSet temp = that.difference(e);
                        if (!temp.empty()) {
                            this.categories.addElement(temp);
                        }
                        temp = e.intersection(that);
                        e = e.difference(that);
                        if (!temp.equals(that)) {
                            this.categories.setElementAt(temp, j);
                        }
                    }
                    --j;
                }
                if (e.empty()) continue;
                this.categories.addElement(e);
            }
            CharSet allChars = new CharSet();
            int i = 1;
            while (i < this.categories.size()) {
                allChars = allChars.union((CharSet)this.categories.elementAt(i));
                ++i;
            }
            CharSet ignoreChars = (CharSet)this.categories.elementAt(0);
            ignoreChars = ignoreChars.difference(allChars);
            this.categories.setElementAt(ignoreChars, 0);
            iter = this.expressions.keys();
            while (iter.hasMoreElements()) {
                String key = (String)iter.nextElement();
                CharSet cs = (CharSet)this.expressions.get(key);
                StringBuffer cats = new StringBuffer();
                int j = 0;
                while (j < this.categories.size()) {
                    CharSet temp = cs.intersection((CharSet)this.categories.elementAt(j));
                    if (!temp.empty()) {
                        cats.append((char)(256 + j));
                        if (temp.equals(cs)) break;
                    }
                    ++j;
                }
                this.expressions.put(key, cats.toString());
            }
            RuleBasedBreakIterator.this.charCategoryTable = new CompactByteArray(0);
            int i2 = 0;
            while (i2 < this.categories.size()) {
                CharSet chars = (CharSet)this.categories.elementAt(i2);
                CharSet.Enumeration enum1 = chars.getChars();
                while (enum1.hasMoreElements()) {
                    char[] range = (char[])enum1.nextElement();
                    if (i2 != 0) {
                        RuleBasedBreakIterator.this.charCategoryTable.setElementAt(range[0], range[1], (byte)i2);
                        continue;
                    }
                    RuleBasedBreakIterator.this.charCategoryTable.setElementAt(range[0], range[1], (byte)-1);
                }
                ++i2;
            }
            RuleBasedBreakIterator.this.charCategoryTable.compact();
            RuleBasedBreakIterator.this.numCategories = this.categories.size();
        }

        protected void mungeExpressionList(Hashtable expressions) {
        }

        private void buildStateTable(Vector tempRuleList) {
            this.tempStateTable = new Vector();
            this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
            this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
            int i = 0;
            while (i < tempRuleList.size()) {
                String rule = (String)tempRuleList.elementAt(i);
                if (rule.charAt(0) != '!') {
                    this.parseRule(rule, true);
                }
                ++i;
            }
            this.finishBuildingStateTable(true);
        }

        private void parseRule(String rule, boolean forward) {
            short[] state;
            int currentState;
            int p = 0;
            int lastState = currentState = 1;
            String pendingChars = "";
            this.decisionPointStack = new Stack();
            this.decisionPointList = new Vector();
            this.loopingStates = new Vector();
            this.statesToBackfill = new Vector();
            boolean sawEarlyBreak = false;
            if (!forward) {
                this.loopingStates.addElement(new Integer(1));
            }
            this.decisionPointList.addElement(new Integer(currentState));
            currentState = this.tempStateTable.size() - 1;
            while (p < rule.length()) {
                int i;
                char c = rule.charAt(p);
                this.clearLoopingStates = false;
                if (c == '[' || c == '\\' || Character.isLetter(c) || Character.isDigit(c) || c < ' ' || c == '.' || c >= '\u007f') {
                    if (c != '.') {
                        int q = p;
                        if (c == '\\') {
                            q = p + 2;
                            ++p;
                        } else if (c == '[') {
                            int bracketLevel = 1;
                            while (bracketLevel > 0) {
                                if ((c = rule.charAt(++q)) == '[') {
                                    ++bracketLevel;
                                    continue;
                                }
                                if (c == ']') {
                                    --bracketLevel;
                                    continue;
                                }
                                if (c != '\\') continue;
                                ++q;
                            }
                            ++q;
                        } else {
                            q = p + 1;
                        }
                        pendingChars = (String)this.expressions.get(rule.substring(p, q));
                        p = q - 1;
                    } else {
                        int rowNum = (Integer)this.decisionPointList.lastElement();
                        state = (short[])this.tempStateTable.elementAt(rowNum);
                        if (p + 1 < rule.length() && rule.charAt(p + 1) == '*' && state[0] != 0) {
                            this.decisionPointList.addElement(new Integer(state[0]));
                            pendingChars = "";
                            ++p;
                        } else {
                            StringBuffer temp = new StringBuffer();
                            i = 0;
                            while (i < RuleBasedBreakIterator.this.numCategories) {
                                temp.append((char)(i + 256));
                                ++i;
                            }
                            pendingChars = temp.toString();
                        }
                    }
                    if (pendingChars.length() != 0) {
                        if (p + 1 < rule.length() && rule.charAt(p + 1) == '*') {
                            this.decisionPointStack.push(this.decisionPointList.clone());
                        }
                        int newState = this.tempStateTable.size();
                        if (this.loopingStates.size() != 0) {
                            this.statesToBackfill.addElement(new Integer(newState));
                        }
                        state = new short[RuleBasedBreakIterator.this.numCategories + 1];
                        if (sawEarlyBreak) {
                            state[((RuleBasedBreakIterator)RuleBasedBreakIterator.this).numCategories] = 16384;
                        }
                        this.tempStateTable.addElement(state);
                        this.updateStateTable(this.decisionPointList, pendingChars, (short)newState);
                        this.decisionPointList.removeAllElements();
                        lastState = currentState;
                        do {
                            this.decisionPointList.addElement(new Integer(++currentState));
                        } while (currentState + 1 < this.tempStateTable.size());
                    }
                } else if (c == '{') {
                    this.decisionPointStack.push(this.decisionPointList.clone());
                } else if (c == '}' || c == '*') {
                    if (c == '*') {
                        int i2 = lastState + 1;
                        while (i2 < this.tempStateTable.size()) {
                            Vector temp = new Vector();
                            temp.addElement(new Integer(i2));
                            this.updateStateTable(temp, pendingChars, (short)(lastState + 1));
                            ++i2;
                        }
                    }
                    Vector temp = (Vector)this.decisionPointStack.pop();
                    int i3 = 0;
                    while (i3 < this.decisionPointList.size()) {
                        temp.addElement(this.decisionPointList.elementAt(i3));
                        ++i3;
                    }
                    this.decisionPointList = temp;
                } else if (c == '?') {
                    this.setLoopingStates(this.decisionPointList, this.decisionPointList);
                } else if (c == '(') {
                    this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
                    lastState = currentState++;
                    this.decisionPointList.insertElementAt(new Integer(currentState), 0);
                    this.decisionPointStack.push(this.decisionPointList.clone());
                    this.decisionPointStack.push(new Vector());
                } else if (c == '|') {
                    Vector oneDown = (Vector)this.decisionPointStack.pop();
                    Vector twoDown = (Vector)this.decisionPointStack.peek();
                    this.decisionPointStack.push(oneDown);
                    i = 0;
                    while (i < this.decisionPointList.size()) {
                        oneDown.addElement(this.decisionPointList.elementAt(i));
                        ++i;
                    }
                    this.decisionPointList = (Vector)twoDown.clone();
                } else if (c == ')') {
                    Vector exitPoints = (Vector)this.decisionPointStack.pop();
                    int i4 = 0;
                    while (i4 < this.decisionPointList.size()) {
                        exitPoints.addElement(this.decisionPointList.elementAt(i4));
                        ++i4;
                    }
                    this.decisionPointList = exitPoints;
                    if (p + 1 >= rule.length() || rule.charAt(p + 1) != '*') {
                        this.decisionPointStack.pop();
                    } else {
                        exitPoints = (Vector)this.decisionPointList.clone();
                        Vector temp = (Vector)this.decisionPointStack.pop();
                        int tempStateNum = (Integer)temp.firstElement();
                        short[] tempState = (short[])this.tempStateTable.elementAt(tempStateNum);
                        int i5 = 0;
                        while (i5 < this.decisionPointList.size()) {
                            temp.addElement(this.decisionPointList.elementAt(i5));
                            ++i5;
                        }
                        this.decisionPointList = temp;
                        i5 = 0;
                        while (i5 < tempState.length) {
                            if (tempState[i5] > tempStateNum) {
                                this.updateStateTable(exitPoints, new Character((char)(i5 + 256)).toString(), tempState[i5]);
                            }
                            ++i5;
                        }
                        lastState = currentState;
                        currentState = this.tempStateTable.size() - 1;
                        ++p;
                    }
                } else if (c == '/') {
                    sawEarlyBreak = true;
                    int i6 = 0;
                    while (i6 < this.decisionPointList.size()) {
                        state = (short[])this.tempStateTable.elementAt((Integer)this.decisionPointList.elementAt(i6));
                        int n = RuleBasedBreakIterator.this.numCategories;
                        state[n] = (short)(state[n] | 0x2000);
                        ++i6;
                    }
                }
                if (this.clearLoopingStates) {
                    this.setLoopingStates(null, this.decisionPointList);
                }
                ++p;
            }
            this.setLoopingStates(null, this.decisionPointList);
            int i = 0;
            while (i < this.decisionPointList.size()) {
                int rowNum = (Integer)this.decisionPointList.elementAt(i);
                state = (short[])this.tempStateTable.elementAt(rowNum);
                int n = RuleBasedBreakIterator.this.numCategories;
                state[n] = (short)(state[n] | 0x8000);
                if (sawEarlyBreak) {
                    int n2 = RuleBasedBreakIterator.this.numCategories;
                    state[n2] = (short)(state[n2] | 0x2000);
                }
                ++i;
            }
        }

        private void updateStateTable(Vector rows, String pendingChars, short newValue) {
            short[] newValues = new short[RuleBasedBreakIterator.this.numCategories + 1];
            int i = 0;
            while (i < pendingChars.length()) {
                newValues[pendingChars.charAt((int)i) - 256] = newValue;
                ++i;
            }
            i = 0;
            while (i < rows.size()) {
                this.mergeStates((Integer)rows.elementAt(i), newValues, rows);
                ++i;
            }
        }

        private void mergeStates(int rowNum, short[] newValues, Vector rowsBeingUpdated) {
            short[] oldValues = (short[])this.tempStateTable.elementAt(rowNum);
            boolean isLoopingState = this.loopingStates.contains(new Integer(rowNum));
            int i = 0;
            while (i < oldValues.length) {
                if (oldValues[i] != newValues[i]) {
                    if (isLoopingState && this.loopingStates.contains(new Integer(oldValues[i]))) {
                        if (newValues[i] != 0) {
                            if (oldValues[i] == 0) {
                                this.clearLoopingStates = true;
                            }
                            oldValues[i] = newValues[i];
                        }
                    } else if (oldValues[i] == 0) {
                        oldValues[i] = newValues[i];
                    } else if (i == RuleBasedBreakIterator.this.numCategories) {
                        oldValues[i] = (short)(newValues[i] & 0xE000 | oldValues[i]);
                    } else if (oldValues[i] != 0 && newValues[i] != 0) {
                        int combinedRowNum = this.searchMergeList(oldValues[i], newValues[i]);
                        if (combinedRowNum != 0) {
                            oldValues[i] = (short)combinedRowNum;
                        } else {
                            int oldRowNum = oldValues[i];
                            int newRowNum = newValues[i];
                            combinedRowNum = this.tempStateTable.size();
                            if (this.mergeList == null) {
                                this.mergeList = new Vector();
                            }
                            this.mergeList.addElement(new int[]{oldRowNum, newRowNum, combinedRowNum});
                            short[] newRow = new short[RuleBasedBreakIterator.this.numCategories + 1];
                            short[] oldRow = (short[])this.tempStateTable.elementAt(oldRowNum);
                            System.arraycopy((Object)oldRow, 0, (Object)newRow, 0, RuleBasedBreakIterator.this.numCategories + 1);
                            this.tempStateTable.addElement(newRow);
                            oldValues[i] = (short)combinedRowNum;
                            if ((this.decisionPointList.contains(new Integer(oldRowNum)) || this.decisionPointList.contains(new Integer(newRowNum))) && !this.decisionPointList.contains(new Integer(combinedRowNum))) {
                                this.decisionPointList.addElement(new Integer(combinedRowNum));
                            }
                            if ((rowsBeingUpdated.contains(new Integer(oldRowNum)) || rowsBeingUpdated.contains(new Integer(newRowNum))) && !rowsBeingUpdated.contains(new Integer(combinedRowNum))) {
                                this.decisionPointList.addElement(new Integer(combinedRowNum));
                            }
                            int k = 0;
                            while (k < this.decisionPointStack.size()) {
                                Vector dpl = (Vector)this.decisionPointStack.elementAt(k);
                                if ((dpl.contains(new Integer(oldRowNum)) || dpl.contains(new Integer(newRowNum))) && !dpl.contains(new Integer(combinedRowNum))) {
                                    dpl.addElement(new Integer(combinedRowNum));
                                }
                                ++k;
                            }
                            this.mergeStates(combinedRowNum, (short[])this.tempStateTable.elementAt(newValues[i]), rowsBeingUpdated);
                        }
                    }
                }
                ++i;
            }
        }

        private int searchMergeList(int a, int b) {
            if (this.mergeList == null) {
                return 0;
            }
            int i = 0;
            while (i < this.mergeList.size()) {
                int[] entry = (int[])this.mergeList.elementAt(i);
                if (entry[0] == a && entry[1] == b || entry[0] == b && entry[1] == a) {
                    return entry[2];
                }
                if (entry[2] == a && (entry[0] == b || entry[1] == b)) {
                    return entry[2];
                }
                if (entry[2] == b && (entry[0] == a || entry[1] == a)) {
                    return entry[2];
                }
                ++i;
            }
            return 0;
        }

        private void setLoopingStates(Vector newLoopingStates, Vector endStates) {
            if (!this.loopingStates.isEmpty()) {
                int loopingState = (Integer)this.loopingStates.lastElement();
                int i = 0;
                while (i < endStates.size()) {
                    this.eliminateBackfillStates((Integer)endStates.elementAt(i));
                    ++i;
                }
                i = 0;
                while (i < this.statesToBackfill.size()) {
                    int rowNum = (Integer)this.statesToBackfill.elementAt(i);
                    short[] state = (short[])this.tempStateTable.elementAt(rowNum);
                    state[((RuleBasedBreakIterator)RuleBasedBreakIterator.this).numCategories] = (short)(state[RuleBasedBreakIterator.this.numCategories] & 0xE000 | loopingState);
                    ++i;
                }
                this.statesToBackfill.removeAllElements();
                this.loopingStates.removeAllElements();
            }
            if (newLoopingStates != null) {
                this.loopingStates = (Vector)newLoopingStates.clone();
            }
        }

        private void eliminateBackfillStates(int baseState) {
            if (this.statesToBackfill.contains(new Integer(baseState))) {
                this.statesToBackfill.removeElement(new Integer(baseState));
                short[] state = (short[])this.tempStateTable.elementAt(baseState);
                int i = 0;
                while (i < RuleBasedBreakIterator.this.numCategories) {
                    if (state[i] != 0) {
                        this.eliminateBackfillStates(state[i]);
                    }
                    ++i;
                }
            }
        }

        private void backfillLoopingStates() {
            short[] loopingState = null;
            int loopingStateRowNum = 0;
            int i = 0;
            while (i < this.tempStateTable.size()) {
                short[] state = (short[])this.tempStateTable.elementAt(i);
                int fromState = state[RuleBasedBreakIterator.this.numCategories] & 0xFFFF1FFF;
                if (fromState > 0) {
                    if (fromState != loopingStateRowNum) {
                        loopingStateRowNum = fromState;
                        loopingState = (short[])this.tempStateTable.elementAt(loopingStateRowNum);
                    }
                    int n = RuleBasedBreakIterator.this.numCategories;
                    state[n] = (short)(state[n] & 0xE000);
                    int j = 0;
                    while (j < state.length) {
                        if (state[j] == 0) {
                            state[j] = loopingState[j];
                        } else if (state[j] == 16384) {
                            state[j] = 0;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }

        private void finishBuildingStateTable(boolean forward) {
            int p;
            int lastClass;
            short[] state1;
            this.backfillLoopingStates();
            int[] rowNumMap = new int[this.tempStateTable.size()];
            Stack rowsToFollow = new Stack();
            rowsToFollow.push(new Integer(1));
            rowNumMap[1] = 1;
            while (rowsToFollow.size() != 0) {
                int rowNum = (Integer)rowsToFollow.pop();
                short[] row = (short[])this.tempStateTable.elementAt(rowNum);
                int i = 0;
                while (i < RuleBasedBreakIterator.this.numCategories) {
                    if (row[i] != 0 && rowNumMap[row[i]] == 0) {
                        rowNumMap[row[i]] = row[i];
                        rowsToFollow.push(new Integer(row[i]));
                    }
                    ++i;
                }
            }
            int[] stateClasses = new int[this.tempStateTable.size()];
            int nextClass = RuleBasedBreakIterator.this.numCategories + 1;
            int i = 1;
            while (i < stateClasses.length) {
                if (rowNumMap[i] != 0) {
                    state1 = (short[])this.tempStateTable.elementAt(i);
                    int j = 0;
                    while (j < RuleBasedBreakIterator.this.numCategories) {
                        if (state1[j] != 0) {
                            int n = i;
                            stateClasses[n] = stateClasses[n] + 1;
                        }
                        ++j;
                    }
                    if (stateClasses[i] == 0) {
                        stateClasses[i] = nextClass;
                    }
                }
                ++i;
            }
            ++nextClass;
            do {
                int currentClass = 1;
                lastClass = nextClass;
                while (currentClass < nextClass) {
                    short[] state2;
                    boolean split = false;
                    state1 = state2 = (short[])null;
                    int i2 = 0;
                    while (i2 < stateClasses.length) {
                        if (stateClasses[i2] == currentClass) {
                            if (state1 == null) {
                                state1 = (short[])this.tempStateTable.elementAt(i2);
                            } else {
                                state2 = (short[])this.tempStateTable.elementAt(i2);
                                int j = 0;
                                while (j < state2.length) {
                                    if (j == RuleBasedBreakIterator.this.numCategories && state1[j] != state2[j] && forward || j != RuleBasedBreakIterator.this.numCategories && stateClasses[state1[j]] != stateClasses[state2[j]]) {
                                        stateClasses[i2] = nextClass;
                                        split = true;
                                        break;
                                    }
                                    ++j;
                                }
                            }
                        }
                        ++i2;
                    }
                    if (split) {
                        ++nextClass;
                    }
                    ++currentClass;
                }
            } while (lastClass != nextClass);
            int[] representatives = new int[nextClass];
            int i3 = 1;
            while (i3 < stateClasses.length) {
                if (representatives[stateClasses[i3]] == 0) {
                    representatives[stateClasses[i3]] = i3;
                } else {
                    rowNumMap[i3] = representatives[stateClasses[i3]];
                }
                ++i3;
            }
            i3 = 1;
            while (i3 < rowNumMap.length) {
                if (rowNumMap[i3] != i3) {
                    this.tempStateTable.setElementAt(null, i3);
                }
                ++i3;
            }
            int newRowNum = 1;
            i3 = 1;
            while (i3 < rowNumMap.length) {
                if (this.tempStateTable.elementAt(i3) != null) {
                    rowNumMap[i3] = newRowNum++;
                }
                ++i3;
            }
            i3 = 1;
            while (i3 < rowNumMap.length) {
                if (this.tempStateTable.elementAt(i3) == null) {
                    rowNumMap[i3] = rowNumMap[rowNumMap[i3]];
                }
                ++i3;
            }
            if (forward) {
                RuleBasedBreakIterator.this.endStates = new boolean[newRowNum];
                RuleBasedBreakIterator.this.lookaheadStates = new boolean[newRowNum];
                RuleBasedBreakIterator.this.stateTable = new short[newRowNum * RuleBasedBreakIterator.this.numCategories];
                p = 0;
                int p2 = 0;
                int i4 = 0;
                while (i4 < this.tempStateTable.size()) {
                    short[] row = (short[])this.tempStateTable.elementAt(i4);
                    if (row != null) {
                        int j = 0;
                        while (j < RuleBasedBreakIterator.this.numCategories) {
                            ((RuleBasedBreakIterator)RuleBasedBreakIterator.this).stateTable[p] = (short)rowNumMap[row[j]];
                            ++p;
                            ++j;
                        }
                        ((RuleBasedBreakIterator)RuleBasedBreakIterator.this).endStates[p2] = (row[RuleBasedBreakIterator.this.numCategories] & 0x8000) != 0;
                        ((RuleBasedBreakIterator)RuleBasedBreakIterator.this).lookaheadStates[p2] = (row[RuleBasedBreakIterator.this.numCategories] & 0x2000) != 0;
                        ++p2;
                    }
                    ++i4;
                }
            } else {
                RuleBasedBreakIterator.this.backwardsStateTable = new short[newRowNum * RuleBasedBreakIterator.this.numCategories];
                p = 0;
                int i5 = 0;
                while (i5 < this.tempStateTable.size()) {
                    short[] row = (short[])this.tempStateTable.elementAt(i5);
                    if (row != null) {
                        int j = 0;
                        while (j < RuleBasedBreakIterator.this.numCategories) {
                            ((RuleBasedBreakIterator)RuleBasedBreakIterator.this).backwardsStateTable[p] = (short)rowNumMap[row[j]];
                            ++p;
                            ++j;
                        }
                    }
                    ++i5;
                }
            }
        }

        private void buildBackwardsStateTable(Vector tempRuleList) {
            this.tempStateTable = new Vector();
            this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
            this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
            int i = 0;
            while (i < tempRuleList.size()) {
                String rule = (String)tempRuleList.elementAt(i);
                if (rule.charAt(0) == '!') {
                    this.parseRule(rule.substring(1), false);
                }
                ++i;
            }
            this.backfillLoopingStates();
            int backTableOffset = this.tempStateTable.size();
            if (backTableOffset > 2) {
                ++backTableOffset;
            }
            int i2 = 0;
            while (i2 < RuleBasedBreakIterator.this.numCategories + 1) {
                this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
                ++i2;
            }
            short[] state = (short[])this.tempStateTable.elementAt(backTableOffset - 1);
            int i3 = 0;
            while (i3 < RuleBasedBreakIterator.this.numCategories) {
                state[i3] = (short)(i3 + backTableOffset);
                ++i3;
            }
            int numRows = RuleBasedBreakIterator.this.stateTable.length / RuleBasedBreakIterator.this.numCategories;
            int column = 0;
            while (column < RuleBasedBreakIterator.this.numCategories) {
                int row = 0;
                while (row < numRows) {
                    int nextRow = RuleBasedBreakIterator.this.lookupState(row, column);
                    if (nextRow != 0) {
                        int nextColumn = 0;
                        while (nextColumn < RuleBasedBreakIterator.this.numCategories) {
                            int cellValue = RuleBasedBreakIterator.this.lookupState(nextRow, nextColumn);
                            if (cellValue != 0) {
                                state = (short[])this.tempStateTable.elementAt(nextColumn + backTableOffset);
                                state[column] = (short)(column + backTableOffset);
                            }
                            ++nextColumn;
                        }
                    }
                    ++row;
                }
                ++column;
            }
            if (backTableOffset > 1) {
                int j;
                state = (short[])this.tempStateTable.elementAt(1);
                int i4 = backTableOffset - 1;
                while (i4 < this.tempStateTable.size()) {
                    short[] state2 = (short[])this.tempStateTable.elementAt(i4);
                    j = 0;
                    while (j < RuleBasedBreakIterator.this.numCategories) {
                        if (state[j] != 0 && state2[j] != 0) {
                            state2[j] = state[j];
                        }
                        ++j;
                    }
                    ++i4;
                }
                state = (short[])this.tempStateTable.elementAt(backTableOffset - 1);
                i4 = 1;
                while (i4 < backTableOffset - 1) {
                    short[] state2 = (short[])this.tempStateTable.elementAt(i4);
                    if ((state2[RuleBasedBreakIterator.this.numCategories] & 0x8000) == 0) {
                        j = 0;
                        while (j < RuleBasedBreakIterator.this.numCategories) {
                            if (state2[j] == 0) {
                                state2[j] = state[j];
                            }
                            ++j;
                        }
                    }
                    ++i4;
                }
            }
            this.finishBuildingStateTable(false);
        }

        protected void error(String message, int position, String context) {
            throw new IllegalArgumentException(Msg.getString("K033b", new Object[]{new Integer(position), message, context.substring(0, position), context.substring(position)}));
        }
    }

    private static final class SafeCharIterator
    implements CharacterIterator,
    Cloneable {
        private CharacterIterator base;
        private int rangeStart;
        private int rangeLimit;
        private int currentIndex;

        SafeCharIterator(CharacterIterator base) {
            this.base = base;
            this.rangeStart = base.getBeginIndex();
            this.rangeLimit = base.getEndIndex();
            this.currentIndex = base.getIndex();
        }

        public char first() {
            return this.setIndex(this.rangeStart);
        }

        public char last() {
            return this.setIndex(this.rangeLimit - 1);
        }

        public char current() {
            if (this.currentIndex < this.rangeStart || this.currentIndex >= this.rangeLimit) {
                return '\uffff';
            }
            return this.base.setIndex(this.currentIndex);
        }

        public char next() {
            ++this.currentIndex;
            if (this.currentIndex >= this.rangeLimit) {
                this.currentIndex = this.rangeLimit;
                return '\uffff';
            }
            return this.base.setIndex(this.currentIndex);
        }

        public char previous() {
            --this.currentIndex;
            if (this.currentIndex < this.rangeStart) {
                this.currentIndex = this.rangeStart;
                return '\uffff';
            }
            return this.base.setIndex(this.currentIndex);
        }

        public char setIndex(int i) {
            if (i < this.rangeStart || i > this.rangeLimit) {
                throw new IllegalArgumentException(Msg.getString("K0022"));
            }
            this.currentIndex = i;
            return this.current();
        }

        public int getBeginIndex() {
            return this.rangeStart;
        }

        public int getEndIndex() {
            return this.rangeLimit;
        }

        public int getIndex() {
            return this.currentIndex;
        }

        public Object clone() {
            CharacterIterator copyOfBase;
            SafeCharIterator copy = null;
            try {
                copy = (SafeCharIterator)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error(Msg.getString("K0023", e));
            }
            copy.base = copyOfBase = (CharacterIterator)this.base.clone();
            return copy;
        }
    }
}

