/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MapEntry;
import java.util.NoSuchElementException;
import java.util.Set;

public class LinkedHashMap
extends HashMap {
    private static final long serialVersionUID = 3801124242820219131L;
    private final boolean accessOrder;
    private transient LinkedHashMapEntry head;
    private transient LinkedHashMapEntry tail;

    public LinkedHashMap() {
        this.accessOrder = false;
        this.head = null;
    }

    public LinkedHashMap(int s) {
        super(s);
        this.accessOrder = false;
        this.head = null;
    }

    public LinkedHashMap(int s, float lf) {
        super(s, lf);
        this.accessOrder = false;
        this.head = null;
        this.tail = null;
    }

    public LinkedHashMap(int s, float lf, boolean order) {
        super(s, lf);
        this.accessOrder = order;
        this.head = null;
        this.tail = null;
    }

    public LinkedHashMap(Map m) {
        this.accessOrder = false;
        this.head = null;
        this.tail = null;
        this.putAll(m);
    }

    HashMap.Entry[] newElementArray(int s) {
        return new LinkedHashMapEntry[s];
    }

    public Object get(Object key) {
        LinkedHashMapEntry m = (LinkedHashMapEntry)this.getEntry(key);
        if (m == null) {
            return null;
        }
        if (this.accessOrder && this.tail != m) {
            LinkedHashMapEntry p = m.chainBackward;
            LinkedHashMapEntry n = m.chainForward;
            n.chainBackward = p;
            if (p != null) {
                p.chainForward = n;
            } else {
                this.head = n;
            }
            m.chainForward = null;
            m.chainBackward = this.tail;
            this.tail.chainForward = m;
            this.tail = m;
        }
        return m.value;
    }

    HashMap.Entry createEntry(Object key, int index, Object value) {
        LinkedHashMapEntry m = new LinkedHashMapEntry(key, value);
        m.next = this.elementData[index];
        this.elementData[index] = m;
        this.linkEntry(m);
        return m;
    }

    public Object put(Object key, Object value) {
        int index = this.getModuloHash(key);
        LinkedHashMapEntry m = (LinkedHashMapEntry)this.findEntry(key, index);
        if (m == null) {
            ++this.modCount;
            if (++this.elementCount > this.threshold) {
                this.rehash();
                index = key == null ? 0 : (key.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
            }
            m = (LinkedHashMapEntry)this.createEntry(key, index, null);
        } else {
            this.linkEntry(m);
        }
        Object result = m.value;
        m.value = value;
        if (this.removeEldestEntry(this.head)) {
            this.remove(this.head.key);
        }
        return result;
    }

    void linkEntry(LinkedHashMapEntry m) {
        if (this.tail == m) {
            return;
        }
        if (this.head == null) {
            this.head = this.tail = m;
            return;
        }
        LinkedHashMapEntry p = m.chainBackward;
        LinkedHashMapEntry n = m.chainForward;
        if (p == null) {
            if (n != null) {
                if (this.accessOrder) {
                    this.head = n;
                    n.chainBackward = null;
                    m.chainBackward = this.tail;
                    m.chainForward = null;
                    this.tail.chainForward = m;
                    this.tail = m;
                }
            } else {
                m.chainBackward = this.tail;
                m.chainForward = null;
                this.tail.chainForward = m;
                this.tail = m;
            }
            return;
        }
        if (n == null) {
            return;
        }
        if (this.accessOrder) {
            p.chainForward = n;
            n.chainBackward = p;
            m.chainForward = null;
            m.chainBackward = this.tail;
            this.tail.chainForward = m;
            this.tail = m;
        }
    }

    public void putAll(Map m) {
        Iterator i = m.entrySet().iterator();
        while (i.hasNext()) {
            MapEntry e = (MapEntry)i.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public Set entrySet() {
        return new LinkedHashMapEntrySet(this);
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public boolean contains(Object object) {
                    return LinkedHashMap.this.containsKey(object);
                }

                public int size() {
                    return LinkedHashMap.this.size();
                }

                public void clear() {
                    LinkedHashMap.this.clear();
                }

                public boolean remove(Object key) {
                    if (LinkedHashMap.this.containsKey(key)) {
                        LinkedHashMap.this.remove(key);
                        return true;
                    }
                    return false;
                }

                public Iterator iterator() {
                    return new LinkedHashIterator(new MapEntry.Type(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Object get(MapEntry entry) {
                            return entry.key;
                        }
                    }, LinkedHashMap.this);
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new AbstractCollection(){

                public boolean contains(Object object) {
                    return LinkedHashMap.this.containsValue(object);
                }

                public int size() {
                    return LinkedHashMap.this.size();
                }

                public void clear() {
                    LinkedHashMap.this.clear();
                }

                public Iterator iterator() {
                    return new LinkedHashIterator(new MapEntry.Type(this){
                        final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Object get(MapEntry entry) {
                            return entry.value;
                        }
                    }, LinkedHashMap.this);
                }
            };
        }
        return this.valuesCollection;
    }

    public Object remove(Object key) {
        LinkedHashMapEntry m = (LinkedHashMapEntry)this.removeEntry(key);
        if (m == null) {
            return null;
        }
        LinkedHashMapEntry p = m.chainBackward;
        LinkedHashMapEntry n = m.chainForward;
        if (p != null) {
            p.chainForward = n;
        } else {
            this.head = n;
        }
        if (n != null) {
            n.chainBackward = p;
        } else {
            this.tail = p;
        }
        return m.value;
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        return false;
    }

    public void clear() {
        super.clear();
        this.tail = null;
        this.head = null;
    }

    public Object clone() {
        LinkedHashMap map = (LinkedHashMap)super.clone();
        map.clear();
        Iterator entries = this.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = (Map.Entry)entries.next();
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    static /* synthetic */ void access$1(LinkedHashMap linkedHashMap, LinkedHashMapEntry linkedHashMapEntry) {
        linkedHashMap.tail = linkedHashMapEntry;
    }

    static /* synthetic */ void access$2(LinkedHashMap linkedHashMap, LinkedHashMapEntry linkedHashMapEntry) {
        linkedHashMap.head = linkedHashMapEntry;
    }

    static final class LinkedHashIterator
    extends HashMap.HashMapIterator {
        LinkedHashIterator(MapEntry.Type value, LinkedHashMap hm) {
            super(value, hm);
            this.entry = hm.head;
        }

        public boolean hasNext() {
            return this.entry != null;
        }

        public Object next() {
            this.checkConcurrentMod();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object result = this.type.get(this.entry);
            this.lastEntry = this.entry;
            this.entry = ((LinkedHashMapEntry)this.entry).chainForward;
            this.canRemove = true;
            return result;
        }

        /*
         * Unable to fully structure code
         */
        public void remove() {
            block8: {
                this.checkConcurrentMod();
                if (!this.canRemove) {
                    throw new IllegalStateException();
                }
                this.canRemove = false;
                ++this.associatedMap.modCount;
                index = this.associatedMap.getModuloHash(this.lastEntry.key);
                m = (LinkedHashMapEntry)this.associatedMap.elementData[index];
                if (m != this.lastEntry) ** GOTO lbl13
                this.associatedMap.elementData[index] = this.lastEntry.next;
                break block8;
                while (m.next != this.lastEntry) {
                    m = (LinkedHashMapEntry)m.next;
lbl13:
                    // 2 sources

                    if (m.next != null) continue;
                }
                m.next = this.lastEntry.next;
            }
            lhme = (LinkedHashMapEntry)this.lastEntry;
            p = lhme.chainBackward;
            n = lhme.chainForward;
            lhm = (LinkedHashMap)this.associatedMap;
            if (p != null) {
                p.chainForward = n;
                if (n != null) {
                    n.chainBackward = p;
                } else {
                    LinkedHashMap.access$1(lhm, p);
                }
            } else {
                LinkedHashMap.access$2(lhm, n);
                if (n != null) {
                    n.chainBackward = null;
                } else {
                    LinkedHashMap.access$1(lhm, null);
                }
            }
            --this.associatedMap.elementCount;
            ++this.expectedModCount;
        }
    }

    static final class LinkedHashMapEntrySet
    extends HashMap.HashMapEntrySet {
        public LinkedHashMapEntrySet(LinkedHashMap lhm) {
            super(lhm);
        }

        public Iterator iterator() {
            return new LinkedHashIterator(new MapEntry.Type(this){
                final /* synthetic */ LinkedHashMapEntrySet this$1;
                {
                    this.this$1 = linkedHashMapEntrySet;
                }

                public Object get(MapEntry entry) {
                    return entry;
                }
            }, (LinkedHashMap)this.hashMap());
        }
    }

    static final class LinkedHashMapEntry
    extends HashMap.Entry {
        LinkedHashMapEntry chainForward = null;
        LinkedHashMapEntry chainBackward = null;

        LinkedHashMapEntry(Object theKey, Object theValue) {
            super(theKey, theValue);
        }

        public Object clone() {
            LinkedHashMapEntry entry = (LinkedHashMapEntry)super.clone();
            entry.chainBackward = this.chainBackward;
            entry.chainForward = this.chainForward;
            LinkedHashMapEntry lnext = (LinkedHashMapEntry)entry.next;
            if (lnext != null) {
                entry.next = (LinkedHashMapEntry)lnext.clone();
            }
            return entry;
        }
    }
}

