/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.ibm.oti.util.PriviAction;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormatSymbols;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZones;

public abstract class TimeZone
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3581463369166924961L;
    public static final int SHORT = 0;
    public static final int LONG = 1;
    private static HashMap AvailableZones;
    private static TimeZone Default;
    static final TimeZone GMT;
    private String ID;

    static {
        GMT = new SimpleTimeZone(0, "GMT");
    }

    private static void initializeAvailable() {
        TimeZone[] zones = TimeZones.getTimeZones();
        AvailableZones = new HashMap((zones.length + 1) * 4 / 3);
        AvailableZones.put(GMT.getID(), GMT);
        int i = 0;
        while (i < zones.length) {
            AvailableZones.put(zones[i].getID(), zones[i]);
            ++i;
        }
    }

    private void appendNumber(StringBuffer buffer, int count, int value) {
        String string = Integer.toString(value);
        if (count > string.length()) {
            int i = 0;
            while (i < count - string.length()) {
                buffer.append('0');
                ++i;
            }
        }
        buffer.append(string);
    }

    public Object clone() {
        try {
            TimeZone zone = (TimeZone)super.clone();
            return zone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public static synchronized String[] getAvailableIDs() {
        if (AvailableZones == null) {
            TimeZone.initializeAvailable();
        }
        int length = AvailableZones.size();
        String[] answer = new String[length];
        Iterator keys = AvailableZones.keySet().iterator();
        int i = 0;
        while (i < length) {
            answer[i] = (String)keys.next();
            ++i;
        }
        return answer;
    }

    public static synchronized String[] getAvailableIDs(int offset) {
        if (AvailableZones == null) {
            TimeZone.initializeAvailable();
        }
        int count = 0;
        int length = AvailableZones.size();
        String[] all = new String[length];
        Iterator zones = AvailableZones.values().iterator();
        int i = 0;
        while (i < length) {
            TimeZone tz = (TimeZone)zones.next();
            if (tz.getRawOffset() == offset) {
                all[count++] = tz.getID();
            }
            ++i;
        }
        String[] answer = new String[count];
        System.arraycopy((Object)all, 0, (Object)answer, 0, count);
        return answer;
    }

    public static synchronized TimeZone getDefault() {
        if (Default == null) {
            TimeZone.setDefault(null);
        }
        return (TimeZone)Default.clone();
    }

    public final String getDisplayName() {
        return this.getDisplayName(false, 1, Locale.getDefault());
    }

    public final String getDisplayName(Locale locale) {
        return this.getDisplayName(false, 1, locale);
    }

    public final String getDisplayName(boolean daylightTime, int style) {
        return this.getDisplayName(daylightTime, style, Locale.getDefault());
    }

    public String getDisplayName(boolean daylightTime, int style, Locale locale) {
        if (style == 0 || style == 1) {
            boolean useDaylight = daylightTime && this.useDaylightTime();
            DateFormatSymbols data = new DateFormatSymbols(locale);
            String id = this.getID();
            String[][] zones = data.getZoneStrings();
            int i = 0;
            while (i < zones.length) {
                if (id.equals(zones[i][0])) {
                    return style == 0 ? zones[i][useDaylight ? 4 : 2] : zones[i][useDaylight ? 3 : 1];
                }
                ++i;
            }
            int offset = this.getRawOffset();
            if (useDaylight) {
                offset += this.getDSTSavings();
            }
            char sign = '+';
            if ((offset /= 60000) < 0) {
                sign = '-';
                offset = -offset;
            }
            StringBuffer buffer = new StringBuffer(9);
            buffer.append("GMT");
            buffer.append(sign);
            this.appendNumber(buffer, 2, offset / 60);
            buffer.append(':');
            this.appendNumber(buffer, 2, offset % 60);
            return buffer.toString();
        }
        throw new IllegalArgumentException();
    }

    public String getID() {
        return this.ID;
    }

    public int getDSTSavings() {
        if (this.useDaylightTime()) {
            return 3600000;
        }
        return 0;
    }

    public int getOffset(long time) {
        if (this.inDaylightTime(new Date(time))) {
            return this.getRawOffset() + this.getDSTSavings();
        }
        return this.getRawOffset();
    }

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract int getRawOffset();

    public static synchronized TimeZone getTimeZone(String name) {
        TimeZone zone;
        if (AvailableZones == null) {
            TimeZone.initializeAvailable();
        }
        if ((zone = (TimeZone)AvailableZones.get(name)) == null) {
            char sign;
            if (name.startsWith("GMT") && name.length() > 3 && ((sign = name.charAt(3)) == '+' || sign == '-')) {
                int[] position = new int[1];
                String formattedName = TimeZone.formatTimeZoneName(name, 4);
                if (formattedName == null) {
                    return (TimeZone)GMT.clone();
                }
                int hour = TimeZone.parseNumber(formattedName, 4, position);
                if (hour < 0 || hour > 23) {
                    return (TimeZone)GMT.clone();
                }
                int index = position[0];
                if (index != -1) {
                    int raw = hour * 3600000;
                    if (index < formattedName.length() && formattedName.charAt(index) == ':') {
                        int minute = TimeZone.parseNumber(formattedName, index + 1, position);
                        if (position[0] == -1 || minute < 0 || minute > 59) {
                            return (TimeZone)GMT.clone();
                        }
                        raw += minute * 60000;
                    } else if (hour >= 30 || index > 6) {
                        raw = hour / 100 * 3600000 + hour % 100 * 60000;
                    }
                    if (sign == '-') {
                        raw = -raw;
                    }
                    return new SimpleTimeZone(raw, formattedName);
                }
            }
            zone = GMT;
        }
        return (TimeZone)zone.clone();
    }

    private static String formatTimeZoneName(String name, int offset) {
        StringBuffer buf = new StringBuffer();
        int index = offset;
        int length = name.length();
        buf.append(name.substring(0, offset));
        int colonIndex = -1;
        while (index < length) {
            char c = name.charAt(index);
            if ('0' <= c && c <= '9') {
                buf.append(c);
                if (length - (index + 1) == 2) {
                    if (colonIndex != -1) {
                        return null;
                    }
                    colonIndex = buf.length();
                    buf.append(':');
                }
            } else if (c == ':') {
                if (colonIndex != -1) {
                    return null;
                }
                colonIndex = buf.length();
                buf.append(':');
            } else {
                return null;
            }
            ++index;
        }
        if (colonIndex == -1) {
            colonIndex = buf.length();
            buf.append(":00");
        }
        if (colonIndex == 5) {
            buf.insert(4, '0');
        }
        return buf.toString();
    }

    public boolean hasSameRules(TimeZone zone) {
        if (zone == null) {
            return false;
        }
        return this.getRawOffset() == zone.getRawOffset();
    }

    public abstract boolean inDaylightTime(Date var1);

    private static int parseNumber(String string, int offset, int[] position) {
        int digit;
        int index = offset;
        int length = string.length();
        int result = 0;
        while (index < length && (digit = Character.digit(string.charAt(index), 10)) != -1) {
            ++index;
            result = result * 10 + digit;
        }
        position[0] = index == offset ? -1 : index;
        return result;
    }

    public static synchronized void setDefault(TimeZone timezone) {
        if (timezone != null) {
            Default = timezone;
            return;
        }
        String zone = (String)AccessController.doPrivileged(new PriviAction("user.timezone"));
        if (zone == null || zone.length() == 0) {
            int[] tzinfo = new int[10];
            boolean[] isCustomTimeZone = new boolean[1];
            String zoneId = TimeZone.getCustomTimeZone(tzinfo, isCustomTimeZone);
            if (isCustomTimeZone[0]) {
                switch (tzinfo[1]) {
                    case 0: {
                        Default = new SimpleTimeZone(tzinfo[0], zoneId);
                        break;
                    }
                    default: {
                        Default = new SimpleTimeZone(tzinfo[0], zoneId, tzinfo[5], tzinfo[4], tzinfo[3], tzinfo[2], tzinfo[9], tzinfo[8], tzinfo[7], tzinfo[6], tzinfo[1]);
                        break;
                    }
                }
            } else {
                Default = TimeZone.getTimeZone(zoneId == null ? "" : zoneId);
                if (zoneId != null) {
                    final String id = zoneId;
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            System.setProperty("user.timezone", id);
                            return null;
                        }
                    });
                }
            }
        } else {
            Default = TimeZone.getTimeZone(zone);
        }
    }

    public void setID(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.ID = name;
    }

    public abstract void setRawOffset(int var1);

    public abstract boolean useDaylightTime();

    private static native String getCustomTimeZone(int[] var0, boolean[] var1);
}

