/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

public class Deflater {
    public static final int BEST_COMPRESSION = 9;
    public static final int BEST_SPEED = 1;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int DEFAULT_STRATEGY = 0;
    public static final int DEFLATED = 8;
    public static final int FILTERED = 1;
    public static final int HUFFMAN_ONLY = 2;
    public static final int NO_COMPRESSION = 0;
    private static final int Z_NO_FLUSH = 0;
    private static final int Z_FINISH = 4;
    private int flushParm = 0;
    private boolean noHeader = false;
    private boolean finished = false;
    int compressLevel = -1;
    int strategy = 0;
    long streamHandle = -1L;
    byte[] inputBuffer;
    int inRead = 0;
    int inLength = 0;

    static {
        Deflater.oneTimeInitialization();
    }

    private static native void oneTimeInitialization();

    public int deflate(byte[] buf) {
        return this.deflate(buf, 0, buf.length);
    }

    public synchronized int deflate(byte[] buf, int off, int nbytes) {
        if (this.streamHandle == -1L) {
            throw new IllegalStateException();
        }
        if (off <= buf.length && nbytes >= 0 && off >= 0 && buf.length - off >= nbytes) {
            return this.deflateImpl(buf, off, nbytes, this.streamHandle, this.flushParm);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    private synchronized native int deflateImpl(byte[] var1, int var2, int var3, long var4, int var6);

    private synchronized native void endImpl(long var1);

    public synchronized void end() {
        if (this.streamHandle != -1L) {
            this.endImpl(this.streamHandle);
            this.inputBuffer = null;
            this.streamHandle = -1L;
        }
    }

    protected void finalize() {
        this.end();
    }

    public synchronized void finish() {
        this.flushParm = 4;
    }

    public synchronized boolean finished() {
        return this.finished;
    }

    public synchronized int getAdler() {
        if (this.streamHandle == -1L) {
            throw new IllegalStateException();
        }
        return this.getAdlerImpl(this.streamHandle);
    }

    private synchronized native int getAdlerImpl(long var1);

    public synchronized int getTotalIn() {
        if (this.streamHandle == -1L) {
            throw new IllegalStateException();
        }
        return this.getTotalInImpl(this.streamHandle);
    }

    private synchronized native int getTotalInImpl(long var1);

    public synchronized int getTotalOut() {
        if (this.streamHandle == -1L) {
            throw new IllegalStateException();
        }
        return this.getTotalOutImpl(this.streamHandle);
    }

    private synchronized native int getTotalOutImpl(long var1);

    public boolean needsInput() {
        if (this.inputBuffer == null) {
            return true;
        }
        return this.inRead == this.inLength;
    }

    public synchronized void reset() {
        if (this.streamHandle == -1L) {
            throw new NullPointerException();
        }
        this.flushParm = 0;
        this.finished = false;
        this.resetImpl(this.streamHandle);
        this.inputBuffer = null;
    }

    private synchronized native void resetImpl(long var1);

    public void setDictionary(byte[] buf) {
        this.setDictionary(buf, 0, buf.length);
    }

    public synchronized void setDictionary(byte[] buf, int off, int nbytes) {
        if (this.streamHandle == -1L) {
            throw new IllegalStateException();
        }
        if (off > buf.length || nbytes < 0 || off < 0 || buf.length - off < nbytes) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.setDictionaryImpl(buf, off, nbytes, this.streamHandle);
    }

    private synchronized native void setDictionaryImpl(byte[] var1, int var2, int var3, long var4);

    public void setInput(byte[] buf) {
        this.setInput(buf, 0, buf.length);
    }

    public synchronized void setInput(byte[] buf, int off, int nbytes) {
        if (this.streamHandle == -1L) {
            throw new IllegalStateException();
        }
        if (off <= buf.length && nbytes >= 0 && off >= 0 && buf.length - off >= nbytes) {
            this.inLength = nbytes;
            this.inRead = 0;
            if (this.inputBuffer == null) {
                this.setLevelsImpl(this.compressLevel, this.strategy, this.streamHandle);
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.inputBuffer = buf;
        this.setInputImpl(buf, off, nbytes, this.streamHandle);
    }

    private synchronized native void setLevelsImpl(int var1, int var2, long var3);

    private synchronized native void setInputImpl(byte[] var1, int var2, int var3, long var4);

    public synchronized void setLevel(int level) {
        if (level < -1 || level > 9) {
            throw new IllegalArgumentException();
        }
        if (this.inputBuffer != null) {
            throw new IllegalStateException();
        }
        this.compressLevel = level;
    }

    public synchronized void setStrategy(int strategy) {
        if (strategy < 0 || strategy > 2) {
            throw new IllegalArgumentException();
        }
        if (this.inputBuffer != null) {
            throw new IllegalStateException();
        }
        this.strategy = strategy;
    }

    public Deflater() {
        this(-1, false);
    }

    public Deflater(int level, boolean noHeader) {
        if (level < -1 || level > 9) {
            throw new IllegalArgumentException();
        }
        this.compressLevel = level;
        this.noHeader = noHeader;
        this.streamHandle = this.createStream(this.compressLevel, this.strategy, noHeader);
    }

    public Deflater(int level) {
        this(level, false);
    }

    private native long createStream(int var1, int var2, boolean var3);
}

