/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import com.ibm.oti.jce.support.Msg;
import com.ibm.oti.util.ASN1Decoder;
import com.ibm.oti.util.ASN1Encoder;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class EncryptedPrivateKeyInfo {
    private String algorithmName;
    private final byte[] encryptedData;
    private byte[] algParamsEnc;
    private byte[] encoding = null;
    private AlgorithmParameters algorithmParameters;
    private static String[] algNames = new String[]{"RSA", "DES", "DESede", "Blowfish", "AES", "PBEwithMD5andDES", "PBEwithMD5andTripleDES"};
    private static int[][] algOIDs = new int[][]{{1, 2, 840, 113549, 1, 1, 1}, {1, 3, 36, 3, 1, 1, 2}, {1, 3, 36, 3, 1, 3, 2}, {3, 22, 68}, {2, 16, 840, 1, 101, 3, 4, 1}, {1, 2, 840, 113549, 1, 5, 3}, {3, 22, 69}};

    public EncryptedPrivateKeyInfo(byte[] encodedInfo) throws IOException {
        if (encodedInfo == null) {
            throw new NullPointerException();
        }
        if (encodedInfo.length < 1) {
            throw new IllegalArgumentException();
        }
        this.encoding = encodedInfo;
        Object[] decodedStructure = (Object[])ASN1Decoder.getDecoded(encodedInfo);
        if (decodedStructure.length != 2) {
            throw new IOException(Msg.getString("JCE006"));
        }
        Object[] encryptionAlgorithm = (Object[])decodedStructure[0];
        if (encryptionAlgorithm.length != 2) {
            throw new IOException(Msg.getString("JCE006"));
        }
        int[] OID = (int[])encryptionAlgorithm[0];
        this.algorithmName = EncryptedPrivateKeyInfo.mapOIDToAlgName(OID);
        Object parameters = encryptionAlgorithm[1];
        this.algParamsEnc = (byte[])(parameters != null ? ASN1Encoder.getEncoding(parameters) : null);
        this.encryptedData = (byte[])decodedStructure[1];
        this.createAlgorithmParameters();
    }

    public EncryptedPrivateKeyInfo(String algorithmName, byte[] encryptedData) throws NoSuchAlgorithmException {
        if (algorithmName == null || encryptedData == null) {
            throw new NullPointerException();
        }
        if (encryptedData.length < 1) {
            throw new IllegalArgumentException();
        }
        try {
            Provider[] providers = Security.getProviders("Cipher." + algorithmName);
            if (providers == null) {
                throw new NoSuchAlgorithmException();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new NoSuchAlgorithmException(algorithmName);
        }
        this.algorithmName = algorithmName;
        this.encryptedData = encryptedData;
        this.algParamsEnc = null;
        this.algorithmParameters = null;
    }

    public EncryptedPrivateKeyInfo(AlgorithmParameters params, byte[] encryptedData) throws NoSuchAlgorithmException {
        if (params == null || encryptedData == null) {
            throw new NullPointerException();
        }
        if (encryptedData.length < 1) {
            throw new IllegalArgumentException();
        }
        this.algorithmName = params.getAlgorithm();
        this.encryptedData = encryptedData;
        try {
            this.algParamsEnc = params.getEncoded("ASN.1");
        }
        catch (IOException iOException) {
            this.algParamsEnc = null;
        }
        this.algorithmParameters = params;
    }

    public String getAlgName() {
        return this.algorithmName;
    }

    public AlgorithmParameters getAlgParameters() {
        return this.algorithmParameters;
    }

    private void createAlgorithmParameters() {
        try {
            this.algorithmParameters = AlgorithmParameters.getInstance(this.algorithmName);
            this.algorithmParameters.init(this.algParamsEnc);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.algorithmParameters = null;
        }
        catch (IOException iOException) {
            this.algorithmParameters = null;
        }
    }

    public byte[] getEncryptedData() {
        return (byte[])this.encryptedData.clone();
    }

    public PKCS8EncodedKeySpec getKeySpec(Cipher cipher) throws InvalidKeySpecException {
        try {
            if (cipher.cipherOpMode != 2) {
                throw new InvalidKeySpecException(Msg.getString("JCE008"));
            }
            byte[] decrypted = cipher.doFinal(this.encryptedData);
            return new PKCS8EncodedKeySpec(decrypted);
        }
        catch (IllegalStateException e) {
            throw new InvalidKeySpecException(e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw new InvalidKeySpecException(e.getMessage());
        }
        catch (BadPaddingException e) {
            throw new InvalidKeySpecException(e.getMessage());
        }
    }

    public byte[] getEncoded() throws IOException {
        if (this.encoding != null) {
            return (byte[])this.encoding.clone();
        }
        this.encoding = this.encodeInfo();
        return (byte[])this.encoding.clone();
    }

    private static String mapOIDToAlgName(int[] OID) {
        int i = 0;
        while (i < algOIDs.length) {
            if (EncryptedPrivateKeyInfo.oidValuesMatch(algOIDs[i], OID)) {
                return algNames[i];
            }
            ++i;
        }
        StringBuffer result = new StringBuffer();
        int i2 = 0;
        while (i2 < OID.length - 1) {
            result.append(OID[i2]);
            result.append(".");
            ++i2;
        }
        result.append(OID[OID.length - 1]);
        return result.toString();
    }

    private static int[] mapAlgNameToOID(String algName) throws NoSuchAlgorithmException {
        int i = 0;
        while (i < algNames.length) {
            if (algName.toLowerCase().equals(algNames[i].toLowerCase())) {
                return algOIDs[i];
            }
            ++i;
        }
        StringTokenizer st = new StringTokenizer(algName, ".");
        int tokenCount = st.countTokens();
        int[] OID = new int[tokenCount];
        int i2 = 0;
        while (i2 < tokenCount) {
            try {
                OID[i2] = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new NoSuchAlgorithmException(Msg.getString("JCE009"));
            }
            ++i2;
        }
        return OID;
    }

    private static boolean oidValuesMatch(int[] id1, int[] id2) {
        if (id1.length != id2.length) {
            return false;
        }
        int i = 0;
        while (i < id1.length) {
            if (id1[i] != id2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private byte[] encodeInfo() throws IOException {
        Object[] algIdentifier = new Object[2];
        try {
            algIdentifier[0] = EncryptedPrivateKeyInfo.mapAlgNameToOID(this.algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage());
        }
        algIdentifier[1] = this.algParamsEnc != null ? new ASN1Decoder.Data(this.algParamsEnc) : null;
        Object[] encPrivKeyInf = new Object[]{algIdentifier, this.encryptedData};
        byte[] encoding = ASN1Encoder.getEncoding(encPrivKeyInf);
        return encoding;
    }
}

