/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io;

import com.ibm.oti.connection.CreateConnection;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.InputConnection;
import javax.microedition.io.OutputConnection;

public class Connector {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int READ_WRITE = 3;

    private Connector() {
    }

    public static Connection open(String spec) throws IOException {
        String scheme = Connector.getScheme(spec);
        Class connectionClass = Connector.findConnectionClass(scheme.toLowerCase());
        return Connector.open(spec, 3, false, scheme, connectionClass);
    }

    public static Connection open(String spec, int access) throws IOException {
        String scheme = Connector.getScheme(spec);
        Class connectionClass = Connector.findConnectionClass(scheme.toLowerCase());
        return Connector.open(spec, access, false, scheme, connectionClass);
    }

    public static Connection open(String spec, int access, boolean timeout) throws IOException {
        String scheme = Connector.getScheme(spec);
        Class connectionClass = Connector.findConnectionClass(scheme.toLowerCase());
        return Connector.open(spec, access, timeout, scheme, connectionClass);
    }

    public static DataInputStream openDataInputStream(String spec) throws IOException {
        String scheme = Connector.getScheme(spec);
        Class connectionClass = Connector.findConnectionClass(scheme.toLowerCase());
        return new DataInputStream(Connector.openInputStream(spec, scheme, connectionClass));
    }

    public static DataOutputStream openDataOutputStream(String spec) throws IOException {
        String scheme = Connector.getScheme(spec);
        Class connectionClass = Connector.findConnectionClass(scheme.toLowerCase());
        return new DataOutputStream(Connector.openOutputStream(spec, scheme, connectionClass));
    }

    public static InputStream openInputStream(String spec) throws IOException {
        String scheme = Connector.getScheme(spec);
        Class connectionClass = Connector.findConnectionClass(scheme.toLowerCase());
        return Connector.openInputStream(spec, scheme, connectionClass);
    }

    private static InputStream openInputStream(String spec, String scheme, Class connectionClass) throws IOException {
        Connection connection = Connector.open(spec, 1, false, scheme, connectionClass);
        try {
            if (!(connection instanceof InputConnection)) {
                throw new IllegalArgumentException(Msg.getString("K0004"));
            }
            InputStream inputStream = ((InputConnection)connection).openInputStream();
            return inputStream;
        }
        finally {
            connection.close();
        }
    }

    public static OutputStream openOutputStream(String spec) throws IOException {
        String scheme = Connector.getScheme(spec);
        Class connectionClass = Connector.findConnectionClass(scheme.toLowerCase());
        return Connector.openOutputStream(spec, scheme, connectionClass);
    }

    private static OutputStream openOutputStream(String spec, String scheme, Class connectionClass) throws IOException {
        Connection connection = Connector.open(spec, 2, false, scheme, connectionClass);
        try {
            if (!(connection instanceof OutputConnection)) {
                throw new IllegalArgumentException(Msg.getString("K0005"));
            }
            OutputStream outputStream = ((OutputConnection)connection).openOutputStream();
            return outputStream;
        }
        finally {
            connection.close();
        }
    }

    private static Connection open(String spec, int access, boolean timeout, String scheme, Class connectionClass) throws IOException {
        if (access != 1 && access != 2 && access != 3) {
            throw new IllegalArgumentException(Msg.getString("K0198"));
        }
        CreateConnection connection = null;
        try {
            connection = (CreateConnection)connectionClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new ConnectionNotFoundException(Msg.getString("K0003", connectionClass));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ConnectionNotFoundException(Msg.getString("K0003", connectionClass));
        }
        spec = spec.substring(scheme.length() + 1);
        return connection.setParameters2(spec, access, timeout);
    }

    private static String getScheme(String spec) throws IllegalArgumentException {
        if (spec == null) {
            throw new IllegalArgumentException(Msg.getString("K0067"));
        }
        int index = spec.indexOf(58);
        if (index == -1) {
            throw new IllegalArgumentException(Msg.getString("K0001", spec));
        }
        String scheme = spec.substring(0, index);
        if (scheme.length() == 0) {
            throw new IllegalArgumentException(Msg.getString("K0001", spec));
        }
        return scheme;
    }

    private static Class findConnectionClass(String scheme) throws ConnectionNotFoundException {
        String packageList = (String)AccessController.doPrivileged(new PriviAction("microedition.connection.pkgs"));
        if (packageList != null) {
            int last = 0;
            int index = packageList.indexOf(124);
            int end = packageList.length();
            while (last < end) {
                if (index == -1) {
                    index = end;
                }
                String className = String.valueOf(packageList.substring(last, index)) + "." + scheme + ".Connection";
                try {
                    return Class.forName(className, true, ClassLoader.getSystemClassLoader());
                }
                catch (Exception exception) {
                    last = index + 1;
                    index = packageList.indexOf(124, last);
                }
            }
        }
        try {
            String className = "com.ibm.oti.connection." + scheme + ".Connection";
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (scheme.equals("file")) {
                try {
                    String className = "com.ibm.oti.connection.file.base.Connection";
                    return Class.forName(className);
                }
                catch (ClassNotFoundException classNotFoundException2) {}
            }
            throw new ConnectionNotFoundException(Msg.getString("K0002", scheme));
        }
    }
}

