/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.iptransport.DscpGroupMoGen;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.mao.AttrValueNotUniqueException;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;

public class DscpGroupMoImpl
extends DscpGroupMoGen {
    private int dscpListLength = 0;

    public DscpGroupMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, FroProxy froProxy) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, attrList);
    }

    public DscpGroupMoImpl(MoData moData, FroProxy froProxy) throws MoNameAlreadyTakenException {
        super(moData, froProxy);
    }

    protected int[] validateDscpValues(AttrList attrList, int[] nArray, Coordinator coordinator) throws MoAccessException {
        int[] nArray2 = super.validateDscpValues(attrList, nArray, coordinator);
        this.checkForUniqueElements(nArray2);
        this.dscpListLength = nArray2.length;
        return nArray2;
    }

    protected int getIpIfFroId(Coordinator coordinator) throws MoAccessException {
        if (this.getParent() instanceof IpInterfaceMo) {
            return ((IpInterfaceMo)this.getParent()).getFroId(coordinator);
        }
        return ((Ipv6InterfaceMo)this.getParent()).getFroId(coordinator);
    }

    protected int getPiuId(Coordinator coordinator) throws MoAccessException {
        if (this.getParent() instanceof IpInterfaceMo) {
            return PiuUtils.findPiuParentFroId((ManagedObject)this.getParent());
        }
        return PiuUtils.findPiuParentFroId((ManagedObject)((Ipv6InterfaceMo)this.getParent()).getEthernetRef(coordinator));
    }

    protected int getLengthOfDscpList(Coordinator coordinator) throws MoAccessException {
        return this.dscpListLength;
    }

    private void checkForUniqueElements(int[] nArray) throws MoAccessException {
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = i + 1; j < nArray.length; ++j) {
                if (nArray[j] != nArray[i]) continue;
                throw new AttrValueNotUniqueException("dscpValues", "DscpGroup");
            }
        }
    }
}

