/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.ArrayList;
import java.util.Map;
import se.ericsson.cello.equipment.CppBoardMarker;
import se.ericsson.cello.equipment.PiuDeviceMo;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.iptransport.ExchangeTerminalIpMo;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class ExchangeTerminalIpMoImpl
extends CelloMao
implements ExchangeTerminalIpMo,
FroInfo,
CppBoardMarker,
Reservable {
    private MoData data;
    private MaoFroIndicationHandler indicationHandler = null;
    private static final String PIU_FRO_ID = "piuFroId";
    private static final int MO_DATA_REVISION_13 = 13000;
    private static final int MO_DATA_REVISION_LATEST = 13000;
    private static final int MAXIMUM_NUBMER_OF_SIBLINGS = 1;
    private FroProxy etIpProxy = null;
    static /* synthetic */ Class class$java$lang$String;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"ExchangeTerminalIp", (String)string);
        MoAttributeValidator.checkParents((ManagedObject)managedObject, (String[])new String[]{"PlugInUnit", "PiuDevice"});
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"ExchangeTerminalIp", (int)1);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"ExchangeTerminalIp", (int)128, (int)0);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"ExchangeTerminalIp");
        return new ExchangeTerminalIpMoImpl(managedObject, string, string2, coordinator, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    private ExchangeTerminalIpMoImpl(ManagedObject managedObject, String string, String string2, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "ExchangeTerminalIp", string, coordinator, initialMaoContext);
        this.etIpProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.data = initialMaoContext.createMoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        int n = this.getPiuFroId(coordinator);
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        arrayList.add(new SignedIntParameter(PIU_FRO_ID, n));
        FroData froData = this.etIpProxy.create(coordinator, arrayList);
        int n2 = froData.getFroId();
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n2));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n2);
        this.data.setRevision(13000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    protected int getPiuFroId(Coordinator coordinator) throws MoAccessException {
        int n = 0;
        ManagedObject managedObject = this.getParent();
        if (managedObject instanceof PiuDeviceMo) {
            n = ((PiuDeviceMo)managedObject).getFroId(coordinator);
        } else if (managedObject instanceof PlugInUnitMo) {
            n = ((PlugInUnitMo)managedObject).getFroId(coordinator);
        } else {
            throw new IllegalParentException("ExchangeTerminalIp");
        }
        return n;
    }

    public ExchangeTerminalIpMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        this.data = moData;
        this.etIpProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(13000);
        moDataRecoveryHelper.assertAttribute("froId");
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.etIpProxy.delete(coordinator, this.getFroId(coordinator), null);
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        this.deletePgmChildren(coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    private void deletePgmChildren(Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            if (!managedObject.getType().equals("Program")) continue;
            managedObject.delete(coordinator);
        }
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public String getType() {
        return "ExchangeTerminalIp";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("froId", coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("reservedBy", coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                map = this.readAttrsFromFro(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                map = this.readAttrsFromFro(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("availabilityStatus");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("froId")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator));
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "ExchangeTerminalIp");
        }
        return objectArray;
    }

    private Map readAttrsFromFro(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            map = this.etIpProxy.getAttributes(coordinator, this.getFroId(null));
        }
        return map;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? ExchangeTerminalIpMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "ExchangeTerminalIp");
                }
            } else {
                throw new NoSuchAttributeException(stringArray[i], "ExchangeTerminalIp");
            }
            MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"ExchangeTerminalIp", (int)128, (int)0);
            ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
        }
    }
}

