/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.faultmanagement.Event;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.iptransport.EthernetSwitchBuildIF;
import se.ericsson.cello.iptransport.InternalEthernetPortMo;
import se.ericsson.cello.iptransport.ipcp_internal_eth_port_lh;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericEventInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class InternalEthernetPortMoImpl
extends CelloMao
implements InternalEthernetPortMo,
FroInfo {
    private static final int ETHERNET_2_DIX = 0;
    protected static final int IEEE_802_3_LLC_SNAP = 1;
    private static final int PBIT_0 = 0;
    private static final int PBIT_1 = 1;
    private static final int PBIT_3 = 3;
    private static final int PBIT_4 = 4;
    private static final int PBIT_5 = 5;
    private static final int PBIT_6 = 6;
    private static final int PBIT_MIN = 0;
    private static final int PBIT_MAX = 7;
    private static final int DSCP_MIN = 0;
    private static final int DSCP_MAX = 63;
    private static final String PIU_FRO_ID = "piuFroId";
    private static final String BH_ID = "bhFroId";
    private static final String EXH_FRO_ID = "exhFroId";
    private static final int INTERNAL_ETH_PORT_LH_FLOODING = 4;
    private MoData data;
    private static final int MO_DATA_REVISION_6 = 6000;
    private static final int MO_DATA_REVISION_LATEST = 6000;
    private static final int MAX_NO_INTERNAL_ETHERNET_PORT = 1;
    private FroProxy internalEthernetPortProxy = null;
    private static TagNameDictionary tnd = TagNameDictionaries.get((ResourceBundle)ResourceBundle.getBundle(ipcp_internal_eth_port_lh.class.getName()));
    private MaoFroIndicationHandler indicationHandler = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"InternalEthernetPort", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"ExchangeTerminalIp");
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"InternalEthernetPort", (int)1);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"InternalEthernetPort", (int)128, (int)0);
        ManagedObject managedObject3 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"ethernetSwitchRef", (AttrList)attrList, (boolean)true, (Class[])new Class[]{EthernetSwitchBuildIF.class}, (String)"InternalEthernetPort");
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"frameFormat", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)1, (String)"InternalEthernetPort");
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"configPbitArp", (AttrList)attrList, (boolean)false, (int)6, (int)0, (int)7, (String)"InternalEthernetPort");
        Struct[] structArray = InternalEthernetPortMoImpl.checkAndGetDscpPbitMap(attrList);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"InternalEthernetPort");
        SignedIntParameter signedIntParameter = new SignedIntParameter("frameFormat", n);
        arrayList.add(signedIntParameter);
        ArrayParameter arrayParameter = InternalEthernetPortMoImpl.makeArrayParameter(structArray);
        arrayList.add(arrayParameter);
        int n3 = ((FroInfo)managedObject3).getFroId(coordinator);
        SignedIntParameter signedIntParameter2 = new SignedIntParameter(EXH_FRO_ID, n3);
        arrayList.add(signedIntParameter2);
        int n4 = ((FroInfo)managedObject).getFroId(coordinator);
        SignedIntParameter signedIntParameter3 = new SignedIntParameter(BH_ID, n4);
        arrayList.add(signedIntParameter3);
        int n5 = PiuUtils.findPiuParentFroId((ManagedObject)managedObject);
        SignedIntParameter signedIntParameter4 = new SignedIntParameter(PIU_FRO_ID, n5);
        arrayList.add(signedIntParameter4);
        SignedIntParameter signedIntParameter5 = new SignedIntParameter("configPbitArp", n2);
        arrayList.add(signedIntParameter5);
        InternalEthernetPortMoImpl.validateEthernetSwitchRef(managedObject3, managedObject);
        return new InternalEthernetPortMoImpl(managedObject, string, string2, managedObject3, arrayList, coordinator, froProxy, maoFroIndicationHandler);
    }

    private InternalEthernetPortMoImpl(ManagedObject managedObject, String string, String string2, ManagedObject managedObject2, ArrayList arrayList, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "InternalEthernetPort", string, coordinator);
        this.indicationHandler = maoFroIndicationHandler;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.internalEthernetPortProxy = froProxy;
        ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        FroData froData = this.internalEthernetPortProxy.create(coordinator, (Collection)arrayList);
        int n = froData.getFroId();
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("ethernetSwitchRef", false, managedObject2));
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n);
        this.data.setRevision(6000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public InternalEthernetPortMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.internalEthernetPortProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(6000);
        moDataRecoveryHelper.assertAttribute("froId");
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("ethernetSwitchRef");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ManagedObject managedObject = this.getEthernetSwitchRef(coordinator);
        ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        this.internalEthernetPortProxy.delete(coordinator, this.getFroId(coordinator), null);
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public Struct[] getDscpPbitMap(Coordinator coordinator) throws MoAccessException {
        return (Struct[])this.getAttribute("dscpPbitMap", coordinator);
    }

    public ManagedObject getEthernetSwitchRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("ethernetSwitchRef", coordinator);
    }

    public int getFrameFormat(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("frameFormat", coordinator);
    }

    public void setFrameFormat(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("frameFormat", new Integer(n), coordinator);
    }

    public int getConfigPbitArp(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("configPbitArp", coordinator);
    }

    public void setConfigPbitArp(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("configPbitArp", new Integer(n), coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getPmDot1qTpVlanPortInDiscardsLink(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmDot1qTpVlanPortInDiscardsLink", coordinator);
    }

    public int getPmIfInBroadcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInBroadcastPkts", coordinator);
    }

    public int getPmIfInDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInDiscards", coordinator);
    }

    public int getPmIfInErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInErrors", coordinator);
    }

    public int getPmIfInMulticastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInMulticastPkts", coordinator);
    }

    public int getPmIfInOctetsHi(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInOctetsHi", coordinator);
    }

    public int getPmIfInOctetsLo(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInOctetsLo", coordinator);
    }

    public int getPmIfInUcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInUcastPkts", coordinator);
    }

    public int getPmIfInUnknownProtos(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInUnknownProtos", coordinator);
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(tnd);
            StringParameter stringParameter = (StringParameter)map.get("macAddress");
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (stringParameter != null) {
                arrayList.add("macAddress");
                arrayList2.add(stringParameter.getValue());
            }
            if (arrayList.size() == 0) {
                MessageLog.traceError(this.getClass(), (String)"Unknown attribute in parameterChanged()");
            }
            NotificationSender.instance().pushAVC((ManagedObject)this, arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray());
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute not in property file");
        }
    }

    public int getPmIfOutBroadcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutBroadcastPkts", coordinator);
    }

    public int getPmIfOutDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutDiscards", coordinator);
    }

    public int getPmIfOutErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutErrors", coordinator);
    }

    public int getPmIfOutMulticastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutMulticastPkts", coordinator);
    }

    public int getPmIfOutOctetsHi(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutOctetsHi", coordinator);
    }

    public int getPmIfOutOctetsLo(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutOctetsLo", coordinator);
    }

    public int getPmIfOutUcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutUcastPkts", coordinator);
    }

    public String getInternalEthernetPortId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("InternalEthernetPortId", coordinator);
    }

    public String[] getCurrentPmRegister(Coordinator coordinator) throws MoAccessException {
        return (String[])this.getAttribute("currentPmRegister", coordinator);
    }

    public String getMacAddress(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("macAddress", coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase("froId")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ethernetSwitchRef")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("ethernetSwitchRef")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("dscpPbitMap")) {
                map = this.getAttrFromRes(map, coordinator);
                objectArray[i] = this.convertArray2Struct((ArrayParameter)map.get("dscpPbitMap"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("frameFormat")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("frameFormat");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("configPbitArp")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("configPbitArp");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("macAddress")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (StringParameter)map.get("macAddress");
                objectArray[i] = signedIntParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmDot1qTpVlanPortInDiscardsLink")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmDot1qTpVlanPortInDiscardsLink", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInBroadcastPkts")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfInBroadcastPkts", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInDiscards")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfInDiscards", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInErrors")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfInErrors", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInMulticastPkts")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfInMulticastPkts", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInBroadcastPkts")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfInBroadcastPkts", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInOctetsHi")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfInOctetsHi", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfOutErrors")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfOutErrors", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInOctetsLo")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfInOctetsLo", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInUcastPkts")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfInUcastPkts", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInUnknownProtos")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfInUnknownProtos", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfOutBroadcastPkts")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfOutBroadcastPkts", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfOutDiscards")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfOutDiscards", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfOutErrors")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfOutErrors", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfOutMulticastPkts")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfOutMulticastPkts", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfOutOctetsHi")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfOutOctetsHi", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfOutOctetsLo")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfOutOctetsLo", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfOutUcastPkts")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfOutUcastPkts", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("currentPmRegister")) {
                objectArray[i] = super.getCurrentPmRegister(coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "InternalEthernetPort");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Hashtable<String, SignedIntParameter> hashtable = new Hashtable<String, SignedIntParameter>();
        int n = 0;
        Object var6_6 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? InternalEthernetPortMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "InternalEthernetPort");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"InternalEthernetPort", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("frameFormat")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? InternalEthernetPortMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("frameFormat", "InternalEthernetPort");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"frameFormat", (int)n, (int)0, (int)1, (String)"InternalEthernetPort");
                this.checkFrameFormat(n, coordinator);
                hashtable.put("frameFormat", new SignedIntParameter("frameFormat", n));
                this.sendNotification("frameFormat", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("configPbitArp")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? InternalEthernetPortMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("configPbitArp", "InternalEthernetPort");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"configPbitArp", (int)n, (int)0, (int)7, (String)"InternalEthernetPort");
                hashtable.put("configPbitArp", new SignedIntParameter("configPbitArp", n));
                this.sendNotification("configPbitArp", new Integer(n), coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "InternalEthernetPort");
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(hashtable.values());
        if (arrayList != null) {
            this.internalEthernetPortProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    private Hashtable prepareSetFroAttr(Coordinator coordinator) throws MoAccessException {
        Hashtable hashtable = new Hashtable();
        Map map = this.internalEthernetPortProxy.getAttributes(coordinator, this.getFroId(coordinator), null);
        hashtable.put("dscpPbitMap", map.get("dscpPbitMap"));
        hashtable.put("frameFormat", map.get("frameFormat"));
        hashtable.put("configPbitArp", map.get("configPbitArp"));
        return hashtable;
    }

    public void actionSetDscpPbit(int n, int n2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n < 0 || n > 63) {
            throw new ValueOutOfRangeException("dscp", "InternalEthernetPort");
        }
        if (n2 < 0 || n2 > 7) {
            throw new ValueOutOfRangeException("pbit", "InternalEthernetPort");
        }
        Hashtable hashtable = new Hashtable();
        Map map = this.internalEthernetPortProxy.getAttributes(coordinator, this.getFroId(coordinator), null);
        hashtable.put("dscpPbitMap", map.get("dscpPbitMap"));
        Struct[] structArray = this.convertArray2Struct((ArrayParameter)hashtable.get("dscpPbitMap"));
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.clear();
        int n3 = structArray.length;
        for (int i = 0; i < n3; ++i) {
            hashMap.put(structArray[i].getValue("dscp"), structArray[i].getValue("pbit"));
        }
        hashMap.put(new Integer(n), new Integer(n2));
        Struct[] structArray2 = InternalEthernetPortMoImpl.convertHashMap2StructArr(hashMap);
        InternalEthernetPortMoImpl.checkDscpPbitMapRanges(structArray2);
        hashtable.put("dscpPbitMap", InternalEthernetPortMoImpl.makeArrayParameter(structArray2));
        ArrayList arrayList = new ArrayList();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            arrayList.add(hashtable.get(enumeration.nextElement()));
        }
        this.internalEthernetPortProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        this.sendNotification("dscpPbitMap", structArray2, coordinator);
    }

    public void eventRaised(MaoFroGenericEventInd maoFroGenericEventInd) {
        Map map = null;
        try {
            map = maoFroGenericEventInd.getParameters(tnd);
        }
        catch (Exception exception) {
            MessageLog.traceError(this.getClass(), (String)("Unable to read parameters from event indication in " + this.getLocalDistinguishedName()), (Throwable)exception);
        }
        if (maoFroGenericEventInd.getSpecificEvent() == 4) {
            String string = ((StringParameter)map.get("additionalText")).getValue();
            new Event("InternalEthernetPort", this.getFullDistinguishedName(), "0", "", "Extensive Ethernet frame flooding", string, null);
        } else {
            MessageLog.info(this.getClass(), (String)("Unknown specificEvent: " + maoFroGenericEventInd.getSpecificEvent() + " sent in signal MaoFroGenericEventInd"));
        }
    }

    public String getType() {
        return "InternalEthernetPort";
    }

    private static Struct[] checkAndGetDscpPbitMap(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("dscpPbitMap");
        if (n == -1) {
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            hashMap.clear();
            block7: for (int i = 0; i < 64; ++i) {
                switch (i) {
                    case 10: 
                    case 12: 
                    case 14: {
                        hashMap.put(new Integer(i), new Integer(1));
                        continue block7;
                    }
                    case 18: 
                    case 20: 
                    case 22: {
                        hashMap.put(new Integer(i), new Integer(3));
                        continue block7;
                    }
                    case 26: 
                    case 28: 
                    case 30: {
                        hashMap.put(new Integer(i), new Integer(4));
                        continue block7;
                    }
                    case 34: 
                    case 36: 
                    case 38: {
                        hashMap.put(new Integer(i), new Integer(5));
                        continue block7;
                    }
                    case 46: {
                        hashMap.put(new Integer(i), new Integer(6));
                        continue block7;
                    }
                    default: {
                        hashMap.put(new Integer(i), new Integer(0));
                    }
                }
            }
            return InternalEthernetPortMoImpl.convertHashMap2StructArr(hashMap);
        }
        if (!(attrList.getValue(n) instanceof Struct[])) {
            throw new WrongAttributeTypeException("dscpPbitMap", "InternalEthernetPort");
        }
        Struct[] structArray = (Struct[])attrList.getValue(n);
        InternalEthernetPortMoImpl.checkDscpPbitMapRanges(structArray);
        attrList.removeElementAt(n);
        return structArray;
    }

    private static Struct[] convertHashMap2StructArr(Map map) throws MoAccessException {
        Struct[] structArray = new Struct[64];
        String[] stringArray = new String[]{"dscp", "pbit"};
        for (int i = 0; i < 64; ++i) {
            Integer n = new Integer(i);
            Object[] objectArray = new Object[]{new Integer(i), map.get(n)};
            StructImpl structImpl = new StructImpl(stringArray, objectArray);
            structArray[i] = structImpl;
        }
        return structArray;
    }

    private static void checkDscpPbitMapRanges(Struct[] structArray) throws MoAccessException {
        int n;
        int n2 = structArray.length;
        if (n2 != 64) {
            throw new ValueOutOfRangeException("dscpPbitMap", "InternalEthernetPort");
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.clear();
        for (n = 0; n < n2; ++n) {
            if (!(structArray[n].getValue("dscp") instanceof Integer)) {
                throw new WrongAttributeTypeException("dscp", "InternalEthernetPort");
            }
            if (!(structArray[n].getValue("pbit") instanceof Integer)) {
                throw new WrongAttributeTypeException("pbit", "InternalEthernetPort");
            }
            hashMap.put(structArray[n].getValue("dscp"), structArray[n].getValue("pbit"));
        }
        n2 = hashMap.size();
        for (n = 0; n < n2; ++n) {
            Integer n3 = new Integer(n);
            if (!hashMap.containsKey(n3)) {
                throw new ValueOutOfRangeException("dscp", "InternalEthernetPort");
            }
            if ((Integer)hashMap.get(n3) >= 0 && (Integer)hashMap.get(n3) <= 7) continue;
            throw new ValueOutOfRangeException("pbit", "InternalEthernetPort");
        }
    }

    private Struct[] convertArray2Struct(ArrayParameter arrayParameter) throws MoAccessException {
        Struct[] structArray = new Struct[arrayParameter.size()];
        String[] stringArray = new String[]{"dscp", "pbit"};
        for (int i = 0; i < arrayParameter.size(); ++i) {
            Object[] objectArray = new Object[2];
            StructParameter structParameter = (StructParameter)arrayParameter.get(i);
            objectArray[0] = new Integer(((SignedIntParameter)structParameter.get("dscp")).getValue());
            objectArray[1] = new Integer(((SignedIntParameter)structParameter.get("pbit")).getValue());
            StructImpl structImpl = new StructImpl(stringArray, objectArray);
            structArray[i] = structImpl;
        }
        return structArray;
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }

    private static ArrayParameter makeArrayParameter(Struct[] structArray) throws MoAccessException {
        ArrayParameter arrayParameter = new ArrayParameter("dscpPbitMap");
        for (int i = 0; i < structArray.length; ++i) {
            StructParameter structParameter = new StructParameter("dscpPbitPair");
            structParameter.add((Parameter)new SignedIntParameter("dscp", ((Integer)structArray[i].getValue("dscp")).intValue()));
            structParameter.add((Parameter)new SignedIntParameter("pbit", ((Integer)structArray[i].getValue("pbit")).intValue()));
            arrayParameter.add((Parameter)structParameter);
        }
        return arrayParameter;
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    private Map getFroAttributes(Coordinator coordinator) throws MoAccessException {
        Map map = this.internalEthernetPortProxy.getAttributes(coordinator, this.getFroId(coordinator));
        return map;
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.getFroAttributes(coordinator);
        }
        return map;
    }

    private void checkFrameFormat(int n, Coordinator coordinator) throws MoAccessException {
        if (n == 1) {
            int n2 = 0;
            ManagedObject managedObject = null;
            MoIterator moIterator = this.getChildren();
            while (moIterator != null && moIterator.hasMoreElements()) {
                managedObject = moIterator.nextMo();
                if (!managedObject.getType().equals("IpInterface") || (n2 = ((Integer)managedObject.getAttribute("mtu", coordinator)).intValue()) <= 1492) continue;
                throw new ValueOutOfRangeException("mtu in IpInterface is set to " + n2 + ". The value on " + "mtu" + " can not exceed " + 1492 + " when changing " + "frameFormat" + " to " + n, "InternalEthernetPort");
            }
        }
    }

    private static void validateEthernetSwitchRef(ManagedObject managedObject, ManagedObject managedObject2) throws MoAccessException {
        if (!managedObject.getParent().getLocalDistinguishedName().equals(managedObject2.getLocalDistinguishedName())) {
            throw new MoCanNotBeCreatedException("Reference to EthernetSwitch under a different parent is not allowed for InternalEthernetPort");
        }
    }
}

