/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.equipment.GeneralProcessorUnitMo;
import se.ericsson.cello.equipment.IpAccessHostGpbBuildIF;
import se.ericsson.cello.equipment.PlugInUnitMoInternal;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.iptransport.DnsClientMo;
import se.ericsson.cello.iptransport.FastEthernetMo;
import se.ericsson.cello.iptransport.FastEthernetMoImpl;
import se.ericsson.cello.iptransport.IpAccessAutoConfigMo;
import se.ericsson.cello.iptransport.IpAccessAutoConfigMoImpl;
import se.ericsson.cello.iptransport.IpAccessHostGpbMo;
import se.ericsson.cello.iptransport.IpAccessHostGpbReservable;
import se.ericsson.cello.iptransport.IpInterfaceGroupMo;
import se.ericsson.cello.iptransport.IpInterfaceGroupMoImpl;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.IpInterfaceMoImpl;
import se.ericsson.cello.iptransport.IpValidator;
import se.ericsson.cello.iptransport.M3uAssociationBuildIF2;
import se.ericsson.cello.iptransport.SctpBuildIF;
import se.ericsson.cello.iptransport.ipadm_gpbhostmi;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.managedelement.PlugInUnitRepository;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.FroNotLockedException;
import se.ericsson.cello.mao.HostIpAddress;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.PmData;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IllegalArgumentTypeException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class IpAccessHostGpbMoImpl
extends CelloMao
implements IpAccessHostGpbMo,
IpAccessHostGpbReservable,
IpAccessHostGpbBuildIF {
    private MoData data;
    private FroProxy genIpacHostGpbProxy = null;
    private MaoFroIndicationHandler indicationHandler = null;
    TagNameDictionary tnd = TagNameDictionaries.get((ResourceBundle)ResourceBundle.getBundle(ipadm_gpbhostmi.class.getName()));
    protected static final String AUTOCONFIG_FRO_ID = "autoConfigFroId";
    protected static final String PIU_FRO_ID = "piuFroId";
    protected static final String DH_FRO_ID = "dhFroId";
    protected static final String IPAC_HOST_GPB_FRO_ID = "ipacHostGpbFroId";
    private static final int MAX_NUMBER_GPB_HOSTS = 128;
    private static final int MILLISECONDS_PER_SECOND = 1000;
    private static Class[] ipInterfaceClasses = new Class[]{IpInterfaceMo.class, FastEthernetMo.class, IpInterfaceGroupMo.class};
    private static final int SINGLE_HOMED_1 = 1;
    private static final int SINGLE_HOMED_2 = 2;
    private static final int MULTI_HOMED = 3;
    private static final int MO_DATA_REVISION_14000 = 14000;
    private static final int MO_DATA_REVISION_LATEST = 14000;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"IpAccessHostGpb", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"IpSystem");
        MoAttributeValidator.checkCardinality((String)"IpAccessHostGpb", (int)128);
        IpValidator.checkCombinedHostCardinality(managedObject, "IpAccessHostGpb");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"IpAccessHostGpb", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"administrativeState", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)2, (String)"IpAccessHostGpb");
        int n2 = IpAccessHostGpbMoImpl.checkAndGetIpReassemblyTimeout(attrList);
        int n3 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"ipDefaultTtl", (AttrList)attrList, (boolean)false, (int)64, (int)1, (int)255, (String)"IpAccessHostGpb");
        int n4 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"autoConfig", (AttrList)attrList, (boolean)false, (int)2, (int)1, (int)2, (String)"IpAccessHostGpb");
        ManagedObject managedObject3 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"generalProcessorUnitId", (AttrList)attrList, (boolean)true, (Class)GeneralProcessorUnitMo.class, (String)"IpAccessHostGpb");
        ManagedObject managedObject4 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"interface1", (AttrList)attrList, (boolean)true, (Class[])ipInterfaceClasses, (String)"IpAccessHostGpb");
        IpAccessHostGpbMoImpl.checkGeneralProcessorUnitReservations(managedObject3, coordinator);
        ManagedObject managedObject5 = null;
        String string3 = "0.0.0.0";
        ManagedObject managedObject6 = null;
        String string4 = "0.0.0.0";
        boolean bl = false;
        if (n4 == 1) {
            managedObject5 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"autoConfigIdentity", (AttrList)attrList, (boolean)true, (Class)IpAccessAutoConfigMo.class, (String)"IpAccessHostGpb");
            managedObject6 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"autoConfigIdentity2", (AttrList)attrList, (boolean)false, (Class)IpAccessAutoConfigMo.class, (String)"IpAccessHostGpb");
            if (managedObject6 != null) {
                bl = true;
            }
            string3 = "";
            string4 = "";
        } else if (n4 == 2) {
            string3 = MoAttributeValidator.checkAndGetStringAttribute((String)"ipAddress1", (AttrList)attrList, (boolean)true, (String)"0.0.0.0", (String)"IpAccessHostGpb");
            int n5 = 0;
            if (managedObject4 instanceof IpInterfaceMo) {
                n5 = ((IpInterfaceMo)managedObject4).getNetworkPrefixLength(coordinator);
            } else if (managedObject4 instanceof FastEthernetMo) {
                n5 = ((FastEthernetMo)managedObject4).getNetworkPrefixLength(coordinator);
            } else if (managedObject4 instanceof IpInterfaceGroupMo) {
                n5 = ((IpInterfaceMo)((IpInterfaceGroupMo)managedObject4).getPrimaryIpInterfaceRef(coordinator)).getNetworkPrefixLength(coordinator);
            }
            new HostIpAddress(string3, n5);
            string4 = MoAttributeValidator.checkAndGetStringAttribute((String)"ipAddress2", (AttrList)attrList, (boolean)false, (String)"0.0.0.0", (String)"IpAccessHostGpb");
            if (string3.equals(string4)) {
                throw new ValueOutOfRangeException("Attributes ipAddress1 and ipAddress2 may not be the same", "IpAccessHostGpb");
            }
            if (!string4.equals("0.0.0.0")) {
                bl = true;
                new IpAddress(string4);
            }
        }
        ManagedObject managedObject7 = null;
        if (bl) {
            managedObject7 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"interface2", (AttrList)attrList, (boolean)true, (Class[])ipInterfaceClasses, (String)"IpAccessHostGpb");
            if (managedObject7 != null) {
                if (!managedObject7.getType().equals(managedObject4.getType())) {
                    throw new ValueOutOfRangeException("Attributes interface1 and interface2 should be of same type MO", "IpAccessHostGpb");
                }
                IpValidator.checkInterfacesNotSameInstance(managedObject4, managedObject7, coordinator);
            }
            int n6 = 0;
            if (n4 == 2) {
                if (managedObject7 instanceof IpInterfaceMo) {
                    n6 = ((IpInterfaceMo)managedObject7).getNetworkPrefixLength(coordinator);
                } else if (managedObject7 instanceof FastEthernetMo) {
                    n6 = ((FastEthernetMo)managedObject7).getNetworkPrefixLength(coordinator);
                } else if (managedObject7 instanceof IpInterfaceGroupMo) {
                    n6 = ((IpInterfaceMo)((IpInterfaceGroupMo)managedObject7).getPrimaryIpInterfaceRef(coordinator)).getNetworkPrefixLength(coordinator);
                }
                new HostIpAddress(string4, n6);
            }
        }
        ManagedObject managedObject8 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"dnsClient1Ref", (AttrList)attrList, (boolean)false, (String)"IpAccessHostGpb");
        IpAccessHostGpbMoImpl.validateDnsClientRef(managedObject8, "dnsClient1Ref");
        ManagedObject managedObject9 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"dnsClient2Ref", (AttrList)attrList, (boolean)false, (String)"IpAccessHostGpb");
        IpAccessHostGpbMoImpl.validateDnsClientRef(managedObject9, "dnsClient2Ref");
        if (managedObject9 != null && managedObject7 == null) {
            throw new OperationNotAllowedException("DnsClient2Ref can not be handled when IpInterface2 is invalid or empty", "IpAccessHostGpb");
        }
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"IpAccessHostGpb");
        return new IpAccessHostGpbMoImpl(managedObject, string, string2, n, managedObject3, n4, managedObject5, managedObject6, string3, bl, string4, n3, n2, managedObject4, managedObject7, coordinator, initialMaoContext, froProxy, maoFroIndicationHandler, managedObject8, managedObject9);
    }

    private static int checkAndGetIpReassemblyTimeout(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("ipReasmTimeout");
        if (n != -1) {
            if (attrList.contains(new String[]{"reassemblyTimeout"})) {
                throw new ConfigurationMismatchException("Both ipReasmTimeout and reassemblyTimeout supplied ", "IpAccessHostGpb", "ipReasmTimeout");
            }
            return 1000 * MoAttributeValidator.checkAndGetIntegerAttribute((String)"ipReasmTimeout", (AttrList)attrList, (boolean)false, (int)60, (int)0, (int)Integer.MAX_VALUE, (String)"IpAccessHostGpb");
        }
        return MoAttributeValidator.checkAndGetIntegerAttribute((String)"reassemblyTimeout", (AttrList)attrList, (boolean)false, (int)60000, (int)1, (int)120000, (String)"IpAccessHostGpb");
    }

    private IpAccessHostGpbMoImpl(ManagedObject managedObject, String string, String string2, int n, ManagedObject managedObject2, int n2, ManagedObject managedObject3, ManagedObject managedObject4, String string3, boolean bl, String string4, int n3, int n4, ManagedObject managedObject5, ManagedObject managedObject6, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, ManagedObject managedObject7, ManagedObject managedObject8) throws MoAccessException {
        super(managedObject, "IpAccessHostGpb", string, coordinator);
        this.genIpacHostGpbProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedByMos", false));
        if (managedObject3 != null) {
            ((Reservable)managedObject3).reserve((ManagedObject)this, coordinator);
        }
        if (managedObject4 != null) {
            ((Reservable)managedObject4).reserve((ManagedObject)this, coordinator);
        }
        if (managedObject7 != null) {
            ((Reservable)managedObject7).reserve((ManagedObject)this, coordinator);
        }
        if (managedObject8 != null) {
            ((Reservable)managedObject8).reserve((ManagedObject)this, coordinator);
        }
        int n5 = IpAccessHostGpbMoImpl.getPiuId(managedObject2, coordinator);
        ((Reservable)managedObject5).reserve((ManagedObject)this, coordinator);
        if (managedObject6 != null) {
            ((Reservable)managedObject6).reserve((ManagedObject)this, coordinator);
        }
        int n6 = this.createGpbFro(coordinator, n5, n, n3, n4, n2, managedObject3, managedObject4, string3, string4, bl, managedObject5, managedObject6, managedObject7, managedObject8, initialMaoContext);
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(IPAC_HOST_GPB_FRO_ID, false, n6));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("dnsClient1Ref", true));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("dnsClient2Ref", true));
        ((ReferenceAttribute)this.data.getAttribute("dnsClient1Ref")).setValue(managedObject7);
        ((ReferenceAttribute)this.data.getAttribute("dnsClient2Ref")).setValue(managedObject8);
        this.data.setRevision(14000);
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n6);
        this.getMaoContext().getServiceRepository().addService((Object)this, IpAccessHostGpbBuildIF.class, coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public IpAccessHostGpbMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.genIpacHostGpbProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(14000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reservedByMos");
        moDataRecoveryHelper.assertAttribute(IPAC_HOST_GPB_FRO_ID);
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute(IPAC_HOST_GPB_FRO_ID)).getValue(null));
        this.getMaoContext().getServiceRepository().addService((Object)this, IpAccessHostGpbBuildIF.class, null);
    }

    private int createGpbFro(Coordinator coordinator, int n, int n2, int n3, int n4, int n5, ManagedObject managedObject, ManagedObject managedObject2, String string, String string2, boolean bl, ManagedObject managedObject3, ManagedObject managedObject4, ManagedObject managedObject5, ManagedObject managedObject6, InitialMaoContext initialMaoContext) throws MoAccessException {
        StringParameter stringParameter;
        int n6;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StructParameter structParameter = new StructParameter("location");
        structParameter.add((Parameter)new SignedIntParameter(PIU_FRO_ID, n));
        arrayList.add(structParameter);
        arrayList.add(new SignedIntParameter("administrativeState", n2));
        arrayList.add(new SignedIntParameter("ipDefaultTtl", n3));
        arrayList.add(new SignedIntParameter("reassemblyTimeout", n4));
        arrayList.add(new SignedIntParameter("autoConfig", n5));
        arrayList.add(this.createStructParameter("interface1", n5, managedObject, string, managedObject3, coordinator));
        if (bl) {
            arrayList.add(this.createStructParameter("interface2", n5, managedObject2, string2, managedObject4, coordinator));
        }
        if (managedObject5 != null) {
            n6 = (Integer)managedObject5.getAttribute("froId", coordinator);
            arrayList.add(new SignedIntParameter("dnsClient1Ref", n6));
        }
        if (managedObject6 != null) {
            n6 = (Integer)managedObject6.getAttribute("froId", coordinator);
            arrayList.add(new SignedIntParameter("dnsClient2Ref", n6));
        }
        FroData froData = this.genIpacHostGpbProxy.create(coordinator, arrayList);
        Map map = froData.getParameters();
        StructParameter structParameter2 = (StructParameter)map.get("interface1");
        StringParameter stringParameter2 = (StringParameter)structParameter2.get("ipAddress1");
        if (managedObject3 instanceof IpInterfaceGroupMo) {
            this.validateAddressForIpInterfaceGroup(stringParameter2.getValue(), managedObject3, "IpAccessHostGpb", coordinator);
        } else {
            IpValidator.validateAddressTowardsInterface(stringParameter2.getValue(), managedObject3, "IpAccessHostGpb", coordinator);
        }
        StructParameter structParameter3 = (StructParameter)map.get("interface2");
        if (structParameter3 != null && !(stringParameter = (StringParameter)structParameter3.get("ipAddress2")).getValue().equals("0.0.0.0")) {
            if (managedObject4 instanceof IpInterfaceGroupMo) {
                this.validateAddressForIpInterfaceGroup(stringParameter.getValue(), managedObject4, "IpAccessHostGpb", coordinator);
            } else {
                IpValidator.validateAddressTowardsInterface(stringParameter.getValue(), managedObject4, "IpAccessHostGpb", coordinator);
            }
        }
        return froData.getFroId();
    }

    private StructParameter createStructParameter(String string, int n, ManagedObject managedObject, String string2, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        Object var7_7 = null;
        StructParameter structParameter = new StructParameter(string);
        int n2 = 0;
        if (managedObject != null) {
            n2 = ((IpAccessAutoConfigMoImpl)managedObject).getFroId(coordinator);
        }
        structParameter.add((Parameter)new SignedIntParameter(AUTOCONFIG_FRO_ID, n2));
        if (string.equals("interface1")) {
            structParameter.add((Parameter)new StringParameter("ipAddress1", string2, 15));
        } else {
            structParameter.add((Parameter)new StringParameter("ipAddress2", string2, 15));
        }
        if (managedObject2.getType().equals("FastEthernet")) {
            FastEthernetMoImpl fastEthernetMoImpl = (FastEthernetMoImpl)managedObject2;
            structParameter.add((Parameter)new SignedIntParameter(DH_FRO_ID, fastEthernetMoImpl.getDhFroId(coordinator)));
        } else if (managedObject2.getType().equals("IpInterface")) {
            IpInterfaceMoImpl ipInterfaceMoImpl = (IpInterfaceMoImpl)managedObject2;
            structParameter.add((Parameter)new SignedIntParameter(DH_FRO_ID, ipInterfaceMoImpl.getFroId(coordinator)));
        } else {
            IpInterfaceGroupMoImpl ipInterfaceGroupMoImpl = (IpInterfaceGroupMoImpl)managedObject2;
            structParameter.add((Parameter)new SignedIntParameter(DH_FRO_ID, ipInterfaceGroupMoImpl.getFroId(coordinator)));
        }
        return structParameter;
    }

    private StructParameter createStructParameter(String string, ManagedObject managedObject, String string2, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        StructParameter structParameter = new StructParameter(string);
        int n = 0;
        if (managedObject != null) {
            n = ((IpAccessAutoConfigMoImpl)managedObject).getFroId(coordinator);
        }
        structParameter.add((Parameter)new SignedIntParameter(AUTOCONFIG_FRO_ID, n));
        if (string.equals("interface1")) {
            structParameter.add((Parameter)new StringParameter("ipAddress1", string2, 15));
        } else {
            structParameter.add((Parameter)new StringParameter("ipAddress2", string2, 15));
        }
        int n2 = 0;
        if (managedObject2 != null) {
            n2 = managedObject2.getType().equals("FastEthernet") ? ((FastEthernetMoImpl)managedObject2).getDhFroId(coordinator) : (managedObject2.getType().equals("IpInterface") ? ((IpInterfaceMoImpl)managedObject2).getFroId(coordinator) : ((IpInterfaceGroupMoImpl)managedObject2).getFroId(coordinator));
        }
        structParameter.add((Parameter)new SignedIntParameter(DH_FRO_ID, n2));
        return structParameter;
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject;
        ManagedObject managedObject2;
        ManagedObject managedObject3;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedByMos(coordinator).length != 0) {
            throw new MoReservedNotDeletableException((ManagedObject)this);
        }
        int n = (Integer)this.getAttribute("administrativeState", coordinator);
        if (n != 0) {
            throw new FroNotLockedException(this.getType(), "The MO can not be deleted when unlocked");
        }
        ManagedObject managedObject4 = (ManagedObject)this.getAttribute("autoConfigIdentity", coordinator);
        if (managedObject4 != null) {
            ((Reservable)managedObject4).release((ManagedObject)this, coordinator);
        }
        if ((managedObject3 = (ManagedObject)this.getAttribute("autoConfigIdentity2", coordinator)) != null) {
            ((Reservable)managedObject3).release((ManagedObject)this, coordinator);
        }
        if ((managedObject2 = (ManagedObject)this.getAttribute("interface1", coordinator)) != null) {
            ((Reservable)managedObject2).release((ManagedObject)this, coordinator);
        }
        if ((managedObject = (ManagedObject)this.getAttribute("interface2", coordinator)) != null) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        this.genIpacHostGpbProxy.delete(coordinator, this.getFroId(coordinator), null);
        this.getMaoContext().getServiceRepository().removeService((Object)this, IpAccessHostGpbBuildIF.class, coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        return this.getHostFroId(coordinator);
    }

    public int getHostFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(IPAC_HOST_GPB_FRO_ID)).getValue(coordinator);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("administrativeState", coordinator);
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("administrativeState", new Integer(n), coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedByMos");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedByMos");
    }

    private PmData getPmAttributes(Coordinator coordinator) throws MoAccessException {
        PmData pmData = this.genIpacHostGpbProxy.getPmAttributes(coordinator, this.getFroId(coordinator));
        return pmData;
    }

    public String getType() {
        return "IpAccessHostGpb";
    }

    public String getIpAccessHostGpbId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute(this.getType() + "Id", coordinator);
    }

    public ManagedObject getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("reservedBy", coordinator);
    }

    public ManagedObject[] getReservedByMos(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("reservedByMos", coordinator);
    }

    public ManagedObject getGeneralProcessorUnitId(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("generalProcessorUnitId", coordinator);
    }

    public int getAutoConfig(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("autoConfig", coordinator);
    }

    public ManagedObject getAutoConfigIdentity(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("autoConfigIdentity", coordinator);
    }

    public ManagedObject getAutoConfigIdentity2(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("autoConfigIdentity2", coordinator);
    }

    public String getIpAddress1(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("ipAddress1", coordinator);
    }

    public void setIpAddress1(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ipAddress1", string, coordinator);
    }

    public String getIpAddress2(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("ipAddress2", coordinator);
    }

    public void setIpAddress2(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ipAddress2", string, coordinator);
    }

    public int getIpDefaultTtl(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("ipDefaultTtl", coordinator);
    }

    public void setIpDefaultTtl(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ipDefaultTtl", new Integer(n), coordinator);
    }

    public int getIpReasmTimeout(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("ipReasmTimeout", coordinator);
    }

    public void setIpReasmTimeout(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ipReasmTimeout", new Integer(n), coordinator);
    }

    public int getReassemblyTimeout(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("reassemblyTimeout", coordinator);
    }

    public void setReassemblyTimeout(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("reassemblyTimeout", new Integer(n), coordinator);
    }

    public ManagedObject getInterface1(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("interface1", coordinator);
    }

    public ManagedObject getInterface2(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("interface2", coordinator);
    }

    public int getPmIpInReceives(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInReceives", coordinator);
    }

    public int getPmIpInHdrErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInHdrErrors", coordinator);
    }

    public int getPmIpInAddrErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInAddrErrors", coordinator);
    }

    public int getPmIpInUnknownProtos(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInUnknownProtos", coordinator);
    }

    public int getPmIpInDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInDiscards", coordinator);
    }

    public int getPmIpInDelivers(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInDelivers", coordinator);
    }

    public int getPmIpOutRequests(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpOutRequests", coordinator);
    }

    public int getPmIpOutDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpOutDiscards", coordinator);
    }

    public int getPmIpReasmReqds(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpReasmReqds", coordinator);
    }

    public int getPmIpReasmOKs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpReasmOKs", coordinator);
    }

    public int getPmIpReasmFails(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpReasmFails", coordinator);
    }

    public int getPmIpFragOKs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpFragOKs", coordinator);
    }

    public int getPmIpFragFails(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpFragFails", coordinator);
    }

    public int getPmIpFragCreates(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpFragCreates", coordinator);
    }

    public int getPmIcmpInMsgs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInMsgs", coordinator);
    }

    public int getPmIcmpInErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInErrors", coordinator);
    }

    public int getPmIcmpInDestUnreachs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInDestUnreachs", coordinator);
    }

    public int getPmIcmpInTimeExcds(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInTimeExcds", coordinator);
    }

    public int getPmIcmpInParamProbs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInParamProbs", coordinator);
    }

    public int getPmIcmpInSrcQuenchs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInSrcQuenchs", coordinator);
    }

    public int getPmIcmpInRedirects(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInRedirects", coordinator);
    }

    public int getPmIcmpInEchos(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInEchos", coordinator);
    }

    public int getPmIcmpInEchoReps(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInEchoReps", coordinator);
    }

    public int getPmIcmpOutMsgs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutMsgs", coordinator);
    }

    public int getPmIcmpOutErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutErrors", coordinator);
    }

    public int getPmIcmpOutDestUnreachs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutDestUnreachs", coordinator);
    }

    public int getPmIcmpOutParmProbs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutParmProbs", coordinator);
    }

    public int getPmIcmpOutEchos(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutEchos", coordinator);
    }

    public int getPmIcmpOutEchoReps(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutEchoReps", coordinator);
    }

    public int getPmUdpInDatagrams(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUdpInDatagrams", coordinator);
    }

    public int getPmUdpNoPorts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUdpNoPorts", coordinator);
    }

    public int getPmUdpInErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUdpInErrors", coordinator);
    }

    public int getPmUdpOutDatagrams(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUdpOutDatagrams", coordinator);
    }

    public ManagedObject getDnsClient1Ref(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("dnsClient1Ref", coordinator);
    }

    public void setDnsClient1Ref(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject2 = (ManagedObject)this.getAttribute("interface1", coordinator);
        if (managedObject2 == null) {
            throw new OperationNotAllowedException("DnsClient1Ref can not be handled when IpInterface1 is invalid or empty", "IpAccessHostGpb");
        }
        this.setAttribute("dnsClient1Ref", managedObject, coordinator);
    }

    public ManagedObject getDnsClient2Ref(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("dnsClient2Ref", coordinator);
    }

    public void setDnsClient2Ref(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        Map map = null;
        StructParameter structParameter = (StructParameter)(map = this.getAttrFromRes(map, coordinator)).get("interface2");
        if (structParameter == null) {
            throw new OperationNotAllowedException("DnsClient2Ref can not be handled when IpInterface2 is invalid or empty", "IpAccessHostGpb");
        }
        this.setAttribute("dnsClient2Ref", managedObject, coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        PmData pmData = null;
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            StructParameter structParameter;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                structParameter = this.getReservedByMos(coordinator);
                if (((ManagedObject[])structParameter).length == 0) continue;
                objectArray[i] = structParameter[0];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedByMos")) {
                this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedByMos")), (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("autoConfigIdentity")) {
                map = this.getAttrFromRes(map, coordinator);
                objectArray[i] = null;
                structParameter = (StructParameter)map.get("interface1");
                if (structParameter == null || (signedIntParameter = (SignedIntParameter)structParameter.get(AUTOCONFIG_FRO_ID)).getValue() == 0) continue;
                objectArray[i] = MaoFroTypeConverter.froId2MaoInstance((String)"IpAccessAutoConfig", (int)signedIntParameter.getValue(), (Coordinator)coordinator);
                if (objectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch reference ", "IpAccessHostGpb", "autoConfigIdentity");
            }
            if (stringArray[i].equalsIgnoreCase("autoConfigIdentity2")) {
                map = this.getAttrFromRes(map, coordinator);
                objectArray[i] = null;
                structParameter = (StructParameter)map.get("interface2");
                if (structParameter == null || (signedIntParameter = (SignedIntParameter)structParameter.get(AUTOCONFIG_FRO_ID)).getValue() == 0) continue;
                objectArray[i] = MaoFroTypeConverter.froId2MaoInstance((String)"IpAccessAutoConfig", (int)signedIntParameter.getValue(), (Coordinator)coordinator);
                if (objectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch reference ", "IpAccessHostGpb", "autoConfigIdentity2");
            }
            if (stringArray[i].equalsIgnoreCase("activeGpuId")) {
                map = this.getAttrFromRes(map, coordinator);
                structParameter = (StructParameter)map.get("activeLocation");
                signedIntParameter = (SignedIntParameter)structParameter.get(PIU_FRO_ID);
                objectArray[i] = this.piuFroId2GpuInstance(coordinator, signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("interface1")) {
                map = this.getAttrFromRes(map, coordinator);
                objectArray[i] = null;
                structParameter = (StructParameter)map.get("interface1");
                if (structParameter == null) continue;
                signedIntParameter = (SignedIntParameter)structParameter.get(DH_FRO_ID);
                objectArray[i] = IpInterfaceMoImpl.lookupInstance(signedIntParameter.getValue(), coordinator);
                if (objectArray[i] == null) {
                    objectArray[i] = FastEthernetMoImpl.lookupDhFroIdInstance(signedIntParameter.getValue(), coordinator);
                }
                if (objectArray[i] != null) continue;
                objectArray[i] = this.findIpInterfaceGroup(signedIntParameter.getValue(), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("interface2")) {
                map = this.getAttrFromRes(map, coordinator);
                objectArray[i] = null;
                structParameter = (StructParameter)map.get("interface2");
                if (structParameter == null) continue;
                signedIntParameter = (SignedIntParameter)structParameter.get(DH_FRO_ID);
                objectArray[i] = IpInterfaceMoImpl.lookupInstance(signedIntParameter.getValue(), coordinator);
                if (objectArray[i] == null) {
                    objectArray[i] = FastEthernetMoImpl.lookupDhFroIdInstance(signedIntParameter.getValue(), coordinator);
                }
                if (objectArray[i] != null) continue;
                objectArray[i] = this.findIpInterfaceGroup(signedIntParameter.getValue(), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("generalProcessorUnitId")) {
                map = this.getAttrFromRes(map, coordinator);
                structParameter = (StructParameter)map.get("location");
                signedIntParameter = (SignedIntParameter)structParameter.get(PIU_FRO_ID);
                objectArray[i] = this.piuFroId2GpuInstance(coordinator, signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                map = this.getAttrFromRes(map, coordinator);
                structParameter = (SignedIntParameter)map.get("administrativeState");
                objectArray[i] = new Integer(structParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                map = this.getAttrFromRes(map, coordinator);
                structParameter = (SignedIntParameter)map.get("availabilityStatus");
                objectArray[i] = new Integer(structParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                map = this.getAttrFromRes(map, coordinator);
                structParameter = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(structParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("autoConfig")) {
                map = this.getAttrFromRes(map, coordinator);
                structParameter = (SignedIntParameter)map.get("autoConfig");
                objectArray[i] = new Integer(structParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipAddress1")) {
                structParameter = (StructParameter)(map = this.getAttrFromRes(map, coordinator)).get("interface1");
                if (structParameter != null) {
                    signedIntParameter = (StringParameter)structParameter.get("ipAddress1");
                    objectArray[i] = signedIntParameter.getValue();
                    continue;
                }
                objectArray[i] = "0.0.0.0";
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipAddress2")) {
                structParameter = (StructParameter)(map = this.getAttrFromRes(map, coordinator)).get("interface2");
                if (structParameter != null) {
                    signedIntParameter = (StringParameter)structParameter.get("ipAddress2");
                    objectArray[i] = signedIntParameter.getValue();
                    continue;
                }
                objectArray[i] = "0.0.0.0";
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipDefaultTtl")) {
                map = this.getAttrFromRes(map, coordinator);
                structParameter = (SignedIntParameter)map.get("ipDefaultTtl");
                objectArray[i] = new Integer(structParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipReasmTimeout")) {
                map = this.getAttrFromRes(map, coordinator);
                structParameter = (SignedIntParameter)map.get("reassemblyTimeout");
                objectArray[i] = new Integer(structParameter.getValue() / 1000);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reassemblyTimeout")) {
                map = this.getAttrFromRes(map, coordinator);
                structParameter = (SignedIntParameter)map.get("reassemblyTimeout");
                objectArray[i] = new Integer(structParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("dnsClient1Ref")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("dnsClient1Ref")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("dnsClient2Ref")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("dnsClient2Ref")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpInReceives")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpInReceives"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpInHdrErrors")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpInHdrErrors"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpInAddrErrors")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpInAddrErrors"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpInUnknownProtos")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpInUnknownProtos"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpInDiscards")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpInDiscards"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpInDelivers")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpInDelivers"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpOutRequests")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpOutRequests"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpOutDiscards")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpOutDiscards"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpReasmReqds")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpReasmReqds"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpReasmOKs")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpReasmOKs"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpReasmFails")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpReasmFails"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpFragOKs")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpFragOKs"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpFragFails")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpFragFails"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpFragCreates")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpFragCreates"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInMsgs")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpInMsgs"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInErrors")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpInErrors"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInDestUnreachs")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpInDestUnreachs"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInTimeExcds")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpInTimeExcds"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInParamProbs")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpInParamProbs"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInSrcQuenchs")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpInSrcQuenchs"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInRedirects")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpInRedirects"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInEchos")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpInEchos"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInEchoReps")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpInEchoReps"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpOutMsgs")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpOutMsgs"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpOutErrors")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpOutErrors"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpOutDestUnreachs")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpOutDestUnreachs"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpOutParmProbs")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpOutParmProbs"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpOutEchos")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpOutEchos"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpOutEchoReps")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpOutEchoReps"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUdpInDatagrams")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmUdpInDatagrams"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUdpNoPorts")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmUdpNoPorts"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUdpInErrors")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmUdpInErrors"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUdpOutDatagrams")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmUdpOutDatagrams"));
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "IpAccessHostGpb");
        }
        return objectArray;
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.getFroAttributes(coordinator);
        }
        return map;
    }

    private PmData getPmFromRes(PmData pmData, Coordinator coordinator) throws MoAccessException {
        if (pmData == null) {
            return this.getPmAttributes(coordinator);
        }
        return pmData;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = 0;
        String string = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            ManagedObject managedObject;
            Object object;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? IpAccessHostGpbMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "IpAccessHostGpb");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"IpAccessHostGpb", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpAccessHostGpbMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("administrativeState", "IpAccessHostGpb");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"administrativeState", (int)n, (int)0, (int)2, (String)"IpAccessHostGpb");
                arrayList.add(new SignedIntParameter("administrativeState", n));
                this.sendNotification("administrativeState", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipDefaultTtl")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpAccessHostGpbMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("ipDefaultTtl", "IpAccessHostGpb");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"ipDefaultTtl", (int)n, (int)1, (int)255, (String)"IpAccessHostGpb");
                arrayList.add(new SignedIntParameter("ipDefaultTtl", n));
                this.sendNotification("ipDefaultTtl", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipReasmTimeout")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpAccessHostGpbMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("ipReasmTimeout", "IpAccessHostGpb");
                }
                n = (Integer)objectArray[i];
                if (n < 0) {
                    throw new ValueOutOfRangeException("ipReasmTimeout", "IpAccessHostGpb");
                }
                arrayList.add(new SignedIntParameter("reassemblyTimeout", n * 1000));
                this.sendNotification("ipReasmTimeout", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reassemblyTimeout")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpAccessHostGpbMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("reassemblyTimeout", "IpAccessHostGpb");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"reassemblyTimeout", (int)n, (int)1, (int)120000, (String)"IpAccessHostGpb");
                arrayList.add(new SignedIntParameter("reassemblyTimeout", n));
                this.sendNotification("reassemblyTimeout", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipAddress1")) {
                if (this.getAdministrativeState(coordinator) != 0) {
                    throw new FroNotLockedException("IpAccessHostGpb", "AdministrativeState need to be locked when setting ip address");
                }
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? IpAccessHostGpbMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("ipAddress1", "IpAccessHostGpb");
                }
                string = (String)objectArray[i];
                object = (Integer)this.getAttribute("autoConfig", coordinator);
                if ((Integer)object != 2) {
                    throw new OperationNotAllowedException("ipAddress1 can not be set if autoConfig is configured", "IpAccessHostGpb");
                }
                managedObject = (ManagedObject)this.getAttribute("interface1", coordinator);
                if (managedObject == null) {
                    throw new OperationNotAllowedException("ipAddress1 can not be set if interface1 is not configured", "IpAccessHostGpb");
                }
                int n2 = 0;
                if (managedObject instanceof IpInterfaceMo) {
                    n2 = ((IpInterfaceMo)managedObject).getNetworkPrefixLength(coordinator);
                } else if (managedObject instanceof FastEthernetMo) {
                    n2 = ((FastEthernetMo)managedObject).getNetworkPrefixLength(coordinator);
                } else if (managedObject instanceof IpInterfaceGroupMo) {
                    n2 = ((IpInterfaceMo)((IpInterfaceGroupMo)managedObject).getPrimaryIpInterfaceRef(coordinator)).getNetworkPrefixLength(coordinator);
                }
                new HostIpAddress(string, n2);
                arrayList.add(new StringParameter("ipAddress1", string, 15));
                if (managedObject instanceof IpInterfaceGroupMo) {
                    this.validateAddressForIpInterfaceGroup(string, managedObject, "IpAccessHostGpb", coordinator);
                } else {
                    IpValidator.validateAddressTowardsInterface(string, managedObject, "IpAccessHostGpb", coordinator);
                }
                this.sendNotification("ipAddress1", string, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipAddress2")) {
                if (this.getAdministrativeState(coordinator) != 0) {
                    throw new FroNotLockedException("IpAccessHostGpb", "AdministrativeState need to be locked when setting ip address");
                }
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? IpAccessHostGpbMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("ipAddress2", "IpAccessHostGpb");
                }
                string = (String)objectArray[i];
                object = (Integer)this.getAttribute("autoConfig", coordinator);
                if ((Integer)object != 2) {
                    throw new OperationNotAllowedException("ipAddress2 can not be set if autoConfig is configured ", "IpAccessHostGpb");
                }
                managedObject = (ManagedObject)this.getAttribute("interface2", coordinator);
                if (managedObject == null) {
                    throw new OperationNotAllowedException("ipAddress2 can not be set if interface2 is not configured ", "IpAccessHostGpb");
                }
                int n3 = 0;
                if (managedObject instanceof IpInterfaceMo) {
                    n3 = ((IpInterfaceMo)managedObject).getNetworkPrefixLength(coordinator);
                } else if (managedObject instanceof FastEthernetMo) {
                    n3 = ((FastEthernetMo)managedObject).getNetworkPrefixLength(coordinator);
                } else if (managedObject instanceof IpInterfaceGroupMo) {
                    n3 = ((IpInterfaceMo)((IpInterfaceGroupMo)managedObject).getPrimaryIpInterfaceRef(coordinator)).getNetworkPrefixLength(coordinator);
                }
                new HostIpAddress(string, n3);
                arrayList.add(new StringParameter("ipAddress2", string, 15));
                if (managedObject instanceof IpInterfaceGroupMo) {
                    this.validateAddressForIpInterfaceGroup(string, managedObject, "IpAccessHostGpb", coordinator);
                } else {
                    IpValidator.validateAddressTowardsInterface(string, managedObject, "IpAccessHostGpb", coordinator);
                }
                this.sendNotification("ipAddress2", string, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("dnsClient1Ref")) {
                object = (ManagedObject)this.getAttribute("interface1", coordinator);
                if (object == null) {
                    throw new OperationNotAllowedException("DnsClient1Ref can not be handled when IpInterface1 is invalid or empty", "IpAccessHostGpb");
                }
                if (objectArray[i] == null || objectArray[i] instanceof ManagedObject) {
                    managedObject = (ManagedObject)objectArray[i];
                    IpAccessHostGpbMoImpl.validateDnsClientRef(managedObject, "dnsClient1Ref");
                    this.updateReservedDnsClientMos(this.getDnsClient1Ref(coordinator), managedObject, this.getDnsClient2Ref(coordinator), coordinator);
                    ((ReferenceAttribute)this.data.getAttribute("dnsClient1Ref")).setValue(managedObject);
                    int n4 = 0;
                    if (managedObject instanceof FroInfo) {
                        n4 = ((FroInfo)managedObject).getFroId(coordinator);
                    }
                    arrayList.add(new SignedIntParameter("dnsClient1Ref", n4));
                    this.sendNotification("dnsClient1Ref", objectArray[i], coordinator);
                    continue;
                }
                throw new WrongAttributeTypeException("dnsClient1Ref", "IpAccessHostGpb");
            }
            if (stringArray[i].equalsIgnoreCase("dnsClient2Ref")) {
                object = null;
                managedObject = (StructParameter)(object = this.getAttrFromRes((Map)object, coordinator)).get("interface2");
                if (managedObject == null) {
                    throw new OperationNotAllowedException("DnsClient2Ref can not be handled when IpInterface2 is invalid or empty", "IpAccessHostGpb");
                }
                if (objectArray[i] == null || objectArray[i] instanceof ManagedObject) {
                    ManagedObject managedObject2 = (ManagedObject)objectArray[i];
                    IpAccessHostGpbMoImpl.validateDnsClientRef(managedObject2, "dnsClient2Ref");
                    this.updateReservedDnsClientMos(this.getDnsClient2Ref(coordinator), managedObject2, this.getDnsClient1Ref(coordinator), coordinator);
                    ((ReferenceAttribute)this.data.getAttribute("dnsClient2Ref")).setValue(managedObject2);
                    int n5 = 0;
                    if (managedObject2 instanceof FroInfo) {
                        n5 = ((FroInfo)managedObject2).getFroId(coordinator);
                    }
                    arrayList.add(new SignedIntParameter("dnsClient2Ref", n5));
                    this.sendNotification("dnsClient2Ref", objectArray[i], coordinator);
                    continue;
                }
                throw new WrongAttributeTypeException("dnsClient2Ref", "IpAccessHostGpb");
            }
            throw new NoSuchAttributeException(stringArray[i], "IpAccessHostGpb");
        }
        if (arrayList.size() > 0) {
            this.genIpacHostGpbProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    private void updateReservedDnsClientMos(ManagedObject managedObject, ManagedObject managedObject2, ManagedObject managedObject3, Coordinator coordinator) throws MoAccessException {
        if (managedObject instanceof Reservable && managedObject3 != managedObject) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        if (managedObject2 instanceof Reservable) {
            ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        }
    }

    private static void validateDnsClientRef(ManagedObject managedObject, String string) throws MoAccessException {
        if (managedObject != null && !(managedObject instanceof DnsClientMo)) {
            throw new WrongAttributeTypeException(string, "IpAccessHostGpb");
        }
    }

    public void actionRemoveInterface1(Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.checkLocalIpMask("interface1", coordinator);
        this.releaseAutoConfigId("autoConfigIdentity2", "autoConfigIdentity", coordinator);
        boolean bl = false;
        ManagedObject managedObject2 = this.getDnsClient1Ref(coordinator);
        if (managedObject2 != null) {
            ((Reservable)managedObject2).release((ManagedObject)this, coordinator);
            bl = true;
            ((ReferenceAttribute)this.data.getAttribute("dnsClient1Ref")).setValue(null);
        }
        if ((managedObject = (ManagedObject)this.getAttribute("interface1", coordinator)) != null) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        StructParameter structParameter = this.createStructParameter("interface1", null, "0.0.0.0", null, coordinator);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(structParameter);
        if (bl) {
            arrayList.add(new SignedIntParameter("dnsClient1Ref", 0));
        }
        this.genIpacHostGpbProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
    }

    public void actionRemoveInterface2(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.checkLocalIpMask("interface2", coordinator);
        this.releaseAutoConfigId("autoConfigIdentity", "autoConfigIdentity2", coordinator);
        ManagedObject managedObject = (ManagedObject)this.getAttribute("interface2", coordinator);
        if (managedObject != null) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        boolean bl = false;
        ManagedObject managedObject2 = this.getDnsClient2Ref(coordinator);
        if (managedObject2 != null) {
            ((Reservable)managedObject2).release((ManagedObject)this, coordinator);
            bl = true;
            ((ReferenceAttribute)this.data.getAttribute("dnsClient2Ref")).setValue(null);
        }
        StructParameter structParameter = this.createStructParameter("interface2", null, "0.0.0.0", null, coordinator);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(structParameter);
        if (bl) {
            arrayList.add(new SignedIntParameter("dnsClient2Ref", 0));
        }
        this.genIpacHostGpbProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
    }

    private void checkLocalIpMask(String string, Coordinator coordinator) throws MoAccessException {
        ManagedObject[] managedObjectArray = this.getReservedByMos(coordinator);
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (managedObjectArray[i] == null || !(managedObjectArray[i] instanceof SctpBuildIF)) continue;
            ManagedObject[] managedObjectArray2 = ((SctpBuildIF)managedObjectArray[i]).getReservedBy(coordinator);
            for (int j = 0; j < managedObjectArray2.length; ++j) {
                if (!(managedObjectArray2[j] instanceof M3uAssociationBuildIF2)) continue;
                int n = ((M3uAssociationBuildIF2)managedObjectArray2[j]).getLocalIpMask(coordinator);
                if (string.equals("interface1") && (n == 1 || n == 3)) {
                    throw new OperationNotAllowedException("interface1 can not be removed when localIpMask of an associated M3uAssociationis set to SINGLE_HOMED_1 or MULTI_HOMED", "IpAccessHostGpb");
                }
                if (!string.equals("interface2") || n != 2 && n != 3) continue;
                throw new OperationNotAllowedException("interface2 can not be removed when localIpMask of an associated M3uAssociationis set to SINGLE_HOMED_2 or MULTI_HOMED", "IpAccessHostGpb");
            }
        }
    }

    private void releaseAutoConfigId(String string, String string2, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = (ManagedObject)this.getAttribute(string, coordinator);
        ManagedObject managedObject2 = (ManagedObject)this.getAttribute(string2, coordinator);
        if (managedObject2 != null) {
            if (managedObject != null) {
                if (!managedObject.getLocalDistinguishedName().equals(managedObject2.getLocalDistinguishedName())) {
                    ((Reservable)managedObject2).release((ManagedObject)this, coordinator);
                }
            } else {
                ((Reservable)managedObject2).release((ManagedObject)this, coordinator);
            }
        }
    }

    public void actionAddInterface1AutoConfigOff(ManagedObject managedObject, String string, Coordinator coordinator) throws MoAccessException {
        Integer n;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null) {
            throw new IllegalArgumentTypeException((ManagedObject)this, "interface1");
        }
        if (string == null) {
            throw new IllegalArgumentTypeException((ManagedObject)this, "ipAddress1");
        }
        if (!(managedObject.getType().equals("IpInterface") || managedObject.getType().equals("FastEthernet") || managedObject.getType().equals("IpInterfaceGroup"))) {
            throw new WrongAttributeTypeException("interface1", "IpAccessHostGpb");
        }
        ManagedObject managedObject2 = (ManagedObject)this.getAttribute("interface1", coordinator);
        if (managedObject2 != null) {
            throw new OperationNotAllowedException("interface1 must be removed before a new can be added ", "IpAccessHostGpb");
        }
        ManagedObject managedObject3 = (ManagedObject)this.getAttribute("interface2", coordinator);
        if (managedObject3 != null) {
            if (!managedObject.getType().equals(managedObject3.getType())) {
                throw new OperationNotAllowedException("interface2 interface1 must refer to an MO of the same type as interface2 ", "IpAccessHostGpb");
            }
            IpValidator.checkInterfacesNotSameInstance(managedObject, managedObject3, coordinator);
        }
        if ((n = (Integer)this.getAttribute("autoConfig", coordinator)) != 2 && managedObject3 != null) {
            throw new OperationNotAllowedException("interface1 with autoConfig off can not be set when autoConfig is on and an interface2 exists ", "IpAccessHostGpb");
        }
        ((Reservable)managedObject).reserve((ManagedObject)this, coordinator);
        int n2 = 0;
        if (managedObject instanceof IpInterfaceMo) {
            n2 = ((IpInterfaceMo)managedObject).getNetworkPrefixLength(coordinator);
        } else if (managedObject instanceof FastEthernetMo) {
            n2 = ((FastEthernetMo)managedObject).getNetworkPrefixLength(coordinator);
        } else if (managedObject instanceof IpInterfaceGroupMo) {
            n2 = ((IpInterfaceMo)((IpInterfaceGroupMo)managedObject).getPrimaryIpInterfaceRef(coordinator)).getNetworkPrefixLength(coordinator);
        }
        new HostIpAddress(string, n2);
        if (managedObject instanceof IpInterfaceGroupMo) {
            this.validateAddressForIpInterfaceGroup(string, managedObject, "IpAccessHostGpb", coordinator);
        } else {
            IpValidator.validateAddressTowardsInterface(string, managedObject, "IpAccessHostGpb", coordinator);
        }
        ArrayList<StructParameter> arrayList = new ArrayList<StructParameter>();
        arrayList.add(this.createStructParameter("interface1", null, string, managedObject, coordinator));
        this.genIpacHostGpbProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
    }

    public void actionAddInterface2AutoConfigOff(ManagedObject managedObject, String string, Coordinator coordinator) throws MoAccessException {
        Integer n;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null) {
            throw new IllegalArgumentTypeException((ManagedObject)this, "interface2");
        }
        if (string == null) {
            throw new IllegalArgumentTypeException((ManagedObject)this, "ipAddress2");
        }
        if (!(managedObject.getType().equals("IpInterface") || managedObject.getType().equals("FastEthernet") || managedObject.getType().equals("IpInterfaceGroup"))) {
            throw new WrongAttributeTypeException("interface2", "IpAccessHostGpb");
        }
        ManagedObject managedObject2 = (ManagedObject)this.getAttribute("interface2", coordinator);
        if (managedObject2 != null) {
            throw new OperationNotAllowedException("interface2 must be removed before a new can be added ", "IpAccessHostGpb");
        }
        ManagedObject managedObject3 = (ManagedObject)this.getAttribute("interface1", coordinator);
        if (managedObject3 != null) {
            if (!managedObject.getType().equals(managedObject3.getType())) {
                throw new OperationNotAllowedException("interface2 must refer to an MO of the same type as interface1 ", "IpAccessHostGpb");
            }
            IpValidator.checkInterfacesNotSameInstance(managedObject3, managedObject, coordinator);
        }
        if ((n = (Integer)this.getAttribute("autoConfig", coordinator)) != 2 && managedObject3 != null) {
            throw new OperationNotAllowedException("interface2 with autoConfig off can not be set when autoConfig is on and an interface1 exists ", "IpAccessHostGpb");
        }
        ((Reservable)managedObject).reserve((ManagedObject)this, coordinator);
        int n2 = 0;
        if (managedObject instanceof IpInterfaceMo) {
            n2 = ((IpInterfaceMo)managedObject).getNetworkPrefixLength(coordinator);
        } else if (managedObject instanceof FastEthernetMo) {
            n2 = ((FastEthernetMo)managedObject).getNetworkPrefixLength(coordinator);
        } else if (managedObject instanceof IpInterfaceGroupMo) {
            n2 = ((IpInterfaceMo)((IpInterfaceGroupMo)managedObject).getPrimaryIpInterfaceRef(coordinator)).getNetworkPrefixLength(coordinator);
        }
        new HostIpAddress(string, n2);
        if (managedObject instanceof IpInterfaceGroupMo) {
            this.validateAddressForIpInterfaceGroup(string, managedObject, "IpAccessHostGpb", coordinator);
        } else {
            IpValidator.validateAddressTowardsInterface(string, managedObject, "IpAccessHostGpb", coordinator);
        }
        ArrayList<StructParameter> arrayList = new ArrayList<StructParameter>();
        arrayList.add(this.createStructParameter("interface2", null, string, managedObject, coordinator));
        this.genIpacHostGpbProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
    }

    public void actionAddInterface1AutoConfigOn(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        Integer n;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null) {
            throw new IllegalArgumentTypeException((ManagedObject)this, "interface1");
        }
        if (managedObject2 == null) {
            throw new IllegalArgumentTypeException((ManagedObject)this, "autoConfigIdentity");
        }
        if (!(managedObject.getType().equals("IpInterface") || managedObject.getType().equals("FastEthernet") || managedObject.getType().equals("IpInterfaceGroup"))) {
            throw new WrongAttributeTypeException("interface1", "IpAccessHostGpb");
        }
        if (!managedObject2.getType().equals("IpAccessAutoConfig")) {
            throw new WrongAttributeTypeException("autoConfigIdentity", "IpAccessHostGpb");
        }
        ManagedObject managedObject3 = (ManagedObject)this.getAttribute("interface1", coordinator);
        if (managedObject3 != null) {
            throw new OperationNotAllowedException("interface1 must be removed before a new can be added ", "IpAccessHostGpb");
        }
        ManagedObject managedObject4 = (ManagedObject)this.getAttribute("interface2", coordinator);
        if (managedObject4 != null) {
            if (!managedObject.getType().equals(managedObject4.getType())) {
                throw new OperationNotAllowedException("interface1 interface1 must refer to an MO of the same type as interface2 ", "IpAccessHostGpb");
            }
            IpValidator.checkInterfacesNotSameInstance(managedObject, managedObject4, coordinator);
        }
        if ((n = (Integer)this.getAttribute("autoConfig", coordinator)) != 1 && managedObject4 != null) {
            throw new OperationNotAllowedException("interface1 with autoConfig on can not be set when autoConfig is off and an interface2 exists ", "IpAccessHostGpb");
        }
        ((Reservable)managedObject).reserve((ManagedObject)this, coordinator);
        ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        ArrayList<StructParameter> arrayList = new ArrayList<StructParameter>();
        arrayList.add(this.createStructParameter("interface1", managedObject2, "0.0.0.0", managedObject, coordinator));
        this.genIpacHostGpbProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        Map map = this.genIpacHostGpbProxy.getAttributes(coordinator, this.getFroId(coordinator), null);
        StructParameter structParameter = (StructParameter)map.get("interface1");
        StringParameter stringParameter = (StringParameter)structParameter.get("ipAddress1");
        if (managedObject instanceof IpInterfaceGroupMo) {
            this.validateAddressForIpInterfaceGroup(stringParameter.getValue(), managedObject, "IpAccessHostGpb", coordinator);
        } else {
            IpValidator.validateAddressTowardsInterface(stringParameter.getValue(), managedObject, "IpAccessHostGpb", coordinator);
        }
    }

    public void actionAddInterface2AutoConfigOn(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        Integer n;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null) {
            throw new IllegalArgumentTypeException((ManagedObject)this, "interface2");
        }
        if (managedObject2 == null) {
            throw new IllegalArgumentTypeException((ManagedObject)this, "autoConfigIdentity2");
        }
        if (!(managedObject.getType().equals("IpInterface") || managedObject.getType().equals("FastEthernet") || managedObject.getType().equals("IpInterfaceGroup"))) {
            throw new WrongAttributeTypeException("interface2", "IpAccessHostGpb");
        }
        if (!managedObject2.getType().equals("IpAccessAutoConfig")) {
            throw new WrongAttributeTypeException("autoConfigIdentity2", "IpAccessHostGpb");
        }
        ManagedObject managedObject3 = (ManagedObject)this.getAttribute("interface2", coordinator);
        if (managedObject3 != null) {
            throw new OperationNotAllowedException("interface2 must be removed before a new can be added ", "IpAccessHostGpb");
        }
        ManagedObject managedObject4 = (ManagedObject)this.getAttribute("interface1", coordinator);
        if (managedObject4 != null) {
            if (!managedObject.getType().equals(managedObject4.getType())) {
                throw new OperationNotAllowedException("interface2interface2 must refer to an MO of the same type as interface1 ", "IpAccessHostGpb");
            }
            IpValidator.checkInterfacesNotSameInstance(managedObject4, managedObject, coordinator);
        }
        if ((n = (Integer)this.getAttribute("autoConfig", coordinator)) != 1 && managedObject4 != null) {
            throw new OperationNotAllowedException("interface2 with autoConfig on can not be set when autoConfig is off and an interface1 exists ", "IpAccessHostGpb");
        }
        ((Reservable)managedObject).reserve((ManagedObject)this, coordinator);
        ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        ArrayList<StructParameter> arrayList = new ArrayList<StructParameter>();
        arrayList.add(this.createStructParameter("interface2", managedObject2, "0.0.0.0", managedObject, coordinator));
        this.genIpacHostGpbProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        Map map = this.genIpacHostGpbProxy.getAttributes(coordinator, this.getFroId(coordinator), null);
        StructParameter structParameter = (StructParameter)map.get("interface2");
        StringParameter stringParameter = (StringParameter)structParameter.get("ipAddress2");
        if (managedObject instanceof IpInterfaceGroupMo) {
            this.validateAddressForIpInterfaceGroup(stringParameter.getValue(), managedObject, "IpAccessHostGpb", coordinator);
        } else {
            IpValidator.validateAddressTowardsInterface(stringParameter.getValue(), managedObject, "IpAccessHostGpb", coordinator);
        }
    }

    private Map getFroAttributes(Coordinator coordinator) throws MoAccessException {
        Map map = this.genIpacHostGpbProxy.getAttributes(coordinator, this.getFroId(coordinator));
        return map;
    }

    private static int getPiuId(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (managedObject.getParent().getType().equals("Cbu")) {
            ManagedObject managedObject2 = managedObject.getParent();
            return ((PlugInUnitMoInternal)managedObject2.getParent()).getResourceId(coordinator);
        }
        return ((PlugInUnitMoInternal)managedObject.getParent()).getResourceId(coordinator);
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        if (coordinator == null) {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
        } else {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
        }
    }

    private static void checkGeneralProcessorUnitReservations(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ManagedObject[] managedObjectArray = ((GeneralProcessorUnitMo)managedObject).getReservedBy(coordinator);
        if (managedObjectArray != null) {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                if (!managedObjectArray[i].getType().equals("IpAccessHostGpb")) continue;
                throw new ValueOutOfRangeException("The host cannot be configured on a GPU that is already reserved by a IpAccessHostGpb", "IpAccessHostGpb");
            }
        }
    }

    private ManagedObject piuFroId2GpuInstance(Coordinator coordinator, int n) throws MoAccessException {
        Object var3_3 = null;
        ManagedObject managedObject = null;
        ManagedObject managedObject2 = null;
        ManagedObject managedObject3 = null;
        PlugInUnitRepository plugInUnitRepository = (PlugInUnitRepository)this.getMaoContext().getServiceRepository().getService(PlugInUnitRepository.class);
        if (plugInUnitRepository != null) {
            managedObject = plugInUnitRepository.lookupInstance(n, coordinator);
        } else {
            MessageLog.traceError(this.getClass(), (String)"PlugInUnitRepository not registered in ServiceRepository.");
        }
        if (managedObject == null) {
            throw new ConfigurationMismatchException("Failed to fetch reference PlugInUnit", "IpAccessHostGpb");
        }
        MoIterator moIterator = managedObject.getChildren();
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject2 = moIterator.nextMo();
            if (managedObject2.getType().equals("GeneralProcessorUnit")) {
                managedObject3 = managedObject2;
                continue;
            }
            if (!managedObject2.getType().equals("Cbu")) continue;
            MoIterator moIterator2 = managedObject2.getChildren();
            while (moIterator2 != null && moIterator2.hasMoreElements()) {
                ManagedObject managedObject4 = moIterator2.nextMo();
                if (!managedObject4.getType().equals("GeneralProcessorUnit")) continue;
                managedObject3 = managedObject4;
            }
        }
        if (managedObject3 == null) {
            throw new ConfigurationMismatchException("Failed to fetch referenceGeneralProcessorUnit", "IpAccessHostGpb");
        }
        return managedObject3;
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(this.tnd);
            SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("administrativeState");
            if (signedIntParameter != null) {
                this.sendNotification("administrativeState", new Integer(signedIntParameter.getValue()), null);
            } else {
                MessageLog.traceError(this.getClass(), (String)"Unknown attribute in parameterChanged()");
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag not in property file");
        }
    }

    private void validateAddressForIpInterfaceGroup(String string, ManagedObject managedObject, String string2, Coordinator coordinator) throws MoAccessException {
        IpInterfaceMo ipInterfaceMo = (IpInterfaceMo)((IpInterfaceGroupMo)managedObject).getPrimaryIpInterfaceRef(coordinator);
        IpValidator.validateAddressTowardsInterface(string, ipInterfaceMo, "IpAccessHostGpb", coordinator);
        IpInterfaceMo ipInterfaceMo2 = (IpInterfaceMo)((IpInterfaceGroupMo)managedObject).getSecondaryIpInterfaceRef(coordinator);
        IpValidator.validateAddressTowardsInterface(string, ipInterfaceMo2, "IpAccessHostGpb", coordinator);
    }

    private IpInterfaceGroupMo findIpInterfaceGroup(int n, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        MoIterator moIterator = MoRepository.instance().lookupType("IpInterfaceGroup");
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            if (n != ((IpInterfaceGroupMoImpl)managedObject).getFroId(coordinator)) continue;
            return (IpInterfaceGroupMo)managedObject;
        }
        return null;
    }

    public ManagedObject getActiveGpuId(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("activeGpuId", coordinator);
    }
}

