/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.StringTokenizer;
import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.iptransport.IpFlowMonitorMoGen;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.Ipv4AddressValidation;
import se.ericsson.cello.mao.Ipv6AddressValidation;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;

public class IpFlowMonitorMoImpl
extends IpFlowMonitorMoGen {
    public IpFlowMonitorMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList);
    }

    public IpFlowMonitorMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy);
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        Coordinator coordinator = setRequestContext.getCoordinator();
        int[] nArray = (int[])setRequestContext.getAttributeFromRequest("dscpValue");
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("IpIfFroId", this.getIpIfFroId(coordinator)));
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("piuId", this.getPiuId(coordinator)));
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("lengthOfDscpList", nArray.length));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateRemoteIpAddress(String string, SetRequestContext setRequestContext) throws MoAccessException {
        if (string.equals("")) return;
        if (this.getParent() instanceof IpInterfaceMo) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            String string2 = stringTokenizer.nextToken();
            if (!Ipv4AddressValidation.isIpv4((String)string2)) throw new IpFormatException("The address " + string + " is not a valid Ipv4 address. IpFlowMonitor with parent IpInterface should have Ipv4 address.");
            Ipv4AddressValidation.validateIpV4addressWithPrefix((String)string);
            return;
        } else {
            if (!Ipv6AddressValidation.isIpv6((String)string)) throw new IpFormatException("The address " + string + " is not a valid IPv6 address. IpFlowMonitor with parent Ipv6Interface should have Ipv6 address. ");
            Ipv6AddressValidation.validateIpV6addressWithPrefix((String)string);
        }
    }

    protected int getIpIfFroId(Coordinator coordinator) throws MoAccessException {
        if (this.getParent() instanceof IpInterfaceMo) {
            return ((IpInterfaceMo)this.getParent()).getFroId(coordinator);
        }
        return ((Ipv6InterfaceMo)this.getParent()).getFroId(coordinator);
    }

    protected int getPiuId(Coordinator coordinator) throws MoAccessException {
        if (this.getParent() instanceof IpInterfaceMo) {
            return PiuUtils.findPiuParentFroId((ManagedObject)this.getParent());
        }
        return PiuUtils.findPiuParentFroId((ManagedObject)((Ipv6InterfaceMo)this.getParent()).getEthernetRef(coordinator));
    }
}

