/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.iptransport.IpAccessHostEtMoImpl;
import se.ericsson.cello.iptransport.IpInterfaceGroupMo;
import se.ericsson.cello.iptransport.IpSyncRefMo;
import se.ericsson.cello.iptransport.VpnInterfaceBuildIF;
import se.ericsson.cello.iptransport.ipsyncref_mi;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.DomainNameFormatException;
import se.ericsson.cello.mao.DomainNameValidation;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.FroNotLockedException;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.Ipv4AddressValidation;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.sync.IpSyncReference;
import se.ericsson.cello.sync.SyncReservable;
import se.ericsson.cello.transaction.Coordinator;

public class IpSyncRefMoImpl
extends CelloMao
implements IpSyncRefMo,
Reservable,
FroInfo,
SyncReservable,
IpSyncReference {
    private MoData data;
    private FroProxy genIpSyncRefProxy = null;
    private MaoFroIndicationHandler indicationHandler = null;
    static final String HOST_PIU_ID = "hostPiuId";
    static final String HOST_FRO_ID = "hostFroId";
    private static final String IPSYNCREF_FRO_ID = "ipSyncRefFroId";
    private static final int SYNC_STATUS_NOT_REACHABLE = 0;
    private static final int SYNC_STATUS_NOT_RELIABLE = 1;
    private static final int SYNC_STATUS_OK = 2;
    private static final int MAX_NUMBER_IPSYNCREF = 8;
    private static final int MIN_LENGTH_NTPSERVER_IPADDRESS = 0;
    private static final int MAX_LENGTH_NTPSERVER_IPADDRESS = 255;
    private static final String DEFAULT_NTPSERVER_IPADDRESS = "";
    private static final int MO_DATA_REVISION_6000 = 6000;
    private static final int MO_DATA_REVISION_LATEST = 6000;
    private static TagNameDictionary tnd = TagNameDictionaries.get((ResourceBundle)ResourceBundle.getBundle(ipsyncref_mi.class.getName()));
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        Object object;
        Object object2;
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"IpSyncRef", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"IpAccessHostEt");
        MoAttributeValidator.checkCardinality((String)"IpSyncRef", (int)8);
        ManagedObject managedObject3 = ((IpAccessHostEtMo)managedObject).getIpInterfaceMoRef(coordinator);
        if (managedObject3 instanceof IpInterfaceGroupMo) {
            throw new MoCanNotBeCreatedException("Cannot create IpSyncRef Mo when parent IpAccessHostEt Mo is connected directly to an  IpInterfaceGroup. IpAccessHostEt");
        }
        if (managedObject3 instanceof VpnInterfaceBuildIF && ((IpAccessHostEtMo)(object2 = ((VpnInterfaceBuildIF)managedObject3).getIpAccessHostEtRef(coordinator))).getIpInterfaceMoRef(coordinator) instanceof IpInterfaceGroupMo) {
            throw new MoCanNotBeCreatedException("Cannot create IpSyncRef Mo when parent IpAccessHostEt Mo is connected indirectly to an  IpInterfaceGroup. IpAccessHostEt");
        }
        object2 = ((IpAccessHostEtMo)managedObject).getIpAddress(coordinator);
        if (Ipv4AddressValidation.isIpv4((String)object2)) {
            object = MoRepository.instance().lookupType("IpAccessHostEt");
            while (object.hasMoreElements()) {
                IpAccessHostEtMoImpl ipAccessHostEtMoImpl = (IpAccessHostEtMoImpl)object.nextMo();
                int n = (Integer)ipAccessHostEtMoImpl.getAttribute("ntpServerMode", coordinator);
                if (n != 1) continue;
                throw new ValueOutOfRangeException("ntpServerMode", "IpAccessHostEt");
            }
        } else if (!((String)object2).equals(DEFAULT_NTPSERVER_IPADDRESS)) {
            throw new MoCanNotBeCreatedException("IpSyncRef");
        }
        if (managedObject.getType().equals("IpAccessHostEt") && (object = ((ManagedObject)managedObject.getAttribute("ipInterfaceMoRef", coordinator)).getType()) == "Ipv6Interface") {
            throw new MoCanNotBeCreatedException("IpSyncRef");
        }
        object = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)DEFAULT_NTPSERVER_IPADDRESS, (String)"IpSyncRef", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"administrativeState", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)2, (String)"IpSyncRef");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"ntpServerIpAddress", (AttrList)attrList, (boolean)false, (String)DEFAULT_NTPSERVER_IPADDRESS, (String)"IpSyncRef", (int)255, (int)0);
        IpSyncRefMoImpl.checkNtpServerIpAddressFormat(string2);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"IpSyncRef");
        return new IpSyncRefMoImpl(managedObject, string, (String)object, n, string2, coordinator, froProxy, maoFroIndicationHandler);
    }

    private IpSyncRefMoImpl(ManagedObject managedObject, String string, String string2, int n, String string3, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "IpSyncRef", string, coordinator);
        this.genIpSyncRefProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.checkNtpServerAddressUniqueness(coordinator, string3);
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        int n2 = ((IpAccessHostEtMoImpl)managedObject).getPlugInUnitHostId(coordinator);
        int n3 = ((IpAccessHostEtMoImpl)managedObject).getHostFroId(coordinator);
        int n4 = this.createIpSyncFro(coordinator, n3, n2, n, string3);
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(IPSYNCREF_FRO_ID, false, n4));
        this.data.setRevision(6000);
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n4);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public IpSyncRefMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.genIpSyncRefProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(6000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute(IPSYNCREF_FRO_ID);
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute(IPSYNCREF_FRO_ID)).getValue(null));
    }

    private int createIpSyncFro(Coordinator coordinator, int n, int n2, int n3, String string) throws MoAccessException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new SignedIntParameter(HOST_PIU_ID, n2));
        arrayList.add(new SignedIntParameter(HOST_FRO_ID, n));
        arrayList.add(new SignedIntParameter("administrativeState", n3));
        arrayList.add(new StringParameter("ntpServerIpAddress", string));
        FroData froData = this.genIpSyncRefProxy.create(coordinator, arrayList);
        return froData.getFroId();
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedBy(coordinator).length != 0) {
            throw new MoReservedNotDeletableException((ManagedObject)this);
        }
        int n = (Integer)this.getAttribute("administrativeState", coordinator);
        if (n != 0) {
            throw new FroNotLockedException(this.getType(), "The MO can not be deleted when unlocked");
        }
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        this.genIpSyncRefProxy.delete(coordinator, this.getFroId(coordinator), null);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public void syncReserve(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.reserve(managedObject, coordinator);
    }

    public void syncRelease(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.release(managedObject, coordinator);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        return this.getHostFroId(coordinator);
    }

    public String getType() {
        return "IpSyncRef";
    }

    public int getHostFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(IPSYNCREF_FRO_ID)).getValue(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("administrativeState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("availabilityStatus");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ntpServerIpAddress")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (StringParameter)map.get("ntpServerIpAddress");
                objectArray[i] = signedIntParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("syncStatus")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("syncStatus");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("cachedIpAddress")) {
                signedIntParameter = (StringParameter)(map = this.getAttrFromRes(map, coordinator)).get("cachedIpAddress");
                if (signedIntParameter == null) {
                    objectArray[i] = DEFAULT_NTPSERVER_IPADDRESS;
                    continue;
                }
                objectArray[i] = signedIntParameter.getValue();
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "IpSyncRef");
        }
        return objectArray;
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.getFroAttributes(coordinator);
        }
        return map;
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(tnd);
            StringParameter stringParameter = (StringParameter)map.get("cachedIpAddress");
            SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("administrativeState");
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            if (stringParameter != null) {
                arrayList.add("cachedIpAddress");
                arrayList2.add(stringParameter.getValue());
            }
            if (signedIntParameter != null) {
                arrayList.add("administrativeState");
                arrayList2.add(new Integer(signedIntParameter.getValue()));
            }
            if (arrayList.size() == 0) {
                MessageLog.traceError(this.getClass(), (String)"Unknown attribute in parameterChanged()");
                return;
            }
            NotificationSender.instance().pushAVC((ManagedObject)this, arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray());
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute not in property file");
        }
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = 0;
        String string = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? IpSyncRefMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "IpSyncRef");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"IpSyncRef", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpSyncRefMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("administrativeState", "IpSyncRef");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"administrativeState", (int)n, (int)0, (int)2, (String)"IpSyncRef");
                arrayList.add(new SignedIntParameter("administrativeState", n));
                this.sendNotification("administrativeState", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ntpServerIpAddress")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? IpSyncRefMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("ntpServerIpAddress", "IpSyncRef");
                }
                string = (String)objectArray[i];
                MoAttributeValidator.checkStringWithLength((String)string, (String)"ntpServerIpAddress", (String)"IpSyncRef", (int)255, (int)0);
                IpSyncRefMoImpl.checkNtpServerIpAddressFormat(string);
                this.checkNtpServerAddressUniqueness(coordinator, string);
                if ((Integer)this.getAttribute("administrativeState", coordinator) != 0) {
                    throw new OperationNotAllowedException("Administrative state must be locked when setting ntpServerIpAddress.", "IpSyncRef");
                }
                arrayList.add(new StringParameter("ntpServerIpAddress", string));
                this.sendNotification("ntpServerIpAddress", string, coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "IpSyncRef");
        }
        if (arrayList.size() > 0) {
            this.genIpSyncRefProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    private static void checkNtpServerIpAddressFormat(String string) throws MoAccessException {
        if (string.length() == 0 || string.equals(DEFAULT_NTPSERVER_IPADDRESS)) {
            return;
        }
        try {
            if (Ipv4AddressValidation.isDefault((String)string)) {
                throw new OperationNotAllowedException("ntpServerIpAddress must be a valid IP address. 0.0.0.0 is not allowed", "IpSyncRef");
            }
            Ipv4AddressValidation.isValidIpv4Address((String)string);
        }
        catch (IpFormatException ipFormatException) {
            try {
                DomainNameValidation.validate((String)string);
            }
            catch (DomainNameFormatException domainNameFormatException) {
                throw new ConfigurationMismatchException("ntpServerIpAddress must be either a valid IPv4 address or a valid domain name.", "IpSyncRef");
            }
        }
    }

    private void checkNtpServerAddressUniqueness(Coordinator coordinator, String string) throws MoAccessException {
        ManagedObject managedObject = null;
        IpSyncRefMoImpl ipSyncRefMoImpl = null;
        MoIterator moIterator = this.getParent().getChildren();
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                String string2;
                managedObject = moIterator.nextMo();
                if (!managedObject.getType().equals("IpSyncRef") || managedObject.getLocalDistinguishedName().equals(this.getLocalDistinguishedName()) || (string2 = (String)(ipSyncRefMoImpl = (IpSyncRefMoImpl)managedObject).getAttribute("ntpServerIpAddress", coordinator)) == null || !string2.equals(string)) continue;
                throw new ValueOutOfRangeException("ntpServerAddress must be unique for IpSynRefMos on the same ET board", "IpSyncRef");
            }
        }
    }

    private Map getFroAttributes(Coordinator coordinator) throws MoAccessException {
        Map map = this.genIpSyncRefProxy.getAttributes(coordinator, this.getFroId(coordinator));
        return map;
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("administrativeState", coordinator);
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("administrativeState", new Integer(n), coordinator);
    }

    public void setNtpServerIpAddress(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ntpServerIpAddress", string, coordinator);
    }

    public String getNtpServerIpAddress(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("ntpServerIpAddress", coordinator);
    }

    public int getSyncStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("syncStatus", coordinator);
    }

    public String getCachedIpAddress(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("cachedIpAddress", coordinator);
    }

    public String getIpSyncRefId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute(this.getType() + "Id", coordinator);
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        if (coordinator == null) {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
        } else {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
        }
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
    }
}

