/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.iptransport.TrafficManagementMo;
import se.ericsson.cello.iptransport.ipi_tm_mi;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.mom.commondefinitions.EnumStateValsCheck;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class TrafficManagementMoImpl
extends CelloMao
implements TrafficManagementMo,
Reservable {
    private MoData data;
    private FroProxy genericProxyInstance;
    private MaoFroIndicationHandler indicationHandler;
    private static final TagNameDictionary DICTIONARY = TagNameDictionaries.get((ResourceBundle)new ipi_tm_mi());
    private static final int MAX_TRAFFICMANAGEMENT_MOS = 1;
    private static final int MO_DATA_REVISION_9 = 9000;
    private static final int MO_DATA_REVISION_LATEST = 9000;
    private StringAttribute userLabel;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"TrafficManagement", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"IpSystem");
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"TrafficManagement", (int)1);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"TrafficManagement", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetEnumAttribute((String)"featureState", (AttrList)attrList, (boolean)false, (int)0, (int[])EnumStateValsCheck.VALUES_ARRAY, (String)"TrafficManagement");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"TrafficManagement");
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        arrayList.add(new SignedIntParameter("featureState", n));
        return new TrafficManagementMoImpl(managedObject, string, string2, arrayList, coordinator, froProxy, maoFroIndicationHandler);
    }

    public TrafficManagementMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.genericProxyInstance = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(9000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("froId");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null));
    }

    private TrafficManagementMoImpl(ManagedObject managedObject, String string, String string2, ArrayList arrayList, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "TrafficManagement", string, coordinator);
        this.genericProxyInstance = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        FroData froData = this.genericProxyInstance.create(coordinator, (Collection)arrayList);
        int n = froData.getFroId();
        this.userLabel = new StringAttribute("userLabel", true, string2);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n);
        this.data.setRevision(9000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedBy(coordinator).length != 0) {
            throw new MoReservedNotDeletableException((ManagedObject)this);
        }
        this.genericProxyInstance.delete(coordinator, this.getFroId(coordinator), null);
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        return this.getAttributes(new String[]{string}, coordinator)[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("TrafficManagementId")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("featureState")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("featureState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("licenseState")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("licenseState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "TrafficManagement");
        }
        return objectArray;
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.getFroAttributes(coordinator);
        }
        return map;
    }

    private Map getFroAttributes(Coordinator coordinator) throws MoAccessException {
        Map map = this.genericProxyInstance.getAttributes(coordinator, this.getFroId(coordinator));
        return map;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Map map = this.prepareSetFroAttr(coordinator);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? TrafficManagementMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "TrafficManagement");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"TrafficManagement", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("featureState")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? TrafficManagementMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("featureState", "TrafficManagement");
                }
                int n = (Integer)objectArray[i];
                MoAttributeValidator.checkEnumAttribute((String)"featureState", (int)n, (int[])EnumStateValsCheck.VALUES_ARRAY, (String)"TrafficManagement");
                map.put("featureState", new SignedIntParameter("featureState", n));
                this.sendNotification("featureState", new Integer(n), coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "TrafficManagement");
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(map.values());
        this.genericProxyInstance.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        if (coordinator == null) {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
        } else {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
        }
    }

    private Map prepareSetFroAttr(Coordinator coordinator) throws MoAccessException {
        Map map = this.genericProxyInstance.getAttributes(coordinator, this.getFroId(coordinator), null);
        return map;
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }

    public int getLicenseState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("licenseState", coordinator);
    }

    public int getFeatureState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("featureState", coordinator);
    }

    public void setFeatureState(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("featureState", new Integer(n), coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"TrafficManagement", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public String getType() {
        return "TrafficManagement";
    }

    public String getTrafficManagementId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("TrafficManagementId", coordinator);
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(DICTIONARY);
            SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("licenseState");
            if (signedIntParameter != null) {
                this.sendNotification("licenseState", new Integer(signedIntParameter.getValue()), null);
            } else {
                MessageLog.info((String)("LICENSE_STATE " + map.get("licenseState") + "Unknown attribute in parameterChanged()"));
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag  not in property file");
        }
    }
}

