/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.iptransport.TwampResponderMoGen;
import se.ericsson.cello.iptransport.VpnInterfaceBuildIF;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class TwampResponderMoImpl
extends TwampResponderMoGen
implements FroInfo {
    private ManagedObject ipAccessHostEtRef = null;

    public TwampResponderMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler);
    }

    public TwampResponderMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    public void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        IpAccessHostEtMo ipAccessHostEtMo;
        if (setRequestContext.isIncludedInRequest("ipAccessHostEtRef") && (ipAccessHostEtMo = (IpAccessHostEtMo)setRequestContext.getAttributeFromRequest("ipAccessHostEtRef")) != null) {
            Coordinator coordinator = setRequestContext.getCoordinator();
            ManagedObject managedObject = ipAccessHostEtMo.getIpInterfaceMoRef(coordinator);
            if (managedObject instanceof VpnInterfaceBuildIF) {
                IpAccessHostEtMo ipAccessHostEtMo2 = (IpAccessHostEtMo)((VpnInterfaceBuildIF)managedObject).getIpAccessHostEtRef(coordinator);
                managedObject = ipAccessHostEtMo2.getIpInterfaceMoRef(coordinator);
            }
            int n = PiuUtils.findPiuParentFroId((ManagedObject)this.getPrimaryInterface(managedObject, coordinator));
            setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("piuId", n));
        }
    }

    public ManagedObject fetchIpAccessHostEtRef(SignedIntParameter signedIntParameter, Coordinator coordinator) throws MoAccessException {
        if (this.ipAccessHostEtRef == null) {
            this.ipAccessHostEtRef = MaoFroTypeConverter.froId2MaoInstance((String)"IpAccessHostEt", (int)signedIntParameter.getValue(), (Coordinator)coordinator);
        }
        if (this.ipAccessHostEtRef == null) {
            throw new ConfigurationMismatchException("Invalid IpAccessHostEt froId (" + signedIntParameter.getValue() + ")");
        }
        return this.ipAccessHostEtRef;
    }

    protected void validateIpAccessHostEtRef(ManagedObject managedObject, SetRequestContext setRequestContext) throws MoAccessException {
        if (!IpAccessHostEtMo.class.isInstance(managedObject)) {
            throw new WrongAttributeTypeException("ipAccessHostEtRef", "TwampResponder");
        }
        this.ipAccessHostEtRef = managedObject;
    }

    public ManagedObject getPrimaryInterface(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject2 = managedObject;
        if (managedObject instanceof Ipv6InterfaceMo) {
            managedObject2 = (ManagedObject)((Ipv6InterfaceMo)managedObject).getAttribute("ethernetRef", coordinator);
        }
        return managedObject2;
    }
}

