/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Observable;
import java.util.Observer;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.DeleteManager;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.ExportManager;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.MoHandlerCache;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.MoHandlerCacheImpl;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.Zip;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplicationController;

public class ExportDeleteModel
extends Observable
implements Observer {
    private static ExportDeleteModel theInstance = null;
    private static MoHandlerCache moHandler = null;
    private ExportManager exportManager = null;
    private DeleteManager deleteManager = null;
    public static final int VALUE_DEFINED_MAXIMUM_DEPTH = 100;

    private ExportDeleteModel() {
        moHandler = new MoHandlerCacheImpl();
    }

    public static synchronized ExportDeleteModel getTheInstance() {
        if (theInstance == null) {
            theInstance = new ExportDeleteModel();
        }
        return theInstance;
    }

    public static void initiate() {
        theInstance = null;
    }

    public static MoHandlerCache getMoHandler() {
        return moHandler;
    }

    public ExportManager getExportManager() {
        if (this.exportManager == null) {
            ExportManager.initiate();
            this.exportManager = ExportManager.getTheInstance();
        }
        return this.exportManager;
    }

    public DeleteManager getDeleteManager() {
        if (this.deleteManager == null) {
            DeleteManager.initiate();
            this.deleteManager = DeleteManager.getTheInstance();
            this.deleteManager.setMoHandler(ExportDeleteModel.getMoHandler());
        }
        return this.deleteManager;
    }

    public void exportMOToXML(String string, String string2) throws MoHandlerException, IOException, Exception {
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsoluteFile());
        this.exportMOToXML(fileOutputStream, string);
        fileOutputStream.close();
        if (string2 != null) {
            String[] stringArray = new String[]{string};
            Zip.zipIt(string2, stringArray);
            file.delete();
        }
    }

    public void exportMOToXML(OutputStream outputStream, String string) throws MoHandlerException, IOException, Exception {
        if (this.exportManager == null) {
            this.getExportManager();
            moHandler.initiateCache();
        }
        this.exportManager.exportMOProxyToXML(moHandler, outputStream, string);
    }

    public void exportMOToXML(OutputStream outputStream, String string, AbstractApplicationController abstractApplicationController) throws MoHandlerException, IOException, Exception {
        if (this.exportManager == null) {
            this.getExportManager();
            moHandler.initiateCache();
        }
        this.exportManager.setAbstractController(abstractApplicationController);
        this.exportManager.exportMOProxyToXML(moHandler, outputStream, string);
    }

    public Object[] getRbsLocalCellsNotOffLine() throws MoHandlerException {
        if (this.deleteManager == null) {
            this.getDeleteManager();
            moHandler.initiateCache();
        }
        return this.deleteManager.getRbsLocalCellsNotOffLine();
    }

    public boolean isSecondaryDuwOffLine() throws MoHandlerException {
        if (this.deleteManager == null) {
            this.getDeleteManager();
            moHandler.initiateCache();
        }
        return this.deleteManager.secondaryDuwOffLine();
    }

    public boolean prepareDeleteMO() throws BemException {
        boolean bl = false;
        try {
            if (this.deleteManager == null) {
                this.getDeleteManager();
                moHandler.initiateCache();
            }
            moHandler.clearOrderMoOperations();
            bl = this.deleteManager.prepareDeleteRdbt();
            if (!bl) {
                return bl;
            }
            bl = this.deleteManager.prepareUnInitSectors();
            if (!bl) {
                return bl;
            }
            bl = this.deleteManager.prepareDeleteCellsAndCarriers();
            if (!bl) {
                return bl;
            }
            bl = this.deleteManager.prepareDeleteCables();
            if (!bl) {
                return bl;
            }
            bl = this.deleteManager.prepareDeleteBbif();
            if (!bl) {
                return bl;
            }
            bl = this.deleteManager.prepareDeleteCabinetChildren();
            if (!bl) {
                return bl;
            }
            bl = this.deleteManager.prepareDeleteEcPort();
            if (!bl) {
                return bl;
            }
            bl = this.deleteManager.prepareDeleteEquipment();
            if (!bl) {
                return bl;
            }
            bl = this.deleteManager.prepareDeleteSectors();
            if (!bl) {
                return bl;
            }
            bl = this.deleteManager.prepareDeleteApc();
            if (!bl) {
                return bl;
            }
            bl = this.deleteManager.prepareGpsAndTimeSyncToDef();
            if (!bl) {
                return bl;
            }
            bl = this.deleteManager.prepareDeleteCabinet();
            if (!bl) {
                return bl;
            }
            return bl;
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("failed in prepareDeleteMO", (Throwable)moHandlerException);
        }
    }

    public boolean prepareRemoveSecondaryDUW() throws BemException {
        boolean bl = false;
        try {
            if (this.deleteManager == null) {
                this.getDeleteManager();
                moHandler.initiateCache();
            }
            this.deleteManager.LockPlugInUnit();
            bl = this.deleteManager.prepareDeleteTimingUnit();
            if (!bl) {
                return bl;
            }
            bl = this.deleteManager.prepareDeleteTimDeviceSet();
            if (!bl) {
                return bl;
            }
            bl = this.deleteManager.prepareDeleteMoUnderPlugInUnit();
            if (!bl) {
                return bl;
            }
            bl = this.deleteManager.prepareDeletePlugInUnit();
            if (!bl) {
                return bl;
            }
            bl = this.deleteManager.prepareDeleteSlot2();
            if (!bl) {
                return bl;
            }
            return bl;
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("failed in prepareRemoveSecondaryDUW", (Throwable)moHandlerException);
        }
    }

    public boolean prepareDeleteInterPiuLink() throws BemException {
        boolean bl = false;
        try {
            if (this.deleteManager == null) {
                this.getDeleteManager();
                moHandler.initiateCache();
            }
            if (!(bl = this.deleteManager.prepareDeleteInterPiuLink())) {
                return bl;
            }
            return bl;
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("failed in prepareDeleteInterPiuLink", (Throwable)moHandlerException);
        }
    }

    public boolean commitDeleteMO() throws MoHandlerException {
        moHandler.commitOrderredMoOperations();
        moHandler.clearCache();
        return true;
    }

    public int getTotalNoOfExportProgressReports() throws MoHandlerException, Exception {
        moHandler.initiateCache();
        BemMo[] bemMoArray = moHandler.getChildren(moHandler.getRoot(), 100, "", "");
        int n = bemMoArray.length;
        return n += this.exportManager.getNoOfReportsForDecryptAndParseOfCompleteMom();
    }

    public int getTotalNoOfDeleteProgressReports() {
        return 120;
    }

    public synchronized void addObserver(Observer observer) {
        super.addObserver(observer);
        this.exportManager = this.getExportManager();
        this.exportManager.addObserver(observer);
        this.deleteManager = this.getDeleteManager();
        this.deleteManager.addObserver(observer);
        moHandler.addObserver(observer);
    }

    public synchronized void deleteObserver(Observer observer) {
        super.deleteObserver(observer);
        this.exportManager = this.getExportManager();
        this.exportManager.deleteObserver(observer);
        this.deleteManager = this.getDeleteManager();
        this.deleteManager.deleteObserver(observer);
        moHandler.deleteObserver(observer);
    }

    public synchronized void deleteObservers() {
        super.deleteObservers();
        this.exportManager = this.getExportManager();
        this.exportManager.deleteObservers();
        this.deleteManager = this.getDeleteManager();
        this.deleteManager.deleteObservers();
        moHandler.deleteObservers();
    }

    public void update(Observable observable, Object object) {
    }
}

