/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.provider.ConfigurationData;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.provider.ExportConfigDataProvider;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.CabinetXmlManager;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.OamXmlManager;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.SiteXmlManager;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.Zip;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportConfigDataManager
implements ExportConfigDataProvider {
    private static final String DTD_FILE_PATH = "/se/ericsson/wcdma/rbs/bem/wizard/wizards";
    private static final EnumMap<ExportConfigDataProvider.TYPE_OF_CONFIG, String> DTD_FILE_NAME_MAP = new EnumMap(ExportConfigDataProvider.TYPE_OF_CONFIG.class);
    private static final EnumMap<ExportConfigDataProvider.TYPE_OF_CONFIG, String> DTD_FILE_NAME_PATH_MAP;
    private final EnumMap<ExportConfigDataProvider.TYPE_OF_CONFIG, String> xmlFileNameMap = new EnumMap(ExportConfigDataProvider.TYPE_OF_CONFIG.class);
    private Rbs rbs;
    private String[] configurationCheckReport;

    public ExportConfigDataManager(Rbs rbs, String string, String string2, String string3, String[] stringArray) {
        this.rbs = rbs;
        this.xmlFileNameMap.put(ExportConfigDataProvider.TYPE_OF_CONFIG.CABINET, string);
        this.xmlFileNameMap.put(ExportConfigDataProvider.TYPE_OF_CONFIG.SITE, string2);
        this.xmlFileNameMap.put(ExportConfigDataProvider.TYPE_OF_CONFIG.OAM, string3);
        this.configurationCheckReport = stringArray;
    }

    @Override
    public void exportConfigurationToZip(String string) throws BemException {
        List<ConfigurationData> list = this.getConfigurationData();
        this.exportConfigurationToZip(string, list);
    }

    @Override
    public List<ConfigurationData> getConfigurationData() throws BemException {
        EnumMap<ExportConfigDataProvider.TYPE_OF_CONFIG, InputStream> enumMap = new EnumMap<ExportConfigDataProvider.TYPE_OF_CONFIG, InputStream>(ExportConfigDataProvider.TYPE_OF_CONFIG.class);
        EnumMap<ExportConfigDataProvider.TYPE_OF_CONFIG, ByteArrayInputStream> enumMap2 = new EnumMap<ExportConfigDataProvider.TYPE_OF_CONFIG, ByteArrayInputStream>(ExportConfigDataProvider.TYPE_OF_CONFIG.class);
        try {
            CabinetXmlManager cabinetXmlManager = new CabinetXmlManager(this.rbs, this.xmlFileNameMap.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.CABINET), this.configurationCheckReport);
            enumMap.put(ExportConfigDataProvider.TYPE_OF_CONFIG.CABINET, cabinetXmlManager.createInputStreamWithXmlData());
            SiteXmlManager siteXmlManager = new SiteXmlManager(this.rbs, this.xmlFileNameMap.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.SITE), this.configurationCheckReport);
            enumMap.put(ExportConfigDataProvider.TYPE_OF_CONFIG.SITE, siteXmlManager.createInputStreamWithXmlData());
            OamXmlManager oamXmlManager = new OamXmlManager(this.rbs, this.xmlFileNameMap.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.OAM), this.configurationCheckReport);
            enumMap.put(ExportConfigDataProvider.TYPE_OF_CONFIG.OAM, oamXmlManager.createInputStreamWithXmlData());
            URL uRL = this.getClass().getResource(DTD_FILE_NAME_PATH_MAP.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.CABINET));
            URL uRL2 = this.getClass().getResource(DTD_FILE_NAME_PATH_MAP.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.SITE));
            URL uRL3 = this.getClass().getResource(DTD_FILE_NAME_PATH_MAP.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.OAM));
            if (uRL != null && uRL2 != null && uRL3 != null) {
                enumMap2.put(ExportConfigDataProvider.TYPE_OF_CONFIG.CABINET, this.createByteArrayInputStream(DTD_FILE_NAME_PATH_MAP.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.CABINET)));
                enumMap2.put(ExportConfigDataProvider.TYPE_OF_CONFIG.SITE, this.createByteArrayInputStream(DTD_FILE_NAME_PATH_MAP.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.SITE)));
                enumMap2.put(ExportConfigDataProvider.TYPE_OF_CONFIG.OAM, this.createByteArrayInputStream(DTD_FILE_NAME_PATH_MAP.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.OAM)));
            }
            ArrayList<ConfigurationData> arrayList = new ArrayList<ConfigurationData>();
            for (ExportConfigDataProvider.TYPE_OF_CONFIG tYPE_OF_CONFIG : EnumSet.range(ExportConfigDataProvider.TYPE_OF_CONFIG.CABINET, ExportConfigDataProvider.TYPE_OF_CONFIG.OAM)) {
                ConfigurationData configurationData = new ConfigurationData(DTD_FILE_NAME_MAP.get((Object)tYPE_OF_CONFIG), (InputStream)enumMap2.get((Object)tYPE_OF_CONFIG), tYPE_OF_CONFIG, null);
                ConfigurationData configurationData2 = new ConfigurationData(this.xmlFileNameMap.get((Object)tYPE_OF_CONFIG), (InputStream)enumMap.get((Object)tYPE_OF_CONFIG), tYPE_OF_CONFIG, configurationData);
                arrayList.add(configurationData2);
                arrayList.add(configurationData);
            }
            return arrayList;
        }
        catch (IOException iOException) {
            throw new BemException(iOException.toString());
        }
    }

    @Override
    public void exportConfigurationToZip(String string, List<ConfigurationData> list) throws BemException {
        try {
            String[] stringArray = new String[list.size()];
            InputStream[] inputStreamArray = new InputStream[list.size()];
            int n = 0;
            for (ConfigurationData configurationData : list) {
                stringArray[n] = configurationData.getFileName();
                inputStreamArray[n] = configurationData.getInputStream();
                ++n;
            }
            Zip.zipIt(string, inputStreamArray, stringArray);
        }
        catch (IOException iOException) {
            throw new BemException(iOException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayInputStream createByteArrayInputStream(String string) throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        InputStream inputStream = null;
        try {
            URL uRL = ByteArrayInputStream.class.getResource(string);
            if (uRL == null) {
                ByteArrayInputStream byteArrayInputStream2 = null;
                return byteArrayInputStream2;
            }
            inputStream = uRL.openStream();
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return byteArrayInputStream;
    }

    static {
        DTD_FILE_NAME_MAP.put(ExportConfigDataProvider.TYPE_OF_CONFIG.CABINET, "CabinetEquipment.dtd");
        DTD_FILE_NAME_MAP.put(ExportConfigDataProvider.TYPE_OF_CONFIG.SITE, "SiteEquipment.dtd");
        DTD_FILE_NAME_MAP.put(ExportConfigDataProvider.TYPE_OF_CONFIG.OAM, "OamAccess.dtd");
        DTD_FILE_NAME_PATH_MAP = new EnumMap(ExportConfigDataProvider.TYPE_OF_CONFIG.class);
        DTD_FILE_NAME_PATH_MAP.put(ExportConfigDataProvider.TYPE_OF_CONFIG.CABINET, "/se/ericsson/wcdma/rbs/bem/wizard/wizards/cabinet/dtd/CabinetEquipment.dtd");
        DTD_FILE_NAME_PATH_MAP.put(ExportConfigDataProvider.TYPE_OF_CONFIG.SITE, "/se/ericsson/wcdma/rbs/bem/wizard/wizards/site/dtd/SiteEquipment.dtd");
        DTD_FILE_NAME_PATH_MAP.put(ExportConfigDataProvider.TYPE_OF_CONFIG.OAM, "/se/ericsson/wcdma/rbs/bem/wizard/wizards/oam/dtd/OamAccess.dtd");
    }
}

