/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Observable;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.MOMergeSort;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.MoHandlerCache;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.tree.MONode;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimBbifBoard;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCabinet;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCarrier;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCbu;
import se.ericsson.wcdma.rbs.bem.common.mim.MimConnectionField;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDownlinkBaseBandPool;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEcPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEquipment;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEquipmentSupportFunction;
import se.ericsson.wcdma.rbs.bem.common.mim.MimExchangeTerminal;
import se.ericsson.wcdma.rbs.bem.common.mim.MimFanGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimGeneralProcessorUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimInterPiuLink;
import se.ericsson.wcdma.rbs.bem.common.mim.MimJvm;
import se.ericsson.wcdma.rbs.bem.common.mim.MimNodeBFunction;
import se.ericsson.wcdma.rbs.bem.common.mim.MimOpticalInterfaceLink;
import se.ericsson.wcdma.rbs.bem.common.mim.MimOptoCommCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPiuDevice;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPowerDistrSystem;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPowerSupplySystem;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPredefRbsScannerGpeh;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsLocalCell;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsSlot;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsSubrack;
import se.ericsson.wcdma.rbs.bem.common.mim.MimReliableProgramUniter;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRetProfile;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSector;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSectorAntenna;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSlot;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSubrack;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSubrackProdType;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSupportUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwAllocation;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwitchCoreUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwitchFabric;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwitchInternalLink;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTimDeviceSet;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTimingUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTransportNetwork;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTuDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimUplinkBaseBandPool;
import se.ericsson.wcdma.rbs.bem.common.mim.MimWebServer;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.RootMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalObject;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMoImpl;
import se.ericsson.wcdma.rbs.bem.common.util.MimClassInfo;

public class DeleteManager
extends Observable {
    public static final int VALUE_LEVEL_OF_RBSLOCALCELL = 3;
    public static final long VALUE_RBSLOCALCELL_OFFLINE = 8L;
    public static final int VALUE_DEFINED_MAXIMUM_LEVEL = 100;
    public static final int VALUE_LEVEL_OF_CARRIER = 4;
    public static final int VALUE_LEVEL_OF_SECTOR = 3;
    public static final int VALUE_LEVEL_OF_CABLE = 5;
    public static final int VALUE_LEVEL_OF_EQUIPMENT = 2;
    public static final int VALUE_LEVEL_OF_EQUIPMENTSUPPORTFUNCTION = 2;
    public static final int VALUE_LEVEL_OF_SWALLOCATION = 3;
    public static final int VALUE_LEVEL_OF_TIMINGUNIT = 6;
    public static final int VALUE_LEVEL_OF_RDBT = 1;
    public static final int VALUE_LEVEL_OF_ECPORT_MAXIMUM = 5;
    public static final int VALUE_LEVEL_OF_PLUGINUNIT_MAXIMUM = 4;
    public static final int VALUE_LEVEL_OF_SLOT_MAXIMUM = 3;
    public static final int VALUE_LEVEL_OF_INTERPIULINK_MAXIMUM = 2;
    public static final int VALUE_LEVEL_OF_TIMINGUNIT_MAXIMUM = 5;
    public static final int VALUE_LEVEL_OF_TIMDECIVESET_MAXIMUM = 5;
    public static final int VALUE_LEVEL_OF_UNDERPLUGINUNIT = 10;
    public static final int VALUE_LEVEL_OF_AUXPLUGINUNIT = 4;
    public static final int VALUE_LEVEL_OF_PLUGINUNIT = 5;
    public static final int VALUE_LEVEL_OF_BBIF = 5;
    public static final int TOTAL_NO_OF_PROGRESS_REPORTS = 120;
    public static final int TOTAL_NO_OF_TRANSACTIONS = 7;
    public static final int TOTAL_NO_OF_PROGRESS_REPORTS_PER_TRANSACTION = 17;
    private static final String ATTRNAME_ADMINISTRATIVESTATE = "administrativeState";
    private static final String VALUE_STRING_PROGRESS_FOR_CELLS = "Preparing to Delete Cells and Carriers  ";
    private static final String VALUE_STRING_PROGRESS_FOR_UNINIT_SECTOR = "Preparing to Uninitialize Sectors       ";
    private static final String VALUE_STRING_PROGRESS_FOR_DELETE_SECTOR = "Preparing to Delete Sectors             ";
    private static final String VALUE_STRING_PROGRESS_FOR_CABLES = "Preparing to Delete Cables              ";
    private static final String VALUE_STRING_PROGRESS_FOR_CABINET_CHILDREN = "Preparing to Delete Cabinet MO children ";
    private static final String VALUE_STRING_PROGRESS_FOR_CABINET = "Preparing to Delete Cabinet MO          ";
    private static final String VALUE_STRING_PROGRESS_FOR_EQUIPMENT = "Preparing to Delete Equipment           ";
    private static final String[] EQUIPMENT_WITH_SIBILNGS_THAT_MUST_NOT_BE_DELETED = new String[]{MimExchangeTerminal.MOTYPENAME, MimGeneralProcessorUnit.MOTYPENAME, MimSwitchCoreUnit.MOTYPENAME, MimTimingUnit.MOTYPENAME, MimTuDeviceGroup.MOTYPENAME, MimCbu.MOTYPENAME};
    private static final String[] EQUIPMENT_THAT_MUST_NOT_BE_DELETED = new String[]{MimSwitchInternalLink.MOTYPENAME, MimSwitchFabric.MOTYPENAME, MimJvm.MOTYPENAME, MimWebServer.MOTYPENAME, MimConnectionField.MOTYPENAME, MimBbifBoard.MOTYPENAME, MimInterPiuLink.MOTYPENAME};
    private static final String[] EQUIPMENT_THAT_CAN_NOT_BE_DELETED = new String[]{"DeviceSet", "Device", MimDownlinkBaseBandPool.MOTYPENAME, MimOptoCommCable.MOTYPENAME, MimPredefRbsScannerGpeh.MOTYPENAME, MimSupportUnit.MOTYPENAME, MimRbsSlot.MOTYPENAME, MimSectorAntenna.MOTYPENAME, MimSlot.MOTYPENAME, MimSubrackProdType.MOTYPENAME, MimUplinkBaseBandPool.MOTYPENAME, MimCabinet.MOTYPENAME};
    private static final String[] EQUIPMENT_TREATED_AS_CABLE = new String[]{"Cable", MimOpticalInterfaceLink.MOTYPENAME};
    private static DeleteManager theInstance = null;
    private MoHandlerCache moHandler;
    protected BemMo rootMo;
    private NalNameValue[] swAllocRefCnt = null;

    private DeleteManager() {
    }

    public static synchronized DeleteManager getTheInstance() {
        if (theInstance == null) {
            theInstance = new DeleteManager();
        }
        return theInstance;
    }

    public static void initiate() {
        theInstance = null;
    }

    public MoHandlerCache getMoHandler() {
        return this.moHandler;
    }

    public void setMoHandler(MoHandlerCache moHandlerCache) {
        this.moHandler = moHandlerCache;
    }

    public BemMo getRootMo() throws MoHandlerException {
        if (this.rootMo == null) {
            this.rootMo = this.moHandler.getRoot();
        }
        return this.rootMo;
    }

    public Object[] getRbsLocalCellsNotOffLine() throws MoHandlerException {
        Object object;
        int n;
        this.rootMo = this.moHandler.getRoot();
        BemMo[] bemMoArray = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        bemMoArray = this.moHandler.getChildren(this.rootMo, 3, MimRbsLocalCell.MOTYPENAME, "");
        for (n = 0; n < bemMoArray.length; ++n) {
            Object object2 = this.moHandler.getAttribute(bemMoArray[n], "availabilityStatus");
            Object object3 = this.moHandler.getAttribute(bemMoArray[n], "RbsLocalCellId");
            object = "LDN = " + bemMoArray[n].getDN() + ",  " + "availabilityStatus" + ": " + object2.toString();
            BemLog.log(7, (String)object);
            int n2 = (Integer)object2;
            if (this.cellOffline(n2)) continue;
            arrayList.add(object3.toString());
        }
        n = 0;
        object = arrayList.iterator();
        while (object.hasNext()) {
            String string = "No: " + n++ + "\tRbsLocalCellId: " + object.next().toString();
            BemLog.log(7, string);
        }
        return arrayList.toArray();
    }

    public boolean cellOffline(int n) {
        boolean bl = false;
        int[] nArray = new int[]{7, 2, 0, 9, 5, 10, 1, 3};
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = 1;
            int n3 = n;
            if (((n3 >>= nArray[i]) & n2) != 1) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean secondaryDuwOffLine() throws MoHandlerException {
        boolean bl = false;
        this.rootMo = this.moHandler.getRoot();
        BemMo[] bemMoArray = null;
        bemMoArray = this.moHandler.getChildren(this.rootMo, 4, MimPlugInUnit.MOTYPENAME, "");
        for (int i = 0; i < bemMoArray.length; ++i) {
            BemMo bemMo = bemMoArray[i];
            if (!DuwUtil.getSecondaryDuwPiuLdn().equals(bemMo.getDN())) continue;
            Object object = this.moHandler.getAttribute(bemMo, "availabilityStatus");
            String string = "LDN = " + bemMo.getDN() + ",  " + "availabilityStatus" + ": " + object.toString();
            BemLog.log(7, string);
            Integer n = 0;
            if (!(object instanceof Integer)) continue;
            n = (Integer)object;
            bl = n != 0 && n != 1;
        }
        return bl;
    }

    public void LockPlugInUnit() throws MoHandlerException {
        this.rootMo = this.moHandler.getRoot();
        BemMo[] bemMoArray = this.moHandler.getChildren(this.rootMo, 4, MimPlugInUnit.MOTYPENAME, "");
        if (bemMoArray != null && bemMoArray.length > 0) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo bemMo = bemMoArray[i];
                if (!DuwUtil.getSecondaryDuwPiuLdn().equals(bemMo.getDN())) continue;
                Object object = this.moHandler.getAttribute(bemMo, ATTRNAME_ADMINISTRATIVESTATE);
                Integer n = 0;
                if (!(object instanceof Integer) || (n = (Integer)object) != 1) continue;
                this.moHandler.orderMoOperation("lock", bemMo, new NalNameValue[0]);
                String string = "PlugInUnit is unlocked,lock it now";
                BemLog.log(7, string);
            }
        }
    }

    public boolean prepareDeleteCellsAndCarriers() throws MoHandlerException {
        int n;
        this.rootMo = this.moHandler.getRoot();
        BemMo[] bemMoArray = null;
        BemMo[] bemMoArray2 = null;
        Object object = null;
        Object object2 = null;
        int n2 = 0;
        boolean bl = true;
        bemMoArray = this.moHandler.getChildren(this.rootMo, 3, MimRbsLocalCell.MOTYPENAME, "");
        String string = "\nPreparation of deletion of Cells ...";
        BemLog.log(7, string);
        for (n = 0; n < bemMoArray.length; ++n) {
            object = this.moHandler.getAttribute(bemMoArray[n], "availabilityStatus");
            object2 = this.moHandler.getAttribute(bemMoArray[n], "RbsLocalCellId");
            string = "RbsLocalCellId = " + object2 + ",  " + "availabilityStatus" + ": " + object;
            BemLog.log(7, string);
            this.moHandler.orderMoOperation("delete", bemMoArray[n], new NalNameValue[0]);
            n2 = this.checkAndReportProgress(8, n + 1, bemMoArray.length, n2, VALUE_STRING_PROGRESS_FOR_CELLS);
        }
        if (n2 < 8) {
            n2 = this.checkAndReportProgress(8, 1, 1, n2, VALUE_STRING_PROGRESS_FOR_CELLS);
        }
        string = "DeleteManager: Preparation of deletion of orderMoOperation for '" + MimRbsLocalCell.MOTYPENAME + "' DONE";
        BemLog.log(7, string);
        n2 = 0;
        bemMoArray2 = this.moHandler.getChildren(this.rootMo, 4, MimCarrier.MOTYPENAME, "");
        string = "\nPreparation of deletion of Carriers ...";
        BemLog.log(7, string);
        for (n = 0; n < bemMoArray2.length; ++n) {
            object = this.moHandler.getAttribute(bemMoArray2[n], "availabilityStatus");
            string = "LDN = " + bemMoArray2[n].getDN() + ",  " + "availabilityStatus" + ": " + object;
            BemLog.log(7, string);
            this.moHandler.orderMoOperation("delete", bemMoArray2[n], new NalNameValue[0]);
            n2 = this.checkAndReportProgress(8, n + 1, bemMoArray2.length, n2, VALUE_STRING_PROGRESS_FOR_CELLS);
        }
        if (n2 < 8) {
            n2 = this.checkAndReportProgress(8, 1, 1, n2, VALUE_STRING_PROGRESS_FOR_CELLS);
        }
        string = "DeleteManager: Preparation of deletion of orderMoOperation for '" + MimCarrier.MOTYPENAME + "' DONE";
        BemLog.log(7, string);
        return bl;
    }

    public boolean prepareUnInitSectors() throws MoHandlerException {
        this.rootMo = this.moHandler.getRoot();
        BemMo[] bemMoArray = null;
        Object object = null;
        int n = 0;
        boolean bl = true;
        bemMoArray = this.moHandler.getChildren(this.rootMo, 3, MimSector.MOTYPENAME, "");
        String string = "\nPreparation of Uninit Sectors ...";
        BemLog.log(7, string);
        for (int i = 0; i < bemMoArray.length; ++i) {
            object = this.moHandler.getAttribute(bemMoArray[i], "proceduralStatus");
            string = "LDN = " + bemMoArray[i].getDN() + ",  " + "proceduralStatus" + ": " + object;
            BemLog.log(7, string);
            Integer n2 = 0;
            try {
                if (object instanceof Integer && (n2 = (Integer)object) == 0) {
                    this.moHandler.orderMoOperation("unInitSector", bemMoArray[i], new NalNameValue[0]);
                }
            }
            catch (ClassCastException classCastException) {
                string = "DeleteManager: Casting Attribute proceduralStatusto Integer FAILED";
                BemLog.log(7, string);
            }
            n = this.checkAndReportProgress(17, i + 1, bemMoArray.length, n, VALUE_STRING_PROGRESS_FOR_UNINIT_SECTOR);
        }
        if (n < 17) {
            n = this.checkAndReportProgress(17, 1, 1, n, VALUE_STRING_PROGRESS_FOR_UNINIT_SECTOR);
        }
        string = "DeleteManager: Preparation of UnInit of orderMoOperation for '" + MimSector.MOTYPENAME + "' DONE";
        BemLog.log(7, string);
        return bl;
    }

    public boolean prepareDeleteBbif() throws MoHandlerException {
        this.rootMo = this.moHandler.getRoot();
        BemMo[] bemMoArray = null;
        boolean bl = true;
        bemMoArray = this.moHandler.getChildren(this.rootMo, 5, MimBbifBoard.MOTYPENAME, "");
        String string = "\nPreparation of deletion of Bbif ...";
        BemLog.log(7, string);
        for (int i = 0; i < bemMoArray.length; ++i) {
            string = "LDN = " + bemMoArray[i].getDN();
            BemLog.log(7, string);
            this.moHandler.orderMoOperation("delete", bemMoArray[i], new NalNameValue[0]);
        }
        string = "DeleteManager: Preparation of deletion of orderMoOperation for '" + MimBbifBoard.MOTYPENAME + "' DONE";
        BemLog.log(7, string);
        return bl;
    }

    public boolean prepareDeleteAuxPiuInCorrectOrder() throws MoHandlerException {
        this.rootMo = this.moHandler.getRoot();
        BemMo[] bemMoArray = null;
        boolean bl = true;
        bemMoArray = this.moHandler.getChildren(this.rootMo, 4, MimAuxPlugInUnit.MOTYPENAME, "");
        String string = "\nPreparation of deletion of AuxPiu in correct order ...";
        BemLog.log(7, string);
        for (int i = 0; i < bemMoArray.length; ++i) {
            string = "LDN = " + bemMoArray[i].getDN();
            BemLog.log(7, string);
            this.moHandler.orderMoOperation("delete", bemMoArray[i], new NalNameValue[0]);
        }
        string = "DeleteManager: Preparation of deletion of orderMoOperation for '" + MimAuxPlugInUnit.MOTYPENAME + "' DONE";
        BemLog.log(7, string);
        return bl;
    }

    public boolean prepareDeleteSectors() throws MoHandlerException {
        this.rootMo = this.moHandler.getRoot();
        BemMo[] bemMoArray = null;
        Object object = null;
        int n = 0;
        boolean bl = true;
        bemMoArray = this.moHandler.getChildren(this.rootMo, 3, MimSector.MOTYPENAME, "");
        String string = "\nPreparation of deletion of Sectors ...";
        BemLog.log(7, string);
        for (int i = 0; i < bemMoArray.length; ++i) {
            object = this.moHandler.getAttribute(bemMoArray[i], "availabilityStatus");
            string = "LDN = " + bemMoArray[i].getDN() + ",  " + "availabilityStatus" + ": " + object;
            BemLog.log(7, string);
            this.moHandler.orderMoOperation("delete", bemMoArray[i], new NalNameValue[0]);
            n = this.checkAndReportProgress(17, i + 1, bemMoArray.length, n, VALUE_STRING_PROGRESS_FOR_DELETE_SECTOR);
        }
        if (n < 17) {
            n = this.checkAndReportProgress(17, 1, 1, n, VALUE_STRING_PROGRESS_FOR_DELETE_SECTOR);
        }
        string = "DeleteManager: Preparation of deletion of orderMoOperation for '" + MimSector.MOTYPENAME + "' DONE";
        BemLog.log(7, string);
        return bl;
    }

    public boolean prepareDeleteCables() throws MoHandlerException {
        this.rootMo = this.moHandler.getRoot();
        BemMo[] bemMoArray = null;
        boolean bl = true;
        int n = 0;
        bemMoArray = this.moHandler.getChildren(this.rootMo, 100, "", "");
        String string = "\nPreparation of deletion of Cables ...";
        BemLog.log(7, string);
        for (int i = 0; i < bemMoArray.length; ++i) {
            n = this.checkAndReportProgress(17, i + 1, bemMoArray.length, n, VALUE_STRING_PROGRESS_FOR_CABLES);
            if (!this.isMOTreatedAsCable(bemMoArray[i]) || !this.isMODeletable(bemMoArray[i])) continue;
            this.moHandler.orderMoOperation("delete", bemMoArray[i], new NalNameValue[0]);
        }
        if (n < 17) {
            n = this.checkAndReportProgress(17, 1, 1, n, VALUE_STRING_PROGRESS_FOR_CABLES);
        }
        string = "DeleteManager: Preparation of deletion of orderMoOperation for 'Cables' DONE";
        BemLog.log(7, string);
        return bl;
    }

    public boolean prepareDeleteRdbt() throws MoHandlerException, BemException {
        BemMo[] bemMoArray = null;
        RootMoi rootMoi = new RootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(rootMoi, MimTransportNetwork.MOTYPENAME, "1");
        BemMo bemMo = this.moHandler.getMo(singleChildMoi.getLdn());
        bemMoArray = this.moHandler.getChildren(bemMo, 1, "", "");
        String string = "\nPreparation of deletion of Rdbt ...";
        BemLog.log(7, string);
        for (int i = 0; i < bemMoArray.length; ++i) {
            if (!this.isMOTreatedAsRdbt(bemMoArray[i]) || !this.isMODeletable(bemMoArray[i])) continue;
            this.moHandler.orderMoOperation("delete", bemMoArray[i], new NalNameValue[0]);
        }
        string = "DeleteManager: Preparation of deletion of orderMoOperation for 'Rdbt' DONE";
        BemLog.log(7, string);
        return true;
    }

    public boolean prepareDeleteCabinetChildren() throws MoHandlerException {
        this.rootMo = this.moHandler.getRoot();
        BemMo[] bemMoArray = null;
        boolean bl = true;
        bemMoArray = this.moHandler.getChildren(this.moHandler.getRoot(), 3, MimFanGroup.MOTYPENAME, "");
        if (bemMoArray == null || bemMoArray.length == 0) {
            return true;
        }
        String string = "\nPreparing to Delete Cabinet MO children ";
        BemLog.log(7, string);
        for (int i = 0; i < bemMoArray.length; ++i) {
            this.moHandler.orderMoOperation("delete", bemMoArray[i], new NalNameValue[0]);
        }
        string = "DeleteManager: Preparing to Delete Cabinet MO children  DONE";
        BemLog.log(7, string);
        return bl;
    }

    public boolean prepareDeleteCabinet() throws MoHandlerException {
        this.rootMo = this.moHandler.getRoot();
        BemMo[] bemMoArray = null;
        boolean bl = true;
        int n = 0;
        bemMoArray = this.moHandler.getChildren(this.rootMo, 2, MimCabinet.MOTYPENAME, "");
        String string = "\nPreparing to Delete Cabinet MO          ";
        BemLog.log(7, string);
        for (int i = 0; i < bemMoArray.length; ++i) {
            BemMo bemMo = bemMoArray[i];
            n = this.checkAndReportProgress(17, i + 1, bemMoArray.length, n, VALUE_STRING_PROGRESS_FOR_CABINET);
            Object[] objectArray = (Object[])this.moHandler.getAttribute(bemMo, "reservedBy");
            if (objectArray != null && objectArray.length > 0 && objectArray instanceof BemMo[]) {
                BemMo[] bemMoArray2;
                for (BemMo bemMo2 : bemMoArray2 = (BemMo[])objectArray) {
                    Object object;
                    MONode mONode = this.createNTree(bemMo2);
                    if (bemMo2.getType().equals(MimPlugInUnit.MOTYPENAME)) {
                        object = new NalNameValue[]{Nal.getFactory().getNameValue("positionRef", new BemMoImpl(""))};
                        this.moHandler.orderMoOperation("set attributes", bemMo2, (NalNameValue[])object);
                        continue;
                    }
                    mONode.setDeletable(true);
                    object = mONode.getObjectsToBeDeletedInPostOrder();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        this.moHandler.orderMoOperation("delete", (BemMo)e, new NalNameValue[0]);
                    }
                }
            }
            this.moHandler.orderMoOperation("delete", bemMo, new NalNameValue[0]);
        }
        if (n < 17) {
            n = this.checkAndReportProgress(17, 1, 1, n, VALUE_STRING_PROGRESS_FOR_CABINET);
        }
        string = "DeleteManager: Preparing to Delete Cabinet MO           DONE";
        BemLog.log(7, string);
        return bl;
    }

    public boolean prepareDeleteApc() throws MoHandlerException {
        this.rootMo = this.moHandler.getRoot();
        BemMo[] bemMoArray = this.moHandler.getChildren(this.rootMo, 2, MimEquipmentSupportFunction.MOTYPENAME, "");
        if (bemMoArray != null && bemMoArray.length > 0) {
            MONode mONode = this.createNTree(bemMoArray[0]);
            mONode.setMustNotBeDeleted(true);
            ArrayList arrayList = mONode.getObjectsToBeDeletedInPostOrder();
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                BemMo bemMo = (BemMo)listIterator.next();
                this.moHandler.orderMoOperation("delete", bemMo, new NalNameValue[0]);
            }
        }
        return true;
    }

    public boolean prepareDeleteEcPort() throws MoHandlerException {
        this.rootMo = this.moHandler.getRoot();
        BemMo[] bemMoArray = this.moHandler.getChildren(this.rootMo, 5, MimEcPort.MOTYPENAME, "");
        if (bemMoArray != null && bemMoArray.length > 0) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo bemMo = bemMoArray[i];
                this.moHandler.orderMoOperation("delete", bemMo, new NalNameValue[0]);
            }
        }
        return true;
    }

    public boolean prepareDeleteInterPiuLink() throws MoHandlerException {
        this.rootMo = this.moHandler.getRoot();
        BemMo[] bemMoArray = this.moHandler.getChildren(this.rootMo, 2, MimInterPiuLink.MOTYPENAME, "");
        if (bemMoArray != null && bemMoArray.length > 0) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo bemMo = bemMoArray[i];
                this.moHandler.delete(bemMo);
            }
        }
        return true;
    }

    public boolean prepareDeleteTimingUnit() throws MoHandlerException {
        this.rootMo = this.moHandler.getRoot();
        BemMo[] bemMoArray = this.moHandler.getChildren(this.rootMo, 5, MimTimingUnit.MOTYPENAME, "");
        if (bemMoArray != null && bemMoArray.length > 0) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo bemMo = bemMoArray[i];
                if (bemMo.getDN().indexOf("ManagedElement=1,Equipment=1,Subrack=1,Slot=2,PlugInUnit=1,") < 0) continue;
                this.moHandler.orderMoOperation("delete", bemMo, new NalNameValue[0]);
            }
        }
        return true;
    }

    public boolean prepareDeleteTimDeviceSet() throws MoHandlerException {
        this.rootMo = this.moHandler.getRoot();
        BemMo[] bemMoArray = this.moHandler.getChildren(this.rootMo, 5, MimTimDeviceSet.MOTYPENAME, "");
        if (bemMoArray != null && bemMoArray.length > 0) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo bemMo = bemMoArray[i];
                if (bemMo.getDN().indexOf("ManagedElement=1,Equipment=1,Subrack=1,Slot=2,PlugInUnit=1,") < 0) continue;
                this.moHandler.orderMoOperation("delete", bemMo, new NalNameValue[0]);
            }
        }
        return true;
    }

    public boolean prepareDeleteMoUnderPlugInUnit() throws MoHandlerException {
        this.rootMo = this.moHandler.getRoot();
        BemMo[] bemMoArray = this.moHandler.getChildren(this.rootMo, 10, "", "");
        if (bemMoArray != null && bemMoArray.length > 0) {
            for (int i = 10; i > 4; --i) {
                for (int j = 0; j < bemMoArray.length; ++j) {
                    int n;
                    BemMo bemMo = bemMoArray[j];
                    if (bemMo.getDN().indexOf("ManagedElement=1,Equipment=1,Subrack=1,Slot=2,PlugInUnit=1,") < 0 || i != (n = bemMo.getDN().split(",").length - 1)) continue;
                    String string = "MO: LDN= " + bemMo.getDN() + " must be deleted";
                    BemLog.log(7, string);
                    this.moHandler.orderMoOperation("delete", bemMo, new NalNameValue[0]);
                }
            }
        }
        return true;
    }

    public boolean prepareDeletePlugInUnit() throws MoHandlerException {
        this.rootMo = this.moHandler.getRoot();
        BemMo[] bemMoArray = this.moHandler.getChildren(this.rootMo, 4, MimPlugInUnit.MOTYPENAME, "");
        if (bemMoArray != null && bemMoArray.length > 0) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo bemMo = bemMoArray[i];
                if (!DuwUtil.getSecondaryDuwPiuLdn().equals(bemMo.getDN())) continue;
                this.moHandler.orderMoOperation("delete", bemMo, new NalNameValue[0]);
            }
        }
        return true;
    }

    public boolean prepareDeleteSlot2() throws MoHandlerException {
        this.rootMo = this.moHandler.getRoot();
        BemMo[] bemMoArray = this.moHandler.getChildren(this.rootMo, 3, MimSlot.MOTYPENAME, "");
        if (bemMoArray != null && bemMoArray.length > 0) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo[] bemMoArray2;
                Object[] objectArray;
                BemMo bemMo = bemMoArray[i];
                if (!bemMo.getDN().equals("ManagedElement=1,Equipment=1,Subrack=1,Slot=2") || (objectArray = (Object[])this.moHandler.getAttribute(bemMo, "reservedBy")) == null || objectArray.length <= 0 || !(objectArray instanceof BemMo[])) continue;
                for (BemMo bemMo2 : bemMoArray2 = (BemMo[])objectArray) {
                    Object object;
                    if (bemMo2.getType().equals(MimReliableProgramUniter.MOTYPENAME)) {
                        object = new NalNameValue[]{Nal.getFactory().getNameValue("admPassiveSlot", new BemMoImpl(""))};
                        this.moHandler.orderMoOperation("set attributes", bemMo2, (NalNameValue[])object);
                        continue;
                    }
                    if (bemMo2.getType().equals(MimSwAllocation.MOTYPENAME)) {
                        object = (BemMo[])this.moHandler.getAttribute(bemMo2, "slotList");
                        for (int j = 0; j < ((NalObject[])object).length; ++j) {
                            if (!object[j].getDN().equals("ManagedElement=1,Equipment=1,Subrack=1,Slot=2")) continue;
                            NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("slotList", object[j])};
                            this.moHandler.orderMoOperation("deleteSlot", bemMo2, nalNameValueArray);
                        }
                        continue;
                    }
                    if (bemMo2.getType().equals(MimInterPiuLink.MOTYPENAME)) {
                        object = "MO: LDN= " + bemMo2.getDN() + "check point";
                        BemLog.log(7, (String)object);
                        continue;
                    }
                    this.moHandler.orderMoOperation("delete", bemMo2, new NalNameValue[0]);
                }
            }
        }
        return true;
    }

    public boolean prepareDeleteEquipment() throws MoHandlerException {
        this.rootMo = this.moHandler.getRoot();
        BemMo[] bemMoArray = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        bl = this.createSwAllocRefCnt();
        if (!bl) {
            return bl;
        }
        bemMoArray = this.moHandler.getChildren(this.rootMo, 2, MimEquipment.MOTYPENAME, "");
        String string = "\nPreparation of deletion of Equipment ...";
        BemLog.log(7, string);
        for (int i = 0; i < bemMoArray.length; ++i) {
            Object object;
            MONode mONode = this.createNTree(bemMoArray[i]);
            string = "\nPreparation of Lock of Equipment ...";
            BemLog.log(7, string);
            ArrayList arrayList = mONode.getLockableObjectsInPreOrder();
            ListIterator listIterator = arrayList.listIterator();
            n3 = 0;
            while (listIterator.hasNext()) {
                object = (BemMo)listIterator.next();
                string = "DeleteManager: Lock MOProxy: " + object.getDN();
                BemLog.log(7, string);
                n = this.checkAndReportProgress(17, (i + 1) * n3++, bemMoArray.length * arrayList.size(), n, VALUE_STRING_PROGRESS_FOR_EQUIPMENT);
                if (!this.isMOLockable((BemMo)object)) continue;
                this.moHandler.orderMoOperation("lock", (BemMo)object, new NalNameValue[0]);
            }
            string = "\nPreparation of Delete of Equipment ...";
            BemLog.log(7, string);
            object = mONode.getObjectsToBeDeletedInPostOrder();
            this.checkEcBusMo((List)object);
            ListIterator listIterator2 = object.listIterator();
            n3 = 0;
            while (listIterator2.hasNext()) {
                BemMo bemMo = (BemMo)listIterator2.next();
                string = "DeleteManager: Delete MOProxy: " + bemMo.getDN();
                BemLog.log(7, string);
                n2 = this.checkAndReportProgress(17, (i + 1) * n3++, bemMoArray.length * object.size(), n2, VALUE_STRING_PROGRESS_FOR_EQUIPMENT);
                this.moHandler.orderMoOperation("delete", bemMo, new NalNameValue[0]);
            }
        }
        if ((n += n2) < 34) {
            n = this.checkAndReportProgress(34, 1, 1, n, VALUE_STRING_PROGRESS_FOR_EQUIPMENT);
        }
        string = "DeleteManager: Preparation of deletion of orderMoOperation for 'Equipment' DONE";
        BemLog.log(7, string);
        return bl;
    }

    private void checkEcBusMo(List list) {
        ArrayList<BemMo> arrayList = new ArrayList<BemMo>();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            BemMo bemMo = (BemMo)listIterator.next();
            if (bemMo.getDN().indexOf("EcBus") <= 0) continue;
            this.moHandler.orderMoOperation("delete", bemMo, new NalNameValue[0]);
            arrayList.add(bemMo);
        }
        list.removeAll(arrayList);
    }

    public boolean prepareGpsAndTimeSyncToDef() {
        boolean bl = false;
        NalNameValue[] nalNameValueArray = new NalNameValue[1];
        NalNameValue[] nalNameValueArray2 = new NalNameValue[1];
        nalNameValueArray[0] = Nal.getFactory().getNameValue("gpsOutEnabled", false);
        nalNameValueArray2[0] = Nal.getFactory().getNameValue("featureStateAbsoluteTimeSynch", 0);
        try {
            String string;
            String string2;
            this.rootMo = this.moHandler.getRoot();
            BemMo[] bemMoArray = this.moHandler.getChildren(this.rootMo, 6, MimTimingUnit.MOTYPENAME, "");
            BemMo[] bemMoArray2 = this.moHandler.getChildren(this.rootMo, 2, MimNodeBFunction.MOTYPENAME, "");
            for (int i = 0; i < bemMoArray.length; ++i) {
                string2 = this.moHandler.getAttribute(bemMoArray[i], "gpsOutEnabled").toString();
                if (!string2.equalsIgnoreCase("TRUE")) continue;
                this.moHandler.orderMoOperation("set attributes", bemMoArray[i], nalNameValueArray);
            }
            if (bemMoArray2.length > 0 && (string = this.moHandler.getAttribute(bemMoArray2[0], "featureStateAbsoluteTimeSynch").toString()).equals(string2 = Integer.toString(1))) {
                this.moHandler.orderMoOperation("set attributes", bemMoArray2[0], nalNameValueArray2);
            }
            bl = true;
        }
        catch (MoHandlerException moHandlerException) {
            String string = "Error when trying to set Gps Out Enabled and Absolute Time Synch to default values.";
            BemLog.log(7, string);
        }
        return bl;
    }

    protected MONode createNTree(BemMo bemMo) throws MoHandlerException {
        if (this.mustMOSiblingNotBeDeleted(bemMo)) {
            return new MONode(bemMo, false, true, false, true);
        }
        if (this.mustMONotBeDeleted(bemMo)) {
            return new MONode(bemMo, false, true);
        }
        if (this.isMOTreatedAsCable(bemMo)) {
            String string = "Equipment: LDN= " + bemMo.getDN() + " must NOT be deleted AGAIN";
            BemLog.log(7, string);
            return new MONode(bemMo, false, true);
        }
        String string = "Equipment: LDN= " + bemMo.getDN();
        BemLog.log(7, string);
        boolean bl = this.isMODeletable(bemMo);
        boolean bl2 = this.isMOLockable(bemMo);
        MONode mONode = new MONode(bemMo, bl, false, bl2);
        BemMo[] bemMoArray = this.moHandler.getChildren(bemMo, 1, "", "");
        if (bemMo.getType().equals(MimEquipment.MOTYPENAME)) {
            this.sortChildrenInAscendingOrder(bemMoArray);
            this.arrangeEquipmentInCompulsoryDeleteOrder(bemMoArray);
        } else {
            this.sortChildrenInDescendingOrder(bemMoArray, MimSubrack.MOTYPENAME);
            this.sortChildrenInDescendingOrder(bemMoArray, MimRbsSlot.MOTYPENAME);
        }
        for (int i = 1; i < bemMoArray.length; ++i) {
            if (this.isMOOfTypePiuOrAuxPiu(bemMoArray[i])) {
                this.checkPrepareDeleteSwAllocation(bemMoArray[i]);
            }
            MONode mONode2 = this.createNTree(bemMoArray[i]);
            mONode.appendChild(mONode2);
            if (DuwUtil.getPrimaryDuwPiuLdn().equals(bemMo.getDN()) || DuwUtil.getSecondaryDuwPiuLdn().equals(bemMo.getDN())) {
                mONode.setMustNotBeDeleted(true);
                mONode.setLockable(false);
                ArrayList arrayList = mONode.getChildren();
                int n = 0;
                while (n < arrayList.size()) {
                    MONode mONode3 = (MONode)arrayList.get(n);
                    String string2 = ((BemMoImpl)mONode3.getObject()).getDN();
                    if (string2.contains(MimPiuDevice.MOTYPENAME)) {
                        mONode3.setDeletable(true);
                        ++n;
                        continue;
                    }
                    arrayList.remove(n);
                }
                continue;
            }
            if (mONode2.mustNotDeleteSiblings()) {
                mONode.setMustNotBeDeleted(true);
                mONode.setLockable(false);
                mONode.removeChildren();
                break;
            }
            if (!mONode2.mustNotBeDeleted()) continue;
            mONode.setMustNotBeDeleted(true);
            mONode.setLockable(false);
        }
        return mONode;
    }

    private boolean createSwAllocRefCnt() throws MoHandlerException {
        boolean bl = true;
        BemMo[] bemMoArray = null;
        bemMoArray = this.moHandler.getChildren(this.rootMo, 3, MimSwAllocation.MOTYPENAME, "");
        ArrayList<NalNameValue> arrayList = new ArrayList<NalNameValue>();
        for (int i = 0; i < bemMoArray.length; ++i) {
            BemMo[] bemMoArray2 = null;
            bemMoArray2 = (BemMo[])this.moHandler.getAttribute(bemMoArray[i], "slotList");
            int n = 0;
            if (this.mustMONotBeDeleted(bemMoArray2) || bemMoArray[i].getDN().endsWith("JVM") || bemMoArray[i].getDN().endsWith("WebServer")) continue;
            for (int j = 0; j < bemMoArray2.length; ++j) {
                BemMo[] bemMoArray3 = null;
                if (bemMoArray2[j].getType().equals(MimAuxPlugInUnit.MOTYPENAME)) {
                    ++n;
                    continue;
                }
                bemMoArray3 = this.moHandler.getChildren(bemMoArray2[j], 1, MimPlugInUnit.MOTYPENAME, "");
                if (bemMoArray3.length >= 1) {
                    ++n;
                    continue;
                }
                if (!bemMoArray2[j].getType().equals(MimSlot.MOTYPENAME)) continue;
                NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("slotList", bemMoArray2[j])};
                this.moHandler.orderMoOperation("deleteSlot", bemMoArray[i], nalNameValueArray);
            }
            if (n <= 0) {
                this.moHandler.orderMoOperation("deleteAllRepertoires", bemMoArray[i], new NalNameValue[0]);
                String string = "DeleteManager: Deleting all repertoires in SwAllocation with ldn = " + bemMoArray[i].getDN();
                BemLog.log(7, string);
                this.moHandler.orderMoOperation("delete", bemMoArray[i], new NalNameValue[0]);
                string = "DeleteManager: Deleting SwAllocation (empty slot list) with ldn = " + bemMoArray[i].getDN();
                BemLog.log(7, string);
                arrayList.add(Nal.getFactory().getNameValue(bemMoArray[i].getDN(), 0));
                continue;
            }
            arrayList.add(Nal.getFactory().getNameValue(bemMoArray[i].getDN(), n));
        }
        this.swAllocRefCnt = arrayList.toArray(new NalNameValue[0]);
        return bl;
    }

    private boolean checkPrepareDeleteSwAllocation(BemMo bemMo) throws MoHandlerException {
        boolean bl = true;
        BemMo[] bemMoArray = null;
        boolean bl2 = false;
        bemMoArray = this.moHandler.getChildren(bemMo, 1, "", "");
        for (int i = 0; i < bemMoArray.length; ++i) {
            if (!this.mustMOSiblingNotBeDeleted(bemMoArray[i]) && !this.mustMONotBeDeleted(bemMoArray[i])) continue;
            bl2 = true;
        }
        if (!bl2) {
            return this.prepareDeleteSwAllocation(bemMo);
        }
        return bl;
    }

    private void sortChildrenInAscendingOrder(BemMo[] bemMoArray) {
        int n = bemMoArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = bemMoArray[i].getType();
        }
        MOMergeSort.mergeSortAscending(bemMoArray, stringArray, 1, n - 1);
    }

    private void sortChildrenInDescendingOrder(BemMo[] bemMoArray, String string) {
        String string2 = bemMoArray[0].getType();
        if (string2.endsWith(string)) {
            int n = bemMoArray.length;
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.getValueOfLastElement(bemMoArray[i]);
            }
            MOMergeSort.mergeSortDescending(bemMoArray, stringArray, 1, n - 1);
        }
    }

    private void arrangeEquipmentInCompulsoryDeleteOrder(BemMo[] bemMoArray) throws MoHandlerException {
        int n = bemMoArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getSortedStringFromSubChildren(bemMoArray[i], i);
        }
        MOMergeSort.mergeSortAscending(bemMoArray, stringArray, 1, n - 1);
    }

    protected String getSortedStringFromSubChildren(BemMo bemMo, int n) throws MoHandlerException {
        Object object;
        BemMo[] bemMoArray;
        Object object2;
        if (bemMo.getType().equals(MimPowerSupplySystem.MOTYPENAME)) {
            return "0001";
        }
        if (bemMo.getType().equals(MimPowerDistrSystem.MOTYPENAME)) {
            return "0002";
        }
        if (bemMo.getType().equals(MimAuxPlugInUnit.MOTYPENAME)) {
            object2 = this.moHandler.getAttribute(bemMo, "auType");
            bemMoArray = (BemMo[])object2;
            if (bemMoArray.intValue() == 12) {
                return "0003";
            }
            if (bemMoArray.intValue() == 11) {
                return "0004";
            }
        }
        object2 = new StringBuffer();
        bemMoArray = null;
        if (bemMo.getType().equals(MimRbsSubrack.MOTYPENAME)) {
            bemMoArray = this.moHandler.getChildren(bemMo, 2, MimAuxPlugInUnit.MOTYPENAME, "");
            String string = null;
            for (int i = 0; i < bemMoArray.length; ++i) {
                object = this.moHandler.getAttribute(bemMoArray[i], "auType");
                if (!(object instanceof Integer)) continue;
                Integer n2 = (Integer)object;
                if (n2 == 12) {
                    return "0003";
                }
                if (n2 != 11) continue;
                string = "0004";
            }
            if (string != null) {
                return string;
            }
        }
        if (bemMo.getType().equals(MimSectorAntenna.MOTYPENAME)) {
            bemMoArray = this.moHandler.getChildren(bemMo, 1, MimAuxPlugInUnit.MOTYPENAME, "");
            for (int i = 0; i < bemMoArray.length; ++i) {
                Object object3 = this.moHandler.getAttribute(bemMoArray[i], "auType");
                if (!(object3 instanceof Integer) || (Integer)(object = (Integer)object3) != 28) continue;
                return "0003";
            }
        }
        if (bemMo.getType().equals(MimRetProfile.MOTYPENAME)) {
            ((StringBuffer)object2).append("0");
            ((StringBuffer)object2).append(999 - n);
            return ((StringBuffer)object2).toString();
        }
        if (n + 4 < 1000) {
            ((StringBuffer)object2).append("0");
        }
        if (n + 4 < 100) {
            ((StringBuffer)object2).append("0");
        }
        if (n + 4 < 10) {
            ((StringBuffer)object2).append("0");
        }
        ((StringBuffer)object2).append(n + 4);
        return ((StringBuffer)object2).toString();
    }

    protected String getValueOfLastElement(BemMo bemMo) {
        String string = bemMo.getLastRDN();
        String string2 = string.substring(string.lastIndexOf("=") + 1, string.length());
        StringBuffer stringBuffer = new StringBuffer(string2);
        for (int i = 0; i < 10 - string2.length(); ++i) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }

    protected boolean mustMOSiblingNotBeDeleted(BemMo bemMo) {
        String string = bemMo.getDN();
        for (int i = 0; i < EQUIPMENT_WITH_SIBILNGS_THAT_MUST_NOT_BE_DELETED.length; ++i) {
            if (string.indexOf(EQUIPMENT_WITH_SIBILNGS_THAT_MUST_NOT_BE_DELETED[i]) < 0) continue;
            String string2 = "Equipment: LDN= " + string + " AND it's siblings must NOT be deleted";
            BemLog.log(7, string2);
            return true;
        }
        return false;
    }

    protected boolean mustMONotBeDeleted(BemMo bemMo) {
        String string = bemMo.getDN();
        for (int i = 0; i < EQUIPMENT_THAT_MUST_NOT_BE_DELETED.length; ++i) {
            if (string.indexOf(EQUIPMENT_THAT_MUST_NOT_BE_DELETED[i]) < 0) continue;
            String string2 = "Equipment: LDN= " + string + " must NOT be deleted";
            BemLog.log(7, string2);
            return true;
        }
        return false;
    }

    protected boolean mustMONotBeDeleted(BemMo[] bemMoArray) {
        for (int i = 0; i < bemMoArray.length; ++i) {
            if (!this.mustMONotBeDeleted(bemMoArray[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isMODeletable(BemMo bemMo) {
        String string = bemMo.getType();
        for (int i = 0; i < EQUIPMENT_THAT_CAN_NOT_BE_DELETED.length; ++i) {
            if (!string.endsWith(EQUIPMENT_THAT_CAN_NOT_BE_DELETED[i])) continue;
            String string2 = "Equipment: LDN= " + bemMo.getDN() + " can NOT be deleted";
            BemLog.log(7, string2);
            return false;
        }
        return true;
    }

    protected boolean isMOTreatedAsCable(BemMo bemMo) {
        String string = bemMo.getType();
        for (int i = 0; i < EQUIPMENT_TREATED_AS_CABLE.length; ++i) {
            if (!string.endsWith(EQUIPMENT_TREATED_AS_CABLE[i])) continue;
            String string2 = "Equipment: LDN= " + bemMo.getDN() + " is treated as cable";
            BemLog.log(7, string2);
            return true;
        }
        return false;
    }

    protected boolean isMOTreatedAsRdbt(BemMo bemMo) {
        String string = bemMo.getType();
        if (string.startsWith("Rdbt")) {
            String string2 = "Equipment: LDN= " + bemMo.getDN() + " is treated as rdbt";
            BemLog.log(7, string2);
            return true;
        }
        return false;
    }

    protected boolean isMOOfTypePiuOrAuxPiu(BemMo bemMo) {
        String string = bemMo.getType();
        if (string.indexOf(MimAuxPlugInUnit.MOTYPENAME) >= 0) {
            String string2 = "Equipment: LDN= " + bemMo.getDN() + " is of type " + MimAuxPlugInUnit.MOTYPENAME;
            BemLog.log(7, string2);
            return true;
        }
        if (string.indexOf(MimPlugInUnit.MOTYPENAME) >= 0) {
            String string3 = "Equipment: LDN= " + bemMo.getDN() + " is of type " + MimPlugInUnit.MOTYPENAME;
            BemLog.log(7, string3);
            return true;
        }
        return false;
    }

    private boolean prepareDeleteSwAllocation(BemMo bemMo) throws MoHandlerException {
        String string = bemMo.getType();
        BemMo bemMo2 = bemMo;
        if (string.equals(MimPlugInUnit.MOTYPENAME)) {
            bemMo2 = bemMo.getParent();
        }
        Object object = null;
        object = this.moHandler.getAttribute(bemMo2, "reservedBy");
        if (object instanceof BemMo[]) {
            BemMo[] bemMoArray = (BemMo[])object;
            for (int i = 0; i < bemMoArray.length; ++i) {
                if (!bemMoArray[i].getType().equals(MimSwAllocation.MOTYPENAME)) continue;
                String string2 = bemMoArray[i].getDN();
                BemMo bemMo3 = this.moHandler.getMo(string2);
                NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("slotList", bemMo2)};
                this.moHandler.orderMoOperation("deleteSlot", bemMo3, nalNameValueArray);
                String string3 = "DeleteManager: Deleting a slot: " + bemMo2.getDN() + ", in SwAllocation with ldn = " + bemMo3.getDN();
                BemLog.log(7, string3);
                for (int j = 0; j < this.swAllocRefCnt.length; ++j) {
                    if (!this.swAllocRefCnt[j].getName().equals(string2)) continue;
                    Integer n = (Integer)this.swAllocRefCnt[j].getValue();
                    if (n <= 1) {
                        this.moHandler.orderMoOperation("deleteAllRepertoires", bemMo3, new NalNameValue[0]);
                        string3 = "DeleteManager: Deleting all repertoires in SwAllocation with ldn = " + bemMo3.getDN();
                        BemLog.log(7, string3);
                        this.moHandler.orderMoOperation("delete", bemMo3, new NalNameValue[0]);
                        string3 = "DeleteManager: Deleting SwAllocation with ldn = " + bemMo3.getDN();
                        BemLog.log(7, string3);
                        continue;
                    }
                    String string4 = this.swAllocRefCnt[j].getName();
                    int n2 = n - 1;
                    Integer n3 = n2;
                    this.swAllocRefCnt[j] = Nal.getFactory().getNameValue(string4, n3);
                    string3 = "DeleteManager: Waiting to delete repertoires (" + n2 + " left) in SwAllocation with ldn = " + bemMo3.getDN();
                    BemLog.log(7, string3);
                }
            }
            return true;
        }
        return false;
    }

    protected boolean isMOLockable(BemMo bemMo) throws MoHandlerException {
        MimClassInfo mimClassInfo = new MimClassInfo(bemMo.getDN());
        String[] stringArray = mimClassInfo.getAttributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(ATTRNAME_ADMINISTRATIVESTATE)) continue;
            Object object = this.moHandler.getAttribute(bemMo, ATTRNAME_ADMINISTRATIVESTATE);
            Integer n = 0;
            try {
                if (object instanceof Integer && (n = (Integer)object) == 0) {
                    return false;
                }
            }
            catch (ClassCastException classCastException) {
                String string = "DeleteManager: Casting Attribute administrativeStateto Integer/Long FAILED";
                BemLog.log(7, string);
                return false;
            }
            return true;
        }
        return false;
    }

    private int checkAndReportProgress(int n, int n2, int n3, int n4, String string) {
        int n5 = n * n2 / n3 - n4;
        int n6 = n4;
        if (n5 > 0) {
            n6 += n5;
            this.setChanged();
            this.notifyObservers(Nal.getFactory().getNameValue(string, n5));
        }
        return n6;
    }
}

