/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zip {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int zipIt(String string, InputStream[] inputStreamArray, String[] stringArray) throws IOException {
        byte[] byArray = new byte[512];
        ZipOutputStream zipOutputStream = null;
        if (string == null || inputStreamArray == null || inputStreamArray.length <= 0) {
            return -1;
        }
        Zip.createDirs(string);
        File file = new File(string);
        Closeable closeable = new FileOutputStream(file);
        zipOutputStream = new ZipOutputStream((OutputStream)closeable);
        try {
            for (int i = 0; i < inputStreamArray.length; ++i) {
                closeable = inputStreamArray[i];
                if (((InputStream)closeable).markSupported()) {
                    ((InputStream)closeable).reset();
                }
                ZipEntry zipEntry = new ZipEntry(stringArray[i].replace(File.separatorChar, '/'));
                zipOutputStream.putNextEntry(zipEntry);
                int n = 0;
                while ((n = ((InputStream)closeable).read(byArray)) != -1) {
                    zipOutputStream.write(byArray, 0, n);
                }
                zipOutputStream.closeEntry();
                Zip.printResult(zipEntry);
            }
        }
        finally {
            zipOutputStream.close();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int zipIt(String string, String[] stringArray, String[] stringArray2) throws IOException {
        byte[] byArray = new byte[512];
        ZipOutputStream zipOutputStream = null;
        if (string == null || stringArray.length <= 0) {
            return -1;
        }
        File file = new File(string);
        Closeable closeable = new FileOutputStream(file);
        zipOutputStream = new ZipOutputStream((OutputStream)closeable);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                closeable = new FileInputStream(stringArray[i]);
                ZipEntry zipEntry = new ZipEntry(stringArray2[i].replace(File.separatorChar, '/'));
                zipEntry.setTime(new File(stringArray[i]).lastModified());
                zipEntry.setComment("created by the Export tool");
                zipOutputStream.putNextEntry(zipEntry);
                int n = 0;
                while ((n = ((InputStream)closeable).read(byArray)) != -1) {
                    zipOutputStream.write(byArray, 0, n);
                }
                zipOutputStream.closeEntry();
                ((InputStream)closeable).close();
                Zip.printResult(zipEntry);
            }
        }
        finally {
            zipOutputStream.close();
        }
        return 0;
    }

    public static synchronized int zipIt(String string, String[] stringArray) throws IOException {
        return Zip.zipIt(string, stringArray, stringArray);
    }

    private static void printResult(ZipEntry zipEntry) {
        PrintStream printStream = System.err;
        printStream.print("added " + zipEntry.getName());
        if (zipEntry.getMethod() == 8) {
            long l = zipEntry.getSize();
            if (l > 0L) {
                long l2 = zipEntry.getCompressedSize();
                long l3 = (l - l2) * 100L / l;
                printStream.println(" (deflated " + l3 + "%)");
            } else {
                printStream.println(" (deflated 0%)");
            }
        } else {
            printStream.println(" (stored 0%)");
        }
    }

    private static void createDirs(String string) {
        String string2;
        int n = string.lastIndexOf("/");
        if (n == -1) {
            n = string.lastIndexOf("\\");
        }
        if (n != -1 && !new File(string2 = string.substring(0, n)).exists()) {
            new File(string2).mkdirs();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length <= 1) {
            System.err.println("Zip.java compress a number of files into the given destination file, and overwrites it, if it exists.\n");
            System.err.println("Usage:");
            System.err.println("> java Zip destFile source1 [... sourceN]\n");
            System.err.println("  destFile      is the destination File (e.g. file.zip)");
            System.err.println("  source1       is source File no 1");
            System.err.println("  sourceN       is source File no N");
        } else {
            String[] stringArray2 = new String[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                stringArray2[i - 1] = stringArray[i];
            }
            Zip.zipIt(stringArray[0], stringArray2);
        }
    }
}

