/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.xmlelement;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.xmlelement.AbstractDtdInfo;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.xmlelement.XmlElementFactory;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.provider.PhysicalTerminationProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.AbstractRbs3RadioEquipmentCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.util.AIRUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.IubUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsInfo;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDownlinkBaseBandPool;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;

public abstract class AbstractXmlElement {
    private static final String[] specialAttributes = new String[]{"rbsType", "revision", "npcTestConfig", "sectorNumber", "sequenceNumber", "cellNumber", "portId", "slot", "name", "ethernetIpAddress", "ethernetSubnetMask", "dnsServerAddress"};
    private static final String[] countedAttributes = new String[]{"sectorNumber", "cellNumber", "portId", "slot"};
    private static final String[] supressWhenValueIsZeroAttributes = new String[]{"slotsForETM1", "slotsForETMC1", "slotsForETM3", "slotsForETM4", "slotsForETMC41s", "slotsForETMFX11", "slotsForETMFX14", "numberOfCarriers", "numberOfRu"};
    private static final String[] supressWhenEmptyStringAttributes = new String[]{"secondaryPortId", "radioSharedBySector", "dhcpServerPrimaryIpAddress", "dhcpServerSecondaryIpAddress", "singleLogonServer", "primaryNtpServerIpAddress", "secondaryNtpServerIpAddress", "timeSlotsInFraction"};
    private static final String[][] supressWhenDefaultValueAttribute = new String[][]{{"SectorCapability", "cabinetNumber", "1"}};
    private String[] ignoredAttributes;
    private List containedElements;
    private String[] attributeNames;
    private String[] attributeValues;
    private boolean[] attributeSupported;
    private String elementName;
    private AbstractDtdInfo dtdInfo;
    private Rbs rbs;
    private String pseudoPrefix;
    private String countedValue;
    private String secondCountedValue;
    private boolean exist;
    private boolean elementShouldNotExist = false;
    private static final String NEWLINE = "\n\r";

    public AbstractXmlElement(String string, AbstractDtdInfo abstractDtdInfo, Rbs rbs, String string2, String string3, String string4, String[] stringArray) throws BemException {
        this.elementName = string;
        this.dtdInfo = abstractDtdInfo;
        this.rbs = rbs;
        this.pseudoPrefix = string2;
        this.countedValue = string3;
        this.secondCountedValue = string4;
        this.containedElements = XmlElementFactory.createContainedElements(this, this.dtdInfo, this.rbs);
        this.ignoredAttributes = stringArray;
        this.getAttributes();
        this.exist = this.checkIfExisting();
    }

    public AbstractXmlElement(String string, AbstractDtdInfo abstractDtdInfo, Rbs rbs, String string2, String string3, String string4) throws BemException {
        this(string, abstractDtdInfo, rbs, string2, string3, string4, new String[0]);
    }

    public AbstractXmlElement(String string, AbstractDtdInfo abstractDtdInfo, Rbs rbs, String string2) throws BemException {
        this(string, abstractDtdInfo, rbs, string2, "", "", new String[0]);
    }

    public AbstractXmlElement(String string, AbstractDtdInfo abstractDtdInfo, Rbs rbs, String string2, String string3, String[] stringArray) throws BemException {
        this(string, abstractDtdInfo, rbs, string2, string3, "", stringArray);
    }

    public AbstractXmlElement(String string, AbstractDtdInfo abstractDtdInfo, Rbs rbs, String string2, String string3) throws BemException {
        this(string, abstractDtdInfo, rbs, string2, string3, "", new String[0]);
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getPrefix() {
        return this.pseudoPrefix;
    }

    private boolean checkIfExisting() {
        boolean bl = false;
        if (this.elementShouldNotExist) {
            return false;
        }
        if (this.attributeValues != null && this.attributeValues.length > 0) {
            for (int i = 0; i < this.attributeValues.length; ++i) {
                String string = this.attributeValues[i];
                if (string == null || string.equals("##UNDEFINED") || this.isValueInStringArray(this.attributeNames[i], countedAttributes)) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            bl = this.checkIfContainedElementsExisting();
        }
        return bl;
    }

    private boolean checkIfContainedElementsExisting() {
        boolean bl = false;
        if (this.containedElements != null) {
            for (int i = 0; i < this.containedElements.size(); ++i) {
                AbstractXmlElement abstractXmlElement = (AbstractXmlElement)this.containedElements.get(i);
                if (!abstractXmlElement.getExist()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private boolean getExist() {
        return this.exist;
    }

    String getCountedValue() {
        return this.countedValue;
    }

    String getSecondCountedValue() {
        return this.secondCountedValue;
    }

    private void getAttributes() throws BemException {
        this.emasLog("=========================================================");
        this.emasLog("AbstractXmlElement--> Element=<" + this.elementName + ">  PseudoPrefix=<" + this.pseudoPrefix + "> " + "dtdInfo.generatorName=" + this.dtdInfo.generatorName);
        this.attributeNames = this.dtdInfo.getContainedAttributes(this.elementName);
        if (this.attributeNames != null) {
            int n;
            this.attributeValues = new String[this.attributeNames.length];
            this.attributeSupported = new boolean[this.attributeNames.length];
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (n = 0; n < this.attributeNames.length; ++n) {
                String string = this.attributeNames[n];
                String string2 = null;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("attributeName=").append(string).append("  ");
                boolean bl4 = this.isSpecialAttribute(string);
                boolean bl5 = this.isIgnoredAttribute(string);
                if (bl5) continue;
                if (bl4) {
                    stringBuffer.append("  SPECIAL_TREATED_ATTRIBUTE ");
                    this.attributeSupported[n] = true;
                } else {
                    String string3 = this.pseudoPrefix + string;
                    this.attributeSupported[n] = this.rbs.isParameterSupported(string3);
                    stringBuffer.append("  pseudoName=").append(string3).append("  attributeSupported=").append(this.attributeSupported[n]);
                }
                if (this.attributeSupported[n]) {
                    this.attributeValues[n] = string2 = this.getAttribute(string);
                    stringBuffer.append(" value=<").append(string2).append(">");
                } else {
                    this.attributeValues[n] = null;
                }
                if (this.elementName.equals("HsdpaSlot")) {
                    if (string.equals(this.dtdInfo.getNumHsCodeResourcesAttributeName())) {
                        if (this.attributeSupported[n]) {
                            if ("0".equals(string2)) {
                                bl = true;
                            }
                        } else {
                            bl = true;
                        }
                    } else if (string.equals(this.dtdInfo.getNumHsCodeResources1stBBPAttributeName())) {
                        if (this.attributeSupported[n]) {
                            if (MimDownlinkBaseBandPool.DEFAULT_NUMHSCODERESOURCES.toString().equals(string2)) {
                                bl2 = true;
                            }
                        } else {
                            bl2 = true;
                        }
                    } else if (string.equals(this.dtdInfo.getNumHsCodeResources2ndBBPAttributeName())) {
                        if (this.attributeSupported[n]) {
                            if (MimDownlinkBaseBandPool.DEFAULT_NUMHSCODERESOURCES.toString().equals(string2)) {
                                bl3 = true;
                            }
                        } else {
                            bl3 = true;
                        }
                    }
                } else {
                    this.filterSpecialCases(string, string2, n);
                }
                this.emasLog(stringBuffer.toString());
            }
            if (this.elementName.equals("HsdpaSlot")) {
                if (bl && bl2 && bl3) {
                    this.elementShouldNotExist = true;
                }
            } else if (this.elementName.equals("OptionalEquipmentConfiguration") && !this.elementShouldNotExist) {
                n = 1;
                for (int i = 0; i < this.attributeValues.length; ++i) {
                    if (null == this.attributeValues[i] || this.attributeNames[i].equals("cabinetNumber")) continue;
                    n = 0;
                    break;
                }
                this.elementShouldNotExist = n;
            }
        }
        this.emasLog("ELEMENT=" + this.elementName + "  elementShouldNotExist=" + this.elementShouldNotExist + " (if true-->the element will be filtered)");
    }

    private String radioBuildingBlockGetter(String string, String string2) throws BemException {
        String string3 = this.getAttributeNormalWay(string, string2);
        if (string3 != null && string3.endsWith("b") && !string3.startsWith("RBB")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        return string3;
    }

    private String getAttributeNormalWay(String string, String string2) throws BemException {
        String string3 = null;
        String string4 = string + string2;
        if (this.rbs.isParameterSupported(string4) && !this.isCustomerParameterIgnored(string4)) {
            string3 = this.rbs.getCustomerParameter(string4);
        }
        return string3;
    }

    private boolean isCustomerParameterIgnored(String string) throws BemException {
        boolean bl = false;
        CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
        if (customerParameter.getAccessLevel() == 1) {
            bl = true;
        }
        return bl;
    }

    private boolean isDefaultValue(String string) throws BemException {
        for (int i = 0; i < supressWhenDefaultValueAttribute.length; ++i) {
            if (!this.elementName.equals(supressWhenDefaultValueAttribute[i][0]) || !string.equals(supressWhenDefaultValueAttribute[i][1])) continue;
            String string2 = this.getPrefix() + string;
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string2);
            return this.rbs.isParameterSupported(string2) && (customerParameter.isDefault() || supressWhenDefaultValueAttribute[i][2].equals(customerParameter.getValue()));
        }
        return false;
    }

    private String getAttribute(String string) throws BemException {
        String string2 = null;
        if (string.equals(this.dtdInfo.getRbsTypeAttributeName())) {
            string2 = this.rbs.getRbsType();
        } else if (string.equals(this.dtdInfo.getRevisionAttributeName())) {
            string2 = this.dtdInfo.getRevision();
        } else if (string.equals(this.dtdInfo.getRadioBuildingBlockAttributeName())) {
            string2 = this.radioBuildingBlockGetter(this.pseudoPrefix, string);
        } else if (string.equals(this.dtdInfo.getNpcTestConfigAttributeName())) {
            string2 = null;
        } else if (string.equals(this.dtdInfo.getNumberOfCarriersAttributeName())) {
            string2 = this.handleNumberOfCarriersAttribute(this.pseudoPrefix, string);
        } else if (string.equals(this.dtdInfo.getSequenceNumberAttributeName()) || string.equals(this.dtdInfo.getPortIdAttributeName()) && !this.secondCountedValue.equals("")) {
            string2 = this.secondCountedValue;
        } else if (!this.countedValue.equals("") && this.isCountedAttribute(string)) {
            string2 = this.countedValue;
        } else if (string.equals("name")) {
            CustomerParameter[] customerParameterArray = this.rbs.getCustomerParameterObjects();
            String string3 = "";
            for (int i = 0; i < customerParameterArray.length; ++i) {
                String string4;
                string3 = customerParameterArray[i].getName();
                if (!string3.startsWith(this.pseudoPrefix)) continue;
                int n = this.pseudoPrefix.length();
                string2 = string4 = this.pseudoPrefix.substring(0, n - 1);
                break;
            }
        } else if (string.equals("ethernetIpAddress")) {
            string2 = this.rbs.getCustomerParameter("ipAddress");
        } else if (string.equals("ethernetSubnetMask")) {
            string2 = this.rbs.getCustomerParameter("subnetMask");
        } else if (string.equals("syncSubnetMask")) {
            String string5 = this.rbs.getCustomerParameter("IpSec_configType");
            string2 = string5.equals("IPSEC_SINGLE_LINK") ? this.rbs.getCustomerParameter("OamIpHost_oamSubnetMask") : this.getAttributeNormalWay(this.pseudoPrefix, string);
        } else if (string.equals("defaultRouter0")) {
            String string6 = this.rbs.getCustomerParameter("IpSec_configType");
            string2 = string6.equals("IPSEC_SINGLE_LINK") ? this.rbs.getCustomerParameter("OamIpHost_oamDefaultRouter0") : this.getAttributeNormalWay(this.pseudoPrefix, string);
        } else if (string.equals("syncVid")) {
            String string7 = this.rbs.getCustomerParameter("IpSec_configType");
            string2 = string7.equals("IPSEC_SINGLE_LINK") ? this.rbs.getCustomerParameter("OamIpHost_oamVid") : this.getAttributeNormalWay(this.pseudoPrefix, string);
        } else if (string.equals("dnsServerAddress")) {
            String string8 = this.rbs.getCustomerParameter(this.pseudoPrefix + string + "1");
            String string9 = this.rbs.getCustomerParameter(this.pseudoPrefix + string + "2");
            String string10 = this.rbs.getCustomerParameter(this.pseudoPrefix + string + "3");
            string2 = string8.equals("##UNDEFINED") ? string8 : (string9.equals("##UNDEFINED") ? string8 : (string10.equals("##UNDEFINED") ? string8 + "," + string9 : string8 + "," + string9 + "," + string10));
        } else {
            string2 = this.getAttributeNormalWay(this.pseudoPrefix, string);
        }
        if (string2 != null) {
            string2 = this.filterParameters(string, string2);
        }
        return string2;
    }

    private String handleNumberOfCarriersAttribute(String string, String string2) throws BemException {
        String string3 = null;
        RadioEquipmentProvider radioEquipmentProvider = this.rbs.getRadioEquipmentProvider();
        if (!(radioEquipmentProvider instanceof AbstractRbs3RadioEquipmentCI)) {
            String string4;
            String string5 = this.dtdInfo.getRadioIfTypeAttributeName();
            if (this.rbs.isParameterSupported(string5) && (string4 = this.rbs.getCustomerParameter(string5)).equals("OBIF")) {
                string3 = this.getAttributeNormalWay(string, string2);
            }
        } else {
            string3 = this.getAttributeNormalWay(string, string2);
        }
        return string3;
    }

    private String[] getAttributeNamesToFilter() {
        String[] stringArray = new String[9];
        stringArray[0] = "radioBuildingBlock";
        stringArray[1] = "numberOfCarriers";
        stringArray[2] = "cpriLineRate";
        stringArray[3] = "primaryPortId";
        stringArray[4] = "auUnitType";
        stringArray[5] = "sectorSequenceNumber";
        stringArray[6] = "radioSharedBySector";
        stringArray[7] = "secondaryPortId";
        stringArray[8] = "cabinetNumber";
        return stringArray;
    }

    private String filterParameters(String string, String string2) throws BemException {
        string2 = this.filterSpecialCustomerParameter(string, string2, "ConfigureCabinetEquipment");
        if ((string2 = this.filterSpecialCustomerParameter(string, string2, "EcPort")) != null) {
            string2 = this.filterStepDependentRadioParameters(string, string2);
        }
        if (string2 != null) {
            string2 = this.filterTxBranchConfiguredParameter(string, string2);
        }
        return string2;
    }

    private String filterTxBranchConfiguredParameter(String string, String string2) {
        if ((string.equals("txBranchConfigured") || string.equals("txBranchConfigured2")) && this.getElementName().equals("Cell") && string2.equals("S")) {
            string2 = null;
        }
        return string2;
    }

    private String filterSpecialCustomerParameter(String string, String string2, String string3) throws BemException {
        if (string2 != null) {
            if (string.equals("carrierAllocationMode")) {
                if (this.getElementName().equals(string3) && this.rbs.getRbsData().isRbs6000()) {
                    string2 = null;
                }
            } else if (string.equals("hubPosition") && this.getElementName().equals(string3) && this.isDuwV2In6601() && this.isDuwEcPort()) {
                string2 = null;
            }
        }
        return string2;
    }

    private boolean isDuwEcPort() {
        for (int i = 0; i < this.attributeNames.length; ++i) {
            if (!this.attributeNames[i].equals("unitType") || this.attributeValues[i] == null || !this.attributeValues[i].equals("DUW")) continue;
            return true;
        }
        return false;
    }

    private String filterStepDependentRadioParameters(String string, String string2) throws BemException {
        block7: {
            String[] stringArray;
            block8: {
                stringArray = this.getAttributeNamesToFilter();
                String string3 = this.dtdInfo.getRadioIfTypeAttributeName();
                String string4 = null;
                if (this.rbs.isParameterSupported("1" + string3)) {
                    string4 = this.rbs.getCustomerParameter("1" + string3);
                }
                String string5 = null;
                if (this.rbs.isParameterSupported("2" + string3)) {
                    string5 = this.rbs.getCustomerParameter("2" + string3);
                }
                int n = 0;
                if (this.countedValue != null && !this.countedValue.equals("")) {
                    n = Integer.valueOf(this.countedValue);
                }
                if (!(n > 0 && this.rbs.getRadioEquipmentProvider().isSectorRemote(n) && string4 == null || string4 != null && string4.equals("OBIF") || string5 != null && string5.equals("OBIF") && n > 6) && (string5 == null || !string5.equals("DUI_O") || n <= 6)) break block8;
                if (!this.dtdInfo.getRoot().equals("Cabinet")) break block7;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string6 = stringArray[i];
                    if (string6 == null || !string.equals(string6)) continue;
                    string2 = null;
                    break block7;
                }
                break block7;
            }
            if (this.dtdInfo.getRoot().equals("Site")) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string7 = stringArray[i];
                    if (string7 == null) continue;
                    if (RbsInfo.RBS_3018.NAME.equals(this.rbs.getRbsType()) && string7.equals(this.dtdInfo.getRadioBuildingBlockAttributeName())) break;
                    if (!string.equals(string7)) continue;
                    if ("SectorCapability".equals(this.elementName)) {
                        string2 = null;
                    }
                    break;
                }
            }
        }
        return string2;
    }

    private void filterSpecialCases(String string, String string2, int n) throws BemException {
        if (string.equals(this.dtdInfo.getCellCreatedAttributeName())) {
            if (this.attributeSupported[n] && string2 != null && string2.equals("NO")) {
                this.elementShouldNotExist = true;
            }
        } else if (string.equals(this.dtdInfo.getRfCableSetAttributeName())) {
            if (this.attributeSupported[n]) {
                String string3 = this.pseudoPrefix + string;
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string3);
                if (customerParameter.getAccessLevel() == 1) {
                    this.elementShouldNotExist = true;
                }
            } else {
                this.elementShouldNotExist = true;
            }
        } else if (string.equals(this.dtdInfo.getNumEulResourcesAttributeName())) {
            if (this.attributeSupported[n]) {
                if ("0".equals(string2)) {
                    this.elementShouldNotExist = true;
                }
            } else {
                this.elementShouldNotExist = true;
            }
        } else if (string.equals(this.dtdInfo.getCreateSectorAttributeName())) {
            if ("NO".equals(string2)) {
                this.elementShouldNotExist = true;
            }
        } else if (string.equals("cabinetNumber")) {
            if ("Cabinet".equals(this.elementName) && "##UNDEFINED".equals(string2)) {
                this.elementShouldNotExist = true;
            } else if ("OptionalEquipmentConfiguration".equals(this.elementName) && "##UNDEFINED".equals(string2)) {
                this.elementShouldNotExist = true;
            } else if ("ExternalAlarmConfiguration".equals(this.elementName) && "##UNDEFINED".equals(string2)) {
                this.elementShouldNotExist = true;
            } else if ("ExternalControlConfiguration".equals(this.elementName) && "##UNDEFINED".equals(string2)) {
                this.elementShouldNotExist = true;
            }
        } else if (string.equals("configureRet")) {
            int n2;
            String string4;
            if (this.attributeSupported[n] && !this.rbs.isParameterSupported(string4 = this.pseudoPrefix + "tmaType") && (n2 = this.getIndexOfValueInStringArray("tmaType", this.attributeNames)) != -1) {
                if ("YES".equals(string2)) {
                    this.attributeSupported[n2] = true;
                    if (this.attributeValues[n2] == null) {
                        this.attributeValues[n2] = "NONE";
                    }
                } else {
                    this.elementShouldNotExist = true;
                }
            }
        } else if (string.equals(this.dtdInfo.getUniqueHwIdAttributeName())) {
            int n3;
            String string5;
            String string6;
            boolean bl;
            if ("AretConfiguration".equals(this.elementName) && (bl = this.rbs.isParameterSupported(string6 = (string5 = MessageFormat.format("S{0}_", new Integer(n3 = Integer.valueOf(this.getSectorNumber()).intValue()))) + "typeOfRet"))) {
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string6);
                String string7 = customerParameter.getValue();
                boolean bl2 = AIRUtil.getInstance(this.rbs).isNodeConfiguredWithAir(n3);
                if (bl2 && "ARETU".equals(string7) && !"##UNDEFINED".equals(string2)) {
                    this.elementShouldNotExist = true;
                }
            }
        } else if (string.equals(this.dtdInfo.getUniqueHwId2AttributeName())) {
            String string8 = this.getPrefix();
            String string9 = this.getAttributeNormalWay(string8, "uniqueHwId");
            String string10 = this.getAttributeNormalWay(string8, "uniqueHwId2");
            if (!this.isUniqueHwValid(string9) && !this.isUniqueHwValid(string10)) {
                this.elementShouldNotExist = true;
            }
        } else if (string.equals("synchSlot")) {
            boolean bl;
            PhysicalTerminationProvider physicalTerminationProvider;
            if ("-".equals(string2)) {
                this.elementShouldNotExist = true;
            } else if (IubUtil.isIpNode() && (physicalTerminationProvider = (PhysicalTerminationProvider)((Object)this.rbs.getConfigItem("AtmAndPtCI"))) != null && (bl = physicalTerminationProvider.isCbuBoard(string2))) {
                String string11 = this.getAttribute("synchPort");
                String[] stringArray = new String[]{"1", "2", "3", "4"};
                if (Arrays.asList(stringArray).contains(string11)) {
                    this.elementShouldNotExist = true;
                }
            }
        } else if (string.equals("etIPSynchSlot")) {
            if (string2 == null || string2.equals("0")) {
                this.elementShouldNotExist = true;
            }
        } else if (string.equals("syncIpAddress")) {
            if (string2 == null || string2.equals("##UNDEFINED")) {
                this.elementShouldNotExist = true;
            }
        } else if (string.equals("vlan")) {
            if (DuwUtil.hasDuw()) {
                this.elementShouldNotExist = true;
            } else if (this.rbs.getCustomerParameterObject("slotsForETMFX11").getValue().equals("0") && this.rbs.getCustomerParameterObject("slotsForETMFX14").getValue().equals("0")) {
                this.elementShouldNotExist = true;
            }
        } else if (string.equals("portNo")) {
            if (DuwUtil.hasDuw()) {
                this.elementShouldNotExist = true;
            } else if (this.rbs.getCustomerParameterObject("slotsForETMFX11").getValue().equals("0") && this.rbs.getCustomerParameterObject("slotsForETMFX14").getValue().equals("0")) {
                this.elementShouldNotExist = true;
            }
        } else if (string.equals("gigaBitEthernetPort")) {
            if (!DuwUtil.hasDuw() && this.rbs.getCustomerParameterObject("slotsForETMFX11").getValue().equals("0") && this.rbs.getCustomerParameterObject("slotsForETMFX14").getValue().equals("0")) {
                this.elementShouldNotExist = true;
            }
        } else if (string.equals("hubPosition")) {
            if (!this.isDuwV2In6601() && string2 != null && string2.equals("")) {
                this.elementShouldNotExist = true;
            }
        } else if (this.isDuwV2In6601() && string.equals("cascadingOrder") && string2 != null && string2.equals("0")) {
            this.elementShouldNotExist = true;
        }
    }

    private boolean isDuwV2In6601() throws BemException {
        return DuwUtil.isDualDuwAndPrimaryIsV2() && RbsInfo.RBS_6601W.NAME.equals(this.rbs.getRbsType());
    }

    private boolean isSpecialAttribute(String string) {
        return this.isValueInStringArray(string, specialAttributes);
    }

    private boolean isIgnoredAttribute(String string) {
        return this.isValueInStringArray(string, this.ignoredAttributes);
    }

    private boolean isCountedAttribute(String string) {
        return this.isValueInStringArray(string, countedAttributes);
    }

    private boolean isValueInStringArray(String string, String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private int getIndexOfValueInStringArray(String string, String[] stringArray) {
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            n = i;
            break;
        }
        return n;
    }

    public String printElement() throws BemException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.exist) {
            boolean bl = this.attributeNames != null;
            boolean bl2 = this.containedElements != null && this.containedElements.size() > 0;
            this.printElementHeader(bl, stringBuffer);
            if (bl) {
                String string = this.printAllAttributes();
                stringBuffer.append(string);
                if (bl2) {
                    this.printElementHeaderEnding(stringBuffer);
                }
            }
            if (bl2) {
                for (int i = 0; i < this.containedElements.size(); ++i) {
                    AbstractXmlElement abstractXmlElement = (AbstractXmlElement)this.containedElements.get(i);
                    String string = abstractXmlElement.printElement();
                    stringBuffer.append(string);
                }
            }
            this.printElementFooter(bl2, stringBuffer);
        }
        return stringBuffer.toString();
    }

    private void printElementHeader(boolean bl, StringBuffer stringBuffer) {
        if (bl) {
            stringBuffer.append("\n\r<" + this.elementName + NEWLINE);
        } else {
            stringBuffer.append("\n\r<" + this.elementName + ">" + NEWLINE);
        }
    }

    private void printElementHeaderEnding(StringBuffer stringBuffer) {
        stringBuffer.append(">\n\r");
    }

    private void printElementFooter(boolean bl, StringBuffer stringBuffer) {
        if (bl) {
            stringBuffer.append("</" + this.elementName + ">" + NEWLINE);
        } else {
            stringBuffer.append("/>\n\r");
        }
    }

    private String printAllAttributes() throws BemException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.attributeNames.length; ++i) {
            String string = this.attributeValues[i];
            String string2 = this.attributeNames[i];
            if (string == null || string.equals("##UNDEFINED") || this.isValueInStringArray(string2, supressWhenValueIsZeroAttributes) && string.equals("0") || this.isValueInStringArray(string2, supressWhenEmptyStringAttributes) && string.equals("") || this.isDefaultValue(string2) || (string2.equals("numHsCodeResources1stBBP") || string2.equals("numHsCodeResources2ndBBP")) && string.equals(MimDownlinkBaseBandPool.DEFAULT_NUMHSCODERESOURCES.toString()) || string2.equals("numHsCodeResources") && string.equals(MimTxDeviceGroup.DEFAULT_NUMHSCODERESOURCES.toString())) continue;
            stringBuffer.append(this.attributeNames[i] + "=\"" + string + "\"" + NEWLINE);
        }
        return stringBuffer.toString();
    }

    private void emasLog(String string) {
        Nal.getFactory().getLog().nalTrace(5, this.getClass(), string + "     ");
    }

    private String getSectorNumber() {
        String string = "0";
        String string2 = this.getPrefix();
        if (string2.startsWith("S")) {
            int n = this.pseudoPrefix.indexOf("_");
            string = string2.substring(1, n);
        }
        return string;
    }

    private boolean isUniqueHwValid(String string) {
        return string != null && !string.equals("##UNDEFINED") && !string.equals("");
    }
}

