/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.hwtest.control;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import se.ericsson.wcdma.rbs.bem.application.applications.hwtest.app.BoardApplicable;
import se.ericsson.wcdma.rbs.bem.application.applications.hwtest.control.BoardController;
import se.ericsson.wcdma.rbs.bem.application.applications.hwtest.control.MessageDialogControl;
import se.ericsson.wcdma.rbs.bem.application.applications.hwtest.control.StatusTableModel;
import se.ericsson.wcdma.rbs.bem.application.applications.hwtest.model.Board;
import se.ericsson.wcdma.rbs.bem.application.applications.hwtest.model.BoardListener;
import se.ericsson.wcdma.rbs.bem.application.applications.hwtest.model.BoardModel;
import se.ericsson.wcdma.rbs.bem.application.applications.hwtest.model.BoardModeller;
import se.ericsson.wcdma.rbs.bem.application.applications.hwtest.model.HwTestProgressReportListener;
import se.ericsson.wcdma.rbs.bem.application.applications.hwtest.view.BoardViewer;
import se.ericsson.wcdma.rbs.bem.application.applications.hwtest.view.MessageDialogView;
import se.ericsson.wcdma.rbs.bem.application.common.util.ProgressDialog;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalFactory;
import se.ericsson.wcdma.rbs.bem.common.trace.BEMTrace;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplicationController;

public class BoardControl
extends AbstractApplicationController
implements BoardController,
HwTestProgressReportListener {
    protected static final int BOARD_DELETED = 0;
    protected static final int BOARD_CREATED = 1;
    protected static final int HW_TEST_RESULT_CHANGED = 2;
    protected static final int ADM_STATE_CHANGED = 3;
    private static final String PROGRESS_WINDOW_MESSAGE = "Reading board information from RBS";
    private static final String CANCEL_WINDOW_MESSAGE = "Do you really want to close Test Board?";
    private static final String CANCEL_WINDOW_TITLE = "Confirm";
    private String myResultPassed;
    private String myResultFailed;
    private String myResultUndetermined;
    private String myResultPending;
    private String myStateLocked;
    private String myStateUnlocked;
    private String myStateShuttingdown;
    protected String myStatusBarAccepted;
    protected String myStatusBarRejected;
    protected String myStatusBarAcceptedPartly;
    private String myPassedValue;
    private String myFailedValue;
    private String myPendingValue;
    private String myUndeterminedValue;
    protected String myTableHeadBoard;
    protected String myTableHeadResult;
    protected String myTableHeadAdmstat;
    protected String myTableHeadProdNo;
    protected String myTableHeadRev;
    private String myErrorMessage;
    private BoardApplicable myApplication;
    private BoardViewer myView;
    protected BoardModeller myModel;
    private Board[] myBoards;
    private ProgressDialog myProgressDialog;
    private boolean boardsCollected = false;
    private StartButtonAction myStartButtonAction;
    private CloseButtonAction myCloseButtonAction;
    private LockButtonAction myLockButtonAction;
    private UnlockButtonAction myUnlockButtonAction;
    private ModelBoardListener myModelBoardListener;
    private CancelButtonListener myCancelButtonListener;
    private StatusTableModel myTableModel;
    private ListSelectionListener mySelectionListener;
    public ResourceBundle myLanguageBundle;

    protected void init() {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardControl.class, "init()");
        }
        this.myApplication = (BoardApplicable)((Object)this.getApplication());
        this.myView = (BoardViewer)((Object)this.getView());
        Object[] objectArray = null;
        this.myApplication.setTitle("HWT_TITLE", objectArray);
        this.myStartButtonAction = new StartButtonAction();
        this.myCloseButtonAction = new CloseButtonAction();
        this.myLockButtonAction = new LockButtonAction();
        this.myUnlockButtonAction = new UnlockButtonAction();
        this.myView.getStartButton().addActionListener(this.myStartButtonAction);
        this.myView.getCloseButton().addActionListener(this.myCloseButtonAction);
        this.myView.getLockButton().addActionListener(this.myLockButtonAction);
        this.myView.getUnlockButton().addActionListener(this.myUnlockButtonAction);
        this.mySelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl = BoardControl.this.myView.getStatusTable().getSelectedRows().length > 0;
                BoardControl.this.myView.getLockButton().setEnabled(bl);
                BoardControl.this.myView.getUnlockButton().setEnabled(bl);
                BoardControl.this.myView.getStartButton().setEnabled(bl);
            }
        };
        this.myView.getStatusTable().getSelectionModel().addListSelectionListener(this.mySelectionListener);
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardControl.class, "init()");
        }
    }

    protected void afterVisible() {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardControl.class, "afterVisible()");
        }
        this.getView().setCursor(new Cursor(3));
        this.myLanguageBundle = this.myApplication.getLanguageBundle();
        this.setLanguageBundleMessages(this.myLanguageBundle);
        this.myModel = new BoardModel();
        this.myModel.setLanguageBundle(this.myLanguageBundle);
        this.myModel.addProgressReportListener(this);
        this.myModelBoardListener = new ModelBoardListener();
        this.myModel.addBoardListener(this.myModelBoardListener);
        this.delay(2);
        this.startProgressDialog();
    }

    private void startProgressDialog() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (BoardControl.this.boardsCollected) {
                    return;
                }
                BoardControl.this.myCancelButtonListener = new CancelButtonListener();
                BoardControl.this.myProgressDialog = new ProgressDialog(null, BoardControl.PROGRESS_WINDOW_MESSAGE, BoardControl.this.myCancelButtonListener);
                String string = System.getProperty("os.name");
                if (string.equalsIgnoreCase("SunOS")) {
                    BoardControl.this.myProgressDialog.setModal(true);
                }
                BoardControl.this.myProgressDialog.setVisible(true);
            }
        });
    }

    private void afterBoardsCollected() {
        this.myBoards = this.myModel.getBoards();
        this.myTableModel = new StatusTableModel(this.myBoards, this.myLanguageBundle);
        this.myView.getStatusTable().setModel(this.myTableModel);
        this.setAllBoardTestResults();
        this.myPassedValue = this.myTableModel.getNoOfBoardsForState(0);
        this.myView.getPassedLabel().setText(this.myPassedValue);
        this.myPendingValue = this.myTableModel.getNoOfBoardsForState(2);
        this.myView.getPendingLabel().setText(this.myPendingValue);
        this.myFailedValue = this.myTableModel.getNoOfBoardsForState(1);
        this.myView.getFailedLabel().setText(this.myFailedValue);
        this.myUndeterminedValue = this.myTableModel.getNoOfBoardsForState(3);
        this.myView.getUndeterminedLabel().setText(this.myUndeterminedValue);
        this.getView().setCursor(new Cursor(0));
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardControl.class, "afterVisible()");
        }
    }

    protected void stop() {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardControl.class, "stop()");
        }
        this.myView.getStartButton().removeActionListener(this.myStartButtonAction);
        this.myView.getCloseButton().removeActionListener(this.myCloseButtonAction);
        this.myView.getLockButton().removeActionListener(this.myLockButtonAction);
        this.myView.getUnlockButton().removeActionListener(this.myUnlockButtonAction);
        this.myView.getStatusTable().getSelectionModel().removeListSelectionListener(this.mySelectionListener);
        this.myModel.removeBoardListener(this.myModelBoardListener);
        this.myModel.removeProgressReportListener(this);
        this.myModel.close();
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardControl.class, "stop()");
        }
    }

    public void startDialogMessage(String string, String string2) {
        String string3 = null;
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardControl.class, "startDialogMessage(String, String)", string, string2);
        }
        string3 = string2 != null ? string2 : "HWT_TITLE";
        this.myErrorMessage = string;
        this.startDialog(true, string3, null, MessageDialogView.class, MessageDialogControl.class);
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardControl.class, "startDialogMessage(String, String)");
        }
    }

    public String getErrorMessage() {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardControl.class, "getErrorMessage()");
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardControl.class, "getErrorMessage()", this.myErrorMessage);
        }
        return this.myErrorMessage;
    }

    public void setStatusBar(String string) {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardControl.class, "setStatusBar(String)", string);
        }
        this.myApplication.setStatus(string, null);
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardControl.class, "setStatusBar(String)");
        }
    }

    private void setLanguageBundleMessages(ResourceBundle resourceBundle) {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardControl.class, "setLanguageBundleMessages(ResourceBundle)", resourceBundle);
        }
        if (resourceBundle != null) {
            this.myResultPassed = resourceBundle.getString("BEM_HWT_RES_PASSED");
            this.myResultFailed = resourceBundle.getString("BEM_HWT_RES_FAILED");
            this.myResultUndetermined = resourceBundle.getString("BEM_HWT_RES_UNDETERMINED");
            this.myResultPending = resourceBundle.getString("BEM_HWT_RES_PENDING");
            this.myStateLocked = resourceBundle.getString("BEM_ADMIN_STATE_LOCKED");
            this.myStateUnlocked = resourceBundle.getString("BEM_ADMIN_STATE_UNLOCKED");
            this.myStateShuttingdown = resourceBundle.getString("BEM_ADMIN_STATE_SHUTTINGDOWN");
            this.myStatusBarAccepted = "HWT_STATUS_BAR_MESSAGE_ACCEPTED";
            this.myStatusBarRejected = "HWT_STATUS_BAR_MESSAGE_REJECTED";
            this.myStatusBarAcceptedPartly = "HWT_STATUS_BAR_MESSAGE_PARTIALLY_ACCEPTED";
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardControl.class, "setLanguageBundleMessages(ResourceBundle)");
        }
    }

    protected String getAdminStateString(Object object) {
        String string = null;
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardControl.class, "getAdminStateString(Object)", object);
        }
        switch ((Integer)object) {
            case 0: {
                string = this.myStateLocked;
                break;
            }
            case 1: {
                string = this.myStateUnlocked;
                break;
            }
            case 2: {
                string = this.myStateShuttingdown;
                break;
            }
            default: {
                string = "Untranslated state";
            }
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardControl.class, "getAdminStateString(Object)", string);
        }
        return string;
    }

    protected String getHwTestResultString(Object object) {
        String string = null;
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardControl.class, "getHwTestResultString(Object)", object);
        }
        switch ((Integer)object) {
            case 0: {
                string = this.myResultPassed;
                break;
            }
            case 1: {
                string = this.myResultFailed;
                break;
            }
            case 3: {
                string = this.myResultUndetermined;
                break;
            }
            case 2: {
                string = this.myResultPending;
                break;
            }
            default: {
                string = "Untranslated result";
            }
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardControl.class, "getHwTestResultString(Object)", string);
        }
        return string;
    }

    public void setAllBoardTestResults() {
        this.myPassedValue = this.myTableModel.getNoOfBoardsForState(0);
        this.myView.getPassedLabel().setText(this.myPassedValue);
        this.myPendingValue = this.myTableModel.getNoOfBoardsForState(2);
        this.myView.getPendingLabel().setText(this.myPendingValue);
        this.myFailedValue = this.myTableModel.getNoOfBoardsForState(1);
        this.myView.getFailedLabel().setText(this.myFailedValue);
        this.myUndeterminedValue = this.myTableModel.getNoOfBoardsForState(3);
        this.myView.getUndeterminedLabel().setText(this.myUndeterminedValue);
    }

    private void reselectRows(int[] nArray) {
        try {
            this.delay(1);
            SelectionInterval[] selectionIntervalArray = this.getIntervalsFromSelection(nArray);
            boolean bl = true;
            JTable jTable = this.myView.getStatusTable();
            for (int i = 0; i < selectionIntervalArray.length; ++i) {
                SelectionInterval selectionInterval = selectionIntervalArray[i];
                int n = selectionInterval.getSelectionStart();
                int n2 = selectionInterval.getSelectionEnd();
                if (bl) {
                    jTable.setRowSelectionInterval(n, n2);
                    bl = false;
                    continue;
                }
                jTable.addRowSelectionInterval(n, n2);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    private void delay(int n) {
        int n2 = n * 1000;
        try {
            NalFactory nalFactory = Nal.getFactory();
            nalFactory.sleep(n2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private SelectionInterval[] getIntervalsFromSelection(int[] nArray) {
        ArrayList<SelectionInterval> arrayList = new ArrayList<SelectionInterval>();
        if (nArray != null && nArray.length > 0) {
            int n = nArray[0];
            int n2 = nArray[0];
            for (int i = 0; i < nArray.length; ++i) {
                SelectionInterval selectionInterval;
                int n3 = nArray[i];
                if (nArray.length == 1) {
                    selectionInterval = new SelectionInterval(n, nArray[i]);
                    arrayList.add(selectionInterval);
                }
                if (n3 - n2 > 1) {
                    selectionInterval = new SelectionInterval(n, nArray[i - 1]);
                    arrayList.add(selectionInterval);
                    n = nArray[i];
                    n2 = nArray[i];
                }
                if (i != nArray.length - 1) continue;
                selectionInterval = new SelectionInterval(n, nArray[i]);
                arrayList.add(selectionInterval);
            }
        }
        return arrayList.toArray(new SelectionInterval[0]);
    }

    public void reportHwTestDoneWithProblems(Map map, boolean bl) {
        if (map != null && map.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = map.entrySet().iterator();
            stringBuffer.append(this.myLanguageBundle.getString("HWT_NOT_STARTED_VE_POP_UP_HEADING"));
            stringBuffer.append("\n");
            stringBuffer.append("\n");
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                stringBuffer.append(((Board)entry.getKey()).getBoardName());
                stringBuffer.append("    ");
                stringBuffer.append((String)entry.getValue());
                stringBuffer.append("  \n");
            }
            this.startDialogMessage(stringBuffer.toString(), "HWT_TITLE_TEST_ERROR");
        }
    }

    public void reportHwTestDone() {
    }

    public void reportLockDone() {
    }

    public void reportUnlockDone() {
    }

    public void reportCollectBoardsDone() {
        this.boardsCollected = true;
        if (this.myProgressDialog != null) {
            this.myProgressDialog.setVisible(false);
            this.myProgressDialog.dispose();
            this.myProgressDialog = null;
        }
        this.afterBoardsCollected();
    }

    public void reportStatusBarMessage(int n) {
        String string;
        switch (n) {
            case 1: {
                string = this.myStatusBarAccepted;
                break;
            }
            case 2: {
                string = this.myStatusBarAcceptedPartly;
                break;
            }
            case 3: {
                string = this.myStatusBarRejected;
                break;
            }
            default: {
                string = "Unknown messageType " + n + " sent to reportStatusBarMessage()";
            }
        }
        this.setStatusBar(string);
    }

    static /* synthetic */ Board[] access$1002(BoardControl boardControl, Board[] boardArray) {
        boardControl.myBoards = boardArray;
        return boardArray;
    }

    private class CancelButtonListener
    implements ActionListener {
        private CancelButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = JOptionPane.showConfirmDialog(BoardControl.this.myProgressDialog, BoardControl.CANCEL_WINDOW_MESSAGE, BoardControl.CANCEL_WINDOW_TITLE, 0);
            if (n == 0) {
                if (BoardControl.this.myProgressDialog != null) {
                    BoardControl.this.myProgressDialog.setVisible(false);
                    BoardControl.this.myProgressDialog = null;
                }
                BoardControl.this.stop();
                BoardControl.this.getApplication().stopApplication();
            }
        }
    }

    private static class SelectionInterval {
        private int selStart = -1;
        private int selEnd = -1;

        public SelectionInterval(int n, int n2) {
            this.selStart = n;
            this.selEnd = n2;
        }

        public int getSelectionStart() {
            return this.selStart;
        }

        public int getSelectionEnd() {
            return this.selEnd;
        }
    }

    private class ModelBoardListener
    implements BoardListener {
        Board thisBoard;
        Board[] theseBoards;

        private ModelBoardListener() {
        }

        public void created(Board board, String string) {
            this.thisBoard = board;
            this.theseBoards = new Board[BoardControl.this.myBoards.length + 1];
            for (int i = 0; i < BoardControl.this.myBoards.length; ++i) {
                this.theseBoards[i] = BoardControl.this.myBoards[i];
            }
            this.theseBoards[((BoardControl)BoardControl.this).myBoards.length + 1] = this.thisBoard;
            BoardControl.access$1002(BoardControl.this, this.theseBoards);
            if (BEMTrace.ENABLED) {
                BEMTrace.enter(ModelBoardListener.class, "created(BoardData)", board);
            }
            BoardControl.this.myTableModel.updateTable(board, string, 1);
            BoardControl.this.myView.getStatusTable().setModel(BoardControl.this.myTableModel);
            BoardControl.this.setAllBoardTestResults();
            if (BEMTrace.ENABLED) {
                BEMTrace.exit(ModelBoardListener.class, "created(BoardData)");
            }
        }

        public void deleted(Board board, String string) {
            if (BEMTrace.ENABLED) {
                BEMTrace.enter(ModelBoardListener.class, "deleted(BoardData)", board);
            }
            this.thisBoard = board;
            int n = 0;
            this.theseBoards = new Board[BoardControl.this.myBoards.length - 1];
            for (int i = 0; i < BoardControl.this.myBoards.length; ++i) {
                if (BoardControl.this.myBoards[i].getBoardName().equals(string)) continue;
                this.theseBoards[n] = BoardControl.this.myBoards[i];
                ++n;
            }
            BoardControl.access$1002(BoardControl.this, this.theseBoards);
            BoardControl.this.myTableModel.updateTable(board, string, 0);
            BoardControl.this.myView.getStatusTable().setModel(BoardControl.this.myTableModel);
            BoardControl.this.setAllBoardTestResults();
            if (BEMTrace.ENABLED) {
                BEMTrace.exit(ModelBoardListener.class, "deleted(BoardData)");
            }
        }

        public void adminStateChanged(Board board, String string) {
            if (BEMTrace.ENABLED) {
                BEMTrace.enter(ModelBoardListener.class, "adminStateChanged(BoardData)", board);
            }
            this.thisBoard = board;
            BoardControl.this.myTableModel.updateTable(board, string, 3);
            BoardControl.this.myView.getStatusTable().setModel(BoardControl.this.myTableModel);
            if (BEMTrace.ENABLED) {
                BEMTrace.exit(ModelBoardListener.class, "adminStateChanged(BoardData)");
            }
        }

        public void hwTestResultChanged(Board board, String string) {
            if (BEMTrace.ENABLED) {
                BEMTrace.enter(ModelBoardListener.class, "hwTestResultChanged(BoardData)", board);
            }
            this.thisBoard = board;
            BoardControl.this.myTableModel.updateTable(board, string, 2);
            BoardControl.this.myView.getStatusTable().setModel(BoardControl.this.myTableModel);
            BoardControl.this.setAllBoardTestResults();
            if (BEMTrace.ENABLED) {
                BEMTrace.exit(ModelBoardListener.class, "hwTestresultChanged(BoardData)");
            }
        }
    }

    private class CloseButtonAction
    implements ActionListener {
        private CloseButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BEMTrace.ENABLED) {
                BEMTrace.enter(CloseButtonAction.class, "actionPerformed(ActionEvent)", actionEvent);
            }
            BoardControl.this.getApplication().stopApplication();
            if (BEMTrace.ENABLED) {
                BEMTrace.exit(CloseButtonAction.class, "actionPerformed(ActionEvent)");
            }
        }
    }

    private class UnlockButtonAction
    implements ActionListener {
        private UnlockButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (BEMTrace.ENABLED) {
                BEMTrace.enter(UnlockButtonAction.class, "actionPerformed(ActionEvent)", actionEvent);
            }
            BoardControl.this.setStatusBar(null);
            int[] nArray = BoardControl.this.myView.getStatusTable().getSelectedRows();
            if (nArray.length > 0 && (n = BoardControl.this.showConfirmDialog("HWT_MSG_UNLOCK", null, "HWT_TITLE_UNLOCK", null, 0, 3, null)) == 0) {
                Board[] boardArray = new Board[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    boardArray[i] = BoardControl.this.myBoards[nArray[i]];
                }
                BoardControl.this.myModel.unlock(boardArray);
            }
            BoardControl.this.reselectRows(nArray);
            if (BEMTrace.ENABLED) {
                BEMTrace.exit(UnlockButtonAction.class, "actionPerformed(ActionEvent)");
            }
        }
    }

    private class LockButtonAction
    implements ActionListener {
        private LockButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (BEMTrace.ENABLED) {
                BEMTrace.enter(LockButtonAction.class, "actionPerformed(ActionEvent)", actionEvent);
            }
            BoardControl.this.setStatusBar(null);
            int[] nArray = BoardControl.this.myView.getStatusTable().getSelectedRows();
            if (nArray.length > 0 && (n = BoardControl.this.showConfirmDialog("HWT_MSG_LOCK", null, "HWT_TITLE_LOCK", null, 0, 3, null)) == 0) {
                Board[] boardArray = new Board[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    boardArray[i] = BoardControl.this.myBoards[nArray[i]];
                }
                BoardControl.this.myModel.lock(boardArray);
            }
            BoardControl.this.reselectRows(nArray);
            if (BEMTrace.ENABLED) {
                BEMTrace.exit(LockButtonAction.class, "actionPerformed(ActionEvent)");
            }
        }
    }

    private class StartButtonAction
    implements ActionListener {
        private StartButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BEMTrace.ENABLED) {
                BEMTrace.enter(StartButtonAction.class, "actionPerformed(ActionEvent)", actionEvent);
            }
            BoardControl.this.setStatusBar(null);
            int[] nArray = BoardControl.this.myView.getStatusTable().getSelectedRows();
            if (nArray.length > 0) {
                Board[] boardArray = new Board[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    boardArray[i] = BoardControl.this.myBoards[nArray[i]];
                }
                BoardControl.this.myModel.test(boardArray);
            }
            BoardControl.this.reselectRows(nArray);
            if (BEMTrace.ENABLED) {
                BEMTrace.exit(StartButtonAction.class, "actionPerformed(ActionEvent)");
            }
        }
    }
}

