/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.convert;

import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.convert.AbstractConverter;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.data.Action;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.IubUtil;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCbu;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSyncRef;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSynchronization;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTransportNetwork;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTuSyncRef;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.moi.RootMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMoImpl;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class SyncRefActionConverter
extends AbstractConverter {
    private Action convertToAction = null;
    private String ldn = null;

    public SyncRefActionConverter(String string) {
        super(null, null);
        this.ldn = string;
        this.convertToAction = new Action(MimSynchronization.MOTYPENAME, "addSyncRefResource");
    }

    public Object convert(Object object) {
        try {
            String string = this.ldn;
            Integer n = this.getSyncRefPriority(string);
            string = this.removeMoFromLdn(MimCbu.MOTYPENAME);
            Object[] objectArray = new Object[]{new BemMoImpl(string), n};
            this.convertToAction.setValue(objectArray);
        }
        catch (BemException bemException) {
            bemException.printStackTrace();
            Nal.getLog().nalTrace(1, this.getClass(), "Failed to convert value: " + object, bemException);
        }
        return this.convertToAction;
    }

    private Integer getSyncRefPriority(String string) throws BemException {
        RootMoi rootMoi = new RootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(rootMoi, MimTransportNetwork.MOTYPENAME, "1");
        SingleChildMoi singleChildMoi2 = new SingleChildMoi(singleChildMoi, MimSynchronization.MOTYPENAME, "1");
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        BemMo bemMo = moHandlerImpl.getMo(singleChildMoi2.getLdn());
        Object object = bemMo.getAttribute("syncReference");
        BemMo[] bemMoArray = (BemMo[])object;
        Object object2 = bemMo.getAttribute("syncRefPriority");
        int[] nArray = (int[])object2;
        for (int i = 0; i < bemMoArray.length; ++i) {
            BemMo bemMo2 = bemMoArray[i];
            if (!bemMo2.getDN().equals(string)) continue;
            if (IubUtil.isIpNode() && this.isOnlyAtmSyncRefExisting(bemMoArray)) {
                int n = this.getPrioritySeq(nArray, i);
                nArray = new int[]{5, 6, 7, 8};
                return nArray[n];
            }
            return nArray[i];
        }
        throw new BemException("Failed in method " + this.getClass() + ".getSyncRefPriority(), synchPriority not found!");
    }

    private String removeMoFromLdn(String string) {
        int n = this.ldn.indexOf(string + "=");
        if (n != -1) {
            String string2 = this.ldn.substring(0, n);
            int n2 = this.ldn.indexOf(",", n + string.length());
            String string3 = "";
            if (n2 > -1) {
                string3 = this.ldn.substring(n2 + 1);
            }
            this.ldn = string2 + string3;
        }
        return this.ldn;
    }

    private int getPrioritySeq(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0 || nArray[n] <= nArray[i]) continue;
            ++n2;
        }
        return n2;
    }

    private boolean isOnlyAtmSyncRefExisting(BemMo[] bemMoArray) {
        boolean bl = true;
        for (int i = 0; i < bemMoArray.length; ++i) {
            String string = bemMoArray[i].getDN();
            if (!BemUtil.isLdnOfType(string, MimIpSyncRef.MOTYPENAME) && !BemUtil.isLdnOfType(string, MimTuSyncRef.MOTYPENAME)) continue;
            bl = false;
            break;
        }
        return bl;
    }
}

