/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.switchtu.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import se.ericsson.wcdma.rbs.bem.application.applications.switchtu.app.TuApplicable;
import se.ericsson.wcdma.rbs.bem.application.applications.switchtu.model.SwitchTuException;
import se.ericsson.wcdma.rbs.bem.application.applications.switchtu.model.Tu;
import se.ericsson.wcdma.rbs.bem.application.applications.switchtu.model.TuModel;
import se.ericsson.wcdma.rbs.bem.application.applications.switchtu.model.TuModeller;
import se.ericsson.wcdma.rbs.bem.application.applications.switchtu.view.TuViewer;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.trace.BEMTrace;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplicationController;

public class TuControl
extends AbstractApplicationController {
    private String myNoTu;
    private TuApplicable myApplication;
    private TuViewer myView;
    private TuModeller myModel;
    private Tu[] myTus;
    private SwitchButtonAction mySwitchButtonAction;
    private CloseButtonAction myCloseButtonAction;

    protected void init() {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(TuControl.class, "init()");
        }
        this.myView = (TuViewer)((Object)this.getView());
        this.myApplication = (TuApplicable)((Object)this.getApplication());
        this.mySwitchButtonAction = new SwitchButtonAction();
        this.myCloseButtonAction = new CloseButtonAction();
        this.myView.getSwitchButton().addActionListener(this.mySwitchButtonAction);
        this.myView.getCloseButton().addActionListener(this.myCloseButtonAction);
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(TuControl.class, "init()");
        }
    }

    protected void afterVisible() {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(TuControl.class, "afterVisible()");
        }
        this.setLanguageBundleMessages(this.myApplication.getLanguageBundle());
        this.myModel = new TuModel();
        this.myTus = this.myModel.getTus();
        if (this.myTus.length == 1) {
            this.showConfirmDialog("TU_ERROR_MESSAGE_ONLY_ONE_TU", null, "BEM_INFORMATION_TITLE", null, -1, 1, null);
        } else if (this.myTus.length < 1) {
            this.showConfirmDialog("TU_ERROR_MESSAGE_NO_ACTIVE_TU", null, "BEM_INFORMATION_TITLE", null, -1, 1, null);
        }
        this.setLabels(false);
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(TuControl.class, "afterVisible()");
        }
    }

    protected void stop() {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(TuControl.class, "stop()");
        }
        this.myView.getSwitchButton().removeActionListener(this.mySwitchButtonAction);
        this.myView.getCloseButton().removeActionListener(this.myCloseButtonAction);
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(TuControl.class, "stop()");
        }
    }

    protected boolean canStop() {
        return true;
    }

    private void setLabels(boolean bl) {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(TuControl.class, "setLabels(boolean)", bl);
        }
        this.myTus = this.myModel.getTus();
        int n = -1;
        try {
            n = this.myModel.getDistributedStatus();
        }
        catch (Exception exception) {
            if (BEMTrace.ENABLED) {
                BEMTrace.exception(TuControl.class, "setLabels()", exception);
            }
            BemLog.exceptionRaised("Failed to read attribute activeTu", exception);
            this.showErrorMessage("TU_ERROR_MESSAGE_DEFAULT", null);
        }
        int n2 = -1;
        for (int i = 0; i < this.myTus.length; ++i) {
            int n3 = this.myTus[i].getReference();
            if (n != n3) continue;
            n2 = i;
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.msg(TuControl.class, "setLabels()", "activeTu = " + n);
            BEMTrace.msg(TuControl.class, "setLabels()", "index = " + n2);
        }
        BemLog.logNotify("Active TU = " + n);
        BemLog.logNotify("Array index = " + n2);
        if (n == 1) {
            String string = this.myTus[0].getTuName();
            this.myView.getDistNameLabel().setText(string);
            if (this.myTus.length > 1) {
                String string2 = this.myTus[1].getTuName();
                this.myView.getStandbyNameLabel().setText(string2);
            } else {
                this.myView.getStandbyNameLabel().setText(this.myNoTu);
                if (bl) {
                    this.showErrorMessage("TU_ERROR_MESSAGE_ONLY_ONE_TU", null);
                }
            }
        } else if (n == 2) {
            String string = this.myTus[1].getTuName();
            this.myView.getDistNameLabel().setText(string);
            if (this.myTus.length > 1) {
                String string3 = this.myTus[0].getTuName();
                this.myView.getStandbyNameLabel().setText(string3);
            } else {
                this.myView.getStandbyNameLabel().setText(this.myNoTu);
                if (bl) {
                    this.showErrorMessage("TU_ERROR_MESSAGE_ONLY_ONE_TU", null);
                }
            }
        } else {
            this.myView.getDistNameLabel().setText(this.myNoTu);
            this.myView.getStandbyNameLabel().setText(this.myNoTu);
            if (bl) {
                this.showErrorMessage("TU_ERROR_MESSAGE_NO_ACTIVE_TU", null);
            }
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(TuControl.class, "setLabels()");
        }
    }

    private void setStatusBar(String string) {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(TuControl.class, "setStatusBar(String)", string);
        }
        this.myApplication.setStatus(string, null);
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(TuControl.class, "setStatusBar(String)");
        }
    }

    private void showErrorMessage(String string, String string2) {
        String string3 = null;
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(TuControl.class, "showErrorMessage(String, String)", string, string2);
        }
        string3 = string2 != null ? string2 : "BEM_ERROR_TITLE";
        this.showConfirmDialog(string, null, string3, null, -1, 0, null);
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(TuControl.class, "showErrorMessage(String, String)");
        }
    }

    private int showWarningMessage(String string, String string2) {
        String string3 = null;
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(TuControl.class, "showMessage(String, String)", string, string2);
        }
        string3 = string2 != null ? string2 : "BEM_WARNING_TITLE";
        int n = this.showConfirmDialog(string, null, string3, null, 2, 3, null);
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(TuControl.class, "showMessage(String, String)", n);
        }
        return n;
    }

    private void setLanguageBundleMessages(ResourceBundle resourceBundle) {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(TuControl.class, "setLanguageBundleMessages(ResourceBundle)", resourceBundle);
        }
        if (resourceBundle != null) {
            this.myNoTu = resourceBundle.getString("TU_LABEL_NONE");
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(TuControl.class, "setLanguageBundleMessages(ResourceBundle)");
        }
    }

    private class CloseButtonAction
    implements ActionListener {
        private CloseButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BEMTrace.ENABLED) {
                BEMTrace.enter(CloseButtonAction.class, "actionPerformed(ActionEvent)", actionEvent);
            }
            TuControl.this.getApplication().stopApplication();
            if (BEMTrace.ENABLED) {
                BEMTrace.exit(CloseButtonAction.class, "actionPerformed(ActionEvent)");
            }
        }
    }

    private class SwitchButtonAction
    implements ActionListener {
        private SwitchButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BEMTrace.ENABLED) {
                BEMTrace.enter(SwitchButtonAction.class, "actionPerformed(ActionEvent)", actionEvent);
            }
            TuControl.this.setStatusBar(null);
            if (TuControl.this.myTus.length > 1) {
                int n = TuControl.this.showWarningMessage("TU_QUESTION_MESSAGE", null);
                if (n == 0) {
                    try {
                        boolean bl = TuControl.this.myModel.switchTu();
                        if (bl) {
                            TuControl.this.setLabels(true);
                            TuControl.this.setStatusBar("TU_INFO_MESSAGE_SWITCH_OK");
                        }
                    }
                    catch (SwitchTuException switchTuException) {
                        if (BEMTrace.ENABLED) {
                            BEMTrace.exception(SwitchButtonAction.class, "actionPerformed()", switchTuException);
                        }
                        BemLog.exceptionRaised("Action switchDistributingTu failed", switchTuException);
                        TuControl.this.showErrorMessage("TU_ERROR_MESSAGE_SWITCH_REJECTED", null);
                    }
                    catch (Exception exception) {
                        if (BEMTrace.ENABLED) {
                            BEMTrace.exception(SwitchButtonAction.class, "actionPerformed()", exception);
                        }
                        BemLog.exceptionRaised("Action switchDistributingTu failed", exception);
                        TuControl.this.showErrorMessage("TU_ERROR_MESSAGE_DEFAULT", null);
                    }
                }
            } else if (TuControl.this.myTus.length == 1) {
                TuControl.this.showErrorMessage("TU_ERROR_MESSAGE_ONLY_ONE_TU", null);
            } else {
                TuControl.this.showErrorMessage("TU_ERROR_MESSAGE_NO_ACTIVE_TU", null);
            }
            if (BEMTrace.ENABLED) {
                BEMTrace.exit(SwitchButtonAction.class, "actionPerformed(ActionEvent)");
            }
        }
    }
}

