/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.common.model;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;

public class Configurator {
    protected static final String ERROR_ATTRIBUTES_EMPTY = "MO attribute list empty";
    protected static final String ERROR_CONFIGURATOR = "Configurator:";
    protected static final String ERROR_LDN_NOT_FOUND = "LDN not found";
    protected static final String ERROR_MODIFY_NOT_FOUND = "Attribute to be modified not found";
    protected static final String ERROR_MODIFY_MO_NOT_FOUND = "MO to be modified not found";
    protected static final String ERROR_ATTRIB = "Attribute:";
    protected static final String ERROR_LDN = "MO with LDN:";
    protected static final String ERROR_REMOVE_NOT_FOUND = "Mo to be removed not found.";
    protected static final String ERROR_ADD_EXISTS = "Mo to be added already exists";
    protected static final String ERROR_ATTRIB_NOT_FOUND = "Attribute not found";
    protected Hashtable theConfiguredMoTable = new Hashtable();
    protected Hashtable theLoadedMoTable = new Hashtable();

    public NalNameValue getConfiguredAttribute(String string, String string2) throws BemException {
        if (this.theConfiguredMoTable == null) {
            throw new BemException(ERROR_ATTRIBUTES_EMPTY);
        }
        NalNameValue nalNameValue = this.getAttributeValue(string, string2, this.theConfiguredMoTable);
        return nalNameValue;
    }

    public Vector getConfiguredAttributes(String string) throws BemException {
        if (this.theConfiguredMoTable == null) {
            throw new BemException(ERROR_ATTRIBUTES_EMPTY);
        }
        Vector vector = (Vector)this.theConfiguredMoTable.get(string);
        if (vector == null) {
            throw new BemException("Configurator:LDN not found MO with LDN:" + string);
        }
        return vector;
    }

    public void modifyConfiguredAttribute(String string, NalNameValue nalNameValue) throws BemException {
        if (this.isConfiguredMoExisting(string)) {
            Vector vector = (Vector)this.theConfiguredMoTable.get(string);
            if (vector == null) {
                throw new BemException("Configurator:MO to be modified not found MO with LDN:" + string);
            }
            Enumeration enumeration = vector.elements();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                NalNameValue nalNameValue2 = (NalNameValue)enumeration.nextElement();
                if (!nalNameValue2.getName().equals(nalNameValue.getName())) continue;
                int n = vector.indexOf(nalNameValue2);
                vector.setElementAt(nalNameValue, n);
                bl = true;
                break;
            }
            if (!bl) {
                vector.addElement(nalNameValue);
            }
            this.theConfiguredMoTable.put(string, vector);
        } else {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            vector.add(nalNameValue);
            this.addConfiguredMo(string, vector);
        }
    }

    public void modifyConfiguredAttributes(String string, Vector vector) throws BemException {
        if (this.isConfiguredMoExisting(string)) {
            Vector vector2 = (Vector)this.theConfiguredMoTable.get(string);
            if (vector == null || vector2 == null) {
                throw new BemException("Configurator:MO to be modified not found MO with LDN:" + string);
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                boolean bl = false;
                NalNameValue nalNameValue = (NalNameValue)enumeration.nextElement();
                Enumeration enumeration2 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    NalNameValue nalNameValue2 = (NalNameValue)enumeration2.nextElement();
                    if (!nalNameValue.getName().equals(nalNameValue2.getName())) continue;
                    int n = vector2.indexOf(nalNameValue2);
                    vector2.setElementAt(nalNameValue, n);
                    bl = true;
                    break;
                }
                if (bl) continue;
                vector2.addElement(nalNameValue);
            }
            this.theConfiguredMoTable.put(string, vector2);
        } else {
            this.addConfiguredMo(string, vector);
        }
    }

    public void removeConfiguredMo(String string) throws BemException {
        if (this.theConfiguredMoTable.remove(string) == null) {
            throw new BemException("Configurator:Mo to be removed not found.\nMO with LDN:" + string);
        }
    }

    public void addConfiguredMo(String string, Vector vector) throws BemException {
        Vector vector2 = this.theConfiguredMoTable.put(string, vector);
        if (vector2 != null) {
            throw new BemException("Configurator:Mo to be added already exists MO with LDN:" + string + "," + ERROR_ATTRIB + vector);
        }
    }

    public void addConfiguredMo(String string) throws BemException {
        Vector vector = this.theConfiguredMoTable.put(string, new Vector());
        if (vector != null) {
            throw new BemException("Configurator:Mo to be added already exists MO with LDN:" + string + "(no attributes)");
        }
    }

    public void setLoadedAttributes(String string, NalNameValue[] nalNameValueArray) throws BemException {
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        for (int i = 0; i < nalNameValueArray.length; ++i) {
            vector.add(nalNameValueArray[i]);
        }
        this.setLoadedAttributes(string, vector);
    }

    public void setLoadedAttributes(String string, Vector vector) throws BemException {
        this.theLoadedMoTable.put(string, new Vector(vector));
    }

    public void setLoadedMo(String string) throws BemException {
        this.theLoadedMoTable.put(string, new Vector());
    }

    public void modifyLoadedAttribute(String string, NalNameValue nalNameValue) throws BemException {
        Vector vector = (Vector)this.theLoadedMoTable.get(string);
        if (vector == null) {
            throw new BemException("Configurator:MO to be modified not found MO with LDN:" + string);
        }
        Enumeration enumeration = vector.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            NalNameValue nalNameValue2 = (NalNameValue)enumeration.nextElement();
            if (!nalNameValue2.getName().equals(nalNameValue.getName())) continue;
            int n = vector.indexOf(nalNameValue2);
            vector.setElementAt(nalNameValue, n);
            bl = true;
        }
        if (!bl) {
            vector.addElement(nalNameValue);
        }
        this.theLoadedMoTable.put(string, vector);
    }

    public void removeLoadedMo(String string) throws BemException {
        boolean bl = this.theLoadedMoTable.containsKey(string);
        if (bl && this.theLoadedMoTable.remove(string) == null) {
            throw new BemException("Configurator:Mo to be removed not found.\nMO with LDN:" + string);
        }
    }

    public void makeSnapshot() throws BemException {
        if (this.theLoadedMoTable == null) {
            throw new BemException(ERROR_ATTRIBUTES_EMPTY);
        }
        this.theConfiguredMoTable.clear();
        Enumeration enumeration = this.theLoadedMoTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)this.theLoadedMoTable.get(string);
            this.theConfiguredMoTable.put(string, vector.clone());
        }
    }

    public boolean hasChanged(String string, String string2) throws BemException {
        String string3;
        NalNameValue nalNameValue = this.getConfiguredAttribute(string, string2);
        if (!this.wasMoExistingBeforeWizard(string)) {
            return true;
        }
        NalNameValue nalNameValue2 = this.getAttributeValue(string, string2, this.theLoadedMoTable);
        String string4 = ((Object)nalNameValue).toString();
        boolean bl = string4.equals(string3 = ((Object)nalNameValue2).toString());
        return !bl;
    }

    public Vector getChangedAttributes(String string) throws BemException {
        Vector vector = new Vector(0);
        Vector vector2 = this.getConfiguredAttributes(string);
        if (!this.wasMoExistingBeforeWizard(string)) {
            vector = new Vector(vector2);
            return vector;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            NalNameValue nalNameValue = (NalNameValue)vector2.get(i);
            String string2 = nalNameValue.getName();
            boolean bl = this.hasChanged(string, string2);
            if (!bl) continue;
            vector.add(nalNameValue);
        }
        vector = this.removeReadOnlyAttributes(vector);
        return vector;
    }

    public boolean isConfiguredMoExisting(String string) {
        boolean bl = false;
        if (string != null) {
            bl = this.theConfiguredMoTable.containsKey(string);
        }
        return bl;
    }

    public boolean wasMoExistingBeforeWizard(String string) throws BemException {
        boolean bl = false;
        if (string != null) {
            bl = this.theLoadedMoTable.containsKey(string);
        }
        return bl;
    }

    public Vector getConfiguredChildren(String string, int n, String string2) {
        int n2 = this.getNumberOfRdns(string);
        Vector vector = new Vector(0, 1);
        boolean bl = true;
        if (string2.equals("")) {
            bl = false;
            vector.add(string);
        }
        Enumeration enumeration = this.theConfiguredMoTable.keys();
        while (enumeration.hasMoreElements()) {
            String string3;
            int n3;
            String string4 = (String)enumeration.nextElement();
            if (!string4.startsWith(this.trimLdnSuffix(string)) || (n3 = this.getNumberOfRdns(string4) - n2) > n || n3 <= 0 || string4.equals(string) || bl && !string2.equals(string3 = this.getMoTypeForLdn(string4))) continue;
            vector.add(string4);
        }
        vector = this.sortVector(vector);
        return vector;
    }

    private String trimLdnSuffix(String string) {
        if (!string.endsWith(",")) {
            string = string + ",";
            return string;
        }
        return string;
    }

    public Vector removeReadOnlyAttributes(Vector vector) {
        Vector<NalNameValue> vector2 = new Vector<NalNameValue>(0, 1);
        for (NalNameValue nalNameValue : vector) {
            String string = nalNameValue.getName();
            if (string.equals("availabilityStatus")) continue;
            vector2.add(nalNameValue);
        }
        return vector2;
    }

    private NalNameValue getAttributeValue(String string, String string2, Hashtable hashtable) throws BemException {
        Vector vector = (Vector)hashtable.get(string);
        if (vector == null) {
            throw new BemException("Configurator:LDN not found MO with LDN:" + string + "," + ERROR_ATTRIB + string2);
        }
        NalNameValue nalNameValue = null;
        Enumeration enumeration = vector.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            NalNameValue nalNameValue2 = (NalNameValue)enumeration.nextElement();
            if (!nalNameValue2.getName().equals(string2)) continue;
            nalNameValue = nalNameValue2;
            bl = true;
            break;
        }
        if (!bl) {
            throw new BemException("Configurator:Attribute not found MO with LDN:" + string + "," + ERROR_ATTRIB + string2);
        }
        return nalNameValue;
    }

    private int getNumberOfRdns(String string) {
        int n = string.indexOf(61);
        int n2 = 0;
        while (n != -1) {
            ++n2;
            n = string.indexOf(61, n + 1);
        }
        return n2;
    }

    private String getMoTypeForLdn(String string) {
        int n = string.lastIndexOf(",") + 1;
        int n2 = string.lastIndexOf("=");
        String string2 = string.substring(n, n2);
        return string2;
    }

    private Vector sortVector(Vector vector) {
        Object[] objectArray = vector.toArray();
        Arrays.sort(objectArray);
        Vector<Object> vector2 = new Vector<Object>(0, 1);
        for (int i = 0; i < objectArray.length; ++i) {
            vector2.add(objectArray[i]);
        }
        return vector2;
    }
}

