/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.client.clients.cli.xml;

import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.backend.NalLogBackend;

public class XmlEntity {
    private static final String QUOTE_STRING = "\"";
    private boolean isOk = true;
    private boolean isOpen = false;
    private String currentApplicationName = "";
    private StringBuffer xmlResultBody = new StringBuffer();
    private static final String XML_ENTITY_ERROR_BEGIN = "Error in XmlEntity.";
    private static final String ALREADY_OPEN = "already open.";

    public XmlEntity() {
        this("");
    }

    public XmlEntity(String string) {
    }

    public String getXmlResult() throws BemException {
        String string = this.checkValidity();
        if (string != null) {
            throw new BemException(string);
        }
        String string2 = "";
        if (this.isOk()) {
            string2 = "\nBEMCLI result=OK for command=" + this.currentApplicationName + "\n";
        }
        String string3 = XmlEntity.getXmlHeader();
        String string4 = XmlEntity.getXmlBody(this.xmlResultBody);
        String string5 = XmlEntity.getXmlFooter();
        return string2 + string3 + string4 + string5;
    }

    public void beginApplication(String string) throws BemException {
        this.beginApplication(string, "");
    }

    public void beginApplication(String string, String string2) throws BemException {
        if (this.isOpen) {
            throw new BemException("Error in XmlEntity.already open.");
        }
        this.isOpen = true;
        this.currentApplicationName = string;
    }

    private String checkValidity() {
        String string = null;
        return string;
    }

    public void endApplication() {
        this.isOpen = false;
    }

    public void addErrorMessage(String string) {
        this.addErrorMessage(string, null);
    }

    public void addErrorMessage(String string, Throwable throwable) {
        this.isOk = false;
        this.xmlResultBody.append("Command " + this.currentApplicationName + ": " + string + "\n");
        if (throwable != null) {
            this.xmlResultBody.append("Caused by: ");
            this.xmlResultBody.append(XmlEntity.getStackTrace(throwable));
            this.xmlResultBody.append("\n");
        }
    }

    private static String getStackTrace(Throwable throwable) {
        return NalLogBackend.getStackTrace(throwable);
    }

    private static String getXmlHeader() {
        return "<Result\n\n";
    }

    private static String getXmlBody(StringBuffer stringBuffer) {
        String string = "result=";
        if (stringBuffer.length() > 0) {
            string = string + XmlEntity.getXmlString("ERROR") + "\n";
            string = string + "details=";
            string = string + XmlEntity.getXmlString(stringBuffer.toString()) + "\n";
        } else {
            string = string + XmlEntity.getXmlString("OK");
        }
        return string;
    }

    private static String getXmlFooter() {
        return "\n/>\n";
    }

    private static String getXmlString(String string) {
        return QUOTE_STRING + string.replace('\"', ' ') + QUOTE_STRING;
    }

    public static String formatXmlError(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = XmlEntity.getXmlHeader();
        String string3 = XmlEntity.getXmlBody(stringBuffer);
        String string4 = XmlEntity.getXmlFooter();
        return string2 + string3 + string4;
    }

    public boolean isOk() {
        return this.isOk;
    }
}

