/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.check.ConfigurationCheckReport;
import se.ericsson.wcdma.rbs.bem.common.config.check.ReportEntry;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AbstractAntennaSystemCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AntennaBranchRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AntennaFeederRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.OilRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.RruRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.RruwRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.AlarmConfigurationProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.CellAndCarrierListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsProduct;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractDbControlledAuxillaryUnitRI;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAntFeederCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimOpticalInterfaceLink;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRruDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.nonautogenerated.MimAntennaBranchDef;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.CableMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.ChildWithAttributeValues;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class AntennaSystemRruCI
extends AbstractAntennaSystemCI {
    private static final String AUTO_CREATED_RDNID_1 = "1";
    private static final String OIL_DL_DEFAULT_RDNID_1 = "-DL";
    private static final String OIL_UL_DEFAULT_RDNID_1 = "-UL";
    private final MoHandler moHandler;

    public AntennaSystemRruCI(Rbs rbs) {
        this(rbs, false);
    }

    public AntennaSystemRruCI(Rbs rbs, boolean bl) {
        super(rbs, false, bl, true, true);
        this.moHandler = rbs.getMoHandler();
    }

    public AntennaSystemRruCI(Rbs rbs, boolean bl, boolean bl2) {
        super(rbs, bl2, bl, true, true);
        this.moHandler = rbs.getMoHandler();
    }

    public boolean open() throws BemException {
        if (this.isOpen) {
            return true;
        }
        super.open();
        this.radioEP = this.rbs.getRadioEquipmentProvider();
        int[] nArray = this.radioEP.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            this.createRruRI(nArray[i]);
            this.createAntennaFeederRI(nArray[i]);
            this.createOilRI(nArray[i]);
        }
        this.cellCarrP.addCellAndCarrierListener(new SectorInUseListener());
        this.isOpen = true;
        return true;
    }

    private boolean rruw(int n) throws BemException {
        boolean bl = false;
        String string = this.radioEP.getTerminationObject(n, MimAntennaBranchDef.BRANCH_A);
        if (string.substring(string.lastIndexOf("=") + 1).startsWith("RRUW")) {
            bl = true;
        }
        return bl;
    }

    protected void createRruRI(int n) throws BemException {
        int n2;
        if (this.rru == null) {
            this.rru = new AbstractDbControlledAuxillaryUnitRI[this.maxNoOfSectors];
        }
        if (this.rruMois[n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber)] == null) {
            this.initialiseMoiResources(n2);
        }
        if (this.rruw(n)) {
            if (this.rruAuxPiuMois[n2].getLdn().endsWith("RRU")) {
                this.initialiseRruwAuxPiuMoiResources(n2);
            }
            this.rru[n2] = new RruwRI(this.rbs, this.rruMois[n2].getLdn(), AtfProvider.ALL_CONTROLLERS_OF_RRU_INDEXED_BY_SECTOR[n]);
        } else {
            this.rru[n2] = new RruRI(this.rbs, this.rruMois[n2].getLdn(), AtfProvider.ALL_CONTROLLERS_OF_RRU_INDEXED_BY_SECTOR[n]);
        }
    }

    protected void createOilRI(int n) throws BemException {
        if (this.oilDl == null) {
            this.oilDl = new OilRI[this.maxNoOfSectors];
            this.oilUl = new OilRI[this.maxNoOfSectors];
        }
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        this.oilDl[n2] = new OilRI(this.rbs, n2, "Dl", this.optLinkDlMois[n2].getLdn(), this.radioEP, this.rruAuxPiuMois[n2].getLdn());
        this.oilUl[n2] = new OilRI(this.rbs, n2, "Ul", this.optLinkUlMois[n2].getLdn(), this.radioEP, this.rruAuxPiuMois[n2].getLdn());
    }

    private void createAntFeederPerBranch(int n, String string) throws BemException {
        AntennaBranchRI antennaBranchRI = null;
        AntennaFeederRI[] antennaFeederRIArray = null;
        MoInstance[] moInstanceArray = null;
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        this.initialiseMoiResources(n2);
        for (int i = 0; i < 2; ++i) {
            if (!string.equals(AntennaSystemRruCI.getBranchType(i))) continue;
            antennaBranchRI = this.antennaBranch[n2][i];
            antennaFeederRIArray = this.antennaFeeder[n2][i];
            moInstanceArray = this.antFeederMois[n2][i];
        }
        if (antennaBranchRI == null && antennaFeederRIArray == null && moInstanceArray == null) {
            throw new BemException("Error in AntennaSystemRruCI.createAntFeederPerBranch(" + n + ", " + string + ")");
        }
        BemMo bemMo = this.rbs.getRbsType().equals(RbsProduct.RBS_3402.NAME) ? this.moHandler.getMo(this.rru[n2].getLdn()).getParent() : this.moHandler.getMo(this.radioEP.getTerminationObject(n, string));
        BemMo bemMo2 = this.moHandler.getMo(antennaBranchRI.getLdn());
        String string2 = AntennaSystemRruCI.getSectorPrefix(n);
        for (int i = 0; i < moInstanceArray.length; ++i) {
            MoInstance moInstance = moInstanceArray[i];
            if (moInstance == null) continue;
            int n3 = this.radioEP.getTerminationConnectors(n, string)[i];
            antennaFeederRIArray[i] = new AntennaFeederRI(this.rbs, string2, n2, string, bemMo, n3, bemMo2, moInstance.getLdn());
            antennaFeederRIArray[i].setLoadedValues();
        }
    }

    protected void createAntennaFeederRI(int n) throws BemException {
        if (this.antennaFeeder == null) {
            this.antennaFeeder = new AntennaFeederRI[this.maxNoOfSectors][AntennaSystemRruCI.getMaxNumberOfBranches()][2];
        }
        for (int i = 0; i < 2; ++i) {
            this.createAntFeederPerBranch(n, AntennaSystemRruCI.getBranchType(i));
        }
    }

    protected void updateSectorParameters(int n, boolean bl) throws BemException {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        if (!this.sectorExist(n)) {
            this.initialiseMoiResources(n2);
        }
        this.createAntennaFeederRI(n);
        this.retCic.createRetRI(n);
        AlarmConfigurationProvider alarmConfigurationProvider = this.rbs.getAlarmConfigurationProvider();
        if (this.rruw(n)) {
            alarmConfigurationProvider.setConfigureAlarmForRruw(n, true);
        } else {
            alarmConfigurationProvider.setConfigureAlarmForRruw(n, false);
        }
    }

    protected String[] getSectorRdns() throws BemException {
        String[] stringArray = new String[]{AUTO_CREATED_RDNID_1, "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
        try {
            BemMo bemMo = this.moHandler.getMo(this.rbs.getEquipmentMoi().getLdn());
            BemMo[] bemMoArray = this.moHandler.getChildren(bemMo, 1, MimOpticalInterfaceLink.MOTYPENAME, "");
            if (bemMoArray.length > 0) {
                block2: for (int i = 0; i < this.maxNoOfSectors; ++i) {
                    int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
                    Integer n2 = this.radioEP.getTerminationConnectors(n, "DL")[0];
                    String string = this.radioEP.getTerminationObject(n, "DL");
                    if (n2 == null || string == null) continue;
                    BemMo bemMo2 = this.moHandler.getMo(string);
                    for (int j = 0; j < bemMoArray.length; ++j) {
                        String string2;
                        BemMo[] bemMoArray2;
                        BemMo bemMo3;
                        String string3;
                        BemMo bemMo4;
                        String string4;
                        BemMo bemMo5;
                        Integer n3 = (Integer)bemMoArray[j].getAttribute("objectAConnector");
                        if (!n3.equals(n2) || !(bemMo5 = (BemMo)bemMoArray[j].getAttribute("connectedToObjectARef")).getDN().equals(bemMo2.getDN()) || !(string4 = (bemMo4 = (BemMo)bemMoArray[j].getAttribute("connectedToObjectBRef")).getType()).equals(string3 = MimAuxPlugInUnit.MOTYPENAME) || !(bemMo3 = bemMo4.getParent()).isExisting() || !(bemMoArray2 = (BemMo[])bemMo3.getAttribute("reservedBy"))[0].isExisting()) continue;
                        stringArray[n - 1] = string2 = bemMoArray2[0].getId();
                        continue block2;
                    }
                }
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(this.getClass() + " getSectorRdns() ", (Throwable)moHandlerException);
        }
        return stringArray;
    }

    private void initialiseRruwAuxPiuMoiResources(int n) {
        this.rruAuxPiuMois[n] = new ChildWithAttributeValues(this.sectorAntennaMois[n][0], MimAuxPlugInUnit.MOTYPENAME, "auType", new Integer(20), "RRUW");
        this.rruMois[n] = new SingleChildMoi(this.rruAuxPiuMois[n], MimRruDeviceGroup.MOTYPENAME, AUTO_CREATED_RDNID_1);
    }

    protected void initialiseMoiResources(int n, boolean bl) throws BemException {
        this.initialiseMoiResources(n);
    }

    protected void initialiseMoiResources(int n) throws BemException {
        int n2 = SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber);
        this.rruAuxPiuMois[n] = this.rruw(n2) ? new ChildWithAttributeValues(this.sectorAntennaMois[n][0], MimAuxPlugInUnit.MOTYPENAME, "auType", new Integer(20), "RRUW") : new ChildWithAttributeValues(this.sectorAntennaMois[n][0], MimAuxPlugInUnit.MOTYPENAME, "auType", new Integer(10), "RRU");
        this.rruMois[n] = new SingleChildMoi(this.rruAuxPiuMois[n], MimRruDeviceGroup.MOTYPENAME, AUTO_CREATED_RDNID_1);
        this.retCic.initialiseMoiResources(n);
        Integer n3 = this.radioEP.getTerminationConnectors(n2, "UL")[0];
        Integer n4 = this.radioEP.getTerminationConnectors(n2, "DL")[0];
        String string = this.radioEP.getTerminationObject(n2, "UL");
        BemMo bemMo = this.moHandler.getMo(string);
        String string2 = this.radioEP.getTerminationObject(n2, "DL");
        BemMo bemMo2 = this.moHandler.getMo(string2);
        this.optLinkDlMois[n] = new CableMoi(MimOpticalInterfaceLink.MOTYPENAME, "B", null, null, null, null, "connectedToObjectBRef", bemMo2, "objectBConnector", n4, Integer.toString(n2) + OIL_DL_DEFAULT_RDNID_1);
        this.optLinkUlMois[n] = new CableMoi(MimOpticalInterfaceLink.MOTYPENAME, "A", "connectedToObjectARef", bemMo, "objectAConnector", n3, null, null, null, null, Integer.toString(n2) + OIL_UL_DEFAULT_RDNID_1);
        for (int i = 0; i < 2; ++i) {
            this.antFeederMois[n][i] = this.createAntennaFeederMois(n, AntennaSystemRruCI.getBranchType(i));
        }
    }

    private CableMoi[] createAntennaFeederMois(int n, String string) throws BemException {
        int n2 = SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber);
        Integer[] integerArray = this.radioEP.getTerminationConnectors(n2, string);
        CableMoi[] cableMoiArray = new CableMoi[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            Integer n3 = integerArray[i];
            Integer n4 = new Integer(0);
            Object[] objectArray = new Object[]{n3, n4};
            String string2 = this.rbs.getRbsType().equals(RbsProduct.RBS_3402.NAME) ? this.rruAuxPiuMois[n].getLdn() : this.radioEP.getTerminationObject(n2, string);
            BemMo bemMo = this.moHandler.getMo(string2);
            String string3 = String.valueOf(n2) + string;
            cableMoiArray[i] = new CableMoi(MimAntFeederCable.MOTYPENAME, "B", null, null, null, null, "connectedToObjectARef", bemMo, "objectAConnector", objectArray, string3);
        }
        return cableMoiArray;
    }

    public ArrayList getNeededRIs() throws BemException {
        ArrayList arrayList = super.getNeededRIs();
        int[] nArray = this.radioEP.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.cellCarrP.isSectorInUse(nArray[i])) continue;
            int n = SectorUtil.getSectorIndexFromSectorNumber(nArray[i], this.startingSectorNumber);
            if (!this.rbs.getRbsType().equals(RbsProduct.RBS_3402.NAME)) continue;
            AbstractResourceItem abstractResourceItem = this.oilDl[n];
            arrayList.add(abstractResourceItem);
            abstractResourceItem = this.rru[n];
            arrayList.add(abstractResourceItem);
            abstractResourceItem = this.oilUl[n];
            arrayList.add(abstractResourceItem);
        }
        return arrayList;
    }

    public List getRIsToUninstall() throws BemException {
        List list = super.getRIsToUninstall();
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            if (!this.sectorExist(n) || this.sectorEquipped(n)) continue;
            List list2 = super.getAntennaFeederRIs(i, true);
            list.addAll(list2);
            AbstractResourceItem abstractResourceItem = this.rru[i];
            list.add(abstractResourceItem);
            abstractResourceItem = this.oilDl[i];
            list.add(abstractResourceItem);
            abstractResourceItem = this.oilUl[i];
            list.add(abstractResourceItem);
        }
        return list;
    }

    public ConfigurationCheckReport checkConfiguration(ConfigurationCheckReport configurationCheckReport) throws BemException {
        int[] nArray = this.radioEP.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            String string;
            BemMo bemMo;
            String string2 = this.sectorRdns[nArray[i] - 1];
            String string3 = Integer.toString(nArray[i]);
            int n = SectorUtil.getSectorIndexFromSectorNumber(nArray[i], this.startingSectorNumber);
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < this.antFeederMois[n][j].length; ++k) {
                    MoInstance moInstance = this.antFeederMois[n][j][k];
                    if (moInstance == null || (bemMo = this.moHandler.getMo(string = moInstance.getLdn())).isExisting() || string2.equals(string3)) continue;
                    ReportEntry reportEntry = new ReportEntry("Error", "", string2, string3, "No antenna feeder cable found for this RDN");
                    configurationCheckReport.addReportEntry(reportEntry);
                }
            }
            string = this.optLinkDlMois[n].getLdn();
            bemMo = this.moHandler.getMo(string);
            if (!bemMo.isExisting() && !string2.equals(string3)) {
                ReportEntry reportEntry = new ReportEntry("Error", "", string2, string3, "No optical interface cable found for this RDN");
                configurationCheckReport.addReportEntry(reportEntry);
            }
            if ((bemMo = this.moHandler.getMo(string = this.optLinkUlMois[n].getLdn())).isExisting() || string2.equals(string3)) continue;
            ReportEntry reportEntry = new ReportEntry("Error", "", string2, string3, "No optical interface cable found for this RDN");
            configurationCheckReport.addReportEntry(reportEntry);
        }
        return configurationCheckReport;
    }

    protected void createCustomerParameters(String string, int n) throws BemException {
        super.createCustomerParameters(string, n);
    }

    private class SectorInUseListener
    implements CellAndCarrierListener {
        private SectorInUseListener() {
        }

        public void update(int n) {
            boolean bl = AntennaSystemRruCI.this.cellCarrP.isSectorInUse(n);
            int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, AntennaSystemRruCI.this.startingSectorNumber);
            if (bl) {
                AntennaSystemRruCI.this.sectorUsedRestriction[n2].setAccessLevel(3);
            } else {
                AntennaSystemRruCI.this.sectorUsedRestriction[n2].setAccessLevel(1);
                try {
                    AlarmConfigurationProvider alarmConfigurationProvider = AntennaSystemRruCI.this.rbs.getAlarmConfigurationProvider();
                    alarmConfigurationProvider.setConfigureAlarmForRruw(n, false);
                }
                catch (BemException bemException) {
                    BemLog.log(2, "Exception when trying to disable RRUW alarmson unused sector " + n + ".\nMessage: " + bemException.getMessage());
                }
            }
        }
    }
}

