/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.AbstractEtmBoardManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.EtbSlotParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.PhysicalLineParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.StandardParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationParameterList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public abstract class AbstractTerminationRI
extends AbstractResourceItem {
    private static final String[] myInstallationPhases = new String[]{"PhysPathTermCreationPhase", "PhysPathTermDeletionPhase"};
    private static String loadedStandard = null;
    public static final String RESERVEDBY_SYNC = "reservedBySync";
    private EtbSlotParameter slotParameter = null;
    private StandardParameter standardParameter = null;
    private PhysicalLineParameter lineParameter = null;
    private String[] linesToUnInstall = null;
    private AbstractEtmBoardManager boardManager = null;
    private Mapping mapping = null;
    private HashMap lineToLdnMapping = null;
    private HashMap ldnToLineMapping = null;
    private static final String MO_ID_PREFIX = "=pp";
    private MoHandler theMoHandler = null;
    private boolean isToBeInstalled = true;

    public static String getLoadedStandard() {
        return loadedStandard;
    }

    public static void setLoadedStandard(String string) {
        loadedStandard = string;
    }

    public AbstractTerminationRI(String string, Rbs rbs, AbstractEtmBoardManager abstractEtmBoardManager, Mapping mapping, TerminationParameterList terminationParameterList, String[] stringArray, String[] stringArray2) {
        super(string, rbs, myInstallationPhases);
        this.boardManager = abstractEtmBoardManager;
        this.mapping = mapping;
        this.slotParameter = terminationParameterList.getSlotParameter();
        this.standardParameter = terminationParameterList.getStandardParameter();
        this.lineParameter = terminationParameterList.getLineParameter();
        this.createMappingTables(stringArray, stringArray2);
        this.theMoHandler = rbs.getMoHandler();
    }

    public void install(String string) throws BemException {
        if (string.equals("PhysPathTermCreationPhase") && this.isToBeInstalled()) {
            this.createTermination();
            if (loadedStandard == null) {
                loadedStandard = this.getSelectedStandard();
            }
        }
    }

    protected abstract void createTermination() throws BemException;

    public void uninstall(String string) throws BemException {
        if (string.equals("PhysPathTermDeletionPhase") && this.isToBeUnInstalled()) {
            this.deleteTermination();
        }
    }

    protected abstract void deleteTermination() throws BemException;

    public boolean isConnectedToSync(String string) throws BemException {
        boolean bl = false;
        BemMo bemMo = this.theMoHandler.getMo(string);
        try {
            BemMo bemMo2;
            Object object;
            boolean bl2 = this.theMoHandler.isExisting(bemMo);
            if (bl2 && (object = this.theMoHandler.getAttribute(bemMo, RESERVEDBY_SYNC)) != null && object instanceof BemMo && (bemMo2 = (BemMo)object).getDN() != null) {
                bl = true;
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException.toString());
        }
        return bl;
    }

    public boolean hasChildren(String string) throws BemException {
        BemMo bemMo = this.theMoHandler.getMo(string);
        BemMo[] bemMoArray = null;
        try {
            bemMoArray = this.theMoHandler.getChildren(bemMo);
        }
        catch (MoHandlerException moHandlerException) {
            // empty catch block
        }
        return bemMoArray != null && bemMoArray.length > 1;
    }

    public String getSubLdn(String string, String string2) {
        int n;
        int n2;
        if (string != null && (n2 = string.indexOf(string2)) != -1 && (n = string.substring(n2).indexOf(",")) != -1) {
            return string.substring(0, n2 + n);
        }
        return null;
    }

    public ArrayList getReferencesToOtherMOs(String string, String string2) throws BemException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            BemMo bemMo = this.theMoHandler.getMo(string);
            try {
                Object object = this.theMoHandler.getAttribute(bemMo, string2);
                if (object != null) {
                    if (object instanceof BemMo) {
                        BemMo bemMo2 = (BemMo)object;
                        if (bemMo2.getDN() != null) {
                            arrayList.add(bemMo2.getDN());
                        }
                    } else if (object instanceof BemMo[]) {
                        BemMo[] bemMoArray = (BemMo[])object;
                        for (int i = 0; i < bemMoArray.length; ++i) {
                            if (bemMoArray[i].getDN() == null) continue;
                            arrayList.add(bemMoArray[i].getDN());
                        }
                    }
                }
            }
            catch (MoHandlerException moHandlerException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public String generateTerminationLdn(String string, String string2) {
        String string3 = this.boardManager.getEtmLdn(this.getSelectedSlot()) + ",";
        String string4 = string3 + string + MO_ID_PREFIX;
        String string5 = string4 + string2;
        return string5;
    }

    public abstract String[] getTerminationLdns() throws BemException;

    public void setLinesToUnInstall(String[] stringArray) {
        if (stringArray != null) {
            this.linesToUnInstall = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.linesToUnInstall[i] = stringArray[i];
            }
        } else {
            this.linesToUnInstall = null;
        }
    }

    public String[] getLinesToUnInstall() {
        if (this.linesToUnInstall != null) {
            return this.linesToUnInstall;
        }
        return null;
    }

    public String[] getAllLines() {
        return this.lineParameter.getAllLines();
    }

    public String[] getAllLoadedLines() {
        return this.lineParameter.getAllLoadedLines();
    }

    protected String getSelectedSlot() {
        return this.slotParameter.getValue();
    }

    public String[] getSelectedLines() {
        return this.lineParameter.getAllLines();
    }

    public String[] getLoadedSelectedLines() {
        return this.lineParameter.getAllLoadedLines();
    }

    public String getSelectedStandard() {
        return this.standardParameter.getValue();
    }

    public String getLoadedSelectedStandard() {
        return this.standardParameter.getLoadedValue();
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public String getLineId() throws BemException {
        String string = "";
        String[] stringArray = this.getSelectedLines();
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        return string;
    }

    public String getSubLineId() throws BemException {
        return null;
    }

    public boolean isInstalled() throws BemException {
        boolean bl = false;
        String[] stringArray = this.getTerminationLdns();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.isExisting(stringArray[i])) {
                bl = false;
                break;
            }
            bl = true;
        }
        return bl;
    }

    public boolean isToBeInstalled() {
        return this.isToBeInstalled;
    }

    public boolean isToBeUnInstalled() {
        return !this.isToBeInstalled;
    }

    public void setToBeInstalled() {
        this.isToBeInstalled = true;
    }

    public void setToBeUnInstalled() {
        this.isToBeInstalled = false;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getLdn() {
        return "";
    }

    private void createMappingTables(String[] stringArray, String[] stringArray2) {
        int n;
        this.lineToLdnMapping = new HashMap();
        this.ldnToLineMapping = new HashMap();
        if (stringArray != null && stringArray2 != null && (n = stringArray.length) > 0) {
            for (int i = 0; i < n; ++i) {
                this.lineToLdnMapping.put(stringArray2[i], stringArray[i]);
                this.ldnToLineMapping.put(stringArray[i], stringArray2[i]);
            }
        }
    }

    public String getLineFromLdn(String string) {
        return (String)this.ldnToLineMapping.get(string);
    }

    public String[] getConfiguredLdns() {
        Set set = this.ldnToLineMapping.keySet();
        String[] stringArray = set.toArray(new String[0]);
        return stringArray;
    }

    public HashMap getLdnToLineMapping() {
        return this.ldnToLineMapping;
    }

    public String generateLineFromLdn(String string) {
        String string2 = null;
        try {
            int n = string.lastIndexOf(MO_ID_PREFIX) + MO_ID_PREFIX.length();
            String string3 = string.substring(n);
            Integer.parseInt(string3);
            string2 = string3;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public String getLdnFromLine(String string) {
        String string2 = null;
        if (this.lineToLdnMapping != null) {
            string2 = (String)this.lineToLdnMapping.get(string);
        }
        return string2;
    }

    public abstract String generateTerminationLdn(String var1) throws BemException;

    public String generateSynchTerminationLdn(String string) throws BemException {
        return this.generateTerminationLdn(string);
    }

    public String getSynchTerminationMoType() throws BemException {
        return "";
    }

    public String[] getSynchTerminations(String[] stringArray) throws BemException {
        return stringArray;
    }

    public final void createRiMoIfNotExisting(String string, Vector vector) throws BemException {
        super.createMoIfNotExisting(string, vector);
    }

    public final void deleteRiMoIfNotExisting(String string) throws BemException {
        super.deleteMoIfNotExisting(string);
    }

    public CustomerParameter getSlotCp() {
        return this.slotParameter;
    }
}

