/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.duwterminationutil;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.DuwEtmc41Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.AbstractTerminationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.duwterminationutil.DuwTerminationHandler;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.util.Etmc41TerminationUtil;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;

public class DuwEtmc41TerminationHandler
implements DuwTerminationHandler {
    private static final String LINE_NO = "5";
    private AbstractTerminationRI terminationRi;
    private Mapping mapping;
    private Rbs rbs;

    public DuwEtmc41TerminationHandler(AbstractTerminationRI abstractTerminationRI, Rbs rbs) {
        this.terminationRi = abstractTerminationRI;
        this.mapping = new DuwEtmc41Mapping();
        this.rbs = rbs;
    }

    public void createTermination() throws BemException {
        Etmc41TerminationUtil.createTermination(this.terminationRi, this.terminationRi.getSelectedStandard(), LINE_NO);
    }

    public void deleteTermination() throws BemException {
        MoHandler moHandler = this.rbs.getMoHandler();
        Etmc41TerminationUtil.deleteTermination(this.terminationRi, moHandler);
    }

    public String[] getTerminationLdns() {
        String[] stringArray = Etmc41TerminationUtil.getTerminationLdns(this.terminationRi, LINE_NO);
        return stringArray;
    }

    public String generateTerminationLdn(String string) {
        String string2 = Etmc41TerminationUtil.generateTerminationLdn(this.terminationRi, string, LINE_NO);
        return string2;
    }

    public String generateSynchTerminationLdn(String string) {
        String string2 = Etmc41TerminationUtil.generateSynchTerminationLdn(this.terminationRi, string, LINE_NO);
        return string2;
    }

    public String[] getSupportedTerminationTypes() {
        String[] stringArray = this.mapping.getSupportedTerminationTypes();
        return stringArray;
    }

    public String getSynchTerminationMoType() {
        String string = Etmc41TerminationUtil.getSynchTerminationMoType();
        return string;
    }

    public String[] getSynchTerminations(String[] stringArray) {
        return new String[]{LINE_NO};
    }

    public String getLineId() {
        return LINE_NO;
    }

    public String getSubLineId() throws BemException {
        String string = Etmc41TerminationUtil.getSubLineId(this.terminationRi);
        return string;
    }

    public Mapping getMapping() {
        return this.mapping;
    }
}

