/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class RestartEscalationRI
extends AbstractResourceItem
implements ResourceItem {
    public static final String name = "RESTART-ESCALATION";
    private static final String[] myInstallationPhases = new String[]{"DeviceBoardCreationPhase", "RestartEscalationPhase"};
    private final String configurationVersionLdn;
    private static final int rollbackInitCounterValue = 2;
    private final boolean autoCreatedCVIsTurnedOn;

    public RestartEscalationRI(Rbs rbs, String string) {
        super(name, rbs, myInstallationPhases);
        this.configurationVersionLdn = string;
        this.autoCreatedCVIsTurnedOn = false;
    }

    public void install(String string) throws BemException {
        if (myInstallationPhases[0].equals(string)) {
            this.setRollbackInitCounterValue();
        }
        if (myInstallationPhases[1].equals(string)) {
            this.setAutoCreatedCVIsTurnedOn();
        }
    }

    private void setRollbackInitCounterValue() throws BemException {
        BemMo bemMo = super.getMo(this.configurationVersionLdn);
        Boolean bl = (Boolean)super.getAttribute(bemMo, "rollbackOn");
        if (bl.booleanValue()) {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            vector.add(Nal.getFactory().getNameValue("rollbackInitCounterValue", new Integer(2)));
            super.setAttributes(bemMo, vector);
        }
    }

    private void setAutoCreatedCVIsTurnedOn() throws BemException {
        BemMo bemMo = super.getMo(this.configurationVersionLdn);
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        vector.add(Nal.getFactory().getNameValue("autoCreatedCVIsTurnedOn", this.autoCreatedCVIsTurnedOn));
        super.setAttributes(bemMo, vector);
    }

    public boolean isInstalled() {
        return true;
    }

    public String getDisplayName() {
        return name;
    }

    public String getLdn() {
        return "";
    }
}

